/*
 * Decompiled with CFR 0.152.
 */
package forge.token;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.item.PaperToken;
import forge.token.ITokenDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TokenDb
implements ITokenDatabase {
    private final Map<String, PaperToken> tokensByName = Maps.newTreeMap(String.CASE_INSENSITIVE_ORDER);
    private final CardEdition.Collection editions;
    private final Map<String, CardRules> rulesByName;

    public TokenDb(Map<String, CardRules> rules, CardEdition.Collection editions) {
        this.rulesByName = rules;
        this.editions = editions;
    }

    public boolean containsRule(String rule) {
        return this.rulesByName.containsKey(rule);
    }

    @Override
    public PaperToken getToken(String tokenName) {
        return this.getToken(tokenName, CardEdition.UNKNOWN.getName());
    }

    public void preloadTokens() {
        for (CardEdition edition : this.editions) {
            for (String name : edition.getTokens().keySet()) {
                try {
                    this.getToken(name, edition.getCode());
                }
                catch (Exception e) {
                    System.out.println(name + "_" + edition.getCode() + " defined in Edition file, but not defined as a token script.");
                }
            }
        }
    }

    @Override
    public PaperToken getToken(String tokenName, String edition) {
        String fullName = String.format("%s_%s", tokenName, edition.toLowerCase());
        if (!this.tokensByName.containsKey(fullName)) {
            PaperToken pt = new PaperToken(this.rulesByName.get(tokenName), this.editions.get(edition), tokenName);
            this.tokensByName.put(fullName, pt);
            return pt;
        }
        return this.tokensByName.get(fullName);
    }

    @Override
    public PaperToken getToken(String tokenName, String edition, int artIndex) {
        return null;
    }

    @Override
    public PaperToken getTokenFromEditions(String tokenName, CardDb.CardArtPreference fromSet) {
        return null;
    }

    @Override
    public PaperToken getTokenFromEditions(String tokenName, Date printedBefore, CardDb.CardArtPreference fromSet) {
        return null;
    }

    @Override
    public PaperToken getTokenFromEditions(String tokenName, Date printedBefore, CardDb.CardArtPreference fromSet, int artIndex) {
        return null;
    }

    @Override
    public PaperToken getFoiled(PaperToken cpi) {
        return null;
    }

    @Override
    public int getPrintCount(String cardName, String edition) {
        return 0;
    }

    @Override
    public int getMaxPrintCount(String cardName) {
        return 0;
    }

    @Override
    public int getArtCount(String cardName, String edition) {
        return 0;
    }

    @Override
    public Collection<PaperToken> getUniqueTokens() {
        return null;
    }

    @Override
    public List<PaperToken> getAllTokens() {
        return new ArrayList<PaperToken>(this.tokensByName.values());
    }

    @Override
    public List<PaperToken> getAllTokens(String tokenName) {
        return null;
    }

    @Override
    public List<PaperToken> getAllTokens(Predicate<PaperToken> predicate) {
        return null;
    }

    @Override
    public Predicate<? super PaperToken> wasPrintedInSets(List<String> allowedSetCodes) {
        return null;
    }

    @Override
    public Iterator<PaperToken> iterator() {
        return this.tokensByName.values().iterator();
    }
}

