/*
 * Decompiled with CFR 0.152.
 */
package forge.sound;

import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.sound.SoundSystem;
import forge.util.MyRandom;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.lang3.ArrayUtils;

public enum MusicPlaylist {
    BLACK("black/"),
    BLUE("blue/"),
    RED("red/"),
    GREEN("green/"),
    WHITE("white/"),
    COLORLESS("colorless/"),
    CASTLE("castle/"),
    CAVE("cave/"),
    TOWN("town/"),
    BOSS("boss/"),
    MENUS("menus/"),
    MATCH("match/");

    private final String subDir;
    private int mostRecentTrackIdx = -1;
    private File[] filenames;
    private static boolean isInvalidated;

    private MusicPlaylist(String subDir0) {
        this.subDir = subDir0;
    }

    public static void invalidateMusicPlaylist() {
        isInvalidated = true;
    }

    public String getRandomFilename() {
        String path = SoundSystem.instance.getMusicDirectory() + this.subDir;
        if (this.filenames == null || isInvalidated) {
            try {
                FilenameFilter filter = (file, name) -> name.endsWith(".mp3") || name.endsWith(".wav") || name.endsWith(".m4a");
                this.filenames = new File(path).listFiles(filter);
                if (GuiBase.isAdventureMode() && (this.filenames == null || ArrayUtils.isEmpty(this.filenames))) {
                    path = ForgeConstants.ADVENTURE_COMMON_MUSIC_DIR + this.subDir;
                    this.filenames = new File(path).listFiles(filter);
                }
                if (this.filenames == null) {
                    this.filenames = new File[0];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.filenames = new File[0];
            }
            isInvalidated = false;
        }
        if (this.filenames.length == 0) {
            return null;
        }
        if (this.filenames.length == 1) {
            this.mostRecentTrackIdx = 0;
        } else {
            int newIndex;
            while ((newIndex = MyRandom.getRandom().nextInt(this.filenames.length)) == this.mostRecentTrackIdx) {
            }
            this.mostRecentTrackIdx = newIndex;
        }
        return this.filenames[this.mostRecentTrackIdx].getPath();
    }

    public String getNewRandomFilename() {
        Object[] music;
        String path = SoundSystem.instance.getMusicDirectory() + this.subDir;
        try {
            FilenameFilter filter = (file, name) -> name.endsWith(".mp3") || name.endsWith(".wav") || name.endsWith(".m4a");
            music = new File(path).listFiles(filter);
            if (GuiBase.isAdventureMode() && (music == null || ArrayUtils.isEmpty(music))) {
                path = ForgeConstants.ADVENTURE_COMMON_MUSIC_DIR + this.subDir;
                music = new File(path).listFiles(filter);
            }
            if (music == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (music.length == 0) {
            return null;
        }
        int index = MyRandom.getRandom().nextInt(music.length);
        System.out.println("Looking up " + path + ForgeConstants.PATH_SEPARATOR + music[index]);
        return ((File)music[index]).getPath();
    }

    static {
        isInvalidated = false;
    }
}

