/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.settings;

import com.google.common.collect.Lists;
import forge.Forge;
import forge.Graphics;
import forge.MulliganDefs;
import forge.StaticData;
import forge.adventure.util.Config;
import forge.ai.AiProfileUtil;
import forge.assets.FLanguage;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.game.GameLogEntryType;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.TabPageScreen;
import forge.screens.home.HomeScreen;
import forge.screens.match.MatchController;
import forge.screens.settings.SettingsScreen;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.FCheckBox;
import forge.toolbox.FGroupList;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.util.Callback;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SettingsPage
extends TabPageScreen.TabPage<SettingsScreen> {
    private final FGroupList<Setting> lstSettings = this.add(new FGroupList());
    private final CustomSelectSetting settingSkins;
    private final CustomSelectSetting settingCJKFonts;

    public SettingsPage() {
        super(Forge.getLocalizer().getMessage("lblSettings", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPREFERENCE : FSkinImage.SETTINGS);
        this.lstSettings.setListItemRenderer(new SettingRenderer());
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("lblGeneralSettings", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("lblGameplayOptions", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("RandomDeckGeneration", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("AdvancedSettings", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("GraphicOptions", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("lblCardOverlays", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("lblVibrationOptions", new Object[0]));
        this.lstSettings.addGroup(Forge.getLocalizer().getMessage("SoundOptions", new Object[0]));
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_LANGUAGE, Forge.getLocalizer().getMessage("cbpSelectLanguage", new Object[0]), Forge.getLocalizer().getMessage("nlSelectLanguage", new Object[0]), (Iterable)FLanguage.getAllLanguages()){

            @Override
            public void valueChanged(String newValue) {
                ForgePreferences prefs = FModel.getPreferences();
                if (prefs.getPref(ForgePreferences.FPref.UI_CJK_FONT).isEmpty() && (newValue.equals("zh-CN") || newValue.equals("ja-JP"))) {
                    String message = "Please download CJK font (from \"Files\"), and set it before change language.";
                    if (newValue.equals("zh-CN")) {
                        message = message + "\nChinese please use \"SourceHanSansCN\".";
                    }
                    if (newValue.equals("ja-JP")) {
                        message = message + "\nJapanese please use \"SourceHanSansJP\".";
                    }
                    FOptionPane.showMessageDialog(message, "Please set CJK Font");
                    return;
                }
                FLanguage.changeLanguage(newValue);
                FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            Forge.restart(true);
                        }
                    }
                });
            }
        }, 0);
        this.settingSkins = new CustomSelectSetting(ForgePreferences.FPref.UI_SKIN, Forge.getLocalizer().getMessage("lblTheme", new Object[0]), Forge.getLocalizer().getMessage("nlTheme", new Object[0]), (Iterable)FSkin.getAllSkins()){

            @Override
            public void valueChanged(String newValue) {
                FSkin.changeSkin(newValue);
            }
        };
        this.lstSettings.addItem(this.settingSkins, 0);
        this.settingCJKFonts = new CustomSelectSetting(ForgePreferences.FPref.UI_CJK_FONT, Forge.getLocalizer().getMessage("lblCJKFont", new Object[0]), Forge.getLocalizer().getMessage("nlCJKFont", new Object[0]), (Iterable)FSkinFont.getAllCJKFonts()){

            @Override
            public void valueChanged(String newValue) {
                ForgePreferences prefs = FModel.getPreferences();
                if (newValue.equals("None")) {
                    String locale = prefs.getPref(ForgePreferences.FPref.UI_LANGUAGE);
                    if (locale.equals("zh-CN") || locale.equals("ja-JP")) {
                        return;
                    }
                    newValue = "";
                }
                if (newValue.equals(prefs.getPref(ForgePreferences.FPref.UI_CJK_FONT))) {
                    return;
                }
                super.valueChanged(newValue);
            }
        };
        this.lstSettings.addItem(this.settingCJKFonts, 0);
        if (GuiBase.isAndroid()) {
            this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_LANDSCAPE_MODE, Forge.getLocalizer().getMessage("lblLandscapeMode", new Object[0]), Forge.getLocalizer().getMessage("nlLandscapeMode", new Object[0])){

                @Override
                public void select() {
                    super.select();
                    boolean landscapeMode = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LANDSCAPE_MODE);
                    Forge.getDeviceAdapter().setLandscapeMode(landscapeMode);
                    if (Forge.isLandscapeMode() != landscapeMode) {
                        FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                            @Override
                            public void run(Boolean result) {
                                if (result.booleanValue()) {
                                    Forge.restart(true);
                                }
                            }
                        });
                    }
                }
            }, 0);
        } else {
            this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_FULLSCREEN_MODE, Forge.getLocalizer().getMessage("lblFullScreenMode", new Object[0]), Forge.getLocalizer().getMessage("nlFullScreenMode", new Object[0])){

                @Override
                public void select() {
                    super.select();
                    Config.instance().getSettingData().fullScreen = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_FULLSCREEN_MODE);
                    Config.instance().saveSettings();
                }
            }, 0);
            this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_VIDEO_MODE, Forge.getLocalizer().getMessage("lblVideoMode", new Object[0]), Forge.getLocalizer().getMessage("nlVideoMode", new Object[0]), ForgeConstants.VIDEO_MODES){

                @Override
                public void valueChanged(String newValue) {
                    super.valueChanged(newValue);
                    String mode = newValue;
                    Graphics.setVideoMode(mode);
                }
            }, 0);
        }
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_SELECTOR_MODE, Forge.getLocalizer().getMessage("lblSelectorMode", new Object[0]), Forge.getLocalizer().getMessage("nlSelectorMode", new Object[0]), new String[]{"Default", "Classic", "Adventure"}){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                Forge.selector = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_SELECTOR_MODE);
            }
        }, 0);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.USE_SENTRY, Forge.getLocalizer().getMessage("lblAutomaticBugReports", new Object[0]), Forge.getLocalizer().getMessage("nlAutomaticBugReports", new Object[0])), 0);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.MULLIGAN_RULE, Forge.getLocalizer().getMessage("cbpMulliganRule", new Object[0]), Forge.getLocalizer().getMessage("nlpMulliganRule", new Object[0]), MulliganDefs.getMulliganRuleNames()){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                StaticData.instance().setMulliganRule(MulliganDefs.GetRuleByName(FModel.getPreferences().getPref(ForgePreferences.FPref.MULLIGAN_RULE)));
            }
        }, 1);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_CURRENT_AI_PROFILE, Forge.getLocalizer().getMessage("cbpAiProfiles", new Object[0]), Forge.getLocalizer().getMessage("nlpAiProfiles", new Object[0]), AiProfileUtil.getProfilesArray()), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ANTE, Forge.getLocalizer().getMessage("cbAnte", new Object[0]), Forge.getLocalizer().getMessage("nlAnte", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ANTE_MATCH_RARITY, Forge.getLocalizer().getMessage("cbAnteMatchRarity", new Object[0]), Forge.getLocalizer().getMessage("nlAnteMatchRarity", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.MATCH_HOT_SEAT_MODE, Forge.getLocalizer().getMessage("lblHotSeatMode", new Object[0]), Forge.getLocalizer().getMessage("nlHotSeatMode", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_AI_CHEATS, Forge.getLocalizer().getMessage("cbEnableAICheats", new Object[0]), Forge.getLocalizer().getMessage("nlEnableAICheats", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_MANABURN, Forge.getLocalizer().getMessage("cbManaBurn", new Object[0]), Forge.getLocalizer().getMessage("nlManaBurn", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_MANA_LOST_PROMPT, Forge.getLocalizer().getMessage("cbManaLostPrompt", new Object[0]), Forge.getLocalizer().getMessage("nlManaLostPrompt", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY, Forge.getLocalizer().getMessage("cbEnforceDeckLegality", new Object[0]), Forge.getLocalizer().getMessage("nlEnforceDeckLegality", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.PERFORMANCE_MODE, Forge.getLocalizer().getMessage("cbPerformanceMode", new Object[0]), Forge.getLocalizer().getMessage("nlPerformanceMode", new Object[0])), 1);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.MATCH_AI_SIDEBOARDING_MODE, Forge.getLocalizer().getMessage("cbpAiSideboardingMode", new Object[0]), Forge.getLocalizer().getMessage("nlpAiSideboardingMode", new Object[0]), Lists.newArrayList("Off", "AI", "Human For AI")){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                AiProfileUtil.setAiSideboardingMode(AiProfileUtil.AISideboardingMode.normalizedValueOf(newValue));
            }
        }, 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.MATCH_EXPERIMENTAL_RESTORE, Forge.getLocalizer().getMessage("cbExperimentalRestore", new Object[0]), Forge.getLocalizer().getMessage("nlExperimentalRestore", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.FILTERED_HANDS, Forge.getLocalizer().getMessage("cbFilteredHands", new Object[0]), Forge.getLocalizer().getMessage("nlFilteredHands", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_CLONE_MODE_SOURCE, Forge.getLocalizer().getMessage("cbCloneImgSource", new Object[0]), Forge.getLocalizer().getMessage("nlCloneImgSource", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.MATCHPREF_PROMPT_FREE_BLOCKS, Forge.getLocalizer().getMessage("cbPromptFreeBlocks", new Object[0]), Forge.getLocalizer().getMessage("nlPromptFreeBlocks", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT, Forge.getLocalizer().getMessage("cbDetailedPaymentDesc", new Object[0]), Forge.getLocalizer().getMessage("nlDetailedPaymentDesc", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_GRAY_INACTIVE_TEXT, Forge.getLocalizer().getMessage("cbGrayText", new Object[0]), Forge.getLocalizer().getMessage("nlGrayText", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_SHOW_STORM_COUNT_IN_PROMPT, Forge.getLocalizer().getMessage("cbShowStormCount", new Object[0]), Forge.getLocalizer().getMessage("nlShowStormCount", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_PRESELECT_PREVIOUS_ABILITY_ORDER, Forge.getLocalizer().getMessage("cbPreselectPrevAbOrder", new Object[0]), Forge.getLocalizer().getMessage("nlPreselectPrevAbOrder", new Object[0])), 1);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_ALLOW_ORDER_GRAVEYARD_WHEN_NEEDED, Forge.getLocalizer().getMessage("lblOrderGraveyard", new Object[0]), Forge.getLocalizer().getMessage("nlOrderGraveyard", new Object[0]), new String[]{"Never", "With Relevant Cards", "Always"}), 1);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_AUTO_YIELD_MODE, Forge.getLocalizer().getMessage("lblAutoYields", new Object[0]), Forge.getLocalizer().getMessage("nlpAutoYieldMode", new Object[0]), new String[]{"Per Ability (Each Match)", "Per Card (Each Game)"}), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ALLOW_ESC_TO_END_TURN, Forge.getLocalizer().getMessage("cbEscapeEndsTurn", new Object[0]), Forge.getLocalizer().getMessage("nlEscapeEndsTurn", new Object[0])), 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ALT_PLAYERINFOLAYOUT, Forge.getLocalizer().getMessage("lblAltLifeDisplay", new Object[0]), Forge.getLocalizer().getMessage("nlAltLifeDisplay", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.altPlayerLayout = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_PLAYERINFOLAYOUT);
                if (MatchController.instance != null) {
                    MatchController.instance.resetPlayerPanels();
                }
            }
        }, 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ALT_PLAYERZONETABS, Forge.getLocalizer().getMessage("lblAltZoneTabs", new Object[0]), Forge.getLocalizer().getMessage("nlAltZoneTabs", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.altZoneTabs = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_PLAYERZONETABS);
                if (MatchController.instance != null) {
                    MatchController.instance.resetPlayerPanels();
                }
            }
        }, 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ANIMATED_CARD_TAPUNTAP, Forge.getLocalizer().getMessage("lblAnimatedCardTapUntap", new Object[0]), Forge.getLocalizer().getMessage("nlAnimatedCardTapUntap", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.animatedCardTapUntap = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANIMATED_CARD_TAPUNTAP);
            }
        }, 1);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.DECKGEN_NOSMALL, Forge.getLocalizer().getMessage("cbRemoveSmall", new Object[0]), Forge.getLocalizer().getMessage("nlRemoveSmall", new Object[0])), 2);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.DECKGEN_CARDBASED, Forge.getLocalizer().getMessage("cbCardBased", new Object[0]), Forge.getLocalizer().getMessage("nlCardBased", new Object[0])), 2);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.DECKGEN_SINGLETONS, Forge.getLocalizer().getMessage("cbSingletons", new Object[0]), Forge.getLocalizer().getMessage("nlSingletons", new Object[0])), 2);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.DECKGEN_ARTIFACTS, Forge.getLocalizer().getMessage("cbRemoveArtifacts", new Object[0]), Forge.getLocalizer().getMessage("nlRemoveArtifacts", new Object[0])), 2);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.DEV_MODE_ENABLED, Forge.getLocalizer().getMessage("cbDevMode", new Object[0]), Forge.getLocalizer().getMessage("nlDevMode", new Object[0])){

            @Override
            public void select() {
                super.select();
                ForgePreferences.DEV_MODE = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DEV_MODE_ENABLED);
            }
        }, 3);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.DEV_LOG_ENTRY_TYPE, Forge.getLocalizer().getMessage("cbpGameLogEntryType", new Object[0]), Forge.getLocalizer().getMessage("nlGameLogEntryType", new Object[0]), GameLogEntryType.class), 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.LOAD_CARD_SCRIPTS_LAZILY, Forge.getLocalizer().getMessage("cbLoadCardsLazily", new Object[0]), Forge.getLocalizer().getMessage("nlLoadCardsLazily", new Object[0])), 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS, Forge.getLocalizer().getMessage("cbLoadArchivedFormats", new Object[0]), Forge.getLocalizer().getMessage("nlLoadArchivedFormats", new Object[0])), 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_LOAD_UNKNOWN_CARDS, Forge.getLocalizer().getMessage("lblEnableUnknownCards", new Object[0]), Forge.getLocalizer().getMessage("nlEnableUnknownCards", new Object[0])){

            @Override
            public void select() {
                super.select();
                FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            Forge.restart(true);
                        }
                    }
                });
            }
        }, 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_LOAD_NONLEGAL_CARDS, Forge.getLocalizer().getMessage("lblEnableNonLegalCards", new Object[0]), Forge.getLocalizer().getMessage("nlEnableNonLegalCards", new Object[0])){

            @Override
            public void select() {
                super.select();
                FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            Forge.restart(true);
                        }
                    }
                });
            }
        }, 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.ALLOW_CUSTOM_CARDS_IN_DECKS_CONFORMANCE, Forge.getLocalizer().getMessage("lblAllowCustomCardsInDecks", new Object[0]), Forge.getLocalizer().getMessage("nlAllowCustomCardsInDecks", new Object[0])){

            @Override
            public void select() {
                super.select();
                FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            Forge.restart(true);
                        }
                    }
                });
            }
        }, 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_NETPLAY_COMPAT, Forge.getLocalizer().getMessage("lblExperimentalNetworkCompatibility", new Object[0]), Forge.getLocalizer().getMessage("nlExperimentalNetworkCompatibility", new Object[0])){

            @Override
            public void select() {
                super.select();
                GuiBase.enablePropertyConfig(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_NETPLAY_COMPAT));
            }
        }, 3);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_DISPOSE_TEXTURES, Forge.getLocalizer().getMessage("lblDisposeTextures", new Object[0]), Forge.getLocalizer().getMessage("nlDisposeTextures", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.disposeTextures = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_DISPOSE_TEXTURES);
            }
        }, 3);
        if (GuiBase.isAndroid()) {
            this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_AUTO_CACHE_SIZE, Forge.getLocalizer().getMessage("lblAutoCacheSize", new Object[0]), Forge.getLocalizer().getMessage("nlAutoCacheSize", new Object[0])){

                @Override
                public void select() {
                    super.select();
                    FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                        @Override
                        public void run(Boolean result) {
                            if (result.booleanValue()) {
                                Forge.restart(true);
                            }
                        }
                    });
                }
            }, 3);
        }
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES, Forge.getLocalizer().getMessage("lblDisableCardImages", new Object[0]), Forge.getLocalizer().getMessage("nlDisableCardImages", new Object[0])){

            @Override
            public void select() {
                super.select();
                ImageCache.disposeTextures();
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER, Forge.getLocalizer().getMessage("cbImageFetcher", new Object[0]), Forge.getLocalizer().getMessage("nlImageFetcher", new Object[0])), 4);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_PREFERRED_ART, Forge.getLocalizer().getMessage("lblPreferredArt", new Object[0]), Forge.getLocalizer().getMessage("nlPreferredArt", new Object[0]), FModel.getMagicDb().getCardArtAvailablePreferences()){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblRestartForgeDescription", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblLater", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            Forge.restart(true);
                        }
                    }
                });
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_SMART_CARD_ART, Forge.getLocalizer().getMessage("lblSmartCardArtOpt", new Object[0]), Forge.getLocalizer().getMessage("nlSmartCardArtOpt", new Object[0]) + "\n" + Forge.getLocalizer().getMessage("nlSmartCardArtOptNote", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT, Forge.getLocalizer().getMessage("cbDisplayFoil", new Object[0]), Forge.getLocalizer().getMessage("nlDisplayFoil", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_RANDOM_FOIL, Forge.getLocalizer().getMessage("cbRandomFoil", new Object[0]), Forge.getLocalizer().getMessage("nlRandomFoil", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_RANDOM_ART_IN_POOLS, Forge.getLocalizer().getMessage("cbRandomArtInPools", new Object[0]), Forge.getLocalizer().getMessage("nlRandomArtInPools", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_COMPACT_TABS, Forge.getLocalizer().getMessage("lblCompactTabs", new Object[0]), Forge.getLocalizer().getMessage("nlCompactTabs", new Object[0])){

            @Override
            public void select() {
                super.select();
                TabPageScreen.COMPACT_TABS = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_TABS);
                ((SettingsScreen)SettingsPage.this.parentScreen).revalidate();
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_COMPACT_LIST_ITEMS, Forge.getLocalizer().getMessage("lblCompactListItems", new Object[0]), Forge.getLocalizer().getMessage("nlCompactListItems", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_HIDE_REMINDER_TEXT, Forge.getLocalizer().getMessage("cbHideReminderText", new Object[0]), Forge.getLocalizer().getMessage("nlHideReminderText", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE, Forge.getLocalizer().getMessage("lblShowMatchBackground", new Object[0]), Forge.getLocalizer().getMessage("nlShowMatchBackground", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_LIBGDX_TEXTURE_FILTERING, Forge.getLocalizer().getMessage("lblBattlefieldTextureFiltering", new Object[0]), Forge.getLocalizer().getMessage("nlBattlefieldTextureFiltering", new Object[0])), 4);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_DISPLAY_CURRENT_COLORS, Forge.getLocalizer().getMessage("cbpDisplayCurrentCardColors", new Object[0]), Forge.getLocalizer().getMessage("nlDisplayCurrentCardColors", new Object[0]), new String[]{"Never", "Multicolor", "Changed", "Multi+Changed", "Always"}), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ROTATE_SPLIT_CARDS, Forge.getLocalizer().getMessage("lblRotateZoomSplit", new Object[0]), Forge.getLocalizer().getMessage("nlRotateZoomSplit", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ROTATE_PLANE_OR_PHENOMENON, Forge.getLocalizer().getMessage("lblRotateZoomPlanesPhenomena", new Object[0]), Forge.getLocalizer().getMessage("nlRotateZoomPlanesPhenomena", new Object[0])), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_DISABLE_IMAGES_EFFECT_CARDS, Forge.getLocalizer().getMessage("lblDisableCardEffect", new Object[0]), Forge.getLocalizer().getMessage("nlDisableCardEffect", new Object[0])), 4);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING, Forge.getLocalizer().getMessage("lblBorderMaskOption", new Object[0]), Forge.getLocalizer().getMessage("nlBorderMaskOption", new Object[0]), new String[]{"Off", "Crop", "Full", "Art"}){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                Forge.enableUIMask = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING);
                ImageCache.clearGeneratedCards();
                ImageCache.disposeTextures();
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_PRELOAD_EXTENDED_ART, Forge.getLocalizer().getMessage("lblPreloadExtendedArtCards", new Object[0]), Forge.getLocalizer().getMessage("nlPreloadExtendedArtCards", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.enablePreloadExtendedArt = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_PRELOAD_EXTENDED_ART);
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_MATCH_SCROLL_INDICATOR, Forge.getLocalizer().getMessage("lblMatchScrollIndicator", new Object[0]), Forge.getLocalizer().getMessage("nlMatchScrollIndicator", new Object[0])), 4);
        if (!GuiBase.isAndroid()) {
            this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_ENABLE_MAGNIFIER, Forge.getLocalizer().getMessage("lblEnableMagnifier", new Object[0]), Forge.getLocalizer().getMessage("nlEnableMagnifier", new Object[0])){

                @Override
                public void select() {
                    super.select();
                    if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MAGNIFIER)) {
                        Forge.setCursor(FSkin.getCursor().get(0), "0");
                    }
                }
            }, 4);
        }
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_AUTO_AIDECK_SELECTION, Forge.getLocalizer().getMessage("lblAutoAIDeck", new Object[0]), Forge.getLocalizer().getMessage("nlAutoAIDeck", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.autoAIDeckSelection = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_AUTO_AIDECK_SELECTION);
            }
        }, 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_SHOW_FPS, Forge.getLocalizer().getMessage("lblShowFPSDisplay", new Object[0]), Forge.getLocalizer().getMessage("nlShowFPSDisplay", new Object[0])){

            @Override
            public void select() {
                super.select();
                Forge.showFPS = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SHOW_FPS);
            }
        }, 4);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE, Forge.getLocalizer().getMessage("cbpCounterDisplayType", new Object[0]), Forge.getLocalizer().getMessage("nlCounterDisplayType", new Object[0]), new String[]{ForgeConstants.CounterDisplayType.TEXT.getName(), ForgeConstants.CounterDisplayType.IMAGE.getName(), ForgeConstants.CounterDisplayType.HYBRID.getName(), ForgeConstants.CounterDisplayType.OLD_WHEN_SMALL.getName()}), 4);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS, Forge.getLocalizer().getMessage("lblShowCardOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowCardOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_CARD_NAME, Forge.getLocalizer().getMessage("lblShowCardNameOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowCardNameOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_CARD_MANA_COST, Forge.getLocalizer().getMessage("lblShowCardManaCostOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowCardManaCostOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_CARD_POWER, Forge.getLocalizer().getMessage("lblShowCardPTOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowCardPTOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_CARD_ID, Forge.getLocalizer().getMessage("lblShowCardIDOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowCardIDOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_DRAFT_RANKING, Forge.getLocalizer().getMessage("lblShowDraftRankingOverlay", new Object[0]), Forge.getLocalizer().getMessage("nlShowDraftRankingOverlay", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_OVERLAY_ABILITY_ICONS, Forge.getLocalizer().getMessage("lblShowAbilityIconsOverlays", new Object[0]), Forge.getLocalizer().getMessage("nlShowAbilityIconsOverlays", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_USE_LASER_ARROWS, Forge.getLocalizer().getMessage("lblUseLaserArrows", new Object[0]), Forge.getLocalizer().getMessage("nlUseLaserArrows", new Object[0])), 5);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_VIBRATE_ON_LIFE_LOSS, Forge.getLocalizer().getMessage("lblVibrateWhenLosingLife", new Object[0]), Forge.getLocalizer().getMessage("nlVibrateWhenLosingLife", new Object[0])), 6);
        this.lstSettings.addItem(new BooleanSetting(ForgePreferences.FPref.UI_VIBRATE_ON_LONG_PRESS, Forge.getLocalizer().getMessage("lblVibrateAfterLongPress", new Object[0]), Forge.getLocalizer().getMessage("nlVibrateAfterLongPress", new Object[0])), 6);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_CURRENT_SOUND_SET, Forge.getLocalizer().getMessage("cbpSoundSets", new Object[0]), Forge.getLocalizer().getMessage("nlpSoundSets", new Object[0]), SoundSystem.instance.getAvailableSoundSets()){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                SoundSystem.instance.invalidateSoundCache();
            }
        }, 7);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_CURRENT_MUSIC_SET, Forge.getLocalizer().getMessage("cbpMusicSets", new Object[0]), Forge.getLocalizer().getMessage("nlpMusicSets", new Object[0]), SoundSystem.getAvailableMusicSets()){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                MusicPlaylist.invalidateMusicPlaylist();
                SoundSystem.instance.changeBackgroundTrack();
            }
        }, 7);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_VOL_SOUNDS, Forge.getLocalizer().getMessage("cbAdjustSoundsVolume", new Object[0]), Forge.getLocalizer().getMessage("nlAdjustSoundsVolume", new Object[0]), new String[]{"0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"}), 7);
        this.lstSettings.addItem(new CustomSelectSetting(ForgePreferences.FPref.UI_VOL_MUSIC, Forge.getLocalizer().getMessage("cbAdjustMusicVolume", new Object[0]), Forge.getLocalizer().getMessage("nlAdjustMusicVolume", new Object[0]), new String[]{"0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"}){

            @Override
            public void valueChanged(String newValue) {
                super.valueChanged(newValue);
                SoundSystem.instance.changeBackgroundTrack();
            }
        }, 7);
    }

    public void refreshSkinsList() {
        this.settingSkins.updateOptions(FSkin.getAllSkins());
    }

    public void refreshCJKFontsList() {
        this.settingCJKFonts.updateOptions(FSkinFont.getAllCJKFonts());
    }

    @Override
    protected void doLayout(float width, float height) {
        this.lstSettings.setBounds(0.0f, 0.0f, width, height);
    }

    private class SettingRenderer
    extends FList.ListItemRenderer<Setting> {
        private SettingRenderer() {
        }

        @Override
        public float getItemHeight() {
            return SettingsScreen.SETTING_HEIGHT;
        }

        @Override
        public boolean tap(Integer index, Setting value, float x, float y, int count) {
            value.select();
            return true;
        }

        @Override
        public void drawValue(Graphics g2, Integer index, Setting value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
            float offset = SettingsScreen.getInsets(w) - FList.PADDING;
            float totalHeight = h2 -= 2.0f * offset;
            h2 = font.getMultiLineBounds((CharSequence)value.label).height + SettingsScreen.SETTING_PADDING;
            g2.drawText(value.label, font, foreColor, x += offset, y += offset, w -= 2.0f * offset, h2, false, 8, false);
            value.drawPrefValue(g2, font, foreColor, x, y, w, h2);
            g2.drawText(value.description, SettingsScreen.DESC_FONT, SettingsScreen.DESC_COLOR, x, y + (h2 += SettingsScreen.SETTING_PADDING), w, totalHeight - h2 + SettingsScreen.getInsets(w), true, 8, false);
        }
    }

    private class CustomSelectSetting
    extends Setting {
        private final List<String> options;

        public CustomSelectSetting(ForgePreferences.FPref pref0, String label0, String description0, String[] options0) {
            super(pref0, label0 + ":", description0);
            this.options = new ArrayList<String>();
            this.options.addAll(Arrays.asList(options0));
        }

        public CustomSelectSetting(ForgePreferences.FPref pref0, String label0, String description0, Iterable<String> options0) {
            super(pref0, label0 + ":", description0);
            this.options = new ArrayList<String>();
            if (options0 != null) {
                for (String option : options0) {
                    this.options.add(option);
                }
            }
        }

        public <E extends Enum<E>> CustomSelectSetting(ForgePreferences.FPref pref0, String label0, String description0, Class<E> enumData) {
            super(pref0, label0 + ":", description0);
            this.options = new ArrayList<String>();
            for (Enum option : (Enum[])enumData.getEnumConstants()) {
                this.options.add(option.toString());
            }
        }

        public void valueChanged(String newValue) {
            FModel.getPreferences().setPref(this.pref, newValue);
            FModel.getPreferences().save();
        }

        public void updateOptions(Iterable<String> options0) {
            this.options.clear();
            if (options0 != null) {
                for (String option : options0) {
                    this.options.add(option);
                }
            }
        }

        @Override
        public void select() {
            Forge.openScreen(new CustomSelectScreen());
        }

        @Override
        public void drawPrefValue(Graphics g2, FSkinFont font, FSkinColor color, float x, float y, float w, float h2) {
            g2.drawText(FModel.getPreferences().getPref(this.pref), font, color, x, y, w, h2, false, 16, false);
        }

        private class CustomSelectScreen
        extends FScreen {
            private final FList<String> lstOptions;
            private final String currentValue;

            private CustomSelectScreen() {
                super("Select " + CustomSelectSetting.this.label.substring(0, CustomSelectSetting.this.label.length() - 1));
                this.currentValue = FModel.getPreferences().getPref(CustomSelectSetting.this.pref);
                this.lstOptions = this.add(new FList(CustomSelectSetting.this.options));
                this.lstOptions.setListItemRenderer((FList.ListItemRenderer<String>)new FList.DefaultListItemRenderer<String>(){

                    @Override
                    public boolean tap(Integer index, String value, float x, float y, int count) {
                        Forge.back();
                        if (!value.equals(CustomSelectScreen.this.currentValue)) {
                            CustomSelectSetting.this.valueChanged(value);
                        }
                        return true;
                    }

                    @Override
                    public void drawValue(Graphics g2, Integer index, String value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                        float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                        g2.drawText(value, font, foreColor, x += offset, y += offset, w -= 2.0f * offset, h2 -= 2.0f * offset, false, 8, true);
                        float radius = h2 / 3.0f;
                        g2.drawCircle(Utils.scale(1.0f), SettingsScreen.DESC_COLOR, x += w - radius, y += h2 / 2.0f, radius);
                        if (value.equals(CustomSelectScreen.this.currentValue)) {
                            g2.fillCircle(foreColor, x, y, radius / 2.0f);
                        }
                    }
                });
            }

            @Override
            protected void doLayout(float startY, float width, float height) {
                this.lstOptions.setBounds(0.0f, startY, width, height - startY);
            }

            @Override
            public FScreen getLandscapeBackdropScreen() {
                if (SettingsScreen.launchedFromHomeScreen()) {
                    return HomeScreen.instance;
                }
                return null;
            }
        }
    }

    private class BooleanSetting
    extends Setting {
        public BooleanSetting(ForgePreferences.FPref pref0, String label0, String description0) {
            super(pref0, label0, description0);
        }

        @Override
        public void select() {
            FModel.getPreferences().setPref(this.pref, !FModel.getPreferences().getPrefBoolean(this.pref));
            FModel.getPreferences().save();
        }

        @Override
        public void drawPrefValue(Graphics g2, FSkinFont font, FSkinColor color, float x, float y, float w, float h2) {
            x += w - h2;
            w = h2;
            FCheckBox.drawCheckBox(g2, SettingsScreen.DESC_COLOR, color, FModel.getPreferences().getPrefBoolean(this.pref), x, y, w, h2);
        }
    }

    private abstract class Setting {
        protected String label;
        protected String description;
        protected ForgePreferences.FPref pref;

        public Setting(ForgePreferences.FPref pref0, String label0, String description0) {
            this.label = label0;
            this.description = description0;
            this.pref = pref0;
        }

        public abstract void select();

        public abstract void drawPrefValue(Graphics var1, FSkinFont var2, FSkinColor var3, float var4, float var5, float var6, float var7);
    }
}

