/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.settings;

import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.StaticData;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadAchievementImages;
import forge.gui.download.GuiDownloadPicturesLQ;
import forge.gui.download.GuiDownloadPrices;
import forge.gui.download.GuiDownloadQuestImages;
import forge.gui.download.GuiDownloadService;
import forge.gui.download.GuiDownloadSetPicturesLQ;
import forge.gui.download.GuiDownloadSkins;
import forge.gui.download.GuiDownloadZipService;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgeProfileProperties;
import forge.screens.LoadingOverlay;
import forge.screens.TabPageScreen;
import forge.screens.settings.GuiDownloader;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FFileChooser;
import forge.toolbox.FGroupList;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import forge.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FilesPage
extends TabPageScreen.TabPage<SettingsScreen> {
    private final FGroupList<FilesItem> lstItems = this.add(new FGroupList());

    protected FilesPage() {
        super(Forge.getLocalizer().getMessage("lblFiles", new Object[0]), Forge.hdbuttons ? FSkinImage.HDOPEN : FSkinImage.OPEN);
        this.lstItems.setListItemRenderer(new FilesItemRenderer());
        this.lstItems.addGroup(Forge.getLocalizer().getMessage("lblCardAudit", new Object[0]));
        this.lstItems.addGroup(Forge.getLocalizer().getMessage("ContentDownloaders", new Object[0]));
        this.lstItems.addGroup(Forge.getLocalizer().getMessage("lblStorageLocations", new Object[0]));
        this.lstItems.addItem(new Extra(Forge.getLocalizer().getMessage("btnListImageData", new Object[0]), Forge.getLocalizer().getMessage("lblListImageData", new Object[0])){

            @Override
            public void select() {
                FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblProcessingCards", new Object[0]), true, () -> {
                    StringBuffer nifSB = new StringBuffer();
                    StringBuffer cniSB = new StringBuffer();
                    nifSB.append("\n\n-------------------\n");
                    nifSB.append("NO IMAGE FOUND LIST\n");
                    nifSB.append("-------------------\n\n");
                    cniSB.append("\n\n-------------------\n");
                    cniSB.append("UNIMPLEMENTED CARD LIST\n");
                    cniSB.append("-------------------\n\n");
                    Pair<Integer, Integer> totalAudit = StaticData.instance().audit(nifSB, cniSB);
                    final String msg = nifSB.toString();
                    String title = "Missing images: " + totalAudit.getLeft() + "\nUnimplemented cards: " + totalAudit.getRight();
                    FOptionPane.showOptionDialog(msg, title, FOptionPane.INFORMATION_ICON, ImmutableList.of(Forge.getLocalizer().getMessage("lblCopy", new Object[0]), Forge.getLocalizer().getMessage("lblClose", new Object[0])), -1, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            switch (result) {
                                case 0: {
                                    Forge.getClipboard().setContents(msg);
                                    break;
                                }
                            }
                        }
                    });
                }));
            }
        }, 0);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadPics", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadPics", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadPicturesLQ();
            }
        }, 1);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadSetPics", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadSetPics", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadSetPicturesLQ();
            }
        }, 1);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadQuestImages", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadQuestImages", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadQuestImages();
            }
        }, 1);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadAchievementImages", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadAchievementImages", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadAchievementImages();
            }
        }, 1);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadPrices", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadPrices", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadPrices();
            }
        }, 1);
        this.lstItems.addItem(new ContentDownloader(Forge.getLocalizer().getMessage("btnDownloadSkins", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadSkins", new Object[0])){

            @Override
            protected GuiDownloadService createService() {
                return new GuiDownloadSkins();
            }

            @Override
            protected void finishCallback() {
                SettingsScreen.getSettingsScreen().getSettingsPage().refreshSkinsList();
            }
        }, 1);
        this.lstItems.addItem(new OptionContentDownloader(Forge.getLocalizer().getMessage("btnDownloadCJKFonts", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadCJKFonts", new Object[0]), Forge.getLocalizer().getMessage("lblDownloadCJKFontPrompt", new Object[0])){

            @Override
            protected Map<String, String> getCategories() {
                TreeMap<String, String> categories = new TreeMap<String, String>();
                List<String> lines = FileUtil.readFile(ForgeConstants.CJK_FONTS_LIST_FILE);
                ArrayList<String> options = new ArrayList<String>();
                for (String line : lines) {
                    int idx = line.indexOf(124);
                    if (idx == -1) continue;
                    String name = line.substring(0, idx).trim();
                    String url = line.substring(idx + 1).trim();
                    categories.put(name, url);
                    options.add(name);
                }
                return categories;
            }

            @Override
            protected void finishCallback() {
                SettingsScreen.getSettingsScreen().getSettingsPage().refreshCJKFontsList();
            }
        }, 1);
        final StorageOption cardPicsOption = new StorageOption(Forge.getLocalizer().getMessage("lblCardPicsLocation", new Object[0]), ForgeProfileProperties.getCardPicsDir()){

            @Override
            protected void onDirectoryChanged(String newDir) {
                ForgeProfileProperties.setCardPicsDir(newDir);
            }
        };
        final StorageOption decksOption = new StorageOption(Forge.getLocalizer().getMessage("lblDecksLocation", new Object[0]), ForgeProfileProperties.getDecksDir()){

            @Override
            protected void onDirectoryChanged(String newDir) {
                ForgeProfileProperties.setDecksDir(newDir);
            }
        };
        if (!GuiBase.isUsingAppDirectory()) {
            this.lstItems.addItem(new StorageOption(Forge.getLocalizer().getMessage("lblDataLocation", new Object[0]), ForgeProfileProperties.getUserDir()){

                @Override
                protected void onDirectoryChanged(String newDir) {
                    ForgeProfileProperties.setUserDir(newDir);
                    decksOption.updateDir(ForgeProfileProperties.getDecksDir());
                }
            }, 2);
            this.lstItems.addItem(new StorageOption(Forge.getLocalizer().getMessage("lblImageCacheLocation", new Object[0]), ForgeProfileProperties.getCacheDir()){

                @Override
                protected void onDirectoryChanged(String newDir) {
                    ForgeProfileProperties.setCacheDir(newDir);
                    cardPicsOption.updateDir(ForgeProfileProperties.getCardPicsDir());
                }
            }, 2);
            this.lstItems.addItem(cardPicsOption, 2);
            this.lstItems.addItem(decksOption, 2);
        }
    }

    @Override
    protected void doLayout(float width, float height) {
        this.lstItems.setBounds(0.0f, 0.0f, width, height);
    }

    private abstract class StorageOption
    extends FilesItem {
        StorageOption(String name0, String dir0) {
            super(name0, dir0);
        }

        private void updateDir(String dir0) {
            this.description = dir0;
        }

        @Override
        public void select() {
            FFileChooser.show(Forge.getLocalizer().getMessage("lblSelect", new Object[0]).replace("%s", this.label), FFileChooser.ChoiceType.GetDirectory, this.description, new Callback<String>(){

                @Override
                public void run(String result) {
                    if (StringUtils.isEmpty(result) || StorageOption.this.description.equals(result)) {
                        return;
                    }
                    StorageOption.this.updateDir(result);
                    StorageOption.this.onDirectoryChanged(result);
                    FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblRestartForgeMoveFilesNewLocation", new Object[0]), Forge.getLocalizer().getMessage("lblRestartRequired", new Object[0]), FOptionPane.INFORMATION_ICON);
                }
            });
        }

        protected abstract void onDirectoryChanged(String var1);
    }

    private abstract class OptionContentDownloader
    extends FilesItem {
        private final String prompt;

        OptionContentDownloader(String label0, String description0, String propmt0) {
            super(label0, description0);
            this.prompt = propmt0;
        }

        @Override
        public void select() {
            final Map<String, String> categories = this.getCategories();
            GuiChoose.one(this.prompt, categories.keySet(), new Callback<String>(){

                @Override
                public void run(String result) {
                    String url = (String)categories.get(result);
                    String name = url.substring(url.lastIndexOf("/") + 2);
                    new GuiDownloader(new GuiDownloadZipService(name, name, url, ForgeConstants.FONTS_DIR, null, null), new Callback<Boolean>(){

                        @Override
                        public void run(Boolean finished) {
                            if (finished.booleanValue()) {
                                OptionContentDownloader.this.finishCallback();
                            }
                        }
                    }).show();
                }
            });
        }

        protected abstract Map<String, String> getCategories();

        protected void finishCallback() {
        }
    }

    private abstract class ContentDownloader
    extends FilesItem {
        ContentDownloader(String label0, String description0) {
            super(label0, description0);
        }

        @Override
        public void select() {
            new GuiDownloader(this.createService(), new Callback<Boolean>(){

                @Override
                public void run(Boolean finished) {
                    if (finished.booleanValue()) {
                        ContentDownloader.this.finishCallback();
                    }
                }
            }).show();
        }

        protected abstract GuiDownloadService createService();

        protected void finishCallback() {
        }
    }

    private abstract class Extra
    extends FilesItem {
        Extra(String label0, String description0) {
            super(label0, description0);
        }

        @Override
        public void select() {
        }

        protected void finishCallback() {
        }
    }

    private static class FilesItemRenderer
    extends FList.ListItemRenderer<FilesItem> {
        private FilesItemRenderer() {
        }

        @Override
        public float getItemHeight() {
            return SettingsScreen.SETTING_HEIGHT;
        }

        @Override
        public boolean tap(Integer index, FilesItem value, float x, float y, int count) {
            value.select();
            return true;
        }

        @Override
        public void drawValue(Graphics g2, Integer index, FilesItem value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
            float offset = SettingsScreen.getInsets(w) - FList.PADDING;
            float totalHeight = h2 -= 2.0f * offset;
            h2 = font.getMultiLineBounds((CharSequence)value.label).height + SettingsScreen.SETTING_PADDING;
            g2.drawText(value.label, font, foreColor, x += offset, y += offset, w -= 2.0f * offset, h2, false, 8, false);
            g2.drawText(value.description, SettingsScreen.DESC_FONT, SettingsScreen.DESC_COLOR, x, y + (h2 += SettingsScreen.SETTING_PADDING), w, totalHeight - h2 + SettingsScreen.getInsets(w), true, 8, false);
        }
    }

    private abstract class FilesItem {
        protected String label;
        protected String description;

        FilesItem(String label0, String description0) {
            this.label = label0;
            this.description = description0;
        }

        public abstract void select();
    }
}

