/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gui.interfaces.IButton;
import forge.gui.interfaces.ICheckBox;
import forge.gui.interfaces.IComboBox;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.quest.QuestMenu;
import forge.screens.quest.QuestTournamentsScreen;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Utils;
import java.util.List;

public class QuestStatsScreen
extends FScreen {
    private static final float PADDING = FOptionPane.PADDING;
    private final FScrollPane scroller = this.add(new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = PADDING;
            float y = PADDING;
            float w = visibleWidth - 2.0f * PADDING;
            float h2 = ((QuestStatsScreen)QuestStatsScreen.this).lblWins.getAutoSizeBounds().height;
            for (FDisplayObject lbl : this.getChildren()) {
                if (!lbl.isVisible()) continue;
                lbl.setBounds(x, y, w, lbl.getHeight() == 0.0f ? h2 : lbl.getHeight());
                y += lbl.getHeight() + PADDING;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }
    });
    private final FLabel lblWins = this.scroller.add(new StatLabel(FSkinImage.QUEST_PLUS));
    private final FLabel lblLosses = this.scroller.add(new StatLabel(FSkinImage.QUEST_MINUS));
    private final FLabel lblCredits = this.scroller.add(new StatLabel(FSkinImage.QUEST_COINSTACK));
    private final FLabel lblWinStreak = this.scroller.add(new StatLabel(FSkinImage.QUEST_PLUSPLUS));
    private final FLabel lblLife = this.scroller.add(new StatLabel(FSkinImage.QUEST_LIFE));
    private final FLabel lblWorld = this.scroller.add(new StatLabel(FSkinImage.QUEST_MAP));
    private final FComboBox<String> cbxPet = this.scroller.add(new FComboBox());
    private final FComboBox<String> cbxMatchLength = this.scroller.add(new FComboBox());
    private final FCheckBox cbPlant = this.scroller.add(new FCheckBox(Forge.getLocalizer().getMessage("cbSummonPlant", new Object[0])));
    private final FLabel lblZep = this.scroller.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("cbLaunchZeppelin", new Object[0])).icon(FSkinImage.QUEST_ZEP).font(FSkinFont.get(16)).opaque().build());

    public FLabel getLblWins() {
        return this.lblWins;
    }

    public FLabel getLblLosses() {
        return this.lblLosses;
    }

    public FLabel getLblCredits() {
        return this.lblCredits;
    }

    public FLabel getLblWinStreak() {
        return this.lblWinStreak;
    }

    public FLabel getLblLife() {
        return this.lblLife;
    }

    public FLabel getLblWorld() {
        return this.lblWorld;
    }

    public IComboBox<String> getCbxPet() {
        return this.cbxPet;
    }

    public ICheckBox getCbPlant() {
        return this.cbPlant;
    }

    public IComboBox<String> getCbxMatchLength() {
        return this.cbxMatchLength;
    }

    public IButton getLblZep() {
        return this.lblZep;
    }

    public QuestStatsScreen() {
        super(Forge.getLocalizer().getMessage("lblQuestStatistics", new Object[0]), QuestMenu.getMenu());
        this.lblZep.setHeight(Utils.scale(60.0f));
        this.cbxPet.setDropDownChangeHandler(e -> {
            boolean slot = true;
            int index = this.cbxPet.getSelectedIndex();
            List<QuestPetController> pets = FModel.getQuest().getPetsStorage().getAvaliablePets(1, FModel.getQuest().getAssets());
            String petName = index <= 0 || index > pets.size() ? null : pets.get(index - 1).getName();
            FModel.getQuest().selectPet(1, petName);
            FModel.getQuest().save();
        });
        this.cbxMatchLength.setDropDownChangeHandler(e -> {
            String match = this.cbxMatchLength.getSelectedItem();
            if (match != null) {
                FModel.getQuest().setMatchLength(match.substring(match.length() - 1));
                FModel.getQuest().save();
            }
        });
        this.cbPlant.setCommand(e -> {
            FModel.getQuest().selectPet(0, this.cbPlant.isSelected() ? "Plant" : null);
            FModel.getQuest().save();
        });
        this.lblZep.setCommand(e -> {
            if (!QuestUtil.checkActiveQuest(Forge.getLocalizer().getMessage("lblLaunchaZeppelin", new Object[0]))) {
                return;
            }
            FModel.getQuest().getAchievements().setCurrentChallenges(null);
            FModel.getQuest().getAssets().setItemLevel(QuestItemType.ZEPPELIN, 2);
            this.update();
        });
    }

    void addTournamentResultsLabels(QuestTournamentsScreen tournamentsScreen) {
        this.scroller.add(new FLabel.Builder().font(FSkinFont.get(16)).text(Forge.getLocalizer().getMessage("lblTournamentResults", new Object[0])).build());
        this.scroller.add(tournamentsScreen.getLblFirst());
        this.scroller.add(tournamentsScreen.getLblSecond());
        this.scroller.add(tournamentsScreen.getLblThird());
        this.scroller.add(tournamentsScreen.getLblFourth());
    }

    @Override
    public void onActivate() {
        this.update();
    }

    public void update() {
        QuestUtil.updateQuestView(QuestMenu.getMenu());
        this.setHeaderCaption(FModel.getQuest().getName() + " - " + Forge.getLocalizer().getMessage("lblStatistics", new Object[0]) + "\n(" + FModel.getQuest().getRank() + ")");
        this.scroller.revalidate();
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.scroller.setBounds(0.0f, startY, width, height - startY);
    }

    private static class StatLabel
    extends FLabel {
        private StatLabel(FImage icon0) {
            super(new FLabel.Builder().icon(icon0).font(FSkinFont.get(16)).iconScaleFactor(1.0f));
        }
    }
}

