/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.quest.QuestSpellShop;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.SpellShopManager;
import forge.itemmanager.filters.ItemFilter;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.model.FModel;
import forge.screens.LoadingOverlay;
import forge.screens.TabPageScreen;
import forge.screens.quest.QuestMenu;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import forge.util.ItemPool;
import forge.util.Localizer;
import forge.util.Utils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class QuestSpellShopScreen
extends TabPageScreen<QuestSpellShopScreen> {
    private final SpellShopPage spellShopPage;
    private final InventoryPage inventoryPage;
    private final FLabel btnBuySellMultiple = this.add(new FLabel.ButtonBuilder().font(FSkinFont.get(16)).parseSymbols().build());

    public QuestSpellShopScreen() {
        super("", QuestMenu.getMenu(), new SpellShopBasePage[]{new SpellShopPage(), new InventoryPage()}, true);
        this.spellShopPage = (SpellShopPage)this.tabPages.get(0);
        this.inventoryPage = (InventoryPage)this.tabPages.get(1);
        this.btnBuySellMultiple.setVisible(false);
        this.btnBuySellMultiple.setCommand(event -> {
            SpellShopManager itemManager = ((SpellShopBasePage)this.getSelectedPage()).itemManager;
            ItemPool items = itemManager.getSelectedItemPool();
            if (items.isEmpty()) {
                itemManager.toggleMultiSelectMode(-1);
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                if (this.getSelectedPage() == this.spellShopPage) {
                    this.spellShopPage.activateItems(items);
                } else {
                    this.inventoryPage.activateItems(items);
                }
                FThreads.invokeInEdtLater(this::updateCreditsLabel);
            });
        });
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.update();
    }

    @Override
    protected boolean allowBackInLandscapeMode() {
        return true;
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        FModel.getQuest().save();
        super.onClose(canCloseCallback);
    }

    public void update() {
        QuestUtil.updateQuestView(QuestMenu.getMenu());
        this.setHeaderCaption(FModel.getQuest().getName() + " - " + Forge.getLocalizer().getMessage("lblSpellShop", new Object[0]) + "\n(" + FModel.getQuest().getRank() + ")");
        QuestSpellShop.updateDecksForEachCard();
        double multiplier = QuestSpellShop.updateMultiplier();
        this.spellShopPage.refresh();
        this.inventoryPage.refresh();
        this.updateCreditsLabel();
        double multiPercent = multiplier * 100.0;
        DecimalFormat formatter = new DecimalFormat("#0.00");
        String maxSellingPrice = "";
        int maxSellPrice = FModel.getQuest().getCards().getSellPriceLimit();
        if (maxSellPrice < Integer.MAX_VALUE) {
            maxSellingPrice = String.format(Forge.getLocalizer().getMessage("lblMaximumSellingCredits", new Object[0]), maxSellPrice);
        }
        this.spellShopPage.lblSellPercentage.setText(Forge.getLocalizer().getMessage("lblSellCardsAt", new Object[0]) + formatter.format(multiPercent) + Forge.getLocalizer().getMessage("lblTheirValue", new Object[0]) + maxSellingPrice);
    }

    public void updateCreditsLabel() {
        String credits = Forge.getLocalizer().getMessage("lblCredits", new Object[0]) + ": " + QuestUtil.formatCredits(FModel.getQuest().getAssets().getCredits());
        this.spellShopPage.lblCredits.setText(credits);
        this.inventoryPage.lblCredits.setText(credits);
    }

    private void updateBuySellButtonCaption() {
        long total;
        ItemPool<InventoryItem> items;
        String caption;
        if (this.getSelectedPage() == this.spellShopPage) {
            caption = Forge.getLocalizer().getMessage("lblBuy", new Object[0]);
            items = this.spellShopPage.itemManager.getSelectedItemPool();
            total = QuestSpellShop.getTotalBuyCost(items);
        } else {
            caption = Forge.getLocalizer().getMessage("lblSell", new Object[0]);
            items = this.inventoryPage.itemManager.getSelectedItemPool();
            total = QuestSpellShop.getTotalSellValue(items);
        }
        int count = items.countAll();
        if (count == 0) {
            caption = Forge.getLocalizer().getMessage("lblCancel", new Object[0]);
        } else {
            if (count > 1) {
                String itemType = Forge.getLocalizer().getMessage("lblCard", new Object[0]);
                for (Map.Entry<InventoryItem, Integer> entry : items) {
                    if (entry.getKey() instanceof PaperCard) continue;
                    itemType = Forge.getLocalizer().getMessage("lblItem", new Object[0]);
                    break;
                }
                caption = caption + " " + count + " " + itemType + "s";
            }
            caption = caption + " for {CR} " + total;
        }
        this.btnBuySellMultiple.setText(caption);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        super.doLayout(startY, width, height);
        float padding = ItemFilter.PADDING;
        float buttonHeight = this.tabHeader.getHeight() - 2.0f * padding;
        this.btnBuySellMultiple.setBounds(padding, height - buttonHeight - padding, width - 2.0f * padding, buttonHeight);
    }

    private static class InventoryPage
    extends SpellShopBasePage {
        protected FLabel lblSellExtras = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSellAllExtras", new Object[0])).icon(Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS).iconScaleFactor(1.0f).align(16).font(FSkinFont.get(16)).command(event -> FThreads.invokeInBackgroundThread(() -> {
            QuestSpellShop.sellExtras(((QuestSpellShopScreen)((QuestSpellShopScreen)this.parentScreen)).spellShopPage.itemManager, this.itemManager);
            FThreads.invokeInEdtLater(() -> ((QuestSpellShopScreen)this.parentScreen).updateCreditsLabel());
        })).build());
        protected FLabel lblSelectAll = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblSelectAllCards", new Object[0])).icon(Forge.hdbuttons ? FSkinImage.HDSTAR_FILLED : FSkinImage.STAR_FILLED).iconScaleFactor(1.0f).align(16).font(FSkinFont.get(16)).command(event -> FThreads.invokeInBackgroundThread(() -> {
            if (!this.itemManager.getMultiSelectMode()) {
                this.itemManager.toggleMultiSelectMode(0);
            }
            this.itemManager.selectAll();
            FThreads.invokeInEdtLater(() -> ((QuestSpellShopScreen)this.parentScreen).updateCreditsLabel());
        })).build());

        private InventoryPage() {
            super(Forge.getLocalizer().getMessage("lblYourCards", new Object[0]), FSkinImage.QUEST_BOX, false);
        }

        @Override
        protected void refresh() {
            HashMap<ColumnDef, ItemColumn> colOverrides = new HashMap<ColumnDef, ItemColumn>();
            ItemColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverrides, ColumnDef.PRICE, QuestSpellShop.fnPriceCompare, QuestSpellShop.fnPriceSellGet);
            ItemColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverrides, ColumnDef.NEW, FModel.getQuest().getCards().getFnNewCompare(), FModel.getQuest().getCards().getFnNewGet());
            ItemColumn.addColOverride(ItemManagerConfig.QUEST_INVENTORY, colOverrides, ColumnDef.DECKS, QuestSpellShop.fnDeckCompare, QuestSpellShop.fnDeckGet);
            this.itemManager.setup(ItemManagerConfig.QUEST_INVENTORY, colOverrides);
            ItemPool<InventoryItem> ownedItems = new ItemPool<InventoryItem>(InventoryItem.class);
            ownedItems.addAllOfType(FModel.getQuest().getCards().getCardpool().getView());
            this.itemManager.setPool(ownedItems);
        }

        @Override
        protected void activateItems(ItemPool<InventoryItem> items) {
            QuestSpellShop.sell(items, ((QuestSpellShopScreen)((QuestSpellShopScreen)this.parentScreen)).spellShopPage.itemManager, this.itemManager, true);
        }

        @Override
        protected String getVerb() {
            return "Sell";
        }

        @Override
        protected FSkinImage getVerbIcon() {
            return Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS;
        }

        @Override
        protected FDisplayObject getSecondLabel() {
            return this.lblSellExtras;
        }

        @Override
        protected FDisplayObject getSelectAllLabel() {
            return this.lblSelectAll;
        }
    }

    private static class SpellShopPage
    extends SpellShopBasePage {
        private FTextArea lblSellPercentage = this.add(new FTextArea(false));

        private SpellShopPage() {
            super(Forge.getLocalizer().getMessage("lblCardsForSale", new Object[0]), FSkinImage.QUEST_BOOK, true);
            this.lblSellPercentage.setFont(FSkinFont.get(11));
        }

        @Override
        protected void refresh() {
            FThreads.invokeInEdtLater(() -> {
                Forge.getLocalizer();
                LoadingOverlay.show(Localizer.getInstance().getMessage("lblLoading", new Object[0]), true, () -> {
                    HashMap<ColumnDef, ItemColumn> colOverrides = new HashMap<ColumnDef, ItemColumn>();
                    ItemColumn.addColOverride(ItemManagerConfig.SPELL_SHOP, colOverrides, ColumnDef.PRICE, QuestSpellShop.fnPriceCompare, QuestSpellShop.fnPriceGet);
                    ItemColumn.addColOverride(ItemManagerConfig.SPELL_SHOP, colOverrides, ColumnDef.OWNED, FModel.getQuest().getCards().getFnOwnedCompare(), FModel.getQuest().getCards().getFnOwnedGet());
                    this.itemManager.setup(ItemManagerConfig.SPELL_SHOP, colOverrides);
                    this.itemManager.setPool(FModel.getQuest().getCards().getShopList());
                });
            });
        }

        @Override
        protected void activateItems(ItemPool<InventoryItem> items) {
            QuestSpellShop.buy(items, this.itemManager, ((QuestSpellShopScreen)((QuestSpellShopScreen)this.parentScreen)).inventoryPage.itemManager, true);
        }

        @Override
        protected String getVerb() {
            return "Buy";
        }

        @Override
        protected FSkinImage getVerbIcon() {
            return Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS;
        }

        @Override
        protected FDisplayObject getSecondLabel() {
            return this.lblSellPercentage;
        }

        @Override
        protected FDisplayObject getSelectAllLabel() {
            return null;
        }
    }

    private static abstract class SpellShopBasePage
    extends TabPageScreen.TabPage<QuestSpellShopScreen> {
        protected final SpellShopManager itemManager;
        protected FLabel lblCredits = new FLabel.Builder().icon(FSkinImage.QUEST_COINSTACK).iconScaleFactor(0.75f).font(FSkinFont.get(16)).build();

        protected SpellShopBasePage(String caption0, FImage icon0, boolean isShop0) {
            super(caption0, icon0);
            this.itemManager = this.add(new SpellShopManager(isShop0){

                @Override
                public void toggleMultiSelectMode(int indexToSelect) {
                    super.toggleMultiSelectMode(indexToSelect);
                    boolean multiSelectMode = this.getMultiSelectMode();
                    if (multiSelectMode) {
                        ((QuestSpellShopScreen)parentScreen).updateBuySellButtonCaption();
                    }
                    ((QuestSpellShopScreen)parentScreen).btnBuySellMultiple.setVisible(multiSelectMode);
                    ((QuestSpellShopScreen)parentScreen).tabHeader.setVisible(!multiSelectMode);
                }
            });
            this.itemManager.setItemActivateHandler(event -> {});
            this.itemManager.setContextMenuBuilder(new ItemManager.ContextMenuBuilder<InventoryItem>(){

                @Override
                public void buildMenu(FDropDownMenu menu, InventoryItem item) {
                    menu.addItem(new FMenuItem(this.getVerb(), this.getVerbIcon(), event -> this.activateSelectedItem()));
                }
            });
            this.itemManager.setSelectionChangedHandler(event -> {
                if (this.itemManager.getMultiSelectMode()) {
                    ((QuestSpellShopScreen)this.parentScreen).updateBuySellButtonCaption();
                }
            });
            this.add(this.lblCredits);
        }

        protected abstract void activateItems(ItemPool<InventoryItem> var1);

        protected abstract void refresh();

        protected abstract String getVerb();

        protected abstract FSkinImage getVerbIcon();

        protected abstract FDisplayObject getSecondLabel();

        protected abstract FDisplayObject getSelectAllLabel();

        private void activateSelectedItem() {
            final Object item = this.itemManager.getSelectedItem();
            int max = this.itemManager.getItemCount(item);
            if (max == 0) {
                return;
            }
            Callback<Integer> callback = new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    if (result == null || result <= 0) {
                        return;
                    }
                    FThreads.invokeInBackgroundThread(() -> {
                        ItemPool<InventoryItem> items = new ItemPool<InventoryItem>(InventoryItem.class);
                        items.add(item, result);
                        this.activateItems(items);
                        FThreads.invokeInEdtLater(() -> ((QuestSpellShopScreen)parentScreen).updateCreditsLabel());
                    });
                }
            };
            if (max == 1) {
                callback.run(max);
            } else {
                GuiChoose.getInteger(item + " - " + this.getVerb() + " " + Forge.getLocalizer().getMessage("lblHowMany", new Object[0]), 1, max, 20, callback);
            }
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            if (this.itemManager.getMultiSelectMode()) {
                return false;
            }
            return super.fling(velocityX, velocityY);
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = Utils.scale(2.0f);
            float halfWidth = width / 2.0f;
            this.lblCredits.setBounds(0.0f, y, halfWidth, this.lblCredits.getAutoSizeBounds().height);
            if (this.getSelectAllLabel() != null && Forge.isLandscapeMode()) {
                this.getSelectAllLabel().setBounds(this.lblCredits.getAutoSizeBounds().width + 2.0f, y, halfWidth, this.lblCredits.getHeight());
            }
            this.getSecondLabel().setBounds(halfWidth, y, halfWidth, this.lblCredits.getHeight());
            this.itemManager.setBounds(0.0f, this.lblCredits.getHeight(), width, height - this.lblCredits.getHeight());
        }
    }
}

