/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.quest.QuestMenu;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FNumericTextField;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextField;
import forge.util.Utils;

public class QuestPrefsScreen
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private FScrollPane scroller = this.add(new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float x = PADDING;
            float y = PADDING;
            float w = visibleWidth - 2.0f * PADDING;
            float fieldHeight = FTextField.getDefaultHeight();
            float dy = fieldHeight + PADDING;
            for (FDisplayObject child : this.getChildren()) {
                if (!child.isVisible()) continue;
                child.setBounds(x, y, w, fieldHeight);
                y += dy;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y);
        }
    });

    public QuestPrefsScreen() {
        super(Forge.getLocalizer().getMessage("lblQuestPreferences", new Object[0]), QuestMenu.getMenu());
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblRewards", new Object[0]), FSkinImage.QUEST_COIN, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblBaseWinnings", new Object[0]), QuestPreferences.QPref.REWARDS_BASE, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblNoLosses", new Object[0]), QuestPreferences.QPref.REWARDS_UNDEFEATED, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblPoisonWin", new Object[0]), QuestPreferences.QPref.REWARDS_POISON, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblMillingWin", new Object[0]), QuestPreferences.QPref.REWARDS_MILLED, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblMulligan0Win", new Object[0]), QuestPreferences.QPref.REWARDS_MULLIGAN0, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblAlternativeWin", new Object[0]), QuestPreferences.QPref.REWARDS_ALTERNATIVE, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinbyTurn15", new Object[0]), QuestPreferences.QPref.REWARDS_TURN15, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinbyTurn10", new Object[0]), QuestPreferences.QPref.REWARDS_TURN10, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinbyTurn5", new Object[0]), QuestPreferences.QPref.REWARDS_TURN5, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblFirstTurnWin", new Object[0]), QuestPreferences.QPref.REWARDS_TURN1, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblExcludePromosFromRewardPool", new Object[0]), QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL, PrefsGroup.REWARDS));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblBoosterPackRatios", new Object[0]), FSkinImage.QUEST_BOOK, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblCommon", new Object[0]), QuestPreferences.QPref.BOOSTER_COMMONS, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblUncommon", new Object[0]), QuestPreferences.QPref.BOOSTER_UNCOMMONS, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblRare", new Object[0]), QuestPreferences.QPref.BOOSTER_RARES, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblSpecialBoosters", new Object[0]), QuestPreferences.QPref.SPECIAL_BOOSTERS, PrefsGroup.BOOSTER));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblShopPreferences", new Object[0]), FSkinImage.QUEST_COIN, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblMaximumPacks", new Object[0]), QuestPreferences.QPref.SHOP_MAX_PACKS, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingPacks", new Object[0]), QuestPreferences.QPref.SHOP_STARTING_PACKS, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsforPack", new Object[0]), QuestPreferences.QPref.SHOP_WINS_FOR_ADDITIONAL_PACK, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsperSetUnlock", new Object[0]), QuestPreferences.QPref.WINS_UNLOCK_SET, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblCommonSingles", new Object[0]), QuestPreferences.QPref.SHOP_SINGLES_COMMON, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblUncommonSingles", new Object[0]), QuestPreferences.QPref.SHOP_SINGLES_UNCOMMON, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblRareSingles", new Object[0]), QuestPreferences.QPref.SHOP_SINGLES_RARE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblSellingPercentageBase", new Object[0]), QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_BASE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblSellingPercentageMax", new Object[0]), QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_MAX, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblSellingPriceMax", new Object[0]), QuestPreferences.QPref.SHOP_MAX_SELLING_PRICE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblPlaysetSize", new Object[0]), QuestPreferences.QPref.PLAYSET_SIZE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblPlaysetSizeBasicLand", new Object[0]), QuestPreferences.QPref.PLAYSET_BASIC_LAND_SIZE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblPlaysetSizeAnyNumber", new Object[0]), QuestPreferences.QPref.PLAYSET_ANY_NUMBER_SIZE, PrefsGroup.SHOP));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblDifficultyAdjustmentsAll", new Object[0]), FSkinImage.QUEST_NOTES, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingSnowLands", new Object[0]), QuestPreferences.QPref.STARTING_SNOW_LANDS, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblColorBias", new Object[0]), QuestPreferences.QPref.STARTING_POOL_COLOR_BIAS, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblPenaltyforLoss", new Object[0]), QuestPreferences.QPref.PENALTY_LOSS, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWildOpponentMultiplier", new Object[0]), QuestPreferences.QPref.WILD_OPPONENTS_MULTIPLIER, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWildOpponentNumber", new Object[0]), QuestPreferences.QPref.WILD_OPPONENTS_NUMBER, PrefsGroup.DIFFICULTY_ALL));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblDifficultyAdjustmentsEasy", new Object[0]), FSkinImage.QUEST_NOTES, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForBooster", new Object[0]), QuestPreferences.QPref.WINS_BOOSTER_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForRankIncrease", new Object[0]), QuestPreferences.QPref.WINS_RANKUP_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForMediumAI", new Object[0]), QuestPreferences.QPref.WINS_MEDIUMAI_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForHardAI", new Object[0]), QuestPreferences.QPref.WINS_HARDAI_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForExpertAI", new Object[0]), QuestPreferences.QPref.WINS_EXPERTAI_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCommons", new Object[0]), QuestPreferences.QPref.STARTING_COMMONS_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingUncommons", new Object[0]), QuestPreferences.QPref.STARTING_UNCOMMONS_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingRares", new Object[0]), QuestPreferences.QPref.STARTING_RARES_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCredits", new Object[0]), QuestPreferences.QPref.STARTING_CREDITS_EASY, PrefsGroup.DIFFICULTY_EASY));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblDifficultyAdjustmentsMedium", new Object[0]), FSkinImage.QUEST_NOTES, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForBooster", new Object[0]), QuestPreferences.QPref.WINS_BOOSTER_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForRankIncrease", new Object[0]), QuestPreferences.QPref.WINS_RANKUP_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForMediumAI", new Object[0]), QuestPreferences.QPref.WINS_MEDIUMAI_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForHardAI", new Object[0]), QuestPreferences.QPref.WINS_HARDAI_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForExpertAI", new Object[0]), QuestPreferences.QPref.WINS_EXPERTAI_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCommons", new Object[0]), QuestPreferences.QPref.STARTING_COMMONS_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingUncommons", new Object[0]), QuestPreferences.QPref.STARTING_UNCOMMONS_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingRares", new Object[0]), QuestPreferences.QPref.STARTING_RARES_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCredits", new Object[0]), QuestPreferences.QPref.STARTING_CREDITS_MEDIUM, PrefsGroup.DIFFICULTY_MEDIUM));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblDifficultyAdjustmentsHard", new Object[0]), FSkinImage.QUEST_NOTES, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForBooster", new Object[0]), QuestPreferences.QPref.WINS_BOOSTER_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForRankIncrease", new Object[0]), QuestPreferences.QPref.WINS_RANKUP_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForMediumAI", new Object[0]), QuestPreferences.QPref.WINS_MEDIUMAI_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForHardAI", new Object[0]), QuestPreferences.QPref.WINS_HARDAI_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForExpertAI", new Object[0]), QuestPreferences.QPref.WINS_EXPERTAI_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCommons", new Object[0]), QuestPreferences.QPref.STARTING_COMMONS_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingUncommons", new Object[0]), QuestPreferences.QPref.STARTING_UNCOMMONS_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingRares", new Object[0]), QuestPreferences.QPref.STARTING_RARES_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCredits", new Object[0]), QuestPreferences.QPref.STARTING_CREDITS_HARD, PrefsGroup.DIFFICULTY_HARD));
        this.scroller.add(new PrefsHeader(Forge.getLocalizer().getMessage("lblDifficultyAdjustmentsExpert", new Object[0]), FSkinImage.QUEST_NOTES, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForBooster", new Object[0]), QuestPreferences.QPref.WINS_BOOSTER_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForRankIncrease", new Object[0]), QuestPreferences.QPref.WINS_RANKUP_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForMediumAI", new Object[0]), QuestPreferences.QPref.WINS_MEDIUMAI_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForHardAI", new Object[0]), QuestPreferences.QPref.WINS_HARDAI_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblWinsForExpertAI", new Object[0]), QuestPreferences.QPref.WINS_EXPERTAI_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCommons", new Object[0]), QuestPreferences.QPref.STARTING_COMMONS_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingUncommons", new Object[0]), QuestPreferences.QPref.STARTING_UNCOMMONS_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingRares", new Object[0]), QuestPreferences.QPref.STARTING_RARES_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
        this.scroller.add(new PrefsOption(Forge.getLocalizer().getMessage("lblStartingCredits", new Object[0]), QuestPreferences.QPref.STARTING_CREDITS_EXPERT, PrefsGroup.DIFFICULTY_EXPERT));
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.scroller.setBounds(0.0f, startY, width, height - startY);
    }

    private static final class PrefsOption
    extends FContainer {
        private static final float FIELD_WIDTH = new FTextField("99999").getAutoSizeWidth();
        private final FLabel label = this.add(new FLabel.Builder().build());
        private final OptionField field = this.add(new OptionField());
        private final QuestPreferences.QPref pref;
        private final PrefsGroup group;

        private PrefsOption(String label0, QuestPreferences.QPref pref0, PrefsGroup group0) {
            this.label.setText(label0);
            this.pref = pref0;
            this.group = group0;
            this.field.setText(FModel.getQuestPreferences().getPref(pref0));
        }

        @Override
        protected void doLayout(float width, float height) {
            this.label.setBounds(0.0f, 0.0f, width - FIELD_WIDTH - PADDING, height);
            this.field.setBounds(width - FIELD_WIDTH, 0.0f, FIELD_WIDTH, height);
        }

        private final class OptionField
        extends FNumericTextField {
            private OptionField() {
            }

            @Override
            protected boolean validate() {
                if (super.validate()) {
                    QuestPreferences prefs = FModel.getQuestPreferences();
                    int val = Integer.parseInt(this.getText());
                    String validationError = prefs.validatePreference(PrefsOption.this.pref, val);
                    if (validationError != null) {
                        String prefType;
                        switch (PrefsOption.this.group) {
                            case REWARDS: {
                                prefType = Forge.getLocalizer().getMessage("lblRewards", new Object[0]);
                                break;
                            }
                            case BOOSTER: {
                                prefType = Forge.getLocalizer().getMessage("lblBoosterPackRatios", new Object[0]);
                                break;
                            }
                            case SHOP: {
                                prefType = Forge.getLocalizer().getMessage("lblShopPreferences", new Object[0]);
                                break;
                            }
                            case DRAFT_TOURNAMENTS: {
                                prefType = Forge.getLocalizer().getMessage("lblDraftTournaments", new Object[0]);
                                break;
                            }
                            default: {
                                prefType = Forge.getLocalizer().getMessage("lblDifficultyAdjustments", new Object[0]);
                            }
                        }
                        FOptionPane.showErrorDialog(validationError, Forge.getLocalizer().getMessage("lblSaveFailed", new Object[0]) + prefType);
                        return false;
                    }
                    prefs.setPref(PrefsOption.this.pref, this.getText());
                    prefs.save();
                    return true;
                }
                return false;
            }
        }
    }

    private final class PrefsHeader
    extends FLabel {
        private PrefsHeader(String title, FImage icon, final PrefsGroup group) {
            super(new FLabel.ButtonBuilder().text(title).font(FSkinFont.get(16)).icon(icon).iconScaleFactor(1.0f).command(new FEvent.FEventHandler(){
                private boolean showOptions = true;

                @Override
                public void handleEvent(FEvent e) {
                    this.showOptions = !this.showOptions;
                    for (FDisplayObject child : QuestPrefsScreen.this.scroller.getChildren()) {
                        if (!(child instanceof PrefsOption) || ((PrefsOption)child).group != group) continue;
                        child.setVisible(this.showOptions);
                    }
                    QuestPrefsScreen.this.scroller.revalidate();
                }
            }));
        }
    }

    private static enum PrefsGroup {
        REWARDS,
        BOOSTER,
        SHOP,
        DIFFICULTY_ALL,
        DIFFICULTY_EASY,
        DIFFICULTY_MEDIUM,
        DIFFICULTY_HARD,
        DIFFICULTY_EXPERT,
        DRAFT_TOURNAMENTS;

    }
}

