/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.model.FModel;
import forge.screens.LaunchScreen;
import forge.screens.LoadingOverlay;
import forge.screens.quest.QuestMenu;
import forge.toolbox.FOptionPane;

public abstract class QuestLaunchScreen
extends LaunchScreen {
    protected static final float PADDING = FOptionPane.PADDING;

    public QuestLaunchScreen() {
        super("", QuestMenu.getMenu());
    }

    @Override
    public final void onActivate() {
        this.update();
    }

    @Override
    protected void startMatch() {
        FThreads.invokeInBackgroundThread(() -> {
            if (QuestUtil.canStartGame()) {
                FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, QuestUtil::finishStartingGame));
                return;
            }
        });
    }

    public final void update() {
        QuestUtil.updateQuestView(QuestMenu.getMenu());
        this.updateHeaderCaption();
        this.onUpdate();
    }

    protected void updateHeaderCaption() {
        this.setHeaderCaption(FModel.getQuest().getName() + " - " + this.getGameType() + "\n(" + FModel.getQuest().getRank() + ")");
    }

    protected abstract String getGameType();

    protected abstract void onUpdate();
}

