/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.assets.ImageCache;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.deck.FDeckChooser;
import forge.deck.FDeckViewer;
import forge.game.GameType;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.FThreads;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.quest.QuestDeckEditor;
import forge.screens.quest.QuestMenu;
import forge.toolbox.FButton;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FTextField;
import forge.util.ThreadUtil;

public class QuestDecksScreen
extends FScreen {
    private static final float PADDING = FDeckChooser.PADDING;
    private final DeckManager lstDecks = this.add(new DeckManager(GameType.Quest));
    private final FButton btnNewDeck = this.add(new FButton(Forge.getLocalizer().getMessage("lblNewDeck", new Object[0])));
    private final FButton btnEditDeck = this.add(new FButton(Forge.getLocalizer().getMessage("btnEditDeck", new Object[0])));
    private final FButton btnViewDeck = this.add(new FButton(Forge.getLocalizer().getMessage("lblViewDeck", new Object[0])));
    private final FButton btnRandom = this.add(new FButton(Forge.getLocalizer().getMessage("lblRandomDeck", new Object[0])));
    private final FLabel lblInfo = this.add(new FLabel.Builder().align(1).font(FSkinFont.get(16)).text(Forge.getLocalizer().getMessage("lblBuildorselectadeck", new Object[0])).build());
    private final FEvent.FEventHandler onDeckSelectionChanged = e -> {
        DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
        if (deck != null) {
            FModel.getQuest().setCurrentDeck(deck.toString());
        } else {
            FModel.getQuest().setCurrentDeck(QuestPreferences.QPref.CURRENT_DECK.getDefault());
        }
        FModel.getQuest().save();
    };
    private boolean needRefreshOnActivate = true;
    public boolean commanderMode = false;

    public QuestDecksScreen() {
        super("", QuestMenu.getMenu());
        this.lstDecks.setup(ItemManagerConfig.QUEST_DECKS);
        this.lstDecks.setItemActivateHandler(e -> Forge.back());
        this.btnNewDeck.setCommand(e -> ThreadUtil.invokeInGameThread(() -> {
            if (!QuestUtil.checkActiveQuest(Forge.getLocalizer().getMessage("lblCreateaDeck", new Object[0]))) {
                return;
            }
            FThreads.invokeInEdtLater(() -> {
                QuestDeckEditor editor = new QuestDeckEditor(this.commanderMode);
                editor.setSaveHandler(e1 -> {
                    this.needRefreshOnActivate = true;
                });
                Forge.openScreen(editor);
            });
        }));
        this.btnEditDeck.setCommand(e -> this.editSelectedDeck());
        this.btnViewDeck.setCommand(e -> {
            DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
            if (deck != null) {
                FDeckViewer.show(deck.getDeck());
            }
        });
        this.btnRandom.setCommand(e -> DeckgenUtil.randomSelect(this.lstDecks));
    }

    @Override
    public void onActivate() {
        QuestUtil.updateQuestView(QuestMenu.getMenu());
        this.setHeaderCaption(FModel.getQuest().getName() + " - Decks\n(" + FModel.getQuest().getRank() + ")");
        if (this.needRefreshOnActivate) {
            this.needRefreshOnActivate = false;
            this.refreshDecks();
        }
    }

    public void refreshDecks() {
        DeckProxy deck;
        this.lstDecks.setSelectionChangedHandler(null);
        QuestController qData = FModel.getQuest();
        boolean hasQuest = qData.getAssets() != null;
        this.lstDecks.setPool(DeckProxy.getAllQuestDecks(hasQuest ? qData.getMyDecks() : null));
        this.lstDecks.setup(ItemManagerConfig.QUEST_DECKS);
        DeckProxy deckProxy = deck = hasQuest ? (DeckProxy)this.lstDecks.stringToItem(FModel.getQuest().getCurrentDeck()) : null;
        if (deck != null) {
            this.lstDecks.setSelectedItem(deck);
        } else {
            this.lstDecks.setSelectedIndex(0);
            this.onDeckSelectionChanged.handleEvent(null);
        }
        this.lstDecks.setSelectionChangedHandler(this.onDeckSelectionChanged);
    }

    private void editSelectedDeck() {
        DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
        if (deck == null) {
            return;
        }
        ImageCache.preloadCache(deck.getDeck());
        this.needRefreshOnActivate = true;
        Forge.openScreen(new QuestDeckEditor(deck, this.commanderMode));
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING / 2.0f;
        float w = width - 2.0f * PADDING;
        this.lblInfo.setBounds(x, y, w, this.lblInfo.getAutoSizeBounds().height);
        float buttonWidth = (w - PADDING) / 2.0f;
        float buttonHeight = FTextField.getDefaultHeight();
        float listHeight = height - 2.0f * buttonHeight - (y += this.lblInfo.getHeight()) - 3.0f * PADDING;
        this.lstDecks.setBounds(x, y, w, listHeight);
        this.btnNewDeck.setBounds(x, y += listHeight + PADDING, buttonWidth, buttonHeight);
        this.btnEditDeck.setBounds(x + buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        this.btnViewDeck.setBounds(x, y += buttonHeight + PADDING, buttonWidth, buttonHeight);
        this.btnRandom.setBounds(x + buttonWidth + PADDING, y, buttonWidth, buttonHeight);
    }
}

