/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestBazaarManager;
import forge.gamemodes.quest.bazaar.QuestStallDefinition;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gui.GuiBase;
import forge.model.FModel;
import forge.screens.TabPageScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextArea;
import forge.util.Utils;
import java.util.List;
import java.util.Set;

public class QuestBazaarScreen
extends TabPageScreen<QuestBazaarScreen> {
    public QuestBazaarScreen() {
        super(QuestBazaarScreen.getPages());
    }

    @Override
    protected boolean allowBackInLandscapeMode() {
        return true;
    }

    private static BazaarPage[] getPages() {
        int pageNum = 0;
        QuestBazaarManager bazaar = FModel.getQuest().getBazaar();
        Set<String> stallNames = bazaar.getStallNames();
        BazaarPage[] pages = new BazaarPage[stallNames.size()];
        for (String s2 : stallNames) {
            pages[pageNum++] = new BazaarPage(bazaar.getStall(s2));
        }
        return pages;
    }

    private static class BazaarItemDisplay
    extends FContainer {
        private final FLabel lblName = this.add(new FLabel.Builder().font(FSkinFont.get(15)).insets(Vector2.Zero).build());
        private final FTextArea lblDesc = this.add(new FTextArea(false));
        private final FLabel lblIcon = this.add(new FLabel.Builder().iconInBackground().iconScaleFactor(1.0f).insets(Vector2.Zero).build());
        private final FLabel lblCost = this.add(new FLabel.Builder().text("0").icon(FSkinImage.QUEST_COINSTACK).iconScaleFactor(1.0f).build());
        private final FLabel btnBuy = this.add(new FLabel.ButtonBuilder().text(Forge.getLocalizer().getMessage("lblBuy", new Object[0])).font(FSkinFont.get(20)).build());
        private final IQuestBazaarItem item;

        private BazaarItemDisplay(IQuestBazaarItem item0) {
            this.item = item0;
            QuestAssets assets = FModel.getQuest().getAssets();
            int buyingPrice = this.item.getBuyingPrice(assets);
            this.lblName.setText(this.item.getPurchaseName());
            this.lblDesc.setText(this.item.getPurchaseDescription(assets));
            this.lblIcon.setIcon((FImage)this.item.getIcon(assets));
            this.lblCost.setText(String.valueOf(buyingPrice));
            this.lblDesc.setFont(FSkinFont.get(12));
            this.lblDesc.setTextColor(FLabel.getInlineLabelColor());
            this.lblName.setHeight(this.lblName.getAutoSizeBounds().height);
            this.btnBuy.setHeight(this.btnBuy.getAutoSizeBounds().height * 1.2f);
            this.lblCost.setHeight(this.lblCost.getAutoSizeBounds().height);
            if (assets.getCredits() < (long)buyingPrice) {
                this.btnBuy.setEnabled(false);
            } else {
                this.btnBuy.setCommand(e -> {
                    QuestUtil.buyQuestItem(this.item);
                    ((BazaarPage)((QuestBazaarScreen)Forge.getCurrentScreen()).getSelectedPage()).update();
                });
            }
        }

        @Override
        public void drawOverlay(Graphics g2) {
            float y = this.getHeight() - FList.LINE_THICKNESS / 2.0f;
            g2.drawLine(FList.LINE_THICKNESS, FList.getLineColor(), 0.0f, y, this.getWidth(), y);
        }

        public float getPreferredHeight(float width) {
            float padding = BazaarPage.PADDING;
            float labelWidth = (width -= 2.0f * padding) * 0.7f;
            float iconWidth = width - labelWidth - padding;
            float iconHeight = iconWidth * this.lblIcon.getIcon().getHeight() / this.lblIcon.getIcon().getWidth();
            float height1 = this.lblName.getHeight() + this.lblDesc.getPreferredHeight(labelWidth) + 3.0f * padding;
            float height2 = iconHeight + this.btnBuy.getHeight() + this.lblCost.getHeight() + 4.0f * padding;
            return Math.max(height1, height2);
        }

        @Override
        protected void doLayout(float width, float height) {
            float padding = BazaarPage.PADDING;
            float labelWidth = (width -= 2.0f * padding) * 0.7f;
            float iconWidth = width - labelWidth - padding;
            float iconHeight = iconWidth * this.lblIcon.getIcon().getHeight() / this.lblIcon.getIcon().getWidth();
            float x = padding;
            float y = padding;
            this.lblName.setBounds(x, y, labelWidth, this.lblName.getHeight());
            this.lblDesc.setBounds(x, y += this.lblName.getHeight() + padding, labelWidth, height - y - padding);
            y = padding;
            this.lblIcon.setBounds(x += labelWidth + padding, y, iconWidth, iconHeight);
            this.lblCost.setBounds(x, y += iconHeight + padding, iconWidth, this.lblCost.getHeight());
            this.btnBuy.setBounds(x, y += this.lblCost.getHeight() + padding, iconWidth, this.btnBuy.getHeight());
        }
    }

    private static class BazaarPage
    extends TabPageScreen.TabPage<QuestBazaarScreen> {
        private static final float PADDING = Utils.scale(5.0f);
        private final QuestStallDefinition stallDef;
        private final FLabel lblStallName = this.add(new FLabel.Builder().text("").align(1).build());
        private final FLabel lblEmpty = this.add(new FLabel.Builder().font(FSkinFont.get(12)).text(Forge.getLocalizer().getMessage("lblMerchantDoesHaveCommodity", new Object[0])).align(1).build());
        private final FLabel lblCredits = this.add(new FLabel.Builder().font(FSkinFont.get(15)).icon(FSkinImage.QUEST_COINSTACK).iconScaleFactor(1.0f).build());
        private final FLabel lblLife = this.add(new FLabel.Builder().font(this.lblCredits.getFont()).icon(FSkinImage.QUEST_LIFE).iconScaleFactor(1.0f).align(16).build());
        private final FTextArea lblFluff = this.add(new FTextArea(false));
        private final FScrollPane scroller = this.add(new FScrollPane(){

            @Override
            protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
                float y = 0.0f;
                for (FDisplayObject child : this.getChildren()) {
                    child.setBounds(0.0f, y, visibleWidth, ((BazaarItemDisplay)child).getPreferredHeight(visibleWidth));
                    y += child.getHeight();
                }
                return new FScrollPane.ScrollBounds(visibleWidth, y);
            }

            @Override
            public void drawOnContainer(Graphics g2) {
                float y = scroller.getTop() - FList.LINE_THICKNESS / 2.0f;
                g2.drawLine(FList.LINE_THICKNESS, FList.getLineColor(), 0.0f, y, this.getWidth(), y);
            }
        });

        private BazaarPage(QuestStallDefinition stallDef0) {
            super(stallDef0.getName(), (FImage)GuiBase.getInterface().getSkinIcon(stallDef0.getIcon()));
            this.stallDef = stallDef0;
            this.lblFluff.setFont(FSkinFont.get(12));
            this.lblFluff.setAlignment(1);
            this.lblFluff.setTextColor(FLabel.getInlineLabelColor());
        }

        @Override
        protected void onActivate() {
            this.update();
        }

        public void update() {
            this.scroller.clear();
            QuestController qData = FModel.getQuest();
            if (qData.getAssets() == null) {
                return;
            }
            QuestAssets qS = qData.getAssets();
            this.lblCredits.setText(Forge.getLocalizer().getMessage("lblCredits", new Object[0]) + ": " + QuestUtil.formatCredits(qS.getCredits()));
            this.lblLife.setText(Forge.getLocalizer().getMessage("lblLife", new Object[0]) + ": " + qS.getLife(qData.getMode()));
            List<IQuestBazaarItem> items = qData.getBazaar().getItems(qData, this.stallDef.getName());
            this.lblStallName.setText(this.stallDef.getDisplayName());
            this.lblFluff.setText(this.stallDef.getFluff());
            if (items.size() == 0) {
                this.lblEmpty.setVisible(true);
            } else {
                this.lblEmpty.setVisible(false);
                for (IQuestBazaarItem item : items) {
                    this.scroller.add(new BazaarItemDisplay(item));
                }
            }
            this.revalidate();
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = PADDING;
            float y = PADDING;
            float w = width - 2.0f * PADDING;
            this.lblStallName.setBounds(x, y, w, this.lblStallName.getAutoSizeBounds().height);
            this.lblFluff.setBounds(x, y += this.lblStallName.getHeight() + PADDING, w, this.lblFluff.getPreferredHeight(w));
            this.lblCredits.setBounds(x, y += this.lblFluff.getHeight() + PADDING, w / 2.0f, this.lblCredits.getAutoSizeBounds().height);
            this.lblLife.setBounds(x + w / 2.0f, y, w / 2.0f, this.lblCredits.getHeight());
            this.scroller.setBounds(0.0f, y += this.lblCredits.getHeight() + PADDING, width, height - y);
            if (this.lblEmpty.isVisible()) {
                this.lblEmpty.setBounds(x, y, w, this.lblEmpty.getAutoSizeBounds().height);
            }
        }
    }
}

