/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.quest;

import com.badlogic.gdx.Gdx;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.QuestData;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.QuestDataIO;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.screens.LaunchScreen;
import forge.screens.home.LoadGameMenu;
import forge.screens.home.NewGameMenu;
import forge.screens.quest.QuestMenu;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FButton;
import forge.toolbox.FList;
import forge.toolbox.FTextArea;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import forge.util.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class LoadQuestScreen
extends LaunchScreen {
    private static final float ITEM_HEIGHT = Utils.AVG_FINGER_HEIGHT;
    private static final float PADDING = Utils.AVG_FINGER_HEIGHT * 0.1f;
    private static final FSkinColor OLD_QUESTS_BACK_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_INACTIVE).getContrastColor(20);
    private static final FSkinColor SEL_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    private final FTextArea lblOldQuests;
    private final QuestFileLister lstQuests;
    private final FButton btnNewQuest;
    private final FButton btnRenameQuest;
    private final FButton btnDeleteQuest;

    public LoadQuestScreen() {
        super(null, LoadGameMenu.getMenu());
        Forge.getLocalizer();
        this.lblOldQuests = this.add(new FTextArea(false, Localizer.getInstance().getMessage("lblLoadingExistingQuests", new Object[0])));
        this.lstQuests = this.add(new QuestFileLister());
        Forge.getLocalizer();
        this.btnNewQuest = this.add(new FButton(Localizer.getInstance().getMessage("lblNewQuest", new Object[0])));
        Forge.getLocalizer();
        this.btnRenameQuest = this.add(new FButton(Localizer.getInstance().getMessage("lblRename", new Object[0])));
        Forge.getLocalizer();
        this.btnDeleteQuest = this.add(new FButton(Localizer.getInstance().getMessage("lblDelete", new Object[0])));
        this.lblOldQuests.setFont(FSkinFont.get(12));
        this.lblOldQuests.setAlignment(1);
        this.btnNewQuest.setFont(FSkinFont.get(16));
        this.btnNewQuest.setCommand(e -> NewGameMenu.NewGameScreen.QuestMode.open());
        this.btnRenameQuest.setFont(this.btnNewQuest.getFont());
        this.btnRenameQuest.setCommand(e -> this.renameQuest(this.lstQuests.getSelectedQuest()));
        this.btnDeleteQuest.setFont(this.btnNewQuest.getFont());
        this.btnDeleteQuest.setCommand(e -> this.deleteQuest(this.lstQuests.getSelectedQuest()));
    }

    @Override
    public void onActivate() {
        this.lblOldQuests.setText(Forge.getLocalizer().getMessage("lblLoadingExistingQuests", new Object[0]));
        this.lstQuests.clear();
        this.updateEnabledButtons();
        this.revalidate();
        FThreads.invokeInBackgroundThread(() -> {
            File dirQuests = new File(ForgeConstants.QUEST_SAVE_DIR);
            QuestController qc = FModel.getQuest();
            FilenameFilter takeDatFiles = (dir, name) -> name.endsWith(".dat");
            File[] arrFiles = dirQuests.listFiles(takeDatFiles);
            HashMap<String, QuestData> arrQuests = new HashMap<String, QuestData>();
            for (File f : arrFiles) {
                try {
                    arrQuests.put(f.getName(), QuestDataIO.loadData(f));
                }
                catch (IOException e) {
                    System.err.printf("Failed to load quest '%s'%n", f.getName());
                    return;
                }
            }
            this.lstQuests.setQuests(new ArrayList<QuestData>(arrQuests.values()));
            if (arrQuests.size() > 0) {
                String questname = FModel.getQuestPreferences().getPref(QuestPreferences.QPref.CURRENT_QUEST);
                if (arrQuests.get(questname) != null) {
                    this.lstQuests.setSelectedQuest((QuestData)arrQuests.get(questname));
                } else {
                    this.lstQuests.setSelectedIndex(0);
                }
                qc.load(this.lstQuests.getSelectedQuest());
            } else {
                qc.load(null);
            }
            Gdx.app.postRunnable(() -> {
                String str = ForgeConstants.QUEST_SAVE_DIR.replace('\\', '/');
                this.lblOldQuests.setText(Forge.getLocalizer().getMessage("lblOldQuestData", new Object[0]).replace("%s", str));
                this.updateEnabledButtons();
                this.revalidate();
                this.lstQuests.scrollIntoView(this.lstQuests.selectedIndex);
            });
        });
    }

    private void updateEnabledButtons() {
        boolean enabled = this.lstQuests.getSelectedQuest() != null;
        this.btnStart.setEnabled(enabled);
        this.btnRenameQuest.setEnabled(enabled);
        this.btnDeleteQuest.setEnabled(enabled);
    }

    @Override
    protected void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        float y = Forge.isLandscapeMode() ? 0.0f : this.getHeader().getBottom();
        g2.fillRect(OLD_QUESTS_BACK_COLOR, 0.0f, y, this.lstQuests.getWidth(), this.lstQuests.getTop() - y);
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        float y = this.lstQuests.getTop();
        g2.drawLine(1.0f, FList.getLineColor(), 0.0f, y, this.lstQuests.getWidth(), y);
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float buttonWidth = (width - 2.0f * PADDING) / 3.0f;
        float buttonHeight = this.btnNewQuest.getAutoSizeBounds().height * 1.2f;
        float y = startY + 2.0f * PADDING;
        this.lblOldQuests.setBounds(0.0f, y, width, this.lblOldQuests.getPreferredHeight(width));
        this.lstQuests.setBounds(0.0f, y += this.lblOldQuests.getHeight() + PADDING, width, height - y - buttonHeight - PADDING);
        float x = 0.0f;
        this.btnNewQuest.setBounds(x, y += this.lstQuests.getHeight() + PADDING, buttonWidth, buttonHeight);
        this.btnRenameQuest.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        this.btnDeleteQuest.setBounds(x += buttonWidth + PADDING, y, buttonWidth, buttonHeight);
    }

    private void changeQuest() {
        QuestData quest = this.lstQuests.getSelectedQuest();
        if (quest == null) {
            return;
        }
        FModel.getQuestPreferences().setPref(QuestPreferences.QPref.CURRENT_QUEST, quest.getName() + ".dat");
        FModel.getQuestPreferences().save();
        QuestMenu.launchQuestMode(QuestMenu.LaunchReason.LoadQuest, quest.deckConstructionRules == DeckConstructionRules.Commander);
    }

    private void renameQuest(QuestData quest) {
        if (quest == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            String questName;
            String oldQuestName = quest.getName();
            while (true) {
                if ((questName = SOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblEnterNewQuestName", new Object[0]), Forge.getLocalizer().getMessage("lblRenameQuest", new Object[0]), null, oldQuestName)) == null) {
                    return;
                }
                if ((questName = QuestUtil.cleanString(questName)).equals(oldQuestName)) {
                    return;
                }
                if (questName.isEmpty()) {
                    SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblQuestNameEmpty", new Object[0]));
                    continue;
                }
                boolean exists = false;
                for (QuestData questData : this.lstQuests) {
                    if (!questData.getName().equalsIgnoreCase(questName)) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                SOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblQuestExists", new Object[0]));
            }
            quest.rename(questName);
        });
    }

    private void deleteQuest(QuestData quest) {
        if (quest == null) {
            return;
        }
        ThreadUtil.invokeInGameThread(() -> {
            if (!SOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblConfirmDelete", new Object[0]) + " '" + quest.getName() + "'?", Forge.getLocalizer().getMessage("lblDeleteQuest", new Object[0]), Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]))) {
                return;
            }
            FThreads.invokeInEdtLater(() -> {
                new File(ForgeConstants.QUEST_SAVE_DIR, quest.getName() + ".dat").delete();
                new File(ForgeConstants.QUEST_SAVE_DIR, quest.getName() + ".dat.bak").delete();
                this.lstQuests.removeQuest(quest);
                this.updateEnabledButtons();
            });
        });
    }

    @Override
    protected void startMatch() {
        this.changeQuest();
    }

    private class QuestFileLister
    extends FList<QuestData> {
        private int selectedIndex = 0;

        private QuestFileLister() {
            this.setListItemRenderer(new FList.ListItemRenderer<QuestData>(){

                @Override
                public boolean tap(Integer index, QuestData value, float x, float y, int count) {
                    if (count == 2) {
                        LoadQuestScreen.this.changeQuest();
                    } else {
                        QuestFileLister.this.selectedIndex = index;
                    }
                    return true;
                }

                @Override
                public float getItemHeight() {
                    return ITEM_HEIGHT;
                }

                @Override
                public void drawValue(Graphics g2, Integer index, QuestData value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    float offset = SettingsScreen.getInsets(w) - FList.PADDING;
                    x += offset;
                    y += offset;
                    w -= 2.0f * offset;
                    float totalHeight = h2 -= 2.0f * offset;
                    String name = value.getName() + " (" + value.getMode().toString() + ")";
                    h2 = font.getMultiLineBounds((CharSequence)name).height + SettingsScreen.SETTING_PADDING;
                    String winRatio = value.getAchievements().getWin() + "W / " + value.getAchievements().getLost() + "L";
                    float winRatioWidth = font.getBounds((CharSequence)winRatio).width + SettingsScreen.SETTING_PADDING;
                    g2.drawText(name, font, foreColor, x, y, w - winRatioWidth, h2, false, 8, false);
                    g2.drawText(winRatio, font, foreColor, x, y, w, h2, false, 16, false);
                    y += (h2 += SettingsScreen.SETTING_PADDING);
                    h2 = totalHeight - h2 + SettingsScreen.getInsets(w);
                    float iconSize = h2 + Utils.scale(1.0f);
                    float iconOffset = SettingsScreen.SETTING_PADDING - Utils.scale(2.0f);
                    String cards = String.valueOf(value.getAssets().getCardPool().countAll());
                    String credits = String.valueOf(value.getAssets().getCredits());
                    font = FSkinFont.get(12);
                    float cardsWidth = font.getBounds((CharSequence)cards).width + iconSize + SettingsScreen.SETTING_PADDING;
                    float creditsWidth = font.getBounds((CharSequence)credits).width + iconSize + SettingsScreen.SETTING_PADDING;
                    g2.drawText(FModel.getQuest().getRank(value.getAchievements().getLevel()), font, SettingsScreen.DESC_COLOR, x, y, w - creditsWidth - cardsWidth, h2, false, 8, false);
                    g2.drawImage(FSkinImage.HAND, x + w - creditsWidth - cardsWidth + iconOffset, y - SettingsScreen.SETTING_PADDING, iconSize, iconSize);
                    g2.drawText(cards, font, SettingsScreen.DESC_COLOR, x + w - creditsWidth - cardsWidth + iconSize + SettingsScreen.SETTING_PADDING, y, w, h2, false, 8, false);
                    g2.drawImage(FSkinImage.QUEST_COINSTACK, x + w - creditsWidth + iconOffset, y - SettingsScreen.SETTING_PADDING, iconSize, iconSize);
                    g2.drawText(credits, font, SettingsScreen.DESC_COLOR, x + w - creditsWidth + iconSize + SettingsScreen.SETTING_PADDING, y, w, h2, false, 8, false);
                }
            });
        }

        @Override
        protected FSkinColor getItemFillColor(int index) {
            if (index == this.selectedIndex) {
                return SEL_COLOR;
            }
            return null;
        }

        public void setQuests(List<QuestData> qd0) {
            ArrayList<QuestData> sorted = new ArrayList<QuestData>(qd0);
            sorted.sort(Comparator.comparing(x -> x.getName().toLowerCase()));
            this.setListData(sorted);
        }

        public void removeQuest(QuestData qd) {
            this.removeItem(qd);
            if (this.selectedIndex == this.getCount()) {
                --this.selectedIndex;
            }
            this.revalidate();
        }

        public boolean setSelectedIndex(int i0) {
            if (i0 >= this.getCount()) {
                return false;
            }
            this.selectedIndex = i0;
            return true;
        }

        public QuestData getSelectedQuest() {
            if (this.selectedIndex == -1) {
                return null;
            }
            return (QuestData)this.getItemAt(this.selectedIndex);
        }

        public boolean setSelectedQuest(QuestData qd0) {
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.getItemAt(i) != qd0) continue;
                this.selectedIndex = i;
                return true;
            }
            return false;
        }
    }
}

