/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.graphics.Texture;
import forge.Forge;
import forge.Graphics;
import forge.ImageKeys;
import forge.animation.ForgeAnimation;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.gamemodes.planarconquest.ConquestReward;
import forge.item.PaperCard;
import forge.toolbox.FDialog;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class ConquestRewardDialog
extends FScrollPane {
    private static final float PADDING = Utils.scale(5.0f);
    private final RevealDialog dialog;
    private final List<CardRevealer> cardRevealers = new ArrayList<CardRevealer>();
    private final CardRevealAnimation animation;
    private final Runnable callback;
    private int columnCount;
    private float totalZoomAmount;
    private CardRevealer focalCard;

    public static void show(String title, PaperCard card, Runnable callback0) {
        ArrayList<ConquestReward> rewards = new ArrayList<ConquestReward>(1);
        rewards.add(new ConquestReward(card, 0));
        ConquestRewardDialog.show(title, rewards, callback0);
    }

    public static void show(String title, Iterable<ConquestReward> rewards, Runnable callback0) {
        ConquestRewardDialog revealer = new ConquestRewardDialog(title, rewards, callback0);
        revealer.dialog.show();
    }

    private ConquestRewardDialog(String title, Iterable<ConquestReward> rewards, Runnable callback0) {
        this.dialog = new RevealDialog(title);
        this.callback = callback0;
        for (ConquestReward reward : rewards) {
            this.cardRevealers.add(this.add(new CardRevealer(reward)));
        }
        int cardCount = this.cardRevealers.size();
        this.columnCount = cardCount == 1 ? 1 : (cardCount < 5 ? (Forge.extrawide.equals("default") && !Forge.isTabletDevice ? 2 : (cardCount == 4 ? 4 : 3)) : (Forge.extrawide.equals("extrawide") || Forge.isTabletDevice ? 5 : (Forge.extrawide.equals("wide") ? 4 : 3)));
        this.animation = new CardRevealAnimation();
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        float x = PADDING;
        float y = PADDING;
        float cardWidth = (visibleWidth - (float)(this.columnCount + 1) * PADDING) / (float)this.columnCount;
        float cardHeight = cardWidth * 1.4f;
        float maxHeight = visibleHeight - 2.0f * PADDING;
        if (cardHeight > maxHeight) {
            cardHeight = maxHeight;
            float newCardWidth = cardHeight / 1.4f;
            x += (cardWidth - newCardWidth) * (float)this.columnCount / 2.0f;
            cardWidth = newCardWidth;
        }
        float startX = x;
        int cardCount = this.cardRevealers.size();
        try {
            this.cardRevealers.get(0).setBounds(x, y, cardWidth, cardHeight);
            for (int i = 1; i < cardCount; ++i) {
                if (i % this.columnCount == 0) {
                    x = startX;
                    y += cardHeight + PADDING;
                } else {
                    x += cardWidth + PADDING;
                }
                this.cardRevealers.get(i).setBounds(x, y, cardWidth, cardHeight);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        return new FScrollPane.ScrollBounds(visibleWidth, y + cardHeight + PADDING);
    }

    @Override
    public boolean zoom(float x, float y, float amount) {
        this.totalZoomAmount += amount;
        float columnZoomAmount = 2.0f * Utils.AVG_FINGER_WIDTH;
        while (this.totalZoomAmount >= columnZoomAmount) {
            this.setColumnCount(this.columnCount - 1);
            this.totalZoomAmount -= columnZoomAmount;
        }
        while (this.totalZoomAmount <= -columnZoomAmount) {
            this.setColumnCount(this.columnCount + 1);
            this.totalZoomAmount += columnZoomAmount;
        }
        return true;
    }

    public void setColumnCount(int columnCount0) {
        this.setColumnCount(columnCount0, false);
    }

    private void setColumnCount(int columnCount0, boolean forSetup) {
        if (columnCount0 < 1) {
            columnCount0 = 1;
        } else if (columnCount0 > this.cardRevealers.size()) {
            columnCount0 = this.cardRevealers.size();
        }
        if (this.columnCount == columnCount0) {
            return;
        }
        this.columnCount = columnCount0;
        CardRevealer focalCard0 = this.getFocalCard();
        if (focalCard0 == null) {
            this.revalidate();
            return;
        }
        float offsetTop = focalCard0.getTop() - this.getScrollTop();
        this.revalidate();
        this.setScrollTop(focalCard0.getTop() - offsetTop);
        this.focalCard = focalCard0;
    }

    private CardRevealer getFocalCard() {
        if (this.focalCard != null) {
            return this.focalCard;
        }
        float visibleTop = this.getScrollTop();
        for (CardRevealer card : this.cardRevealers) {
            if (!(card.getTop() >= visibleTop)) continue;
            return card;
        }
        return this.cardRevealers.get(0);
    }

    private class CardRevealer
    extends FLabel {
        private static final float DUPLICATE_ALPHA_COMPOSITE = 0.35f;
        private static final float FLIP_DURATION = 0.85f;
        private static final float FADE_DUPLICATE_DURATION = 0.1f;
        private final ConquestReward reward;
        private float progress;

        private CardRevealer(ConquestReward reward0) {
            super(new FLabel.Builder().iconScaleWithFont(true).iconScaleFactor(1.0f));
            this.reward = reward0;
            if (this.reward.isDuplicate()) {
                this.setFont(FSkinFont.get(20));
                this.setIcon(FSkinImage.AETHER_SHARD);
                this.setAlignment(1);
                this.setText(String.valueOf(this.reward.getReplacementShards()));
            }
        }

        private boolean showCardZoom() {
            int index = -1;
            ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
            for (int i = 0; i < ConquestRewardDialog.this.animation.currentIndex; ++i) {
                CardRevealer revealer = (CardRevealer)ConquestRewardDialog.this.cardRevealers.get(i);
                if (revealer == this) {
                    index = i;
                }
                cards.add(revealer.reward.getCard());
            }
            if (index == -1) {
                return false;
            }
            CardZoom.show(cards, index, null);
            return true;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            return this.showCardZoom();
        }

        @Override
        public boolean longPress(float x, float y) {
            return this.showCardZoom();
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            if (this.progress >= 0.85f) {
                float fadeProgress = (this.progress - 0.85f) / 0.1f;
                if (this.reward.isDuplicate()) {
                    float alphaComposite = 0.35f;
                    if (fadeProgress < 1.0f) {
                        alphaComposite += (1.0f - fadeProgress) * 0.65f;
                    }
                    g2.setAlphaComposite(alphaComposite);
                }
                CardRenderer.drawCard(g2, this.reward.getCard(), 0.0f, 0.0f, w, h2, CardRenderer.CardStackPosition.Top);
                if (this.reward.isDuplicate()) {
                    g2.resetAlphaComposite();
                    if (fadeProgress >= 1.0f) {
                        this.drawContent(g2, 0.0f, 0.0f, w, h2);
                    }
                }
            } else {
                float halfDuration = 0.425f;
                if (this.progress >= halfDuration) {
                    float flipWidth = w * (this.progress - halfDuration) / halfDuration;
                    CardRenderer.drawCard(g2, this.reward.getCard(), (w - flipWidth) / 2.0f, 0.0f, flipWidth, h2, CardRenderer.CardStackPosition.Top);
                } else {
                    Texture cardBack = ImageCache.getImage(ImageKeys.getTokenKey("hidden"), true);
                    if (cardBack != null) {
                        float flipWidth = w * (halfDuration - this.progress) / halfDuration;
                        g2.drawImage(cardBack, (w - flipWidth) / 2.0f, 0.0f, flipWidth, h2);
                    }
                }
            }
        }
    }

    private class CardRevealAnimation
    extends ForgeAnimation {
        private static final float DURATION_PER_CARD = 0.7f;
        private float progress = -0.25f;
        private int currentIndex;

        private CardRevealAnimation() {
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            if (this.progress <= 0.0f) {
                return true;
            }
            int index = (int)(this.progress / 0.7f);
            int cardCount = ConquestRewardDialog.this.cardRevealers.size();
            if (index > cardCount) {
                index = cardCount;
            }
            if (index > this.currentIndex) {
                for (int i = this.currentIndex; i < index; ++i) {
                    ((CardRevealer)ConquestRewardDialog.this.cardRevealers.get(i)).progress = 1.0f;
                }
                if (ConquestRewardDialog.this.getScrollHeight() > ConquestRewardDialog.this.getHeight() && index < cardCount) {
                    CardRevealer currentCard = (CardRevealer)ConquestRewardDialog.this.cardRevealers.get(index);
                    ConquestRewardDialog.this.scrollIntoView(currentCard, currentCard.getHeight() / ((float)ConquestRewardDialog.this.columnCount * PADDING) / 2.0f);
                }
            }
            this.currentIndex = index;
            if (this.currentIndex == cardCount) {
                return false;
            }
            ((CardRevealer)ConquestRewardDialog.this.cardRevealers.get(this.currentIndex)).progress = (this.progress - (float)this.currentIndex * 0.7f) / 0.7f;
            return true;
        }

        private void skip() {
            int cardCount = ConquestRewardDialog.this.cardRevealers.size();
            for (int i = this.currentIndex; i < cardCount; ++i) {
                ((CardRevealer)ConquestRewardDialog.this.cardRevealers.get(i)).progress = 1.0f;
            }
            this.currentIndex = cardCount;
            ConquestRewardDialog.this.animation.stop();
            ConquestRewardDialog.this.scrollToBottom();
        }

        @Override
        protected void onEnd(boolean endingAll) {
            if (this.currentIndex == ConquestRewardDialog.this.cardRevealers.size()) {
                ConquestRewardDialog.this.dialog.setButtonEnabled(0, true);
                ConquestRewardDialog.this.dialog.setButtonEnabled(1, false);
            }
        }
    }

    private class RevealDialog
    extends FDialog {
        private RevealDialog(String title) {
            super(title, 2);
            this.add(ConquestRewardDialog.this);
            this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> {
                this.hide();
                if (ConquestRewardDialog.this.callback != null) {
                    ConquestRewardDialog.this.callback.run();
                }
            });
            this.initButton(1, Forge.getLocalizer().getMessage("lblSkip", new Object[0]), e -> ConquestRewardDialog.this.animation.skip());
            this.setButtonEnabled(0, false);
            this.setButtonEnabled(1, false);
        }

        @Override
        protected float layoutAndGetHeight(float width, float maxHeight) {
            ConquestRewardDialog.this.setBounds(0.0f, 0.0f, width, maxHeight);
            return maxHeight;
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            return false;
        }

        @Override
        protected void onRevealFinished() {
            ConquestRewardDialog.this.animation.start();
            this.setButtonEnabled(1, true);
        }
    }
}

