/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.card.CardAvatarImage;
import forge.card.CardFaceSymbols;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.card.ColorSet;
import forge.gamemodes.planarconquest.ConquestAwardPool;
import forge.gamemodes.planarconquest.ConquestBattle;
import forge.gamemodes.planarconquest.ConquestChaosBattle;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestEvent;
import forge.gamemodes.planarconquest.ConquestLocation;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPlaneData;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestRegion;
import forge.gamemodes.planarconquest.ConquestReward;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.FThreads;
import forge.gui.card.CardDetailUtil;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.planarconquest.ConquestChaosWheel;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.planarconquest.ConquestRewardDialog;
import forge.toolbox.FButton;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.Utils;
import forge.util.collect.FCollectionView;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConquestMultiverseScreen
extends FScreen {
    private static final Color FOG_OF_WAR_COLOR = FSkinColor.alphaColor(Color.BLACK, 0.65f);
    private static final Color UNCONQUERED_COLOR = FSkinColor.alphaColor(Color.BLACK, 0.1f);
    public static final Color LOCATION_BAR_COLOR = FSkinColor.alphaColor(Color.WHITE, 0.15f);
    public static final Color LOCATION_BAR_TEXT_COLOR = FSkinColor.fromRGB(200, 207, 208);
    private static final FSkinFont PLANE_NAME_FONT = FSkinFont.get(16);
    private static final FSkinFont EVENT_NAME_FONT = FSkinFont.get(14);
    private static final FSkinFont AVATAR_NAME_FONT = FSkinFont.get(14);
    private static final float BATTLE_BAR_HEIGHT = Utils.AVG_FINGER_HEIGHT * 2.0f;
    private static final float PADDING = FList.PADDING;
    private static final float LOCATION_BAR_HEIGHT = CardRenderer.getCardListItemHeight(false);
    private final PlaneGrid planeGrid = this.add(new PlaneGrid());
    private final LocationBar locationBar = this.add(new LocationBar());
    private final BattleBar battleBar = this.add(new BattleBar());
    private ConquestData model;
    private ConquestBattle activeBattle;
    private static final FImage SHARD_IMAGE = new FImage(){
        final float size = (float)Forge.getScreenWidth() * 0.6f;

        @Override
        public float getWidth() {
            return this.size;
        }

        @Override
        public float getHeight() {
            return this.size;
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            FSkinImage.AETHER_SHARD.draw(g2, x, y, w, h2);
        }
    };
    private static final FImage EMBLEM_IMAGE = new FImage(){
        final float size = (float)Forge.getScreenWidth() * 0.6f;

        @Override
        public float getWidth() {
            return this.size;
        }

        @Override
        public float getHeight() {
            return this.size;
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            FSkinImage.PW_BADGE_COMMON.draw(g2, x, y, w, h2);
        }
    };

    public ConquestMultiverseScreen() {
        super("", ConquestMenu.getMenu());
    }

    @Override
    public void onActivate() {
        if (this.activeBattle == null) {
            this.update();
        } else if (this.activeBattle.isFinished()) {
            if (this.activeBattle.wasConquered()) {
                if (this.activeBattle instanceof ConquestChaosBattle) {
                    ConquestChaosBattle chaosBattle = (ConquestChaosBattle)this.activeBattle;
                    this.awardBoosters(chaosBattle.getAwardPool(), 3);
                } else {
                    ConquestLocation loc = this.activeBattle.getLocation();
                    ConquestEvent.ConquestEventRecord record = this.model.getCurrentPlaneData().getEventRecord(loc);
                    if (record.getWins(this.activeBattle.getTier()) == 1 && record.getHighestConqueredTier() == this.activeBattle.getTier()) {
                        this.model.rewardPlaneswalkEmblems(FModel.getConquestPreferences().getPrefInt(ConquestPreferences.CQPref.PLANESWALK_CONQUER_EMBLEMS));
                        this.model.saveData();
                        this.planeGrid.animateBadgeIntoPosition(loc, this.activeBattle.getTier());
                    } else {
                        this.spinChaosWheel();
                    }
                }
            }
            this.activeBattle = null;
        }
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.battleBar.setBounds(0.0f, height - BATTLE_BAR_HEIGHT, width, BATTLE_BAR_HEIGHT);
        this.locationBar.setBounds(0.0f, height - BATTLE_BAR_HEIGHT - LOCATION_BAR_HEIGHT, width, LOCATION_BAR_HEIGHT);
        this.planeGrid.setBounds(0.0f, startY, width, height - BATTLE_BAR_HEIGHT - LOCATION_BAR_HEIGHT - startY);
        this.planeGrid.scrollPlaneswalkerIntoView();
    }

    public void update() {
        this.model = FModel.getConquest().getModel();
        this.setHeaderCaption(this.model.getName());
        this.planeGrid.revalidate();
        this.planeGrid.scrollPlaneswalkerIntoView();
        this.battleBar.update();
    }

    private void spinChaosWheel() {
        ConquestChaosWheel.spin(new Callback<ConquestEvent.ChaosWheelOutcome>(){

            @Override
            public void run(ConquestEvent.ChaosWheelOutcome outcome) {
                switch (outcome) {
                    case BOOSTER: {
                        ConquestMultiverseScreen.this.awardBoosters(ConquestMultiverseScreen.this.model.getCurrentPlane().getAwardPool(), 1);
                        break;
                    }
                    case DOUBLE_BOOSTER: {
                        ConquestMultiverseScreen.this.awardBoosters(ConquestMultiverseScreen.this.model.getCurrentPlane().getAwardPool(), 2);
                        break;
                    }
                    case SHARDS: {
                        ConquestMultiverseScreen.this.awardShards(FModel.getConquestPreferences().getPrefInt(ConquestPreferences.CQPref.AETHER_WHEEL_SHARDS), false);
                        break;
                    }
                    case DOUBLE_SHARDS: {
                        ConquestMultiverseScreen.this.awardShards(2 * FModel.getConquestPreferences().getPrefInt(ConquestPreferences.CQPref.AETHER_WHEEL_SHARDS), false);
                        break;
                    }
                    case PLANESWALK: {
                        if (ConquestMultiverseScreen.this.model.getUnlockedPlaneCount() == ConquestMultiverseScreen.this.model.getAccessiblePlaneCount()) {
                            FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblAllPlanesUnlockedNotify", new Object[0]), Forge.getLocalizer().getMessage("lblAllPlanesUnlocked", new Object[0]), EMBLEM_IMAGE, new Callback<Integer>(){

                                @Override
                                public void run(Integer result) {
                                    ConquestMultiverseScreen.this.launchChaosBattle();
                                }
                            });
                            break;
                        }
                        ConquestMultiverseScreen.this.awardBonusPlaneswalkEmblems(FModel.getConquestPreferences().getPrefInt(ConquestPreferences.CQPref.PLANESWALK_WHEEL_EMBLEMS));
                        break;
                    }
                    case CHAOS: {
                        ConquestMultiverseScreen.this.launchChaosBattle();
                    }
                }
            }
        });
    }

    private void awardBoosters(ConquestAwardPool pool, int totalCount) {
        AwardBoosterHelper helper = new AwardBoosterHelper(pool, totalCount);
        helper.run();
    }

    private void awardShards(int shards, boolean fromDuplicateCards) {
        String message = Forge.getLocalizer().getMessage("lblReceivedAetherShards", new Object[0]);
        if (fromDuplicateCards) {
            message = Forge.getLocalizer().getMessage("lblReceivedAetherShardsForDuplicateCards", new Object[0]);
        } else {
            this.model.rewardAEtherShards(shards);
            this.model.saveData();
        }
        FOptionPane.showMessageDialog(String.valueOf(shards), FSkinFont.get(32), message, SHARD_IMAGE);
    }

    private void awardBonusPlaneswalkEmblems(int emblems) {
        String message = Forge.getLocalizer().getMessage("lblReceivedBonusPlaneswalkEmblems", new Object[0]);
        this.model.rewardPlaneswalkEmblems(emblems);
        this.model.saveData();
        FOptionPane.showMessageDialog(String.valueOf(emblems), FSkinFont.get(32), message, EMBLEM_IMAGE);
    }

    private void launchEvent() {
        LoadingOverlay.show(Forge.getLocalizer().getMessage("lblStartingBattle", new Object[0]), true, () -> {
            ConquestLocation loc = this.model.getCurrentLocation();
            this.activeBattle = loc.getEvent().createBattle(loc, 0);
            FModel.getConquest().startBattle(this.activeBattle);
        });
    }

    private void launchChaosBattle() {
        FThreads.invokeInEdtNowOrLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblChaosApproaching", new Object[0]), true, () -> {
            this.activeBattle = new ConquestChaosBattle();
            FModel.getConquest().startBattle(this.activeBattle);
        }));
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        if (this.planeGrid.activeMoveAnimation == null && this.planeGrid.activeBadgeAnimation == null) {
            super.buildTouchListeners(screenX, screenY, listeners);
        }
    }

    @Override
    protected void drawBackground(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.startClip(0.0f, this.locationBar.getTop(), w, h2 - this.locationBar.getTop());
        FSkinTexture background = FSkinTexture.BG_SPACE;
        float backgroundHeight = w * background.getHeight() / background.getWidth();
        g2.drawImage(background, 0.0f, h2 - backgroundHeight, w, backgroundHeight);
        g2.endClip();
    }

    private class BattleBar
    extends FContainer {
        private final AvatarDisplay playerAvatar = this.add(new AvatarDisplay(false));
        private final AvatarDisplay opponentAvatar = this.add(new AvatarDisplay(true));
        private final FButton btnBattle = this.add(new FButton(Forge.getLocalizer().getMessage("lblBattle", new Object[0]), event -> ConquestMultiverseScreen.access$3200(ConquestMultiverseScreen.this)));
        private ConquestEvent event;

        private BattleBar() {
            this.btnBattle.setFont(FSkinFont.get(20));
        }

        private void update() {
            this.event = ConquestMultiverseScreen.this.model.getCurrentLocation().getEvent();
            this.playerAvatar.setCard(ConquestMultiverseScreen.this.model.getSelectedCommander().getCard());
            this.opponentAvatar.setCard(this.event.getAvatarCard());
        }

        @Override
        protected void doLayout(float width, float height) {
            float labelHeight = AVATAR_NAME_FONT.getLineHeight() * 1.1f;
            float avatarSize = height - labelHeight - 2.0f * PADDING;
            this.playerAvatar.setBounds(PADDING, height - avatarSize - PADDING, avatarSize, avatarSize);
            this.opponentAvatar.setBounds(width - avatarSize - PADDING, PADDING, avatarSize, avatarSize);
            float buttonWidth = width - 2.0f * avatarSize - 4.0f * PADDING;
            float buttonHeight = height - 2.0f * labelHeight - 4.0f * PADDING;
            this.btnBattle.setBounds((width - buttonWidth) / 2.0f, (height - buttonHeight) / 2.0f, buttonWidth, buttonHeight);
        }

        @Override
        protected void drawOverlay(Graphics g2) {
            float labelWidth = this.opponentAvatar.getLeft() - 2.0f * PADDING;
            float labelHeight = this.playerAvatar.getTop();
            if (this.playerAvatar.card != null) {
                g2.drawText(this.playerAvatar.card.getName(), AVATAR_NAME_FONT, Color.WHITE, PADDING, 0.0f, labelWidth, labelHeight, false, 8, true);
            }
            if (this.opponentAvatar.card != null) {
                g2.drawText(this.opponentAvatar.card.getName(), AVATAR_NAME_FONT, Color.WHITE, this.getWidth() - labelWidth - PADDING, this.getHeight() - labelHeight, labelWidth, labelHeight, false, 16, true);
            }
        }

        private class AvatarDisplay
        extends FDisplayObject {
            private final boolean forOpponent;
            private PaperCard card;
            private FImage image;

            private AvatarDisplay(boolean forOpponent0) {
                this.forOpponent = forOpponent0;
                this.image = FSkinImage.UNKNOWN;
            }

            public void setCard(PaperCard card0) {
                if (this.card == card0) {
                    return;
                }
                this.card = card0;
                this.image = this.card != null ? new CardAvatarImage(this.card) : FSkinImage.UNKNOWN;
            }

            @Override
            public void draw(Graphics g2) {
                if (this.image != null) {
                    this.image.draw(g2, 0.0f, 0.0f, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public boolean tap(float x, float y, int count) {
                if (this.card != null) {
                    if (this.forOpponent) {
                        CardZoom.show(this.card);
                    } else {
                        ConquestMenu.selectCommander();
                    }
                }
                return true;
            }

            @Override
            public boolean longPress(float x, float y) {
                if (this.card != null) {
                    CardZoom.show(this.card);
                }
                return true;
            }
        }
    }

    private class LocationBar
    extends FDisplayObject {
        private LocationBar() {
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            g2.fillRect(LOCATION_BAR_COLOR, 0.0f, 0.0f, w, h2);
            ConquestLocation loc = ConquestMultiverseScreen.this.model.getCurrentLocation();
            ConquestRegion region = loc.getRegion();
            ColorSet regionColors = region.getColorSet();
            float x = PADDING;
            float y = PADDING;
            float symbolSize = CardRenderer.MANA_SYMBOL_SIZE;
            float availableNameWidth = w - CardFaceSymbols.getWidth(regionColors, symbolSize) - 3.0f * PADDING;
            g2.drawText(region.toString(), PLANE_NAME_FONT, LOCATION_BAR_TEXT_COLOR, x, y, availableNameWidth, symbolSize, false, 8, true);
            CardFaceSymbols.drawColorSet(g2, regionColors, x += availableNameWidth + PADDING, y, symbolSize);
            ConquestEvent event = loc.getEvent();
            String details = event.getName();
            if (!event.getVariants().isEmpty()) {
                details = details + " (" + StringUtils.join(event.getVariants(), ", ") + ")";
            }
            x = PADDING;
            g2.drawText(details, EVENT_NAME_FONT, LOCATION_BAR_TEXT_COLOR, x, y += symbolSize, w - 2.0f * PADDING, h2 - y, false, 1, true);
            g2.drawLine(1.0f, Color.BLACK, 0.0f, 0.0f, w, 0.0f);
        }
    }

    private class PlaneGrid
    extends FScrollPane {
        private MoveAnimation activeMoveAnimation;
        private BadgeAnimation activeBadgeAnimation;

        private PlaneGrid() {
        }

        @Override
        public boolean tap(float x, float y, int count) {
            List<ConquestLocation> path;
            ConquestLocation loc = this.getLocation(x, y);
            if (!ConquestMultiverseScreen.this.model.getCurrentLocation().equals(loc) && (path = ConquestMultiverseScreen.this.model.getPath(loc)) != null) {
                this.activeMoveAnimation = new MoveAnimation(path);
                this.activeMoveAnimation.start();
            }
            return true;
        }

        private void animateBadgeIntoPosition(ConquestLocation loc, int tier) {
            this.activeBadgeAnimation = new BadgeAnimation(loc, tier);
            this.activeBadgeAnimation.start();
        }

        @Override
        public void draw(Graphics g2) {
            float y0;
            float x0;
            ConquestPlane plane = ConquestMultiverseScreen.this.model.getCurrentPlane();
            float w = this.getWidth();
            float h2 = this.getHeight();
            float regionHeight = w / 1.302f;
            int cols = plane.getCols();
            int rows = plane.getRowsPerRegion();
            float colWidth = w / (float)cols;
            float rowHeight = regionHeight / (float)rows;
            float eventIconSize = Math.min(colWidth, rowHeight) / 3.0f;
            float eventIconOffset = Math.round(eventIconSize * 0.1f);
            FCollectionView<ConquestRegion> regions = plane.getRegions();
            int regionCount = regions.size();
            ConquestPlaneData planeData = ConquestMultiverseScreen.this.model.getCurrentPlaneData();
            ConquestLocation currentLocation = ConquestMultiverseScreen.this.model.getCurrentLocation();
            g2.startClip(0.0f, 0.0f, w, h2);
            float x = 0.0f;
            float y = -this.getScrollTop();
            float colLineStartY = 0.0f;
            float colLineEndY = h2;
            for (int i = regionCount - 1; i >= 0; --i) {
                int r;
                if (y + regionHeight <= 0.0f) {
                    y += regionHeight;
                    continue;
                }
                if (y > h2) break;
                ConquestRegion region = regions.get((ConquestRegion)i);
                FImage art = (FImage)region.getArt();
                if (art != null && art != CardImageRenderer.forgeArt) {
                    g2.drawImage(art, x, y, w, regionHeight);
                } else {
                    List<CardDetailUtil.DetailColors> backColors = CardDetailUtil.getBorderColors(region.getColorSet());
                    CardImageRenderer.fillColorBackground(g2, backColors, x, y, w, regionHeight);
                }
                for (r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        x0 = x + (float)c * colWidth;
                        y0 = y + (float)(rows - r - 1) * rowHeight;
                        ConquestEvent.ConquestEventRecord eventRecord = planeData.getEventRecord(i, r, c);
                        if (eventRecord != null && eventRecord.hasConquered()) {
                            x0 = Math.round(x0 + colWidth - eventIconOffset - eventIconSize * 0.9f);
                            y0 = Math.round(y0 + eventIconOffset);
                            int tier = eventRecord.getHighestConqueredTier();
                            if (this.activeBadgeAnimation != null && this.activeBadgeAnimation.location.isAt(i, r, c)) {
                                this.activeBadgeAnimation.end.set(x0, y0, eventIconSize, eventIconSize);
                                --tier;
                            }
                            switch (tier) {
                                case 0: {
                                    FSkinImage.PW_BADGE_COMMON.draw(g2, x0, y0, eventIconSize, eventIconSize);
                                    break;
                                }
                                case 1: {
                                    FSkinImage.PW_BADGE_UNCOMMON.draw(g2, x0, y0, eventIconSize, eventIconSize);
                                    break;
                                }
                                case 2: {
                                    FSkinImage.PW_BADGE_RARE.draw(g2, x0, y0, eventIconSize, eventIconSize);
                                    break;
                                }
                                case 3: {
                                    FSkinImage.PW_BADGE_MYTHIC.draw(g2, x0, y0, eventIconSize, eventIconSize);
                                }
                            }
                            continue;
                        }
                        Color color = FOG_OF_WAR_COLOR;
                        if (i == 0 && r == 0 && c == 0) {
                            color = UNCONQUERED_COLOR;
                        } else {
                            for (ConquestLocation loc : ConquestLocation.getNeighbors(plane, i, r, c)) {
                                if (!planeData.hasConquered(loc)) continue;
                                color = UNCONQUERED_COLOR;
                                break;
                            }
                        }
                        g2.fillRect(color, x0, y0, colWidth, rowHeight);
                    }
                }
                y0 = y;
                for (r = 0; r < rows; ++r) {
                    g2.drawLine(1.0f, Color.BLACK, 0.0f, y0, w, y0);
                    y0 += rowHeight;
                }
                y += regionHeight;
            }
            x0 = x + colWidth;
            for (int c = 1; c < cols; ++c) {
                g2.drawLine(1.0f, Color.BLACK, x0, colLineStartY, x0, colLineEndY);
                x0 += colWidth;
            }
            FImage token = (FImage)ConquestMultiverseScreen.this.model.getPlaneswalkerToken();
            float tokenHeight = rowHeight * 0.85f;
            float tokenWidth = tokenHeight * token.getWidth() / token.getHeight();
            Vector2 pos = this.activeMoveAnimation == null ? this.getPosition(currentLocation) : this.activeMoveAnimation.pos;
            x0 = pos.x - tokenWidth / 2.0f;
            y0 = pos.y - tokenHeight / 2.0f - this.getScrollTop();
            g2.drawImage(token, x0, y0, tokenWidth, tokenHeight);
            if (this.activeBadgeAnimation != null) {
                this.activeBadgeAnimation.drawBadge(g2);
            }
            g2.endClip();
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float regionHeight = visibleWidth / 1.302f;
            float height = (float)ConquestMultiverseScreen.this.model.getCurrentPlane().getRegions().size() * regionHeight;
            return new FScrollPane.ScrollBounds(visibleWidth, height);
        }

        private ConquestLocation getLocation(float x, float y) {
            y += this.getScrollTop();
            ConquestPlane plane = ConquestMultiverseScreen.this.model.getCurrentPlane();
            int rowsPerRegion = plane.getRowsPerRegion();
            int cols = plane.getCols();
            float w = this.getWidth();
            float h2 = this.getScrollHeight();
            float regionHeight = w / 1.302f;
            float colWidth = w / (float)cols;
            float rowHeight = regionHeight / (float)rowsPerRegion;
            int rowIndex = (int)((h2 - y) / rowHeight);
            int regionIndex = rowIndex / rowsPerRegion;
            int row = rowIndex % rowsPerRegion;
            int col = (int)(x / colWidth);
            if (col < 0) {
                col = 0;
            } else if (col > cols - 1) {
                col = cols - 1;
            }
            return new ConquestLocation(plane, regionIndex, row, col);
        }

        private Vector2 getPosition(ConquestLocation loc) {
            float w = this.getWidth();
            float h2 = this.getScrollHeight();
            float regionHeight = w / 1.302f;
            float colWidth = w / (float)loc.getPlane().getCols();
            float rowHeight = regionHeight / (float)loc.getPlane().getRowsPerRegion();
            float x = (float)loc.getCol() * colWidth + colWidth / 2.0f;
            float y = h2 - ((float)loc.getRegionIndex() * regionHeight + (float)loc.getRow() * rowHeight + rowHeight / 2.0f);
            return new Vector2(x, y);
        }

        private void scrollPlaneswalkerIntoView() {
            float maxMargin;
            float w = this.getWidth();
            float regionHeight = w / 1.302f;
            float rowHeight = regionHeight / (float)ConquestMultiverseScreen.this.model.getCurrentPlane().getRowsPerRegion();
            float margin = rowHeight * 1.5f;
            if (margin > (maxMargin = this.getHeight() / 2.0f)) {
                margin = maxMargin;
            }
            Vector2 pos = this.activeMoveAnimation == null ? this.getPosition(ConquestMultiverseScreen.this.model.getCurrentLocation()) : this.activeMoveAnimation.pos;
            this.scrollIntoView(pos.x, pos.y - this.getScrollTop(), 0.0f, 0.0f, margin);
        }

        private class BadgeAnimation
        extends ForgeAnimation {
            private static final float DURATION = 0.75f;
            private final ConquestLocation location;
            private final FSkinImage badge;
            private final Rectangle start;
            private final Rectangle end;
            private float progress = -0.5f;

            private BadgeAnimation(ConquestLocation location0, int tier) {
                this.location = location0;
                switch (tier) {
                    case 0: {
                        this.badge = FSkinImage.PW_BADGE_COMMON;
                        break;
                    }
                    case 1: {
                        this.badge = FSkinImage.PW_BADGE_UNCOMMON;
                        break;
                    }
                    case 2: {
                        this.badge = FSkinImage.PW_BADGE_RARE;
                        break;
                    }
                    default: {
                        this.badge = FSkinImage.PW_BADGE_MYTHIC;
                    }
                }
                float gridWidth = PlaneGrid.this.getWidth();
                float startSize = gridWidth * 0.75f;
                this.start = new Rectangle((gridWidth - startSize) / 2.0f, (PlaneGrid.this.getHeight() - startSize) / 2.0f, startSize, startSize);
                this.end = new Rectangle();
            }

            private void drawBadge(Graphics g2) {
                float percentage = this.progress / 0.75f;
                if (percentage < 0.0f) {
                    percentage = 0.0f;
                } else if (percentage > 1.0f) {
                    percentage = 1.0f;
                }
                Rectangle pos = Utils.getTransitionPosition(this.start, this.end, percentage);
                g2.drawImage(this.badge, pos.x, pos.y, pos.width, pos.height);
            }

            @Override
            protected boolean advance(float dt) {
                this.progress += dt;
                return this.progress < 1.25f;
            }

            @Override
            protected void onEnd(boolean endingAll) {
                PlaneGrid.this.activeBadgeAnimation = null;
                if (!endingAll) {
                    ConquestMultiverseScreen.this.spinChaosWheel();
                }
            }
        }

        private class MoveAnimation
        extends ForgeAnimation {
            private static final float DURATION_PER_SEGMENT = 0.5f;
            private final List<ConquestLocation> path;
            private final float duration;
            private Vector2 pos;
            private float progress;

            private MoveAnimation(List<ConquestLocation> path0) {
                this.path = path0;
                this.pos = PlaneGrid.this.getPosition(this.path.get(0));
                this.duration = (float)(this.path.size() - 1) * 0.5f;
            }

            @Override
            protected boolean advance(float dt) {
                this.progress += dt;
                if (this.progress >= this.duration) {
                    this.pos = PlaneGrid.this.getPosition(this.path.get(this.path.size() - 1));
                    PlaneGrid.this.scrollPlaneswalkerIntoView();
                    return false;
                }
                int currentSegment = (int)(this.progress / 0.5f);
                float r = (this.progress - (float)currentSegment * 0.5f) / 0.5f;
                Vector2 p1 = PlaneGrid.this.getPosition(this.path.get(currentSegment));
                Vector2 p2 = PlaneGrid.this.getPosition(this.path.get(currentSegment + 1));
                this.pos = new Vector2((1.0f - r) * p1.x + r * p2.x, (1.0f - r) * p1.y + r * p2.y);
                PlaneGrid.this.scrollPlaneswalkerIntoView();
                return true;
            }

            @Override
            protected void onEnd(boolean endingAll) {
                String secretArea = ConquestMultiverseScreen.this.model.getCurrentLocation().getEvent().getTemporaryUnlock();
                if (secretArea != null) {
                    ConquestUtil.setPlaneTemporarilyAccessible(secretArea, false);
                }
                ConquestMultiverseScreen.this.model.setCurrentLocation(this.path.get(this.path.size() - 1));
                ConquestMultiverseScreen.this.model.saveData();
                PlaneGrid.this.activeMoveAnimation = null;
                ConquestMultiverseScreen.this.battleBar.update();
            }
        }
    }

    private class AwardBoosterHelper
    implements Runnable {
        private final ConquestAwardPool pool;
        private final int totalCount;
        private final int shardsBefore;
        private int number;

        private AwardBoosterHelper(ConquestAwardPool pool0, int totalCount0) {
            this.pool = pool0;
            this.number = 1;
            this.totalCount = totalCount0;
            this.shardsBefore = ConquestMultiverseScreen.this.model.getAEtherShards();
        }

        @Override
        public void run() {
            if (this.number > this.totalCount) {
                int shardsReceived = ConquestMultiverseScreen.this.model.getAEtherShards() - this.shardsBefore;
                if (shardsReceived > 0) {
                    ConquestMultiverseScreen.this.awardShards(shardsReceived, true);
                }
                ConquestMultiverseScreen.this.model.saveData();
                return;
            }
            String title = Forge.getLocalizer().getMessage("lblReceivedBoosterPack", new Object[0]);
            if (this.totalCount > 1) {
                title = Forge.getLocalizer().getMessage("lblReceivedBoosterPackNOfTotal", String.valueOf(this.number), String.valueOf(this.totalCount));
            }
            ++this.number;
            List<ConquestReward> rewards = FModel.getConquest().awardBooster(this.pool);
            ConquestRewardDialog.show(title, rewards, (Runnable)this);
        }
    }
}

