/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.google.common.base.Predicate;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImageComplex;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.ImageCache;
import forge.card.CardFaceSymbols;
import forge.card.CardRenderer;
import forge.card.ColorSet;
import forge.deck.DeckFormat;
import forge.deck.FDeckChooser;
import forge.deck.FDeckViewer;
import forge.gamemodes.planarconquest.ConquestCommander;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestRecord;
import forge.item.PaperCard;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.SFilterUtil;
import forge.itemmanager.SItemManagerUtil;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.ComboBoxFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.StatTypeFilter;
import forge.itemmanager.filters.TextSearchFilter;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.planarconquest.ConquestDeckEditor;
import forge.screens.planarconquest.ConquestMenu;
import forge.toolbox.FButton;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextField;
import forge.util.Callback;
import java.util.Map;

public class ConquestCommandersScreen
extends FScreen {
    private static final float PADDING = FDeckChooser.PADDING;
    private final CommanderManager lstCommanders = this.add(new CommanderManager());
    private final FButton btnViewDeck = this.add(new FButton(Forge.getLocalizer().getMessage("lblViewDeck", new Object[0])));
    private final FButton btnEditDeck = this.add(new FButton(Forge.getLocalizer().getMessage("btnEditDeck", new Object[0])));
    private boolean preventRefreshOnActivate;

    public ConquestCommandersScreen() {
        super(Forge.getLocalizer().getMessage("lblSelectCommander", new Object[0]), ConquestMenu.getMenu());
        this.lstCommanders.setup(ItemManagerConfig.CONQUEST_COMMANDERS);
        this.lstCommanders.setItemActivateHandler(e -> Forge.back());
        this.btnViewDeck.setCommand(e -> {
            ConquestCommander commander = (ConquestCommander)this.lstCommanders.getSelectedItem();
            if (commander != null) {
                this.preventRefreshOnActivate = true;
                FDeckViewer.show(commander.getDeck());
            }
        });
        this.btnEditDeck.setCommand(e -> {
            ConquestCommander commander = (ConquestCommander)this.lstCommanders.getSelectedItem();
            if (commander != null) {
                ImageCache.preloadCache(commander.getDeck());
                this.preventRefreshOnActivate = true;
                Forge.openScreen(new ConquestDeckEditor(commander));
            }
        });
    }

    @Override
    public void onActivate() {
        if (this.preventRefreshOnActivate) {
            this.preventRefreshOnActivate = false;
        } else {
            this.refreshCommanders();
        }
    }

    @Override
    public void onClose(final Callback<Boolean> canCloseCallback) {
        if (canCloseCallback == null) {
            return;
        }
        ConquestCommander commander = (ConquestCommander)this.lstCommanders.getSelectedItem();
        if (commander == null) {
            canCloseCallback.run(true);
            return;
        }
        String problem = DeckFormat.PlanarConquest.getDeckConformanceProblem(commander.getDeck());
        if (problem != null) {
            FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblCantSelectDeckBecause", commander.getName(), problem), Forge.getLocalizer().getMessage("lblInvalidDeck", new Object[0]), FOptionPane.INFORMATION_ICON, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    canCloseCallback.run(false);
                }
            });
            return;
        }
        ConquestData model = FModel.getConquest().getModel();
        if (model.getSelectedCommander() != commander) {
            model.setSelectedCommander(commander);
            model.saveData();
        }
        canCloseCallback.run(true);
    }

    private void refreshCommanders() {
        ConquestData model = FModel.getConquest().getModel();
        this.lstCommanders.setPool(model.getCommanders());
        this.lstCommanders.setup(ItemManagerConfig.CONQUEST_COMMANDERS);
        ConquestCommander commander = model.getSelectedCommander();
        if (commander != null) {
            this.lstCommanders.setSelectedItem(commander);
        } else {
            this.lstCommanders.setSelectedIndex(0);
        }
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING - ItemFilter.PADDING;
        float w = width - 2.0f * PADDING;
        float buttonWidth = (w - PADDING) / 2.0f;
        float buttonHeight = FTextField.getDefaultHeight();
        float listHeight = height - buttonHeight - y - 2.0f * PADDING;
        this.lstCommanders.setBounds(x, y, w, listHeight);
        this.btnViewDeck.setBounds(x, y += listHeight + PADDING, buttonWidth, buttonHeight);
        this.btnEditDeck.setBounds(x + buttonWidth + PADDING, y, buttonWidth, buttonHeight);
    }

    private static class CommanderOriginFilter
    extends ComboBoxFilter<ConquestCommander, ConquestPlane> {
        public CommanderOriginFilter(ItemManager<? super ConquestCommander> itemManager0) {
            super(Forge.getLocalizer().getMessage("lblAllPlanes", new Object[0]), FModel.getPlanes(), itemManager0);
        }

        @Override
        public ItemFilter<ConquestCommander> createCopy() {
            CommanderOriginFilter copy = new CommanderOriginFilter(this.itemManager);
            copy.filterValue = this.filterValue;
            return copy;
        }

        @Override
        protected Predicate<ConquestCommander> buildPredicate() {
            return input -> {
                if (this.filterValue == null) {
                    return true;
                }
                return input.getOriginPlane() == this.filterValue;
            };
        }
    }

    private static class CommanderColorFilter
    extends StatTypeFilter<ConquestCommander> {
        public CommanderColorFilter(ItemManager<? super ConquestCommander> itemManager0) {
            super(itemManager0);
        }

        @Override
        public ItemFilter<ConquestCommander> createCopy() {
            return new CommanderColorFilter(this.itemManager);
        }

        @Override
        protected void buildWidget(ItemFilter.Widget widget) {
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.WHITE);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.BLUE);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.BLACK);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.RED);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.GREEN);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.COLORLESS);
            this.addToggleButton(widget, SItemManagerUtil.StatTypes.MULTICOLOR);
        }

        @Override
        protected final Predicate<ConquestCommander> buildPredicate() {
            return new Predicate<ConquestCommander>(){
                private final Predicate<PaperCard> pred;
                {
                    this.pred = SFilterUtil.buildColorFilter(buttonMap);
                }

                @Override
                public boolean apply(ConquestCommander input) {
                    return this.pred.apply(input.getCard());
                }
            };
        }
    }

    private static class CommanderManager
    extends ItemManager<ConquestCommander> {
        private CommanderManager() {
            super(ConquestCommander.class, true);
            this.setCaption(Forge.getLocalizer().getMessage("lblCommanders", new Object[0]));
        }

        @Override
        protected void addDefaultFilters() {
            this.addFilter(new CommanderColorFilter(this));
            this.addFilter(new CommanderOriginFilter(this));
        }

        @Override
        protected TextSearchFilter<? extends ConquestCommander> createSearchFilter() {
            return new TextSearchFilter<ConquestCommander>(this);
        }

        @Override
        protected AdvancedSearchFilter<? extends ConquestCommander> createAdvancedSearchFilter() {
            return new AdvancedSearchFilter<ConquestCommander>(this);
        }

        @Override
        protected boolean allowSortChange() {
            return false;
        }

        @Override
        public ItemManager.ItemRenderer getListItemRenderer(final FList.CompactModeHandler compactModeHandler) {
            return new ItemManager.ItemRenderer(){

                @Override
                public float getItemHeight() {
                    return CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode());
                }

                public boolean tap(Integer index, Map.Entry<ConquestCommander, Integer> value, float x, float y, int count) {
                    return CardRenderer.cardListItemTap(model.getOrderedList(), index, this, x, y, count, compactModeHandler.isCompactMode());
                }

                public boolean longPress(Integer index, Map.Entry<ConquestCommander, Integer> value, float x, float y) {
                    FDeckViewer.show(value.getKey().getDeck());
                    return true;
                }

                public void drawValue(Graphics g2, Map.Entry<ConquestCommander, Integer> value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    ConquestCommander commander = value.getKey();
                    PaperCard card = commander.getCard();
                    ConquestRecord record = commander.getRecord();
                    FImageComplex cardArt = CardRenderer.getCardArt(card);
                    float cardArtHeight = h2 + 2.0f * FList.PADDING;
                    float cardArtWidth = cardArtHeight * 1.302f;
                    if (cardArt != null) {
                        g2.drawImage(cardArt, x - FList.PADDING, y - FList.PADDING, cardArtWidth, cardArtHeight);
                    }
                    float imageSize = CardRenderer.MANA_SYMBOL_SIZE;
                    ColorSet cardColor = card.getRules().getColorIdentity();
                    float availableWidth = w - cardArtWidth - CardFaceSymbols.getWidth(cardColor, imageSize) - FList.PADDING;
                    g2.drawText(card.getName(), font, foreColor, x += cardArtWidth, y, availableWidth, imageSize, false, 8, true);
                    CardFaceSymbols.drawColorSet(g2, cardColor, x + availableWidth + FList.PADDING, y, imageSize);
                    if (compactModeHandler.isCompactMode()) {
                        return;
                    }
                    font = FSkinFont.get(12);
                    float lineHeight = font.getLineHeight();
                    String set = card.getEdition();
                    float setWidth = CardRenderer.getSetWidth(font, set);
                    availableWidth = w - cardArtWidth - setWidth;
                    g2.drawText(commander.getOrigin() + " (" + record.getWins() + "W / " + record.getLosses() + "L)", font, foreColor, x, y += imageSize + FList.PADDING + CardRenderer.SET_BOX_MARGIN, availableWidth, lineHeight, false, 8, true);
                    CardRenderer.drawSetLabel(g2, font, set, card.getRarity(), x += availableWidth + CardRenderer.SET_BOX_MARGIN, y -= CardRenderer.SET_BOX_MARGIN, setWidth, lineHeight + 2.0f * CardRenderer.SET_BOX_MARGIN);
                }

                public boolean allowPressEffect(FList<Map.Entry<ConquestCommander, Integer>> list, float x, float y) {
                    return x > CardRenderer.getCardListItemHeight(compactModeHandler.isCompactMode()) * 1.302f;
                }
            };
        }
    }
}

