/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.TextRenderer;
import forge.deck.CardPool;
import forge.gamemodes.planarconquest.ConquestData;
import forge.gamemodes.planarconquest.ConquestPlane;
import forge.gamemodes.planarconquest.ConquestPreferences;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.FThreads;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.CardColorFilter;
import forge.itemmanager.filters.CardTypeFilter;
import forge.itemmanager.filters.ComboBoxFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.model.FModel;
import forge.screens.TabPageScreen;
import forge.screens.planarconquest.ConquestAEtherScreen;
import forge.screens.planarconquest.ConquestMenu;
import forge.toolbox.FLabel;
import java.util.Collection;
import java.util.Map;

public class ConquestCollectionScreen
extends TabPageScreen<ConquestCollectionScreen> {
    private final FLabel lblShards = this.add(new FLabel.Builder().font(ConquestAEtherScreen.LABEL_FONT).parseSymbols().build());
    private final FLabel lblInfo = this.add(new FLabel.Builder().font(FSkinFont.get(11)).build());
    private final FLabel btnExileRetrieveMultiple = this.add(new FLabel.ButtonBuilder().font(ConquestAEtherScreen.LABEL_FONT).parseSymbols().build());

    public ConquestCollectionScreen() {
        super("", ConquestMenu.getMenu(), new CollectionTab[]{new CollectionTab(Forge.getLocalizer().getMessage("lblCollection", new Object[0]), FSkinImage.SPELLBOOK), new CollectionTab(Forge.getLocalizer().getMessage("lblExile", new Object[0]), FSkinImage.EXILE)}, true);
        this.btnExileRetrieveMultiple.setVisible(false);
        this.btnExileRetrieveMultiple.setCommand(e -> {
            CollectionTab.CollectionManager list = ((CollectionTab)this.getSelectedPage()).list;
            Collection cards = list.getSelectedItems();
            if (cards.isEmpty()) {
                ((ItemManager)list).toggleMultiSelectMode(-1);
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                if (this.getSelectedPage() == this.tabPages.get(0)) {
                    int value = 0;
                    for (PaperCard card : cards) {
                        value += ConquestUtil.getShardValue(card, ConquestPreferences.CQPref.AETHER_BASE_EXILE_VALUE);
                    }
                    if (FModel.getConquest().getModel().exileCards(cards, value)) {
                        FThreads.invokeInEdtLater(() -> {
                            this.updateShards();
                            this.getCollectionTab().list.removeItemsFlat(cards);
                            this.getExileTab().list.addItemsFlat(cards);
                            this.updateTabCaptions();
                        });
                    }
                } else {
                    int cost = 0;
                    for (PaperCard card : cards) {
                        cost += ConquestUtil.getShardValue(card, ConquestPreferences.CQPref.AETHER_BASE_RETRIEVE_COST);
                    }
                    if (FModel.getConquest().getModel().retrieveCardsFromExile(cards, cost)) {
                        FThreads.invokeInEdtLater(() -> {
                            this.updateShards();
                            this.getCollectionTab().list.addItemsFlat(cards);
                            this.getExileTab().list.removeItemsFlat(cards);
                            this.updateTabCaptions();
                        });
                    }
                }
            });
        });
    }

    @Override
    public void onActivate() {
        this.setHeaderCaption(FModel.getConquest().getModel().getName());
        this.updateShards();
        this.updateInfo();
        this.refreshCards();
    }

    private void updateShards() {
        int availableShards = FModel.getConquest().getModel().getAEtherShards();
        this.lblShards.setText(Forge.getLocalizer().getMessage("lblHaveNAEShards", String.valueOf(availableShards), "{AE}"));
    }

    private void updateInfo() {
        ConquestPreferences prefs = FModel.getConquestPreferences();
        double baseValue = prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_BASE_DUPLICATE_VALUE);
        double exileValue = prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_BASE_EXILE_VALUE);
        double retrieveCost = prefs.getPrefInt(ConquestPreferences.CQPref.AETHER_BASE_RETRIEVE_COST);
        this.lblInfo.setText(Forge.getLocalizer().getMessage("lblExileRetrieveProportion", Math.round(100.0 * exileValue / baseValue), Math.round(100.0 * retrieveCost / baseValue)));
    }

    private void refreshCards() {
        ConquestData model = FModel.getConquest().getModel();
        CardPool collection = new CardPool();
        CardPool exile = new CardPool();
        collection.add(model.getUnlockedCards());
        collection.removeAllFlat(model.getExiledCards());
        exile.add(model.getExiledCards());
        this.getCollectionTab().list.setPool(collection, true);
        this.getExileTab().list.setPool(exile, true);
        this.updateTabCaptions();
    }

    private void updateTabCaptions() {
        this.getCollectionTab().updateCaption();
        this.getExileTab().updateCaption();
    }

    private void updateExileRetrieveButtonCaption() {
        Collection cards;
        ConquestPreferences.CQPref baseValuePref;
        String caption;
        if (this.getSelectedPage() == this.tabPages.get(0)) {
            caption = Forge.getLocalizer().getMessage("lblExile", new Object[0]);
            baseValuePref = ConquestPreferences.CQPref.AETHER_BASE_EXILE_VALUE;
            cards = this.getCollectionTab().list.getSelectedItems();
        } else {
            caption = Forge.getLocalizer().getMessage("lblRetrieve", new Object[0]);
            baseValuePref = ConquestPreferences.CQPref.AETHER_BASE_RETRIEVE_COST;
            cards = this.getExileTab().list.getSelectedItems();
        }
        int count = cards.size();
        if (count == 0) {
            caption = Forge.getLocalizer().getMessage("lblCancel", new Object[0]);
        } else {
            if (count > 1) {
                caption = caption + " " + count + " " + Forge.getLocalizer().getMessage("lblCards", new Object[0]);
            }
            int total = 0;
            for (PaperCard card : cards) {
                total += ConquestUtil.getShardValue(card, baseValuePref);
            }
            caption = caption + " for {AE}" + total;
        }
        this.btnExileRetrieveMultiple.setText(caption);
    }

    private CollectionTab getCollectionTab() {
        return (CollectionTab)this.tabPages.get(0);
    }

    private CollectionTab getExileTab() {
        return (CollectionTab)this.tabPages.get(1);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = ItemFilter.PADDING;
        float y = startY + ItemFilter.PADDING;
        float w = width - 2.0f * x;
        float labelWidth = w * 0.4f;
        float labelHeight = this.lblShards.getAutoSizeBounds().height;
        this.lblShards.setBounds(x, y, labelWidth, labelHeight);
        this.lblInfo.setBounds(x + (labelWidth += ItemFilter.PADDING), y, w - labelWidth, labelHeight);
        super.doLayout(y += labelHeight, width, height);
        float buttonHeight = this.tabHeader.getHeight() - 2.0f * ItemFilter.PADDING;
        this.btnExileRetrieveMultiple.setBounds(x, height - buttonHeight - ItemFilter.PADDING, w, buttonHeight);
    }

    private static class CollectionTab
    extends TabPageScreen.TabPage<ConquestCollectionScreen> {
        private final CollectionManager list;

        private CollectionTab(String caption0, FImage icon0) {
            super(caption0, icon0);
            this.list = this.add(new CollectionManager(caption0));
            ItemManagerConfig config = ItemManagerConfig.CONQUEST_COLLECTION;
            this.list.setup(config, ConquestData.getColOverrides(config));
        }

        private void updateCaption() {
            this.caption = this.list.getCaption() + " (" + this.list.getItemCount() + ")";
        }

        @Override
        protected void doLayout(float width, float height) {
            this.list.setBounds(0.0f, 0.0f, width, height);
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            if (this.list.getMultiSelectMode()) {
                return false;
            }
            return super.fling(velocityX, velocityY);
        }

        private static class CardOriginFilter
        extends ComboBoxFilter<PaperCard, ConquestPlane> {
            public CardOriginFilter(ItemManager<? super PaperCard> itemManager0) {
                super(Forge.getLocalizer().getMessage("lblAllPlanes", new Object[0]), FModel.getPlanes(), itemManager0);
            }

            @Override
            public ItemFilter<PaperCard> createCopy() {
                CardOriginFilter copy = new CardOriginFilter(this.itemManager);
                copy.filterValue = this.filterValue;
                return copy;
            }

            @Override
            protected Predicate<PaperCard> buildPredicate() {
                return input -> {
                    if (this.filterValue == null) {
                        return true;
                    }
                    return ((ConquestPlane)this.filterValue).getCardPool().contains((PaperCard)input);
                };
            }
        }

        private class CollectionManager
        extends CardManager {
            public CollectionManager(String caption0) {
                super(false);
                this.setCaption(caption0);
                this.setContextMenuBuilder(new ItemManager.ContextMenuBuilder<PaperCard>(){

                    @Override
                    public void buildMenu(FDropDownMenu menu, PaperCard card) {
                        FMenuItem item;
                        ConquestData model = FModel.getConquest().getModel();
                        if (model.isInExile(card)) {
                            int cost = ConquestUtil.getShardValue(card, ConquestPreferences.CQPref.AETHER_BASE_RETRIEVE_COST);
                            item = new FMenuItem(Forge.getLocalizer().getMessage("lblRetrieveForNAE", String.valueOf(cost), "{AE}"), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e -> FThreads.invokeInBackgroundThread(() -> {
                                if (model.retrieveCardsFromExile(ImmutableList.of(card), cost)) {
                                    FThreads.invokeInEdtLater(() -> {
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateShards();
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).getCollectionTab().list.addItem(card, 1);
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).getExileTab().list.removeItem(card, 1);
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateTabCaptions();
                                    });
                                }
                            }), true);
                        } else {
                            int value = ConquestUtil.getShardValue(card, ConquestPreferences.CQPref.AETHER_BASE_EXILE_VALUE);
                            item = new FMenuItem(Forge.getLocalizer().getMessage("lblExileForNAE", String.valueOf(value), "{AE}"), FSkinImage.EXILE, e -> FThreads.invokeInBackgroundThread(() -> {
                                if (model.exileCards(ImmutableList.of(card), value)) {
                                    FThreads.invokeInEdtLater(() -> {
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateShards();
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).getCollectionTab().list.removeItem(card, 1);
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).getExileTab().list.addItem(card, 1);
                                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateTabCaptions();
                                    });
                                }
                            }), true);
                        }
                        item.setTextRenderer(new TextRenderer());
                        menu.addItem(item);
                    }
                });
                this.setSelectionChangedHandler(e -> {
                    if (this.getMultiSelectMode()) {
                        ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateExileRetrieveButtonCaption();
                    }
                });
            }

            @Override
            protected void addDefaultFilters() {
                this.addFilter(new CardColorFilter(this));
                this.addFilter(new CardOriginFilter(this));
                this.addFilter(new CardTypeFilter(this));
            }

            @Override
            public void toggleMultiSelectMode(int indexToSelect) {
                super.toggleMultiSelectMode(indexToSelect);
                boolean multiSelectMode = this.getMultiSelectMode();
                if (multiSelectMode) {
                    ((ConquestCollectionScreen)CollectionTab.this.parentScreen).updateExileRetrieveButtonCaption();
                }
                ((ConquestCollectionScreen)CollectionTab.this.parentScreen).btnExileRetrieveMultiple.setVisible(multiSelectMode);
                ((ConquestCollectionScreen)CollectionTab.this.parentScreen).tabHeader.setVisible(!multiSelectMode);
            }

            @Override
            protected void onCardLongPress(int index, Map.Entry<PaperCard, Integer> value, float x, float y) {
                this.toggleMultiSelectMode(index);
            }
        }
    }
}

