/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.planarconquest;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.gamemodes.planarconquest.ConquestEvent;
import forge.toolbox.FOptionPane;
import forge.toolbox.FOverlay;
import forge.util.Aggregates;
import forge.util.Callback;
import forge.util.PhysicsObject;

public class ConquestChaosWheel
extends FOverlay {
    private final WheelSpinAnimation animation = new WheelSpinAnimation();
    private final Callback<ConquestEvent.ChaosWheelOutcome> callback;

    public static void spin(Callback<ConquestEvent.ChaosWheelOutcome> callback0) {
        ConquestChaosWheel wheel = new ConquestChaosWheel(callback0);
        wheel.show();
    }

    private ConquestChaosWheel(Callback<ConquestEvent.ChaosWheelOutcome> callback0) {
        this.callback = callback0;
    }

    @Override
    public void setVisible(boolean visible0) {
        if (this.isVisible() == visible0) {
            return;
        }
        super.setVisible(visible0);
        if (visible0) {
            this.animation.start();
        }
    }

    @Override
    public void drawOverlay(Graphics g2) {
        float wheelSize = this.getWidth() - 2.0f * FOptionPane.PADDING;
        if (Forge.isLandscapeMode()) {
            wheelSize /= 2.0f;
        }
        float x = (this.getWidth() - wheelSize) / 2.0f;
        float y = (this.getHeight() - wheelSize) / 2.0f;
        FSkinTexture.BG_CHAOS_WHEEL.drawRotated(g2, x, y, wheelSize, wheelSize, this.animation.getWheelRotation());
        float spokeSize = wheelSize * 0.15f;
        FSkinImage.PW_BADGE_UNCOMMON.draw(g2, x + (wheelSize - spokeSize) / 2.0f, y - spokeSize * 0.75f, spokeSize, spokeSize);
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    @Override
    public boolean keyDown(int keyCode) {
        return true;
    }

    private class WheelSpinAnimation
    extends ForgeAnimation {
        private final PhysicsObject rotationManager;
        private final float WAIT_DURATION = 1.0f;
        private float timeSpentWaiting = 0.0f;
        private boolean doneSpinning = false;

        private WheelSpinAnimation() {
            float initialPosition = (float)Aggregates.randomInt(1, 8) * 45.0f - 22.5f;
            float initialVelocity = Aggregates.randomInt(360, 720);
            float acceleration = (float)Aggregates.randomInt(50, 100) * -1.0f;
            this.rotationManager = new PhysicsObject(new Vector2(initialPosition, 0.0f), new Vector2(initialVelocity, 0.0f), new Vector2(acceleration, 0.0f), false);
        }

        private float getWheelRotation() {
            return -this.rotationManager.getPosition().x;
        }

        @Override
        protected boolean advance(float dt) {
            if (!this.doneSpinning) {
                this.rotationManager.advance(dt);
                Vector2 pos = this.rotationManager.getPosition();
                while (pos.x > 360.0f) {
                    pos.x -= 360.0f;
                }
                if (!this.rotationManager.isMoving()) {
                    this.doneSpinning = true;
                }
                return true;
            }
            this.timeSpentWaiting += dt;
            return this.timeSpentWaiting < 1.0f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            ConquestChaosWheel.this.hide();
            ConquestChaosWheel.this.callback.run(ConquestEvent.ChaosWheelOutcome.getWheelOutcome(this.getWheelRotation()));
        }
    }
}

