/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.online;

import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.gamemodes.match.GameLobby;
import forge.gamemodes.net.ChatMessage;
import forge.gamemodes.net.IOnlineChatInterface;
import forge.gamemodes.net.IOnlineLobby;
import forge.gamemodes.net.NetConnectUtil;
import forge.gamemodes.net.OfflineLobby;
import forge.gamemodes.net.client.FGameClient;
import forge.gamemodes.net.server.FServerManager;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.interfaces.ILobbyView;
import forge.gui.util.SOptionPane;
import forge.localinstance.skin.FSkinProp;
import forge.screens.LoadingOverlay;
import forge.screens.constructed.LobbyScreen;
import forge.screens.online.OnlineMenu;

public class OnlineLobbyScreen
extends LobbyScreen
implements IOnlineLobby {
    private static GameLobby gameLobby;
    private static FGameClient fGameClient;

    public OnlineLobbyScreen() {
        super(null, OnlineMenu.getMenu(), new OfflineLobby());
    }

    public static GameLobby getGameLobby() {
        return gameLobby;
    }

    public static void clearGameLobby() {
        gameLobby = null;
    }

    public static void setGameLobby(GameLobby gameLobby) {
        OnlineLobbyScreen.gameLobby = gameLobby;
    }

    public static FGameClient getfGameClient() {
        return fGameClient;
    }

    public static void closeClient() {
        OnlineLobbyScreen.getfGameClient().close();
        fGameClient = null;
    }

    @Override
    public void closeConn(String msg) {
        OnlineLobbyScreen.clearGameLobby();
        Forge.back();
        if (msg.length() > 0) {
            FThreads.invokeInBackgroundThread(() -> {
                boolean callBackAlwaysTrue;
                boolean bl = callBackAlwaysTrue = SOptionPane.showOptionDialog(msg, Forge.getLocalizer().getMessage("lblError", new Object[0]), FSkinProp.ICO_WARNING, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), 1) == 0;
                if (callBackAlwaysTrue) {
                    GuiBase.setInterrupted(false);
                    if (FServerManager.getInstance() != null) {
                        FServerManager.getInstance().stopServer();
                    }
                    if (OnlineLobbyScreen.getfGameClient() != null) {
                        OnlineLobbyScreen.closeClient();
                    }
                }
            });
        }
    }

    @Override
    public ILobbyView setLobby(GameLobby lobby0) {
        this.initLobby(lobby0);
        return this;
    }

    @Override
    public void setClient(FGameClient client) {
        fGameClient = client;
    }

    @Override
    public void onActivate() {
        if (GuiBase.isInterrupted()) {
            GuiBase.setInterrupted(false);
            return;
        }
        if (OnlineLobbyScreen.getGameLobby() == null) {
            OnlineLobbyScreen.setGameLobby(this.getLobby());
            FThreads.invokeInBackgroundThread(() -> {
                String url = NetConnectUtil.getServerUrl();
                FThreads.invokeInEdtLater(() -> {
                    if (url == null) {
                        this.closeConn("");
                        return;
                    }
                    boolean joinServer = url.length() > 0;
                    String caption = joinServer ? Forge.getLocalizer().getMessage("lblConnectingToServer", new Object[0]) : Forge.getLocalizer().getMessage("lblStartingServer", new Object[0]);
                    LoadingOverlay.show(caption, true, () -> {
                        ChatMessage result;
                        IOnlineChatInterface chatInterface = (IOnlineChatInterface)((Object)OnlineMenu.OnlineScreen.Chat.getScreen());
                        if (joinServer) {
                            result = NetConnectUtil.join(url, this, chatInterface);
                            if (result.getMessage() == "<<_EM_ESOLC_<<") {
                                this.closeConn(Forge.getLocalizer().getMessage("lblDetectedInvalidHostAddress", url));
                                return;
                            }
                        } else {
                            result = NetConnectUtil.host(this, chatInterface);
                        }
                        chatInterface.addMessage(result);
                        if (!joinServer) {
                            FThreads.invokeInBackgroundThread(NetConnectUtil::copyHostedServerUrl);
                        }
                        OnlineMenu.OnlineScreen.Lobby.update();
                    });
                });
            });
        }
    }
}

