/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.winlose;

import forge.game.GameView;
import forge.game.player.PlayerView;
import forge.gamemodes.match.NextGameDecision;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.screens.match.winlose.ControlWinLose;
import forge.screens.match.winlose.ViewWinLose;
import java.util.Iterator;

public class QuestDraftWinLose
extends ControlWinLose {
    private final transient ViewWinLose view;
    private final ControlWinLose controller;

    public QuestDraftWinLose(ViewWinLose view0, GameView game0) {
        super(view0, game0);
        this.view = view0;
        this.controller = new ControlWinLose(view0, game0);
    }

    @Override
    public final void actionOnQuit() {
        this.controller.actionOnQuit();
        super.actionOnQuit();
    }

    @Override
    public final void showRewards() {
        String warningString;
        String quitString;
        QuestController quest = FModel.getQuest();
        boolean gameHadHumanPlayer = MatchController.instance.hasLocalPlayers();
        if (this.lastGame.isMatchOver()) {
            String winner = this.lastGame.getWinningPlayerName();
            quest.getAchievements().getCurrentDraft().setWinner(winner);
            quest.save();
        }
        QuestDraftUtils.update(MatchController.instance);
        QuestDraftUtils.matchInProgress = false;
        if (!gameHadHumanPlayer) {
            return;
        }
        this.view.getBtnRestart().setEnabled(false);
        this.view.getBtnRestart().setVisible(false);
        boolean isMatchOver = this.lastGame.isMatchOver();
        if (isMatchOver) {
            quitString = "Continue Tournament";
            warningString = null;
            Object warningCaption = null;
        } else {
            quitString = "Forfeit Tournament";
            warningString = "Quitting the match now will forfeit the tournament!\n\nReally quit?";
            String warningCaption = "Really Quit Tournament?";
        }
        this.view.getBtnQuit().setEnabled(true);
        this.view.getBtnContinue().setEnabled(!isMatchOver);
        this.view.getBtnQuit().setText(quitString);
        this.view.getBtnQuit().setCommand(e -> {
            if (warningString == null) {
                if (warningString != null) {
                    PlayerView humanPlayer = null;
                    Iterator<PlayerView> iterator = MatchController.instance.getLocalPlayers().iterator();
                    while (iterator.hasNext()) {
                        PlayerView playerView;
                        humanPlayer = playerView = iterator.next();
                    }
                    for (PlayerView playerView : this.lastGame.getPlayers()) {
                        if (humanPlayer == null) {
                            throw new IllegalStateException("Forfeit tournament button was pressed in a match without human players.");
                        }
                        if (playerView == humanPlayer) continue;
                        quest.getAchievements().getCurrentDraft().setWinner(playerView.getName());
                        quest.save();
                    }
                    QuestDraftUtils.cancelFurtherMatches();
                } else {
                    MatchController.instance.getGameController().nextGameDecision(NextGameDecision.QUIT);
                    this.controller.actionOnQuit();
                    QuestDraftUtils.matchInProgress = false;
                    QuestDraftUtils.continueMatches(MatchController.instance);
                }
            }
        });
    }
}

