/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.winlose;

import forge.Forge;
import forge.game.GameView;
import forge.gamemodes.gauntlet.GauntletWinLoseController;
import forge.gui.FThreads;
import forge.gui.util.SOptionPane;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.winlose.ControlWinLose;
import forge.screens.match.winlose.ViewWinLose;
import java.util.List;

public class GauntletWinLose
extends ControlWinLose {
    private final GauntletWinLoseController controller;

    public GauntletWinLose(ViewWinLose view0, GameView lastGame) {
        super(view0, lastGame);
        this.controller = new GauntletWinLoseController(view0, lastGame){

            @Override
            protected void showOutcome(boolean isMatchOver, String message1, String message2, FSkinProp icon, List<String> lstEventNames, List<String> lstEventRecords, int len, int num) {
                if (!isMatchOver) {
                    return;
                }
                FThreads.invokeInBackgroundThread(() -> {
                    StringBuilder sb = new StringBuilder();
                    if (!lstEventNames.isEmpty()) {
                        for (int i = 0; i < len; ++i) {
                            if (i <= num) {
                                sb.append(i + 1).append(". ").append((String)lstEventNames.get(i)).append(" (").append((String)lstEventRecords.get(i)).append(")\n");
                                continue;
                            }
                            sb.append(i + 1).append(". ??????\n");
                        }
                    }
                    if (message1 != null) {
                        sb.append("\n");
                        sb.append(message1).append("\n\n");
                        sb.append(message2);
                    } else if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    SOptionPane.showMessageDialog(sb.toString(), Forge.getLocalizer().getMessage("lblGauntletProgress", new Object[0]), icon);
                });
            }

            @Override
            protected void saveOptions() {
                GauntletWinLose.this.saveOptions();
            }
        };
    }

    @Override
    public final void showRewards() {
        this.controller.showOutcome();
    }

    @Override
    public void actionOnContinue() {
        if (!this.controller.actionOnContinue()) {
            super.actionOnContinue();
        }
    }

    @Override
    public void actionOnQuit() {
        super.actionOnQuit();
        this.controller.actionOnQuit();
    }
}

