/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.winlose;

import forge.Forge;
import forge.assets.FSkin;
import forge.game.GameView;
import forge.game.player.PlayerView;
import forge.screens.match.MatchController;
import forge.screens.match.winlose.ViewWinLose;

public class ControlWinLose {
    private final ViewWinLose view;
    protected final GameView lastGame;
    private int humancount;

    public ControlWinLose(ViewWinLose v, GameView game) {
        this.view = v;
        this.lastGame = game;
        this.humancount = 0;
        for (PlayerView p : game.getPlayers()) {
            if (p.isAI()) continue;
            ++this.humancount;
        }
        this.addListeners();
    }

    public void addListeners() {
        this.view.getBtnContinue().setCommand(e -> this.actionOnContinue());
        this.view.getBtnRestart().setCommand(e -> this.actionOnRestart());
        this.view.getBtnQuit().setCommand(e -> {
            this.actionOnQuit();
            this.view.getBtnQuit().setEnabled(false);
        });
        if (this.humancount == 0) {
            this.view.getBtnRestart().setEnabled(false);
        }
    }

    public void actionOnContinue() {
        this.view.hide();
        this.saveOptions();
        try {
            MatchController.getHostedMatch().continueMatch();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void actionOnRestart() {
        this.view.hide();
        this.saveOptions();
        try {
            MatchController.getHostedMatch().restartMatch();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void actionOnQuit() {
        boolean openHomeScreen = false;
        this.saveOptions();
        try {
            if (MatchController.getHostedMatch().subGameCount > 0) {
                openHomeScreen = true;
                --MatchController.getHostedMatch().subGameCount;
            }
            MatchController.getHostedMatch().endCurrentGame();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.view.hide();
        if (openHomeScreen || this.humancount == 0) {
            Forge.openHomeScreen(Forge.lastButtonIndex, Forge.getCurrentScreen());
        }
        Forge.setCursor(FSkin.getCursor().get(0), "0");
    }

    public void saveOptions() {
        MatchController.writeMatchPreferences();
    }

    public void showRewards() {
    }

    public ViewWinLose getView() {
        return this.view;
    }
}

