/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.winlose;

import forge.Forge;
import forge.adventure.scene.DuelScene;
import forge.game.GameView;
import forge.screens.match.MatchController;
import forge.screens.match.winlose.ControlWinLose;
import forge.screens.match.winlose.ViewWinLose;

public class AdventureWinLose
extends ControlWinLose {
    public AdventureWinLose(ViewWinLose v, GameView game) {
        super(v, game);
        if (this.lastGame.isMatchOver()) {
            v.getBtnQuit().setText(Forge.getLocalizer().getMessage("lblBackToAdventure", new Object[0]));
        } else {
            v.getBtnContinue().setVisible(true);
            v.getBtnContinue().setEnabled(true);
            v.getBtnContinue().setText(Forge.getLocalizer().getMessage("btnNextGame", new Object[0]));
            v.getBtnQuit().setText(Forge.getLocalizer().getMessageorUseDefault("lblQuitAdventureEventMatch", "Quit Match (will count as a loss)", new Object[0]));
        }
        v.getBtnRestart().setVisible(false);
        v.getBtnRestart().setEnabled(false);
        v.getLabelShowBattlefield().setVisible(false);
        Forge.setCursor(null, "0");
    }

    @Override
    public void actionOnContinue() {
        super.actionOnContinue();
    }

    @Override
    public void actionOnRestart() {
        this.saveOptions();
    }

    @Override
    public void actionOnQuit() {
        this.saveOptions();
        this.getView().hide();
        DuelScene.instance().GameEnd();
        if (!DuelScene.instance().hasCallbackExit()) {
            DuelScene.instance().exitDuelScene();
        }
    }

    @Override
    public void saveOptions() {
        MatchController.writeMatchPreferences();
    }

    @Override
    public void showRewards() {
    }
}

