/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.screens.match.views.VCardDisplayArea;
import forge.toolbox.FCardPanel;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import java.util.List;

public class VZoneDisplay
extends VCardDisplayArea {
    private final PlayerView player;
    private final ZoneType zoneType;
    private FCardPanel revealedPanel;

    public VZoneDisplay(PlayerView player0, ZoneType zoneType0) {
        this.player = player0;
        this.zoneType = zoneType0;
    }

    public ZoneType getZoneType() {
        return this.zoneType;
    }

    @Override
    public void update() {
        this.refreshCardPanels(this.player.getCards(this.zoneType));
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        super.buildTouchListeners(screenX, screenY, listeners);
        if (this.revealedPanel != null) {
            float y;
            float x = this.screenToLocalX(screenX);
            if (this.revealedPanel.contains(x, y = this.screenToLocalY(screenY))) {
                return;
            }
            int idx = this.cardPanels.size() - 1;
            for (int i = this.getChildCount() - 2; i >= 0; --i) {
                FDisplayObject cardPanel = this.getChildAt(i);
                if (!cardPanel.contains(x, y)) continue;
                idx = this.cardPanels.indexOf(cardPanel);
                break;
            }
            this.setRevealedPanel(idx);
        }
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        if (this.revealedPanel == null) {
            return super.pan(x, y, deltaX, deltaY, moreVertical);
        }
        int idx = this.cardPanels.size() - 1;
        for (int i = idx - 1; i >= 0; --i) {
            if (!((VCardDisplayArea.CardAreaPanel)this.cardPanels.get(i)).contains(x, y)) continue;
            idx = i;
            break;
        }
        this.setRevealedPanel(idx);
        return true;
    }

    private void setRevealedPanel(int idx) {
        try {
            this.revealedPanel = (FCardPanel)this.cardPanels.get(idx);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.clearChildren();
        if (Forge.isLandscapeMode()) {
            for (VCardDisplayArea.CardAreaPanel cardPanel : this.cardPanels) {
                if (cardPanel == this.revealedPanel) continue;
                this.add(cardPanel);
            }
        } else {
            int offset;
            int maxIdx = this.cardPanels.size() - 1;
            for (int i = offset = Math.max(idx, maxIdx - idx); i > 0; --i) {
                int idx1 = idx - i;
                int idx2 = idx + i;
                if (idx1 >= 0) {
                    this.add((VCardDisplayArea.CardAreaPanel)this.cardPanels.get(idx1));
                }
                if (idx2 > maxIdx) continue;
                this.add((VCardDisplayArea.CardAreaPanel)this.cardPanels.get(idx2));
            }
        }
        this.add(this.revealedPanel);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.revealedPanel == null) {
            super.setSelectedIndex(index);
        }
        this.setRevealedPanel(index);
    }

    @Override
    public void clear() {
        this.revealedPanel = null;
        super.clear();
    }

    protected boolean layoutVerticallyForLandscapeMode() {
        return true;
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        float cardWidth;
        if (!this.isVisible()) {
            return new FScrollPane.ScrollBounds(visibleWidth, visibleHeight);
        }
        this.orderedCards.clear();
        if (Forge.isLandscapeMode() && this.layoutVerticallyForLandscapeMode()) {
            return this.layoutAndGetScrollBoundsLandscape(visibleWidth, visibleHeight);
        }
        float x = 0.0f;
        float y = 0.0f;
        float cardHeight = visibleHeight;
        float dx = cardWidth = this.getCardWidth(cardHeight);
        float totalWidth = cardWidth * (float)this.cardPanels.size();
        if (totalWidth > visibleWidth && totalWidth <= visibleWidth * 2.0f) {
            dx *= (visibleWidth - cardWidth) / (totalWidth - cardWidth);
            dx += FCardPanel.PADDING / (float)this.cardPanels.size();
            if (this.revealedPanel == null) {
                this.revealedPanel = (FCardPanel)this.cardPanels.get(this.cardPanels.size() - 1);
            }
        } else {
            this.revealedPanel = null;
        }
        for (VCardDisplayArea.CardAreaPanel cardPanel : this.cardPanels) {
            this.orderedCards.add(cardPanel.getCard());
            cardPanel.setBounds(x, y, cardWidth, cardHeight);
            x += dx;
        }
        return new FScrollPane.ScrollBounds(x, visibleHeight);
    }

    private FScrollPane.ScrollBounds layoutAndGetScrollBoundsLandscape(float visibleWidth, float visibleHeight) {
        float scrollHeight;
        float cardHeight;
        float x = 0.0f;
        float y = 0.0f;
        float cardWidth = visibleWidth / 2.0f;
        float dy = cardHeight = this.getCardHeight(cardWidth);
        int rowCount = (int)Math.ceil((float)this.cardPanels.size() / 2.0f);
        float totalHeight = cardHeight * (float)rowCount;
        if (totalHeight > visibleHeight && totalHeight <= visibleHeight * 3.0f) {
            dy *= (visibleHeight - cardHeight) / (totalHeight - cardHeight);
            dy += FCardPanel.PADDING / (float)rowCount;
            if (this.revealedPanel == null) {
                this.revealedPanel = (FCardPanel)this.cardPanels.get(this.cardPanels.size() - 1);
            }
            scrollHeight = visibleHeight;
        } else {
            this.revealedPanel = null;
            scrollHeight = (float)rowCount * dy;
        }
        for (VCardDisplayArea.CardAreaPanel cardPanel : this.cardPanels) {
            this.orderedCards.add(cardPanel.getCard());
            cardPanel.setBounds(x, y, cardWidth, cardHeight);
            if (this.orderedCards.size() % 2 == 0) {
                x = 0.0f;
                y += dy;
                continue;
            }
            x += cardWidth;
        }
        return new FScrollPane.ScrollBounds(visibleWidth, scrollHeight);
    }

    @Override
    protected void startClip(Graphics g2) {
        if (Forge.isLandscapeMode()) {
            g2.startClip(0.0f, 0.0f, this.getWidth(), this.getHeight());
        } else {
            super.startClip(g2);
        }
    }
}

