/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImageInterface;
import forge.game.player.PlayerView;
import forge.localinstance.skin.FSkinProp;
import forge.player.GamePlayerUtil;
import forge.screens.match.MatchController;
import forge.screens.match.views.VDisplayArea;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import java.util.ArrayList;
import java.util.List;

public class VManaPool
extends VDisplayArea {
    private static final FSkinFont FONT = FSkinFont.get(16);
    private final PlayerView player;
    private final List<ManaLabel> manaLabels = new ArrayList<ManaLabel>();
    private int totalMana;

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public VManaPool(PlayerView player0) {
        this.player = player0;
        this.addManaLabel(FSkinProp.IMG_MANA_COLORLESS, (byte)32);
        this.addManaLabel(FSkinProp.IMG_MANA_W, (byte)1);
        this.addManaLabel(FSkinProp.IMG_MANA_U, (byte)2);
        this.addManaLabel(FSkinProp.IMG_MANA_B, (byte)4);
        this.addManaLabel(FSkinProp.IMG_MANA_R, (byte)8);
        this.addManaLabel(FSkinProp.IMG_MANA_G, (byte)16);
    }

    private void addManaLabel(FSkinProp prop, byte colorCode) {
        this.manaLabels.add(this.add(new ManaLabel(Forge.getAssets().images().get((Object)prop), colorCode)));
    }

    @Override
    public int getCount() {
        return this.totalMana;
    }

    @Override
    public void update() {
        this.totalMana = 0;
        for (ManaLabel label : this.manaLabels) {
            int colorCount = this.player.getMana(label.colorCode);
            this.totalMana += colorCount;
            label.text = Integer.toString(colorCount);
        }
    }

    @Override
    protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        float x = 0.0f;
        float y = 0.0f;
        if (Forge.isLandscapeMode()) {
            float labelWidth = visibleWidth / 2.0f;
            float labelHeight = visibleHeight / 3.0f;
            int count = 0;
            for (ManaLabel label : this.manaLabels) {
                label.setBounds(x, y, labelWidth, labelHeight);
                if (++count % 2 == 0) {
                    x = 0.0f;
                    y += labelHeight;
                    continue;
                }
                x += labelWidth;
            }
        } else {
            float labelWidth = visibleWidth / (float)this.manaLabels.size();
            float labelHeight = visibleHeight;
            for (ManaLabel label : this.manaLabels) {
                label.setBounds(x, y, labelWidth, labelHeight);
                x += labelWidth;
            }
        }
        return new FScrollPane.ScrollBounds(visibleWidth, visibleHeight);
    }

    public class ManaLabel
    extends FDisplayObject {
        private final FSkinImageInterface image;
        private final byte colorCode;
        private String text = "0";

        private ManaLabel(FSkinImageInterface image0, byte colorCode0) {
            this.image = image0;
            this.colorCode = colorCode0;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            this.activate();
            return true;
        }

        public void activate() {
            if (VManaPool.this.player.isLobbyPlayer(GamePlayerUtil.getGuiPlayer())) {
                MatchController.instance.getGameController().useMana(this.colorCode);
            }
        }

        @Override
        public boolean flick(float x, float y) {
            if (VManaPool.this.player.isLobbyPlayer(GamePlayerUtil.getGuiPlayer())) {
                int oldMana;
                int newMana = VManaPool.this.player.getMana(this.colorCode);
                do {
                    oldMana = newMana;
                    MatchController.instance.getGameController().useMana(this.colorCode);
                } while (oldMana != (newMana = VManaPool.this.player.getMana(this.colorCode)));
            }
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            float textHeight = FONT.getCapHeight();
            float gapY = textHeight / 4.0f;
            float maxImageHeight = this.getHeight() - textHeight - 3.0f * gapY;
            float h2 = this.image.getNearestHQHeight(maxImageHeight);
            if (h2 > maxImageHeight) {
                h2 /= 2.0f;
            }
            float w = this.image.getWidth() * h2 / this.image.getHeight();
            while (w > this.getWidth()) {
                w = this.image.getWidth() * (h2 /= 2.0f) / this.image.getHeight();
            }
            float x = (this.getWidth() - w) / 2.0f;
            float y = gapY + (maxImageHeight - h2) / 2.0f;
            if (this.isHovered()) {
                g2.fillRect(FSkinColor.getStandardColor(50, 200, 150).alphaColor(0.3f), 0.0f, 0.0f, this.getWidth(), this.getHeight());
            }
            g2.drawImage(this.image, x, y, w, h2);
            x = 0.0f;
            y += h2 + gapY;
            w = this.getWidth();
            h2 = this.getHeight() - y;
            g2.drawText(this.text, FONT, VManaPool.getForeColor(), x, y, w, h2, false, 1, false);
        }
    }
}

