/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.gui.FThreads;
import forge.screens.match.MatchScreen;
import forge.screens.match.views.VCardDisplayArea;
import forge.toolbox.FCardPanel;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VField
extends FContainer {
    private final PlayerView player;
    private final FieldRow row1;
    private final FieldRow row2;
    private boolean flipped;
    private float commandZoneWidth;
    private float fieldModifier;
    private final Runnable updateRoutine = new Runnable(){

        @Override
        public void run() {
            VField.this.clear();
            FCollectionView<CardView> model = VField.this.player.getBattlefield();
            if (model == null) {
                return;
            }
            for (CardView card : model) {
                VCardDisplayArea.CardAreaPanel cardPanel = VCardDisplayArea.CardAreaPanel.get(card);
                cardPanel.updateCard(card);
                cardPanel.setNextPanelInStack(null);
                cardPanel.setPrevPanelInStack(null);
            }
            ArrayList<CardView> creatures = new ArrayList<CardView>();
            ArrayList<CardView> lands = new ArrayList<CardView>();
            ArrayList<CardView> otherPermanents = new ArrayList<CardView>();
            for (CardView card : model) {
                VCardDisplayArea.CardAreaPanel cardPanel = VCardDisplayArea.CardAreaPanel.get(card);
                CardView.CardStateView details = card.getCurrentState();
                if (cardPanel.getAttachedToPanel() != null) continue;
                if (details.isCreature()) {
                    if (VField.this.tryStackCard(card, creatures)) continue;
                    creatures.add(card);
                    continue;
                }
                if (details.isLand()) {
                    if (VField.this.tryStackCard(card, lands)) continue;
                    lands.add(card);
                    continue;
                }
                if (VField.this.tryStackCard(card, otherPermanents)) continue;
                otherPermanents.add(card);
            }
            if (creatures.isEmpty()) {
                VField.this.row1.refreshCardPanels(otherPermanents);
                VField.this.row2.refreshCardPanels(lands);
            } else {
                VField.this.row1.refreshCardPanels(creatures);
                lands.addAll(otherPermanents);
                VField.this.row2.refreshCardPanels(lands);
            }
        }
    };

    public VField(PlayerView player0) {
        this.player = player0;
        this.row1 = this.add(new FieldRow());
        this.row2 = this.add(new FieldRow());
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped0) {
        this.flipped = flipped0;
    }

    public Iterable<VCardDisplayArea.CardAreaPanel> getCardPanels() {
        ArrayList<VCardDisplayArea.CardAreaPanel> cardPanels = new ArrayList<VCardDisplayArea.CardAreaPanel>();
        for (VCardDisplayArea.CardAreaPanel cardPanel : this.row1.getCardPanels()) {
            cardPanels.add(cardPanel);
        }
        for (VCardDisplayArea.CardAreaPanel cardPanel : this.row2.getCardPanels()) {
            cardPanels.add(cardPanel);
        }
        return cardPanels;
    }

    public void update(boolean invokeInEdtNowOrLater) {
        if (invokeInEdtNowOrLater) {
            FThreads.invokeInEdtNowOrLater(this.updateRoutine);
        } else {
            FThreads.invokeInEdtLater(this.updateRoutine);
        }
    }

    private boolean tryStackCard(CardView card, List<CardView> cardsOfType) {
        if (card.hasCardAttachments()) {
            return false;
        }
        if (card.getCurrentState().isCreature() && !card.isToken()) {
            return false;
        }
        String cardName = card.getCurrentState().getName();
        for (CardView c : cardsOfType) {
            if (c.getCurrentState().isCreature()) {
                if (c.hasCardAttachments() || !cardName.equals(c.getCurrentState().getName()) || !card.hasSameCounters(c) || !card.hasSamePT(c) || !card.getCurrentState().getKeywordKey().equals(c.getCurrentState().getKeywordKey()) || card.isTapped() != c.isTapped() || card.isSick() != c.isSick() || card.isToken() != c.isToken()) continue;
                VCardDisplayArea.CardAreaPanel cPanel = VCardDisplayArea.CardAreaPanel.get(c);
                while (cPanel.getNextPanelInStack() != null) {
                    cPanel = cPanel.getNextPanelInStack();
                }
                VCardDisplayArea.CardAreaPanel cardPanel = VCardDisplayArea.CardAreaPanel.get(card);
                cPanel.setNextPanelInStack(cardPanel);
                cardPanel.setPrevPanelInStack(cPanel);
                return true;
            }
            if (c.hasCardAttachments() || !cardName.equals(c.getCurrentState().getName()) || !card.hasSameCounters(c) || !card.getCurrentState().getKeywordKey().equals(c.getCurrentState().getKeywordKey()) || card.getCurrentState().getColors() != c.getCurrentState().getColors() || card.isSick() != c.isSick() || card.isToken() != c.isToken()) continue;
            VCardDisplayArea.CardAreaPanel cPanel = VCardDisplayArea.CardAreaPanel.get(c);
            while (cPanel.getNextPanelInStack() != null) {
                cPanel = cPanel.getNextPanelInStack();
            }
            VCardDisplayArea.CardAreaPanel cardPanel = VCardDisplayArea.CardAreaPanel.get(card);
            cPanel.setNextPanelInStack(cardPanel);
            cardPanel.setPrevPanelInStack(cPanel);
            return true;
        }
        return false;
    }

    public FieldRow getRow1() {
        return this.row1;
    }

    public FieldRow getRow2() {
        return this.row2;
    }

    void setCommandZoneWidth(float commandZoneWidth0) {
        this.commandZoneWidth = commandZoneWidth0;
    }

    void setFieldModifier(float fieldModifierWidth) {
        this.fieldModifier = fieldModifierWidth;
    }

    @Override
    public void clear() {
        this.row1.clear();
        this.row2.clear();
    }

    @Override
    protected void doLayout(float width, float height) {
        float y2;
        float y1;
        float cardSize = height / 2.0f;
        if (this.flipped) {
            y1 = cardSize;
            y2 = 0.0f;
        } else {
            y1 = 0.0f;
            y2 = cardSize;
        }
        this.row1.setBounds(0.0f, y1, width - this.fieldModifier, cardSize);
        this.row2.setBounds(0.0f, y2, width - this.commandZoneWidth - this.fieldModifier, cardSize);
    }

    public class FieldRow
    extends VCardDisplayArea {
        private int selected = -1;
        private FDisplayObject selectedChild;

        private FieldRow() {
            this.setVisible(true);
        }

        @Override
        protected float getCardWidth(float cardHeight) {
            return cardHeight;
        }

        @Override
        public void update() {
        }

        @Override
        public void setNextSelected(int val) {
            ++this.selected;
            if (this.selected >= this.getChildCount()) {
                this.selected = this.getChildCount() - 1;
            }
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
            }
            this.selectedChild = this.getChildAt(this.selected);
            this.selectedChild.setHovered(true);
            MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
        }

        public void selectCurrent() {
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(true);
                MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
            } else {
                this.setNextSelected(1);
            }
        }

        public void unselectCurrent() {
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
                MatchScreen.nullPotentialListener();
            }
        }

        @Override
        public void setPreviousSelected(int val) {
            if (this.getChildCount() < 1) {
                return;
            }
            --this.selected;
            if (this.selected < 0) {
                this.selected = 0;
            }
            if (this.selectedChild != null) {
                this.selectedChild.setHovered(false);
            }
            this.selectedChild = this.getChildAt(this.selected);
            this.selectedChild.setHovered(true);
            MatchScreen.setPotentialListener(Arrays.asList(this.selectedChild));
        }

        @Override
        public void showZoom() {
            if (this.selectedChild instanceof FCardPanel) {
                VCardDisplayArea.CardAreaPanel.get(((FCardPanel)this.selectedChild).getCard()).showZoom();
            }
        }

        @Override
        public void tapChild() {
            if (this.selectedChild instanceof FCardPanel) {
                VCardDisplayArea.CardAreaPanel.get(((FCardPanel)this.selectedChild).getCard()).selectCard(false);
            }
        }
    }
}

