/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.game.card.CounterEnumType;
import forge.game.player.PlayerView;
import forge.screens.match.MatchController;
import forge.screens.match.views.VPhaseIndicator;
import forge.toolbox.FDisplayObject;
import forge.util.ThreadUtil;
import forge.util.Utils;

public class VAvatar
extends FDisplayObject {
    public static final float WIDTH = Utils.AVG_FINGER_WIDTH;
    public static final float HEIGHT = Utils.AVG_FINGER_HEIGHT;
    private final PlayerView player;
    private final FImage image;
    private final AvatarAnimation avatarAnimation;
    private static final FSkinFont LIFE_FONT = FSkinFont.get(18);
    private static final FSkinFont LIFE_FONT_ALT = FSkinFont.get(22);

    public VAvatar(PlayerView player0) {
        this.player = player0;
        this.image = MatchController.getPlayerAvatar(this.player);
        this.setSize(WIDTH, HEIGHT);
        this.avatarAnimation = new AvatarAnimation();
    }

    public VAvatar(PlayerView player0, float size) {
        this.player = player0;
        this.image = MatchController.getPlayerAvatar(this.player);
        this.setSize(size, size);
        this.avatarAnimation = new AvatarAnimation();
    }

    @Override
    public boolean tap(float x, float y, int count) {
        ThreadUtil.invokeInGameThread(() -> MatchController.instance.getGameController().selectPlayer(this.player, null));
        return true;
    }

    public Vector2 getTargetingArrowOrigin() {
        Vector2 origin = new Vector2(this.screenPos.x, this.screenPos.y);
        origin.x += this.getWidth() - this.getWidth() / 8.0f;
        origin.y += this.getWidth() - this.getWidth() / 8.0f;
        return origin;
    }

    @Override
    public void draw(Graphics g2) {
        float h2;
        float w = this.isHovered() ? this.getWidth() / 16.0f + this.getWidth() : this.getWidth();
        float f = h2 = this.isHovered() ? this.getWidth() / 16.0f + this.getHeight() : this.getHeight();
        if (this.avatarAnimation != null && !MatchController.instance.getGameView().isMatchOver()) {
            if (this.player.wasAvatarLifeChanged()) {
                this.avatarAnimation.start();
                this.avatarAnimation.drawAvatar(g2, this.image, 0.0f, 0.0f, w, h2);
            } else {
                g2.drawAvatarImage(this.image, 0.0f, 0.0f, w, h2, this.player.getHasLost(), 0.0f);
                this.drawPlayerIndicator(g2, w, h2, 1.0f);
            }
        } else {
            g2.drawAvatarImage(this.image, 0.0f, 0.0f, w, h2, this.player.getHasLost(), 0.0f);
        }
        if (Forge.altPlayerLayout && !Forge.altZoneTabs && Forge.isLandscapeMode()) {
            return;
        }
        int xp = this.player.getCounters(CounterEnumType.EXPERIENCE);
        if (xp > 0) {
            FSkinFont font = VPhaseIndicator.BASE_FONT;
            float xpHeight = font.getCapHeight();
            g2.drawOutlinedText(xp + " XP", font, Color.WHITE, Color.BLACK, 0.0f, h2 - xpHeight - VPhaseIndicator.PADDING_Y, w - VPhaseIndicator.PADDING_X, h2, false, 16, false);
        }
    }

    private void drawPlayerIndicator(Graphics g2, float w, float h2, float alphaModifier) {
        float oldAlpha = g2.getfloatAlphaComposite();
        boolean displayPriority = true;
        for (PlayerView playerView : MatchController.instance.getGameView().getPlayers()) {
            if (!playerView.isAI()) continue;
            displayPriority = false;
            break;
        }
        if (this.player == MatchController.instance.getGameView().getPlayerTurn()) {
            float alpha;
            float f = alpha = displayPriority ? 1.0f : 0.8f;
            if (alphaModifier < 1.0f) {
                alpha = alphaModifier;
            }
            g2.drawRect(w / 16.0f, FSkinColor.getStandardColor(Color.CYAN).alphaColor(alpha), 0.0f, 0.0f, w, h2);
        }
        if (displayPriority && this.player.getHasPriority() && alphaModifier == 1.0f) {
            g2.drawRect(w / 16.0f, FSkinColor.getStandardColor(Color.LIME).alphaColor(0.6f), 0.0f, 0.0f, w, h2);
        }
        if (MatchController.instance.isHighlighted(this.player)) {
            g2.drawRect(w / 16.0f, Color.MAGENTA, 0.0f, 0.0f, w, h2);
        }
        if (Forge.hasGamepad() && MatchController.getView().selectedPlayerPanel() != null && MatchController.getView().selectedPlayerPanel().getPlayer() == this.player) {
            g2.drawRect(w / 16.0f, Color.ORANGE, 0.0f, 0.0f, w, h2);
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (keyCode == 93) {
            PlayerView selected;
            if (MatchController.getView().selectedPlayerPanel() != null && (selected = MatchController.getView().selectedPlayerPanel().getPlayer()) != null) {
                ThreadUtil.invokeInGameThread(() -> MatchController.instance.getGameController().selectPlayer(selected, null));
            }
            return true;
        }
        return super.keyDown(keyCode);
    }

    private class AvatarAnimation
    extends ForgeAnimation {
        private static final float DURATION = 1.2f;
        private float progress = 0.0f;
        Texture splatter = Forge.getAssets().getTexture(FSkin.getDefaultSkinFile("splatter.png"));

        private AvatarAnimation() {
        }

        private void drawAvatar(Graphics g2, FImage image, float x, float y, float w, float h2) {
            float percentage = this.progress / 1.2f;
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            float mod = w / 2.0f;
            int amount = VAvatar.this.player.getAvatarLifeDifference();
            float oldAlpha = g2.getfloatAlphaComposite();
            float fade = 1.0f - percentage * 1.0f;
            if (amount > 0) {
                g2.drawAvatarImage(image, x, y, w, h2, VAvatar.this.player.getHasLost(), 0.0f);
                VAvatar.this.drawPlayerIndicator(g2, w, h2, percentage);
                g2.setAlphaComposite(fade);
                g2.drawRect(w / 12.0f, Color.WHITE, 0.0f, 0.0f, w, h2);
                g2.drawOutlinedText("+" + amount, Forge.altZoneTabs ? LIFE_FONT_ALT : LIFE_FONT, Color.WHITE, Color.SKY, 0.0f, VAvatar.this.getHeight() / 2.0f * fade, VAvatar.this.getWidth(), VAvatar.this.getHeight(), false, 1, true);
                g2.setAlphaComposite(oldAlpha);
            } else if (amount < 0) {
                if (this.splatter == null) {
                    g2.setColorRGBA(1.0f, percentage, percentage, oldAlpha);
                    g2.drawAvatarImage(image, x, y, w, h2, VAvatar.this.player.getHasLost(), 0.0f);
                    g2.resetColorRGBA(oldAlpha);
                } else {
                    g2.drawAvatarImage(image, x, y, w, h2, VAvatar.this.player.getHasLost(), 0.0f);
                    g2.setAlphaComposite(fade);
                    g2.drawImage(this.splatter, x - mod / 2.0f, y - mod / 2.0f, w + mod, h2 + mod);
                    g2.setAlphaComposite(oldAlpha);
                }
                VAvatar.this.drawPlayerIndicator(g2, w, h2, percentage);
                g2.setAlphaComposite(fade);
                g2.drawOutlinedText(String.valueOf(amount), Forge.altZoneTabs ? LIFE_FONT_ALT : LIFE_FONT, Color.RED, Color.ORANGE, 0.0f, VAvatar.this.getHeight() / 2.0f * fade, VAvatar.this.getWidth(), VAvatar.this.getHeight(), false, 1, true);
                g2.setAlphaComposite(oldAlpha);
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < 1.2f;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            this.progress = 0.0f;
            VAvatar.this.player.setAvatarLifeDifference(0);
        }
    }
}

