/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.screens.match.MatchController;
import forge.toolbox.FCheckBox;
import forge.toolbox.FChoiceList;
import forge.toolbox.FDialog;
import forge.toolbox.FOptionPane;
import forge.util.TextBounds;
import java.util.ArrayList;

public class VAutoYields
extends FDialog {
    private final FChoiceList<String> lstAutoYields;
    private final FCheckBox chkDisableAll;

    public VAutoYields() {
        super(Forge.getLocalizer().getMessage("lblAutoYields", new Object[0]), 2);
        ArrayList<String> autoYields = new ArrayList<String>();
        for (String autoYield : MatchController.instance.getAutoYields()) {
            autoYields.add(autoYield);
        }
        this.lstAutoYields = this.add(new FChoiceList<String>(autoYields){

            @Override
            protected void onCompactModeChange() {
                VAutoYields.this.revalidate();
            }

            @Override
            protected boolean allowDefaultItemWrap() {
                return true;
            }
        });
        this.chkDisableAll = this.add(new FCheckBox(Forge.getLocalizer().getMessage("lblDisableAllAutoYields", new Object[0]), MatchController.instance.getDisableAutoYields()));
        this.chkDisableAll.setCommand(e -> MatchController.instance.setDisableAutoYields(this.chkDisableAll.isSelected()));
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> this.hide());
        this.initButton(1, Forge.getLocalizer().getMessage("lblRemoveYield", new Object[0]), e -> {
            String selected = this.lstAutoYields.getSelectedItem();
            if (selected != null) {
                this.lstAutoYields.removeItem(selected);
                MatchController.instance.setShouldAutoYield(selected, false);
                this.setButtonEnabled(1, this.lstAutoYields.getCount() > 0);
                this.lstAutoYields.cleanUpSelections();
                this.revalidate();
            }
        });
        this.setButtonEnabled(1, autoYields.size() > 0);
    }

    @Override
    public void show() {
        if (this.lstAutoYields.getCount() > 0) {
            super.show();
        } else {
            FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblNoActiveAutoYield", new Object[0]), Forge.getLocalizer().getMessage("lblNoAutoYield", new Object[0]), FOptionPane.INFORMATION_ICON);
        }
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float maxListHeight;
        float padding;
        float x = padding = FOptionPane.PADDING;
        float y = padding;
        float w = width - 2.0f * padding;
        TextBounds checkBoxSize = this.chkDisableAll.getAutoSizeBounds();
        float listHeight = this.lstAutoYields.getListItemRenderer().getItemHeight() * (float)this.lstAutoYields.getCount();
        if (listHeight > (maxListHeight = maxHeight - 3.0f * padding - checkBoxSize.height)) {
            listHeight = maxListHeight;
        }
        this.lstAutoYields.setBounds(x, y, w, listHeight);
        this.chkDisableAll.setBounds(x, y += listHeight + padding, Math.min(checkBoxSize.width, w), checkBoxSize.height);
        return y += checkBoxSize.height + padding;
    }
}

