/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinImageInterface;
import forge.card.CardZoom;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.MatchController;
import forge.toolbox.FCardPanel;
import forge.toolbox.FContainer;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.CardTranslation;
import forge.util.TextUtil;
import forge.util.Utils;
import forge.util.WaitCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VAssignGenericAmount
extends FDialog {
    private static final float CARD_GAP_X = Utils.scale(10.0f);
    private static final float ADD_BTN_HEIGHT = Utils.AVG_FINGER_HEIGHT * 0.75f;
    private final Callback<Map<Object, Integer>> callback;
    private final int totalAmountToAssign;
    private final String lblAmount;
    private final FLabel lblTotalAmount;
    private final boolean atLeastOne;
    private final EffectSourcePanel pnlSource;
    private final TargetsPanel pnlTargets;
    private final List<AssignTarget> targetsList = new ArrayList<AssignTarget>();
    private final Map<Object, AssignTarget> targetsMap = new HashMap<Object, AssignTarget>();

    public VAssignGenericAmount(CardView effectSource, Map<Object, Integer> targets, int amount, boolean atLeastOne, String amountLabel, WaitCallback<Map<Object, Integer>> waitCallback) {
        super(Forge.getLocalizer().getMessage("lbLAssignAmountForEffect", amountLabel, CardTranslation.getTranslatedName(effectSource.getName())), 2);
        this.callback = waitCallback;
        this.totalAmountToAssign = amount;
        this.atLeastOne = atLeastOne;
        this.lblAmount = amountLabel;
        this.lblTotalAmount = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblTotalAmountText", this.lblAmount)).align(1).build());
        this.pnlSource = this.add(new EffectSourcePanel(effectSource));
        this.pnlTargets = this.add(new TargetsPanel(targets));
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> this.finish());
        this.initButton(1, Forge.getLocalizer().getMessage("lblReset", new Object[0]), e -> {
            this.resetAssignedDamage();
            this.initialAssignAmount();
        });
        this.initialAssignAmount();
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float padding = FOptionPane.PADDING;
        float w = width - 2.0f * padding;
        float x = padding;
        float labelHeight = this.lblTotalAmount.getAutoSizeBounds().height;
        float y = maxHeight - labelHeight + padding;
        float dtOffset = ADD_BTN_HEIGHT + ((AssignTarget)this.targetsList.get((int)0)).label.getAutoSizeBounds().height;
        float cardPanelHeight = (y - dtOffset - labelHeight - 3.0f * padding) / 2.0f;
        float cardPanelWidth = cardPanelHeight / 1.4f;
        y = padding;
        this.pnlSource.setBounds(x + (w - cardPanelWidth) / 2.0f, y, cardPanelWidth, cardPanelHeight);
        this.lblTotalAmount.setBounds(x, y += cardPanelHeight + padding, w, labelHeight);
        this.pnlTargets.setBounds(0.0f, y += labelHeight + padding, width, cardPanelHeight + dtOffset);
        return maxHeight;
    }

    private void assignAmountTo(Object source, boolean isAdding) {
        int remainingAmount;
        AssignTarget at = this.targetsMap.get(source);
        int assigned = at.amount;
        int leftToAssign = Math.max(0, at.max - assigned);
        int amountToAdd = isAdding ? 1 : -1;
        if (amountToAdd > (remainingAmount = Math.min(this.getRemainingAmount(), leftToAssign))) {
            amountToAdd = remainingAmount;
        }
        if (this.atLeastOne && assigned + amountToAdd < 1) {
            amountToAdd = 1 - assigned;
        }
        if (0 == amountToAdd || amountToAdd + assigned < 0) {
            return;
        }
        this.addAssignedAmount(at, amountToAdd);
        this.updateLabels();
    }

    private void initialAssignAmount() {
        if (!this.atLeastOne) {
            this.updateLabels();
            return;
        }
        for (AssignTarget at : this.targetsList) {
            this.addAssignedAmount(at, 1);
        }
        this.updateLabels();
    }

    private void resetAssignedDamage() {
        for (AssignTarget at : this.targetsList) {
            at.amount = 0;
        }
    }

    private void addAssignedAmount(AssignTarget at, int addedAmount) {
        int canAssign = this.getRemainingAmount();
        if (canAssign < addedAmount) {
            addedAmount = canAssign;
        }
        at.amount = Math.max(0, addedAmount + at.amount);
    }

    private int getRemainingAmount() {
        int spent = 0;
        for (AssignTarget at : this.targetsList) {
            spent += at.amount;
        }
        return this.totalAmountToAssign - spent;
    }

    private void updateLabels() {
        int amountLeft = this.totalAmountToAssign;
        for (AssignTarget at : this.targetsList) {
            amountLeft -= at.amount;
            StringBuilder sb = new StringBuilder();
            sb.append(at.amount);
            if (at.max - at.amount == 0) {
                sb.append(" (").append(Forge.getLocalizer().getMessage("lblMax", new Object[0])).append(")");
            }
            at.label.setText(sb.toString());
        }
        this.lblTotalAmount.setText(TextUtil.concatNoSpace(Forge.getLocalizer().getMessage("lblAvailableAmount", this.lblAmount) + ": ", String.valueOf(amountLeft), " (of ", String.valueOf(this.totalAmountToAssign), ")"));
        this.setButtonEnabled(0, amountLeft == 0);
    }

    private void finish() {
        if (this.getRemainingAmount() > 0) {
            return;
        }
        this.hide();
        this.callback.run(this.getAssignedMap());
    }

    public Map<Object, Integer> getAssignedMap() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>(this.targetsList.size());
        for (AssignTarget at : this.targetsList) {
            result.put(at.entity, at.amount);
        }
        return result;
    }

    private static class MiscTargetPanel
    extends FDisplayObject {
        private static final FSkinFont FONT = FSkinFont.get(18);
        private final String name;
        private final FImage image;

        private static FSkinColor getForeColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        }

        private MiscTargetPanel(String name0, FImage image0) {
            this.name = name0;
            this.image = image0;
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            g2.drawImage(this.image, 0.0f, 0.0f, w, w);
            g2.drawText(this.name, FONT, MiscTargetPanel.getForeColor(), 0.0f, w, w, h2 - w, false, 1, true);
        }
    }

    private static class EffectSourcePanel
    extends FCardPanel {
        private EffectSourcePanel(CardView card) {
            super(card);
        }

        @Override
        public boolean tap(float x, float y, int count) {
            CardZoom.show(this.getCard());
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            CardZoom.show(this.getCard());
            return true;
        }

        @Override
        protected float getPadding() {
            return 0.0f;
        }
    }

    private class AssignTarget
    extends FContainer {
        private final Object entity;
        private final FDisplayObject obj;
        private final FLabel label;
        private final FLabel btnSubtract;
        private final FLabel btnAdd;
        private final int max;
        private int amount;

        public AssignTarget(Object entity0, int max0) {
            this.entity = entity0;
            this.max = max0;
            if (this.entity instanceof CardView) {
                this.obj = this.add(new EffectSourcePanel((CardView)this.entity));
            } else if (this.entity instanceof PlayerView) {
                PlayerView player = (PlayerView)this.entity;
                this.obj = this.add(new MiscTargetPanel(player.getName(), MatchController.getPlayerAvatar(player)));
            } else if (this.entity instanceof Byte) {
                byte color = (Byte)this.entity;
                FSkinImageInterface manaSymbol = color == 1 ? Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_W) : (color == 2 ? Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_U) : (color == 4 ? Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_B) : (color == 8 ? Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_R) : (color == 16 ? Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_G) : Forge.getAssets().images().get((Object)FSkinProp.IMG_MANA_COLORLESS)))));
                this.obj = this.add(new MiscTargetPanel("", manaSymbol));
            } else {
                this.obj = this.add(new MiscTargetPanel(this.entity.toString(), FSkinImage.UNKNOWN));
            }
            this.label = this.add(new FLabel.Builder().text("0").font(FSkinFont.get(18)).align(1).build());
            this.btnSubtract = this.add(new FLabel.ButtonBuilder().icon(FSkinImage.MINUS).command(e -> VAssignGenericAmount.this.assignAmountTo(this.entity, false)).build());
            this.btnAdd = this.add(new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS).command(e -> VAssignGenericAmount.this.assignAmountTo(this.entity, true)).build());
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = 0.0f;
            this.obj.setBounds(0.0f, y, width, 1.4f * width);
            this.label.setBounds(0.0f, y += this.obj.getHeight(), width, this.label.getAutoSizeBounds().height);
            float buttonSize = (width - FOptionPane.PADDING) / 2.0f;
            this.btnSubtract.setBounds(0.0f, y += this.label.getHeight(), buttonSize, ADD_BTN_HEIGHT);
            this.btnAdd.setBounds(width - buttonSize, y, buttonSize, ADD_BTN_HEIGHT);
        }
    }

    private class TargetsPanel
    extends FScrollPane {
        private TargetsPanel(Map<Object, Integer> targets) {
            for (Map.Entry<Object, Integer> e : targets.entrySet()) {
                this.addDamageTarget(e.getKey(), e.getValue());
            }
        }

        private void addDamageTarget(Object entity, int max) {
            AssignTarget at = this.add(new AssignTarget(entity, max));
            VAssignGenericAmount.this.targetsMap.put(entity, at);
            VAssignGenericAmount.this.targetsList.add(at);
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float cardPanelHeight = visibleHeight - ADD_BTN_HEIGHT - ((AssignTarget)((AssignTarget)((VAssignGenericAmount)VAssignGenericAmount.this).targetsList.get((int)0))).label.getAutoSizeBounds().height;
            float width = cardPanelHeight / 1.4f;
            float dx = width + CARD_GAP_X;
            float x = (visibleWidth - (float)VAssignGenericAmount.this.targetsList.size() * dx + CARD_GAP_X) / 2.0f;
            if (x < FOptionPane.PADDING) {
                x = FOptionPane.PADDING;
            }
            for (AssignTarget at : VAssignGenericAmount.this.targetsList) {
                at.setBounds(x, 0.0f, width, visibleHeight);
                x += dx;
            }
            return new FScrollPane.ScrollBounds(x - CARD_GAP_X + FOptionPane.PADDING, visibleHeight);
        }
    }
}

