/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match.views;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardZoom;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.player.PlayerView;
import forge.screens.match.MatchController;
import forge.toolbox.FCardPanel;
import forge.toolbox.FContainer;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.CardTranslation;
import forge.util.TextUtil;
import forge.util.Utils;
import forge.util.WaitCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VAssignCombatDamage
extends FDialog {
    private static final float CARD_GAP_X = Utils.scale(10.0f);
    private static final float ADD_BTN_HEIGHT = Utils.AVG_FINGER_HEIGHT * 0.75f;
    private final Callback<Map<CardView, Integer>> callback;
    private final int totalDamageToAssign;
    private boolean attackerHasDeathtouch = false;
    private boolean attackerHasDivideDamage = false;
    private boolean attackerHasTrample = false;
    private boolean attackerHasInfect = false;
    private boolean overrideCombatantOrder = false;
    private boolean skip = false;
    private final GameEntityView defender;
    private final FLabel lblTotalDamage = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblTotalDamageText", new Object[0])).align(1).build());
    private final FLabel lblAssignRemaining = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblAssignRemainingText", new Object[0])).align(1).build());
    private final AttDefCardPanel pnlAttacker;
    private final DefendersPanel pnlDefenders;
    private final List<DamageTarget> defenders = new ArrayList<DamageTarget>();
    private final Map<CardView, DamageTarget> damage = new HashMap<CardView, DamageTarget>();

    private boolean canAssignTo(CardView card) {
        for (DamageTarget dt : this.defenders) {
            if (dt.card == card) {
                return true;
            }
            if (this.getDamageToKill(dt.card) <= dt.damage) continue;
            return false;
        }
        throw new RuntimeException("Asking to assign damage to object which is not present in defenders list");
    }

    public VAssignCombatDamage(CardView attacker, List<CardView> blockers, int damage0, GameEntityView defender0, boolean overrideOrder, boolean maySkip, WaitCallback<Map<CardView, Integer>> waitCallback) {
        super(Forge.getLocalizer().getMessage("lbLAssignDamageDealtBy", new Object[0]).replace("%s", CardTranslation.getTranslatedName(attacker.getName())), 3);
        this.callback = waitCallback;
        this.totalDamageToAssign = damage0;
        this.defender = defender0;
        this.attackerHasDeathtouch = attacker.getCurrentState().hasDeathtouch();
        this.attackerHasDivideDamage = attacker.getCurrentState().hasDivideDamage();
        this.attackerHasInfect = attacker.getCurrentState().hasInfect();
        this.attackerHasTrample = this.defender != null && attacker.getCurrentState().hasTrample();
        this.overrideCombatantOrder = overrideOrder;
        this.pnlAttacker = this.add(new AttDefCardPanel(attacker));
        this.pnlDefenders = this.add(new DefendersPanel(blockers));
        this.initButton(0, Forge.getLocalizer().getMessage("lblAuto", new Object[0]), e -> {
            this.resetAssignedDamage();
            this.initialAssignDamage(true);
            this.finish();
        });
        this.initButton(1, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> this.finish());
        this.initButton(2, Forge.getLocalizer().getMessage("lblReset", new Object[0]), e -> {
            this.resetAssignedDamage();
            this.initialAssignDamage(false);
        });
        if (maySkip) {
            this.initButton(2, Forge.getLocalizer().getMessage("lblSkip", new Object[0]), e -> {
                this.skip = true;
                this.finish();
            });
        }
        this.initialAssignDamage(false);
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float padding = FOptionPane.PADDING;
        float w = width - 2.0f * padding;
        float x = padding;
        float labelHeight = this.lblAssignRemaining.getAutoSizeBounds().height;
        float y = maxHeight - labelHeight + padding;
        this.lblAssignRemaining.setBounds(x, y, w, labelHeight);
        float dtOffset = ADD_BTN_HEIGHT + ((DamageTarget)this.defenders.get((int)0)).label.getAutoSizeBounds().height;
        float cardPanelHeight = (y - dtOffset - labelHeight - 3.0f * padding) / 2.0f;
        float cardPanelWidth = cardPanelHeight / 1.4f;
        y = padding;
        this.pnlAttacker.setBounds(x + (w - cardPanelWidth) / 2.0f, y, cardPanelWidth, cardPanelHeight);
        this.lblTotalDamage.setBounds(x, y += cardPanelHeight + padding, w, labelHeight);
        this.pnlDefenders.setBounds(0.0f, y += labelHeight + padding, width, cardPanelHeight + dtOffset);
        return maxHeight;
    }

    private void assignDamageTo(CardView source, boolean isAdding) {
        boolean isFirstBlocker;
        int leftToAssign;
        if (!this.damage.containsKey(source)) {
            source = null;
        }
        if (!(this.attackerHasDivideDamage || source != null && source != this.defender && this.overrideCombatantOrder || !isAdding || this.canAssignTo(source))) {
            return;
        }
        int lethalDamage = this.getDamageToKill(source);
        int damageItHad = this.damage.get(source).damage;
        int damageToAdd = isAdding ? 1 : -1;
        if (damageToAdd > (leftToAssign = this.getRemainingDamage())) {
            damageToAdd = leftToAssign;
        }
        boolean bl = isFirstBlocker = this.defenders.get(0).card == source;
        if (!this.overrideCombatantOrder && isFirstBlocker && damageToAdd + damageItHad < lethalDamage) {
            return;
        }
        if (damageToAdd == 0 || damageToAdd + damageItHad < 0) {
            return;
        }
        this.addDamage(source, damageToAdd);
        this.checkDamageQueue();
        this.updateLabels();
    }

    private void checkDamageQueue() {
        if (this.overrideCombatantOrder && this.attackerHasDivideDamage) {
            return;
        }
        boolean hasAliveEnemy = false;
        for (DamageTarget dt : this.defenders) {
            int lethal = this.getDamageToKill(dt.card);
            int damage = dt.damage;
            if (hasAliveEnemy && (!this.overrideCombatantOrder || dt.card == null || dt.card == this.defender)) {
                dt.damage = 0;
                continue;
            }
            hasAliveEnemy |= damage < lethal;
        }
    }

    private void initialAssignDamage(boolean toAllBlockers) {
        if (!toAllBlockers && this.overrideCombatantOrder) {
            this.updateLabels();
            return;
        }
        int dmgLeft = this.totalDamageToAssign;
        DamageTarget dtLast = null;
        for (DamageTarget dt : this.defenders) {
            int lethal = this.getDamageToKill(dt.card);
            int damage = Math.min(lethal, dmgLeft);
            this.addDamage(dt.card, damage);
            dtLast = dt;
            if ((dmgLeft -= damage) > 0 && toAllBlockers) continue;
            break;
        }
        if (dmgLeft < 0) {
            throw new RuntimeException("initialAssignDamage managed to assign more damage than it could");
        }
        if (toAllBlockers && dmgLeft > 0) {
            this.addDamage(dtLast.card, dmgLeft);
        }
        this.updateLabels();
    }

    private void resetAssignedDamage() {
        for (DamageTarget dt : this.defenders) {
            dt.damage = 0;
        }
    }

    private void addDamage(CardView card, int addedDamage) {
        int canAssign = this.getRemainingDamage();
        if (canAssign < addedDamage) {
            addedDamage = canAssign;
        }
        DamageTarget dt = this.damage.get(card);
        dt.damage = Math.max(0, addedDamage + dt.damage);
    }

    private int getRemainingDamage() {
        int spent = 0;
        for (DamageTarget dt : this.defenders) {
            spent += dt.damage;
        }
        return this.totalDamageToAssign - spent;
    }

    private void updateLabels() {
        int damageLeft = this.totalDamageToAssign;
        boolean allHaveLethal = true;
        for (DamageTarget dt : this.defenders) {
            int dmg = dt.damage;
            damageLeft -= dmg;
            int lethal = this.getDamageToKill(dt.card);
            int overkill = dmg - lethal;
            StringBuilder sb = new StringBuilder();
            sb.append(dmg);
            if (overkill >= 0) {
                sb.append(" (" + Forge.getLocalizer().getMessage("lblLethal", new Object[0]));
                if (overkill > 0) {
                    sb.append(" +").append(overkill);
                }
                sb.append(")");
            }
            allHaveLethal &= dmg >= lethal;
            dt.label.setText(sb.toString());
        }
        this.lblTotalDamage.setText(TextUtil.concatNoSpace(Forge.getLocalizer().getMessage("lblAvailableDamagePoints", new Object[0]) + ": ", String.valueOf(damageLeft), " (of ", String.valueOf(this.totalDamageToAssign), ")"));
        this.setButtonEnabled(1, damageLeft == 0);
        this.lblAssignRemaining.setVisible(allHaveLethal && damageLeft > 0);
    }

    private void finish() {
        if (!this.skip && this.getRemainingDamage() > 0) {
            return;
        }
        this.hide();
        this.callback.run(this.getDamageMap());
    }

    private int getDamageToKill(CardView source) {
        int lethalDamage = 0;
        if (source == null) {
            if (this.defender instanceof PlayerView) {
                PlayerView p = (PlayerView)this.defender;
                lethalDamage = this.attackerHasInfect ? MatchController.instance.getGameView().getPoisonCountersToLose() - p.getCounters(CounterEnumType.POISON) : p.getLife();
            } else if (this.defender instanceof CardView) {
                CardView pw = (CardView)this.defender;
                lethalDamage = ((CardView)this.defender).getCurrentState().isPlaneswalker() ? Integer.parseInt(pw.getCurrentState().getLoyalty()) : Integer.parseInt(pw.getCurrentState().getDefense());
            }
        } else {
            lethalDamage = Math.max(0, source.getLethalDamage());
            if (source.getCurrentState().getType().isPlaneswalker()) {
                lethalDamage = Integer.parseInt(source.getCurrentState().getLoyalty());
            } else if (source.getCurrentState().getType().isBattle()) {
                lethalDamage = Integer.parseInt(source.getCurrentState().getDefense());
            } else if (this.attackerHasDeathtouch) {
                lethalDamage = Math.min(lethalDamage, 1);
            }
        }
        return lethalDamage;
    }

    public Map<CardView, Integer> getDamageMap() {
        if (this.skip) {
            return null;
        }
        HashMap<CardView, Integer> result = new HashMap<CardView, Integer>();
        for (DamageTarget dt : this.defenders) {
            result.put(dt.card, dt.damage);
        }
        return result;
    }

    private static class MiscAttDefPanel
    extends FDisplayObject {
        private static final FSkinFont FONT = FSkinFont.get(18);
        private final String name;
        private final FImage image;

        private static FSkinColor getForeColor() {
            if (Forge.isMobileAdventureMode) {
                return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
            }
            return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        }

        private MiscAttDefPanel(String name0, FImage image0) {
            this.name = name0;
            this.image = image0;
        }

        @Override
        public void draw(Graphics g2) {
            float w = this.getWidth();
            float h2 = this.getHeight();
            g2.drawImage(this.image, 0.0f, 0.0f, w, w);
            g2.drawText(this.name, FONT, MiscAttDefPanel.getForeColor(), 0.0f, w, w, h2 - w, false, 1, true);
        }
    }

    private static class AttDefCardPanel
    extends FCardPanel {
        private AttDefCardPanel(CardView card) {
            super(card);
        }

        @Override
        public boolean tap(float x, float y, int count) {
            CardZoom.show(this.getCard());
            return true;
        }

        @Override
        public boolean longPress(float x, float y) {
            CardZoom.show(this.getCard());
            return true;
        }

        @Override
        protected float getPadding() {
            return 0.0f;
        }
    }

    private class DamageTarget
    extends FContainer {
        private final CardView card;
        private final FDisplayObject obj;
        private final FLabel label;
        private final FLabel btnSubtract;
        private final FLabel btnAdd;
        private int damage;

        public DamageTarget(CardView card0) {
            this.card = card0;
            if (this.card != null) {
                this.obj = this.add(new AttDefCardPanel(this.card));
            } else if (VAssignCombatDamage.this.defender instanceof CardView) {
                this.obj = this.add(new AttDefCardPanel((CardView)VAssignCombatDamage.this.defender));
            } else if (VAssignCombatDamage.this.defender instanceof PlayerView) {
                PlayerView player = (PlayerView)VAssignCombatDamage.this.defender;
                this.obj = this.add(new MiscAttDefPanel(player.getName(), MatchController.getPlayerAvatar(player)));
            } else {
                this.obj = this.add(new MiscAttDefPanel(VAssignCombatDamage.this.defender.toString(), FSkinImage.UNKNOWN));
            }
            this.label = this.add(new FLabel.Builder().text("0").font(FSkinFont.get(18)).align(1).build());
            this.btnSubtract = this.add(new FLabel.ButtonBuilder().icon(FSkinImage.MINUS).command(e -> VAssignCombatDamage.this.assignDamageTo(this.card, false)).build());
            this.btnAdd = this.add(new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS).command(e -> VAssignCombatDamage.this.assignDamageTo(this.card, true)).build());
        }

        @Override
        protected void doLayout(float width, float height) {
            float y = 0.0f;
            this.obj.setBounds(0.0f, y, width, 1.4f * width);
            this.label.setBounds(0.0f, y += this.obj.getHeight(), width, this.label.getAutoSizeBounds().height);
            float buttonSize = (width - FOptionPane.PADDING) / 2.0f;
            this.btnSubtract.setBounds(0.0f, y += this.label.getHeight(), buttonSize, ADD_BTN_HEIGHT);
            this.btnAdd.setBounds(width - buttonSize, y, buttonSize, ADD_BTN_HEIGHT);
        }
    }

    private class DefendersPanel
    extends FScrollPane {
        private DefendersPanel(List<CardView> defenderCards) {
            for (CardView c : defenderCards) {
                this.addDamageTarget(c);
            }
            if (VAssignCombatDamage.this.attackerHasTrample || VAssignCombatDamage.this.attackerHasDivideDamage && VAssignCombatDamage.this.overrideCombatantOrder) {
                this.addDamageTarget(null);
            }
        }

        private void addDamageTarget(CardView card) {
            DamageTarget dt = this.add(new DamageTarget(card));
            VAssignCombatDamage.this.damage.put(card, dt);
            VAssignCombatDamage.this.defenders.add(dt);
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float cardPanelHeight = visibleHeight - ADD_BTN_HEIGHT - ((DamageTarget)((DamageTarget)((VAssignCombatDamage)VAssignCombatDamage.this).defenders.get((int)0))).label.getAutoSizeBounds().height;
            float width = cardPanelHeight / 1.4f;
            float dx = width + CARD_GAP_X;
            float x = (visibleWidth - (float)VAssignCombatDamage.this.defenders.size() * dx + CARD_GAP_X) / 2.0f;
            if (x < FOptionPane.PADDING) {
                x = FOptionPane.PADDING;
            }
            for (DamageTarget dt : VAssignCombatDamage.this.defenders) {
                dt.setBounds(x, 0.0f, width, visibleHeight);
                x += dx;
            }
            return new FScrollPane.ScrollBounds(x - CARD_GAP_X + FOptionPane.PADDING, visibleHeight);
        }
    }
}

