/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.limited;

import forge.Forge;
import forge.assets.FSkinFont;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckProxy;
import forge.deck.FDeckChooser;
import forge.deck.FDeckEditor;
import forge.deck.io.DeckPreferences;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.util.SGuiChoose;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.LaunchScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.LoadGameMenu;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import java.util.ArrayList;

public class LoadDraftScreen
extends LaunchScreen {
    private final DeckManager lstDecks = this.add(new DeckManager(GameType.Draft));
    private final FLabel lblTip = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblDoubleTapToEditDeck", new Object[0])).textColor(FLabel.getInlineLabelColor()).align(1).font(FSkinFont.get(12)).build());
    private final FSkinFont GAME_MODE_FONT = FSkinFont.get(12);
    private final FLabel lblMode = this.add(new FLabel.Builder().text(Forge.getLocalizer().getMessage("lblMode", new Object[0])).font(this.GAME_MODE_FONT).build());
    private final FComboBox<String> cbMode = this.add(new FComboBox());

    public LoadDraftScreen() {
        super(null, LoadGameMenu.getMenu());
        this.cbMode.setFont(this.GAME_MODE_FONT);
        this.cbMode.addItem(Forge.getLocalizer().getMessage("lblGauntlet", new Object[0]));
        this.cbMode.addItem(Forge.getLocalizer().getMessage("lblSingleMatch", new Object[0]));
        this.lstDecks.setup(ItemManagerConfig.DRAFT_DECKS);
        this.lstDecks.setItemActivateHandler(event -> this.editSelectedDeck());
    }

    @Override
    public void onActivate() {
        this.lstDecks.setPool(DeckProxy.getAllDraftDecks());
        this.lstDecks.setSelectedString(DeckPreferences.getDraftDeck());
    }

    private void editSelectedDeck() {
        DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
        if (deck == null) {
            return;
        }
        DeckPreferences.setDraftDeck(deck.getName());
        Forge.openScreen(new FDeckEditor(FDeckEditor.EditorType.Draft, deck, true));
    }

    @Override
    protected void doLayoutAboveBtnStart(float startY, float width, float height) {
        float x = ItemFilter.PADDING;
        float y = startY;
        float w = width - 2.0f * x;
        float labelHeight = this.lblTip.getAutoSizeBounds().height;
        float listHeight = height - labelHeight - y - FDeckChooser.PADDING;
        float comboBoxHeight = this.cbMode.getHeight();
        this.lblMode.setBounds(x, y, this.lblMode.getAutoSizeBounds().width + FDeckChooser.PADDING / 2.0f, comboBoxHeight);
        this.cbMode.setBounds(x + this.lblMode.getWidth(), y, w - this.lblMode.getWidth(), comboBoxHeight);
        this.lstDecks.setBounds(x, y += comboBoxHeight + FDeckChooser.PADDING, w, listHeight);
        this.lblTip.setBounds(x, y += listHeight + FDeckChooser.PADDING, w, labelHeight);
        y += labelHeight + FDeckChooser.PADDING;
    }

    @Override
    protected void startMatch() {
        FThreads.invokeInBackgroundThread(() -> {
            DeckProxy humanDeck = (DeckProxy)this.lstDecks.getSelectedItem();
            if (humanDeck == null) {
                FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblYouMustSelectExistingDeck", new Object[0]), Forge.getLocalizer().getMessage("lblNoDeck", new Object[0]));
                return;
            }
            boolean gauntlet = this.cbMode.getSelectedItem().equals(Forge.getLocalizer().getMessage("lblGauntlet", new Object[0]));
            if (gauntlet) {
                Integer rounds = SGuiChoose.getInteger(Forge.getLocalizer().getMessage("lblHowManyOpponents", new Object[0]), 1, FModel.getDecks().getDraft().get(humanDeck.getName()).getAiDecks().size());
                if (rounds == null) {
                    return;
                }
                FThreads.invokeInEdtLater(() -> {
                    if (!this.checkDeckLegality(humanDeck)) {
                        return;
                    }
                    LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, () -> {
                        FModel.getGauntletMini().resetGauntletDraft();
                        FModel.getGauntletMini().launch(rounds, humanDeck.getDeck(), GameType.Draft);
                    });
                });
            } else {
                Integer aiIndex = SGuiChoose.getInteger(Forge.getLocalizer().getMessage("lblWhichOpponentWouldYouLikeToFace", new Object[0]), 1, FModel.getDecks().getDraft().get(humanDeck.getName()).getAiDecks().size());
                if (aiIndex == null) {
                    return;
                }
                DeckGroup opponentDecks = FModel.getDecks().getDraft().get(humanDeck.getName());
                Deck aiDeck = opponentDecks.getAiDecks().get(aiIndex - 1);
                if (aiDeck == null) {
                    throw new IllegalStateException("Draft: Computer deck is null!");
                }
                FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, () -> {
                    if (!this.checkDeckLegality(humanDeck)) {
                        return;
                    }
                    ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
                    RegisteredPlayer human = new RegisteredPlayer(humanDeck.getDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
                    starter.add(human);
                    starter.add(new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
                    for (RegisteredPlayer pl : starter) {
                        pl.assignConspiracies();
                    }
                    FModel.getGauntletMini().resetGauntletDraft();
                    HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
                    hostedMatch.startMatch(GameType.Draft, null, starter, human, GuiBase.getInterface().getNewGuiGame());
                }));
            }
        });
    }

    private boolean checkDeckLegality(DeckProxy humanDeck) {
        String errorMessage;
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY) && (errorMessage = GameType.Draft.getDeckFormat().getDeckConformanceProblem(humanDeck.getDeck())) != null) {
            FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblInvalidDeckDesc", new Object[0]).replace("%n", errorMessage), Forge.getLocalizer().getMessage("lblInvalidDeck", new Object[0]));
            return false;
        }
        return true;
    }
}

