/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.limited;

import forge.Forge;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.FDeckEditor;
import forge.deck.io.DeckPreferences;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.quest.QuestTournamentController;
import forge.gui.FThreads;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.home.LoadGameMenu;
import forge.toolbox.FOptionPane;
import forge.util.Callback;
import org.apache.commons.lang3.StringUtils;

public class DraftingProcessScreen
extends FDeckEditor {
    private boolean isDraftSaved;
    private final BoosterDraft draft;
    private final QuestTournamentController questDraftController;

    public DraftingProcessScreen(BoosterDraft draft0, FDeckEditor.EditorType editorType0, QuestTournamentController questDraftController0) {
        super(editorType0, "", false);
        this.draft = draft0;
        this.questDraftController = questDraftController0;
        this.getCatalogPage().refresh();
    }

    @Override
    public BoosterDraft getDraft() {
        return this.draft;
    }

    @Override
    public void save(final Callback<Boolean> callback) {
        if (this.isDraftSaved) {
            super.save(callback);
            return;
        }
        if (this.getEditorType() == FDeckEditor.EditorType.QuestDraft) {
            this.finishSave("Tournament Deck");
            if (callback != null) {
                callback.run(true);
            }
            return;
        }
        FOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblSaveDraftAs", new Object[0]) + "?", new Callback<String>(){

            @Override
            public void run(final String name) {
                if (StringUtils.isEmpty(name)) {
                    DraftingProcessScreen.this.save(callback);
                    return;
                }
                for (DeckGroup d : FModel.getDecks().getDraft()) {
                    if (!name.equalsIgnoreCase(d.getName())) continue;
                    FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblAlreadyDeckName", new Object[0]) + name + Forge.getLocalizer().getMessage("lblOverwriteConfirm", new Object[0]), Forge.getLocalizer().getMessage("lblOverwriteDeck", new Object[0]), false, new Callback<Boolean>(){

                        @Override
                        public void run(Boolean result) {
                            if (result.booleanValue()) {
                                DraftingProcessScreen.this.finishSave(name);
                                if (callback != null) {
                                    callback.run(true);
                                }
                            } else {
                                DraftingProcessScreen.this.save(callback);
                            }
                        }
                    });
                    return;
                }
                DraftingProcessScreen.this.finishSave(name);
                if (callback != null) {
                    callback.run(true);
                }
            }
        });
    }

    private void finishSave(String name) {
        this.isDraftSaved = true;
        Deck[] computer = this.draft.getDecks();
        DeckGroup finishedDraft = new DeckGroup(name);
        finishedDraft.setHumanDeck((Deck)this.getDeck().copyTo(name));
        finishedDraft.addAiDecks(computer);
        switch (this.getEditorType()) {
            case Draft: {
                FModel.getDecks().getDraft().add(finishedDraft);
                this.getEditorType().getController().load("", name);
                DeckPreferences.setDraftDeck(name);
                LoadGameMenu.LoadGameScreen.BoosterDraft.setAsBackScreen(false);
                LoadGameMenu.LoadGameScreen.BoosterDraft.open();
                break;
            }
            case QuestDraft: {
                FModel.getQuest().getDraftDecks().add(finishedDraft);
                this.getEditorType().getController().load("", name);
                break;
            }
        }
        this.deckHeader.setVisible(true);
        this.revalidate();
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        if (this.isDraftSaved || canCloseCallback == null) {
            super.onClose(canCloseCallback);
            return;
        }
        if (this.getEditorType() == FDeckEditor.EditorType.QuestDraft) {
            FThreads.invokeInBackgroundThread(() -> {
                if (this.questDraftController.cancelDraft()) {
                    FThreads.invokeInEdtLater(() -> canCloseCallback.run(true));
                }
            });
            return;
        }
        FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblEndDraftConfirm", new Object[0]), Forge.getLocalizer().getMessage("lblLeaveDraft", new Object[0]), Forge.getLocalizer().getMessage("lblLeave", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), false, canCloseCallback);
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }
}

