/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinImage;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.constructed.ConstructedScreen;
import forge.screens.gauntlet.NewGauntletScreen;
import forge.screens.home.AdventureScreen;
import forge.screens.home.puzzle.PuzzleScreen;
import forge.screens.limited.NewDraftScreen;
import forge.screens.limited.NewSealedScreen;
import forge.screens.planarconquest.NewConquestScreen;
import forge.screens.quest.NewQuestScreen;

public class NewGameMenu
extends FPopupMenu {
    private static final ForgePreferences prefs;
    private static final NewGameMenu menu;
    private static NewGameScreen preferredScreen;

    public static NewGameScreen getPreferredScreen() {
        if (preferredScreen == null) {
            return NewGameScreen.Constructed;
        }
        return preferredScreen;
    }

    public static void setPreferredScreen(NewGameScreen preferredScreen0) {
        if (preferredScreen == preferredScreen0) {
            return;
        }
        preferredScreen = preferredScreen0;
        String prefName = preferredScreen.name();
        if (NewGameScreen.Adventure.equals((Object)preferredScreen)) {
            prefName = NewGameScreen.Constructed.name();
        }
        prefs.setPref(ForgePreferences.FPref.NEW_GAME_SCREEN, prefName);
        prefs.save();
    }

    public static NewGameMenu getMenu() {
        return menu;
    }

    private NewGameMenu() {
    }

    @Override
    protected void buildMenu() {
        FScreen currentScreen = Forge.getCurrentScreen();
        for (NewGameScreen ngs : NewGameScreen.values()) {
            this.addItem(ngs.item);
            ngs.item.setSelected(currentScreen == ngs.screen);
        }
    }

    static {
        block2: {
            prefs = FModel.getPreferences();
            menu = new NewGameMenu();
            try {
                preferredScreen = NewGameScreen.valueOf(prefs.getPref(ForgePreferences.FPref.NEW_GAME_SCREEN));
            }
            catch (Exception ex) {
                if (NewGameScreen.Constructed == null) break block2;
                preferredScreen = NewGameScreen.Constructed;
                prefs.setPref(ForgePreferences.FPref.NEW_GAME_SCREEN, preferredScreen.name());
                prefs.save();
            }
        }
    }

    public static enum NewGameScreen {
        Constructed(Forge.getLocalizer().getMessageorUseDefault("lblConstructed", "Constructed", new Object[0]), FSkinImage.MENU_CONSTRUCTED, ConstructedScreen.class),
        BoosterDraft(Forge.getLocalizer().getMessageorUseDefault("lblBoosterDraft", "Booster Draft", new Object[0]), FSkinImage.MENU_DRAFT, NewDraftScreen.class),
        SealedDeck(Forge.getLocalizer().getMessageorUseDefault("lblSealedDeck", "Sealed Deck", new Object[0]), FSkinImage.MENU_SEALED, NewSealedScreen.class),
        QuestMode(Forge.getLocalizer().getMessageorUseDefault("lblQuestMode", "Quest Mode", new Object[0]), FSkinImage.QUEST_ZEP, NewQuestScreen.class),
        PuzzleMode(Forge.getLocalizer().getMessageorUseDefault("lblPuzzleMode", "Puzzle Mode", new Object[0]), FSkinImage.MENU_PUZZLE, PuzzleScreen.class),
        PlanarConquest(Forge.getLocalizer().getMessageorUseDefault("lblPlanarConquest", "Planar Conquest", new Object[0]), FSkinImage.MENU_GALAXY, NewConquestScreen.class),
        Gauntlet(Forge.getLocalizer().getMessageorUseDefault("lblGauntlet", "Gauntlet", new Object[0]), FSkinImage.MENU_GAUNTLET, NewGauntletScreen.class),
        Adventure(Forge.getLocalizer().getMessageorUseDefault("lblAdventureMode", "Adventure Mode", new Object[0]), FSkinImage.MENU_ADVLOGO, AdventureScreen.class);

        private final FMenuItem item;
        private final Class<? extends FScreen> screenClass;
        private FScreen screen;

        private NewGameScreen(String caption0, FImage icon0, Class<? extends FScreen> screenClass0) {
            this.screenClass = screenClass0;
            this.item = new FMenuItem(caption0, icon0, e -> {
                this.open(true);
                NewGameMenu.setPreferredScreen(this);
            });
        }

        private void initializeScreen() {
            if (this.screen == null) {
                try {
                    this.screen = this.screenClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.screen.setHeaderCaption(Forge.getLocalizer().getMessageorUseDefault("lblNewGame", "New Game", new Object[0]) + " - " + this.item.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }

        public void open() {
            this.open(false);
        }

        private void open(boolean replaceBackScreen) {
            this.initializeScreen();
            if (this.screen != null) {
                Forge.openScreen(this.screen, replaceBackScreen);
            }
        }

        public void setAsBackScreen(boolean replace) {
            this.initializeScreen();
            Forge.setBackScreen(this.screen, replace);
        }
    }
}

