/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkinImage;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.gauntlet.LoadGauntletScreen;
import forge.screens.limited.LoadDraftScreen;
import forge.screens.limited.LoadSealedScreen;
import forge.screens.planarconquest.LoadConquestScreen;
import forge.screens.quest.LoadQuestScreen;

public class LoadGameMenu
extends FPopupMenu {
    private static final ForgePreferences prefs = FModel.getPreferences();
    private static final LoadGameMenu menu = new LoadGameMenu();
    private static LoadGameScreen preferredScreen;

    public static LoadGameScreen getPreferredScreen() {
        return preferredScreen;
    }

    public static void setPreferredScreen(LoadGameScreen preferredScreen0) {
        if (preferredScreen == preferredScreen0) {
            return;
        }
        preferredScreen = preferredScreen0;
        prefs.setPref(ForgePreferences.FPref.LOAD_GAME_SCREEN, preferredScreen.name());
        prefs.save();
    }

    public static LoadGameMenu getMenu() {
        return menu;
    }

    private LoadGameMenu() {
    }

    @Override
    protected void buildMenu() {
        FScreen currentScreen = Forge.getCurrentScreen();
        for (LoadGameScreen lgs : LoadGameScreen.values()) {
            this.addItem(lgs.item);
            lgs.item.setSelected(currentScreen == lgs.screen);
        }
    }

    static {
        try {
            preferredScreen = LoadGameScreen.valueOf(prefs.getPref(ForgePreferences.FPref.LOAD_GAME_SCREEN));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            preferredScreen = LoadGameScreen.BoosterDraft;
            prefs.setPref(ForgePreferences.FPref.LOAD_GAME_SCREEN, preferredScreen.name());
            prefs.save();
        }
    }

    public static enum LoadGameScreen {
        BoosterDraft("lblBoosterDraft", FSkinImage.MENU_DRAFT, LoadDraftScreen.class),
        SealedDeck("lblSealedDeck", FSkinImage.MENU_SEALED, LoadSealedScreen.class),
        QuestMode("lblQuestMode", FSkinImage.QUEST_ZEP, LoadQuestScreen.class),
        PlanarConquest("lblPlanarConquest", FSkinImage.MENU_GALAXY, LoadConquestScreen.class),
        Gauntlet("lblGauntlet", FSkinImage.MENU_GAUNTLET, LoadGauntletScreen.class);

        private final FMenuItem item;
        private final Class<? extends FScreen> screenClass;
        private FScreen screen;

        private LoadGameScreen(String caption0, FImage icon0, Class<? extends FScreen> screenClass0) {
            this.screenClass = screenClass0;
            this.item = new FMenuItem(Forge.getLocalizer().getMessage(caption0, new Object[0]), icon0, e -> {
                this.open(true);
                LoadGameMenu.setPreferredScreen(this);
            });
        }

        private void initializeScreen() {
            if (this.screen == null) {
                try {
                    this.screen = this.screenClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.screen.setHeaderCaption(Forge.getLocalizer().getMessage("lblLoadGame", new Object[0]) + " - " + this.item.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }

        public void open() {
            this.open(false);
        }

        private void open(boolean replaceBackScreen) {
            this.initializeScreen();
            if (this.screen != null) {
                Forge.openScreen(this.screen, replaceBackScreen);
            }
        }

        public void setAsBackScreen(boolean replace) {
            this.initializeScreen();
            Forge.setBackScreen(this.screen, replace);
        }
    }
}

