/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home;

import com.badlogic.gdx.Gdx;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinImage;
import forge.deck.FDeckChooser;
import forge.game.GameType;
import forge.gui.FThreads;
import forge.screens.FScreen;
import forge.screens.achievements.AchievementsScreen;
import forge.screens.home.LoadGameMenu;
import forge.screens.home.NewGameMenu;
import forge.screens.online.OnlineMenu;
import forge.screens.planarconquest.ConquestMenu;
import forge.screens.quest.QuestMenu;
import forge.screens.settings.SettingsScreen;
import forge.toolbox.FButton;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class HomeScreen
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private static final FSkinColor clrTheme = FSkinColor.get(FSkinColor.Colors.CLR_THEME);
    private static final FSkinColor l00 = clrTheme.stepColor(0);
    private static final FSkinColor d80 = clrTheme.stepColor(-80);
    public static final float MAIN_MENU_WIDTH_FACTOR = 0.35f;
    public static final HomeScreen instance = new HomeScreen();
    private final FLabel lblLogo = this.add(new FLabel.Builder().icon(new FImage(){
        final float size = (float)Forge.getScreenWidth() * 0.6f;

        @Override
        public float getWidth() {
            return this.size;
        }

        @Override
        public float getHeight() {
            return this.size;
        }

        @Override
        public void draw(Graphics g2, float x, float y, float w, float h2) {
            if (FSkin.getLogo() == null) {
                FSkinImage.LOGO.draw(g2, x, y, w, h2);
            } else {
                g2.drawImage(FSkin.getLogo(), x, y, w, h2);
            }
        }
    }).iconInBackground().iconScaleFactor(1.0f).build());
    private final ButtonScroller buttonScroller = this.add(new ButtonScroller());
    private final List<MenuButton> buttons = new ArrayList<MenuButton>();
    private int activeButtonIndex;
    private int baseButtonCount;
    private FDeckChooser deckManager;
    private boolean QuestCommander = false;
    private String QuestWorld = "";

    private HomeScreen() {
        super((FScreen.Header)null);
        this.addButton(Forge.getLocalizer().getMessage("lblNewGame", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 0;
            NewGameMenu.getPreferredScreen().open();
        });
        this.addButton(Forge.getLocalizer().getMessage("lblLoadGame", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 1;
            LoadGameMenu.getPreferredScreen().open();
        });
        this.addButton(Forge.getLocalizer().getMessage("lblPlayOnline", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 2;
            OnlineMenu.OnlineScreen.Lobby.open();
        });
        this.addButton(Forge.getLocalizer().getMessage("lblDeckManager", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 3;
            if (this.deckManager == null) {
                this.deckManager = new FDeckChooser(GameType.DeckManager, false, null){

                    @Override
                    protected float doLandscapeLayout(float width, float height) {
                        this.getHeader().setBounds(0.0f, 0.0f, 0.0f, 0.0f);
                        this.doLayout(0.0f, width, height);
                        return 0.0f;
                    }
                };
                this.deckManager.setHeaderCaption(Forge.getLocalizer().getMessage("lblDeckManager", new Object[0]));
            }
            Forge.openScreen(this.deckManager);
        });
        this.addButton(Forge.getLocalizer().getMessage("lblAchievements", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 4;
            AchievementsScreen.show();
        });
        this.addButton(Forge.getLocalizer().getMessage("lblSettings", new Object[0]), e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = 5;
            SettingsScreen.show(true);
        });
        this.addButton(Forge.getLocalizer().getMessage("lblHelp", new Object[0]), e -> FThreads.invokeInEdtLater(() -> {
            try {
                if (Forge.getDeviceAdapter().isConnectedToInternet()) {
                    FOptionPane.showOptionDialog("Join Discord option will open the invite link to join Forge Discord server. Forge Support option will open the Forge Support Channel.", "Choose option", FOptionPane.INFORMATION_ICON, ImmutableList.of("Join Discord", "Forge Support"), -1, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            switch (result) {
                                case 0: {
                                    Gdx.net.openURI("https://discord.gg/3v9JCVr");
                                    break;
                                }
                                case 1: {
                                    Gdx.net.openURI("https://discord.com/channels/267367946135928833/692000787856883752");
                                    break;
                                }
                            }
                        }
                    });
                } else {
                    FOptionPane.showErrorDialog("Internet Connection required to open Forge Discord server", "No Internet");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }));
        this.baseButtonCount = this.buttons.size();
    }

    private void addButton(String caption, FEvent.FEventHandler command) {
        this.buttons.add(this.buttonScroller.add(new MenuButton(caption, command)));
    }

    public void updateQuestCommanderMode(boolean isCommander) {
        this.QuestCommander = isCommander;
    }

    public void updateQuestWorld(String questWorld) {
        this.QuestWorld = questWorld;
    }

    public void openMenu(int index) {
        if (index < 0) {
            return;
        }
        if (index == 2) {
            OnlineMenu.OnlineScreen.Lobby.open();
        } else if (index < 6) {
            NewGameMenu.getPreferredScreen().open();
        } else if (index == 6) {
            QuestMenu.launchQuestMode(QuestMenu.LaunchReason.StartQuestMode, instance.getQuestCommanderMode());
        } else if (index == 7) {
            ConquestMenu.launchPlanarConquest(ConquestMenu.LaunchReason.StartPlanarConquest);
        }
    }

    public boolean getQuestCommanderMode() {
        return this.QuestCommander;
    }

    public int getActiveButtonIndex() {
        return this.activeButtonIndex;
    }

    public String getQuestWorld() {
        return this.QuestWorld;
    }

    public void addButtonForMode(String caption, FEvent.FEventHandler command) {
        int index;
        for (int i = this.baseButtonCount; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getText().equals(caption)) continue;
            int index2 = i;
            this.buttons.get(i).setCommand(e -> {
                Forge.lastButtonIndex = this.activeButtonIndex = index2;
                command.handleEvent(e);
            });
            this.activeButtonIndex = i;
            return;
        }
        this.activeButtonIndex = index = this.buttons.size();
        this.addButton(caption, e -> {
            Forge.lastButtonIndex = this.activeButtonIndex = index;
            command.handleEvent(e);
        });
        this.revalidate();
        this.buttonScroller.scrollIntoView(this.buttons.get(index));
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float buttonWidth = width - 2.0f * PADDING;
        float buttonHeight = this.buttons.get(0).getFont().getCapHeight() * 3.5f;
        float x = PADDING;
        float dy = buttonHeight + PADDING;
        float y = height - (float)this.buttons.size() * dy;
        this.buttonScroller.buttonHeight = buttonHeight;
        this.buttonScroller.padding = HomeScreen.PADDING;
        this.buttonScroller.setBounds(x, y, buttonWidth, height - y);
        float logoSize = y - 2.0f * PADDING;
        y = PADDING;
        if (logoSize > buttonWidth) {
            y += (logoSize - buttonWidth) / 2.0f;
            logoSize = buttonWidth;
        }
        x = (width - logoSize) / 2.0f;
        this.lblLogo.setBounds(x, y, logoSize, logoSize);
    }

    @Override
    protected float doLandscapeLayout(float width, float height) {
        float mainMenuWidth = height * 0.35f;
        float logoSize = mainMenuWidth - 2.0f * PADDING;
        this.lblLogo.setBounds(PADDING, PADDING, logoSize, logoSize);
        float x = 2.0f * PADDING;
        float y = this.lblLogo.getBottom() + PADDING;
        float buttonWidth = mainMenuWidth - x;
        float buttonHeight = Utils.AVG_FINGER_HEIGHT * 0.9f;
        this.buttonScroller.buttonHeight = buttonHeight;
        this.buttonScroller.padding = 0.0f;
        this.buttonScroller.setBounds(x, y, buttonWidth, height - y);
        return width - mainMenuWidth;
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        float w = this.getWidth();
        float h2 = this.getHeight();
        if (w > h2) {
            w = h2 * 0.35f;
            float y1 = 0.0f;
            float h1 = h2;
            float y2 = 0.0f;
            float h22 = 0.0f;
            if (this.activeButtonIndex != -1) {
                MenuButton activeButton = this.buttons.get(this.activeButtonIndex);
                h1 = this.buttonScroller.getTop() + activeButton.getTop();
                y2 = h1 + activeButton.getHeight();
                h22 = h2 - y2;
                float scrollerTop = this.buttonScroller.getTop();
                if (y2 < scrollerTop) {
                    h1 = h2;
                    y2 = 0.0f;
                    h22 = 0.0f;
                } else if (h1 < scrollerTop) {
                    h1 = scrollerTop;
                }
            }
            float w1 = w * 0.66f;
            float w2 = w - w1;
            g2.fillRect(l00, 0.0f, y1, w1, h1);
            if (h22 > 0.0f) {
                g2.fillRect(l00, 0.0f, y2, w1, h22);
            }
            g2.fillGradientRect(l00, d80, false, w1, y1, w2, h1);
            if (h22 > 0.0f) {
                g2.fillGradientRect(l00, d80, false, w1, y2, w2, h22);
            }
        }
    }

    private class MenuButton
    extends FButton {
        public MenuButton(String caption, FEvent.FEventHandler command) {
            super(caption, command);
        }

        @Override
        public void draw(Graphics g2) {
            if (Forge.isLandscapeMode()) {
                g2.drawText(this.getText(), this.isHovered() && this.getFont().canIncrease() ? this.getFont().increase() : this.getFont(), this.getForeColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), false, 8, true);
            } else {
                super.draw(g2);
            }
        }
    }

    private class ButtonScroller
    extends FScrollPane {
        private float buttonHeight;
        private float padding;

        private ButtonScroller() {
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            float y = 0.0f;
            float dy = this.buttonHeight + this.padding;
            for (MenuButton button : HomeScreen.this.buttons) {
                button.setBounds(0.0f, y, visibleWidth, this.buttonHeight);
                y += dy;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y - this.padding);
        }
    }
}

