/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.constructed;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.util.Callback;
import forge.util.MyRandom;
import forge.util.Utils;
import java.util.List;
import java.util.Map;

public class AvatarSelector
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private static final int COLUMNS = 5;
    private final int currentIndex;
    private final List<Integer> usedAvatars;
    private final Callback<Integer> callback;
    private final FScrollPane scroller = new FScrollPane(){

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            int rowCount = 0;
            float x = PADDING;
            float y = PADDING;
            float labelSize = (visibleWidth - 6.0f * PADDING) / 5.0f;
            for (FDisplayObject lbl : AvatarSelector.this.scroller.getChildren()) {
                if (rowCount == 5) {
                    x = PADDING;
                    y += labelSize + PADDING;
                    rowCount = 0;
                }
                lbl.setBounds(x, y, labelSize, labelSize);
                x += labelSize + PADDING;
                ++rowCount;
            }
            return new FScrollPane.ScrollBounds(visibleWidth, y + labelSize + PADDING);
        }
    };

    public static int getRandomAvatar(List<Integer> usedAvatars) {
        int random = 0;
        while (usedAvatars.contains(random = MyRandom.getRandom().nextInt(FSkin.getAvatars().size()))) {
        }
        return random;
    }

    public static void show(String playerName, int currentIndex0, List<Integer> usedAvatars0, Callback<Integer> callback0) {
        AvatarSelector selector = new AvatarSelector(playerName, currentIndex0, usedAvatars0, callback0);
        Forge.openScreen(selector);
    }

    private AvatarSelector(String playerName, int currentIndex0, List<Integer> usedAvatars0, Callback<Integer> callback0) {
        super(Forge.getLocalizer().getMessage("lblSelectAvatarFor", new Object[0]).replace("%s", playerName));
        this.currentIndex = currentIndex0;
        this.usedAvatars = usedAvatars0;
        this.callback = callback0;
        this.addAvatarLabel(FSkinImage.UNKNOWN, -1);
        Map<Integer, TextureRegion> avatarMap = FSkin.getAvatars();
        this.addAvatarLabel(new FTextureRegionImage(avatarMap.get(this.currentIndex)), this.currentIndex);
        for (Integer i : avatarMap.keySet()) {
            if (this.currentIndex == i) continue;
            this.addAvatarLabel(new FTextureRegionImage(avatarMap.get(i)), i);
        }
        this.add(this.scroller);
    }

    private void addAvatarLabel(FImage img, int index) {
        FLabel lbl = new FLabel.Builder().icon(img).iconScaleFactor(0.95f).align(1).iconInBackground(true).selectable(true).selected(this.currentIndex == index).build();
        if (index == -1) {
            lbl.setCommand(e -> {
                this.callback.run(AvatarSelector.getRandomAvatar(this.usedAvatars));
                Forge.back();
            });
        } else {
            lbl.setCommand(e -> {
                this.callback.run(index);
                Forge.back();
            });
        }
        this.scroller.add(lbl);
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        this.scroller.setBounds(0.0f, startY, width, height - startY);
    }
}

