/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.toolbox.FButton;
import forge.toolbox.FContainer;
import forge.toolbox.FProgressBar;

public class SplashScreen
extends FContainer {
    private TextureRegion splashTexture;
    private Texture splashBGTexture;
    private FProgressBar progressBar = this.getProgressBar();
    private FSkinFont disclaimerFont;
    private boolean preparedForDialogs;
    private boolean showModeSelector;
    private boolean init;
    private boolean animateLogo;
    private boolean hideBG;
    private boolean hideBtn;
    private boolean startClassic;
    private boolean clear;
    private FButton btnAdventure;
    private FButton btnHome;
    private BGAnimation bgAnimation = this.getBgAnimation();

    public BGAnimation getBgAnimation() {
        if (this.bgAnimation == null) {
            this.bgAnimation = new BGAnimation();
        }
        return this.bgAnimation;
    }

    public FProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new FProgressBar();
            this.progressBar.setDescription("Welcome to Forge");
        }
        return this.progressBar;
    }

    public void setSplashTexture(TextureRegion textureRegion) {
        this.splashTexture = textureRegion;
    }

    public void setSplashBGTexture(Texture texture) {
        this.splashBGTexture = texture;
    }

    public void startClassic() {
        this.startClassic = true;
        this.hideBtn = true;
        this.hideBG = true;
        this.bgAnimation.DURATION = 1.0f;
        this.bgAnimation.progress = 0.0f;
        this.bgAnimation.openAdventure = false;
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    public void prepareForDialogs() {
        if (this.preparedForDialogs) {
            return;
        }
        Color defaultColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        block5: for (FSkinColor.Colors c : FSkinColor.Colors.values()) {
            switch (c) {
                case CLR_BORDERS: 
                case CLR_TEXT: {
                    c.setColor(FProgressBar.SEL_FORE_COLOR);
                    continue block5;
                }
                case CLR_ACTIVE: 
                case CLR_THEME2: {
                    c.setColor(FProgressBar.SEL_BACK_COLOR);
                    continue block5;
                }
                case CLR_INACTIVE: {
                    c.setColor(FSkinColor.stepColor(FProgressBar.SEL_BACK_COLOR, -80));
                    continue block5;
                }
                default: {
                    c.setColor(defaultColor);
                }
            }
        }
        FSkinColor.updateAll();
        this.preparedForDialogs = true;
    }

    public void setShowModeSelector(boolean value) {
        this.showModeSelector = value;
    }

    public boolean isShowModeSelector() {
        return this.showModeSelector;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        this.bgAnimation.start();
        if (!Forge.selector.equalsIgnoreCase("Adventure")) {
            this.bgAnimation.drawBackground(g2);
        } else {
            this.bgAnimation.drawAdventureBackground(g2);
        }
    }

    void drawTransition(Graphics g2, boolean openAdventure, float percentage) {
        Texture t2 = Forge.getAssets().fallback_skins().get("title");
        TextureRegion tr = null;
        if (t2 != null) {
            tr = new TextureRegion(t2);
        }
        float oldAlpha = g2.getfloatAlphaComposite();
        g2.setAlphaComposite(percentage);
        if (openAdventure) {
            if (tr != null) {
                g2.drawGrayTransitionImage(tr, 0.0f, 0.0f, this.getWidth(), this.getHeight(), false, percentage * 1.0f);
            }
        } else {
            g2.fillRect(FSkinColor.get(FSkinColor.Colors.CLR_THEME), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        g2.setAlphaComposite(oldAlpha);
    }

    private void showSelector(Graphics g2, float alpha) {
        float y;
        float h2;
        float w;
        float x;
        if (this.splashTexture == null) {
            return;
        }
        g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
        g2.drawImage(FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        float backgroundRatio = (float)this.splashTexture.getRegionWidth() / (float)this.splashTexture.getRegionHeight();
        float screenRatio = this.getWidth() / this.getHeight();
        if (backgroundRatio > screenRatio) {
            x = 0.0f;
            w = this.getWidth();
            h2 = this.getWidth() * backgroundRatio;
            y = (this.getHeight() - h2) / 2.0f;
        } else {
            y = 0.0f;
            h2 = this.getHeight();
            w = this.getHeight() / backgroundRatio;
            x = (this.getWidth() - w) / 2.0f;
        }
        if (FSkin.getLogo() != null) {
            float xmod = Forge.getScreenHeight() > 1000 ? 1.5f : (Forge.getScreenHeight() > 800 ? 1.3f : 1.0f);
            g2.drawImage(FSkin.getLogo(), this.getWidth() / 2.0f - (float)FSkin.getLogo().getWidth() * xmod / 2.0f, this.getHeight() / 2.0f - (float)FSkin.getLogo().getHeight() * xmod / 1.5f, (float)FSkin.getLogo().getWidth() * xmod, (float)FSkin.getLogo().getHeight() * xmod);
        } else {
            g2.drawImage(this.splashTexture, x, y, w, h2);
        }
        y += h2 * 295.0f / 450.0f;
        float padding = 0.044444446f * w;
        float height = 0.12666667f * h2;
        if (!this.init) {
            this.init = true;
            this.btnAdventure = new FButton(Forge.getLocalizer().getMessageorUseDefault("lblAdventureMode", "Adventure Mode", new Object[0]));
            this.btnHome = new FButton(Forge.getLocalizer().getMessageorUseDefault("lblClassicMode", "Classic Mode", new Object[0]));
            this.btnAdventure.setCommand(e -> {
                if (FSkin.getLogo() == null) {
                    this.hideBG = true;
                    this.hideBtn = true;
                    this.bgAnimation.progress = 0.0f;
                    this.bgAnimation.openAdventure = true;
                } else {
                    this.hideBtn = true;
                    this.animateLogo = true;
                    this.bgAnimation.progress = 0.0f;
                    this.bgAnimation.openAdventure = true;
                }
            });
            this.btnHome.setCommand(e -> {
                if (FSkin.getLogo() == null) {
                    this.hideBG = true;
                    this.hideBtn = true;
                    this.bgAnimation.progress = 0.0f;
                    this.bgAnimation.openAdventure = false;
                } else {
                    this.hideBtn = true;
                    this.animateLogo = true;
                    this.bgAnimation.progress = 0.0f;
                    this.bgAnimation.openAdventure = false;
                }
            });
            float btn_w = w - 2.0f * padding;
            float btn_x = x + padding;
            float multiplier = Forge.isLandscapeMode() ? 1.0f : 1.2f;
            float btn_y = (y + padding) * multiplier;
            this.btnHome.setFont(FSkinFont.get(22));
            this.btnAdventure.setFont(FSkinFont.get(22));
            this.btnHome.setBounds(btn_x, btn_y, btn_w, height);
            this.add(this.btnHome);
            this.btnAdventure.setBounds(btn_x, btn_y + height + padding / 2.0f, btn_w, height);
            this.add(this.btnAdventure);
        }
    }

    private void showSplash(Graphics g2, float alpha) {
        float oldAlpha = g2.getfloatAlphaComposite();
        g2.setAlphaComposite(alpha);
        this.drawDisclaimer(g2);
        g2.setAlphaComposite(oldAlpha);
    }

    void drawDisclaimer(Graphics g2) {
        float y;
        float h2;
        float w;
        float x;
        if (this.splashTexture == null) {
            return;
        }
        g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
        g2.drawImage(FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        float backgroundRatio = (float)this.splashTexture.getRegionWidth() / (float)this.splashTexture.getRegionHeight();
        float screenRatio = this.getWidth() / this.getHeight();
        if (backgroundRatio > screenRatio) {
            x = 0.0f;
            w = this.getWidth();
            h2 = this.getWidth() * backgroundRatio;
            y = (this.getHeight() - h2) / 2.0f;
        } else {
            y = 0.0f;
            h2 = this.getHeight();
            w = this.getHeight() / backgroundRatio;
            x = (this.getWidth() - w) / 2.0f;
        }
        g2.drawImage(this.splashTexture, x, y, w, h2);
        y += h2 * 295.0f / 450.0f;
        if (this.disclaimerFont == null) {
            this.disclaimerFont = FSkinFont.get(9);
        }
        float disclaimerHeight = 0.06666667f * h2;
        String disclaimer = "Forge is not affiliated in any way with Wizards of the Coast.\nForge is open source software, released under the GNU General Public License.";
        if (Forge.forcedEnglishonCJKMissing && !this.clear) {
            this.clear = true;
            FSkinFont.preloadAll("");
            this.disclaimerFont = FSkinFont.get(9);
        }
        g2.drawText(disclaimer, this.disclaimerFont, FProgressBar.SEL_FORE_COLOR, x, y, w, disclaimerHeight, true, 1, true);
        float padding = 0.044444446f * w;
        float pbHeight = 0.12666667f * h2;
        this.progressBar.setBounds(x + padding, y += 0.17333333f * h2, w - 2.0f * padding, pbHeight);
        g2.draw(this.progressBar);
        String version = "v. 1.6.65-SNAPSHOT";
        g2.drawText(version, this.disclaimerFont, FProgressBar.SEL_FORE_COLOR, x, this.getHeight() - disclaimerHeight, w, disclaimerHeight, false, 1, true);
    }

    private class BGAnimation
    extends ForgeAnimation {
        float DURATION = 0.8f;
        private float progress = 0.0f;
        private boolean finished;
        private boolean openAdventure;

        private BGAnimation() {
        }

        private void drawAdventureBackground(Graphics g2) {
            float y;
            float h2;
            float w;
            float x;
            if (SplashScreen.this.splashTexture == null) {
                return;
            }
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            g2.fillRect(Color.BLACK, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight());
            g2.setAlphaComposite(percentage);
            g2.drawRepeatingImage(SplashScreen.this.splashBGTexture, 0.0f, 0.0f, Forge.getScreenWidth(), Forge.getScreenHeight());
            g2.setAlphaComposite(oldAlpha);
            float backgroundRatio = (float)SplashScreen.this.splashTexture.getRegionWidth() / (float)SplashScreen.this.splashTexture.getRegionHeight();
            float screenRatio = SplashScreen.this.getWidth() / SplashScreen.this.getHeight();
            if (backgroundRatio > screenRatio) {
                x = 0.0f;
                w = SplashScreen.this.getWidth();
                h2 = SplashScreen.this.getWidth() * backgroundRatio;
                y = (SplashScreen.this.getHeight() - h2) / 2.0f;
            } else {
                y = 0.0f;
                h2 = SplashScreen.this.getHeight();
                w = SplashScreen.this.getHeight() / backgroundRatio;
                x = (SplashScreen.this.getWidth() - w) / 2.0f;
            }
            float hmod = Forge.isLandscapeMode() ? 1.0f : 1.3f;
            float ymod = 2.6f;
            g2.drawImage(SplashScreen.this.splashTexture, (float)(Forge.getScreenWidth() / 2) - w * percentage * hmod / 2.0f, (float)(Forge.getScreenHeight() / 2) - h2 * percentage * hmod / ymod, w * percentage * hmod, h2 * percentage * hmod);
            y += h2 * 295.0f / 450.0f;
            if (SplashScreen.this.disclaimerFont == null) {
                SplashScreen.this.disclaimerFont = FSkinFont.get(9);
            }
            float disclaimerHeight = 0.06666667f * h2;
            if (Forge.forcedEnglishonCJKMissing && !SplashScreen.this.clear) {
                SplashScreen.this.clear = true;
                FSkinFont.preloadAll("");
                SplashScreen.this.disclaimerFont = FSkinFont.get(9);
            }
            float padding = 0.044444446f * w;
            float pbHeight = 0.12666667f * h2;
            y += 0.17333333f * h2;
            float w2 = Forge.isLandscapeMode() ? (float)(Forge.getScreenWidth() / 2) : (float)(Forge.getScreenHeight() / 2);
            float h22 = 0.12666667f * (w2 / 2.0f);
            String version = "v. 1.6.65-SNAPSHOT";
            g2.drawText(version, SplashScreen.this.disclaimerFont, FProgressBar.SEL_FORE_COLOR, x, SplashScreen.this.getHeight() - disclaimerHeight, w, disclaimerHeight, false, 1, true);
            SplashScreen.this.progressBar.setBounds(((float)Forge.getScreenWidth() - w2) / 2.0f, (float)Forge.getScreenHeight() - h22 * 2.0f, w2, h22);
            g2.draw(SplashScreen.this.progressBar);
        }

        public void drawBackground(Graphics g2) {
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (SplashScreen.this.startClassic) {
                SplashScreen.this.showSplash(g2, 1.0f - percentage);
            } else if (SplashScreen.this.animateLogo) {
                SplashScreen.this.drawTransition(g2, this.openAdventure, percentage);
                g2.setAlphaComposite(1.0f - percentage);
                g2.drawImage(FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, SplashScreen.this.getWidth(), SplashScreen.this.getHeight());
                g2.setAlphaComposite(oldAlpha);
                g2.setAlphaComposite(oldAlpha - percentage);
                float xmod = Forge.getScreenHeight() > 1000 ? 1.5f : (Forge.getScreenHeight() > 800 ? 1.3f : 1.0f);
                g2.drawImage(FSkin.getLogo(), SplashScreen.this.getWidth() / 2.0f - (float)FSkin.getLogo().getWidth() * (xmod += 10.0f * percentage) / 2.0f, SplashScreen.this.getHeight() / 2.0f - (float)FSkin.getLogo().getHeight() * xmod / 1.5f, (float)FSkin.getLogo().getWidth() * xmod, (float)FSkin.getLogo().getHeight() * xmod);
                g2.setAlphaComposite(oldAlpha);
            } else {
                g2.setAlphaComposite(SplashScreen.this.hideBG ? 1.0f - percentage : 1.0f);
                if (SplashScreen.this.showModeSelector) {
                    SplashScreen.this.showSelector(g2, SplashScreen.this.hideBG ? 1.0f - percentage : 1.0f);
                } else {
                    SplashScreen.this.showSplash(g2, 1.0f);
                }
                g2.setAlphaComposite(oldAlpha);
                if (SplashScreen.this.hideBG) {
                    g2.setAlphaComposite(0.0f + percentage);
                    SplashScreen.this.drawTransition(g2, this.openAdventure, percentage);
                    g2.setAlphaComposite(oldAlpha);
                }
            }
            if (SplashScreen.this.hideBtn) {
                float y;
                if (SplashScreen.this.btnAdventure != null) {
                    y = SplashScreen.this.btnAdventure.getTop();
                    SplashScreen.this.btnAdventure.setTop(y + SplashScreen.this.getHeight() / 16.0f * percentage);
                }
                if (SplashScreen.this.btnHome != null) {
                    y = SplashScreen.this.btnHome.getTop();
                    SplashScreen.this.btnHome.setTop(y + SplashScreen.this.getHeight() / 16.0f * percentage);
                }
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            if (SplashScreen.this.animateLogo || SplashScreen.this.hideBG) {
                if (this.openAdventure) {
                    Forge.openAdventure();
                } else {
                    Forge.openHomeDefault();
                }
                Forge.clearSplashScreen();
            }
        }
    }
}

