/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gui.FThreads;
import forge.screens.FScreen;
import forge.toolbox.FOverlay;
import forge.util.ThreadUtil;
import forge.util.Utils;

public class LoadingOverlay
extends FOverlay {
    private static final float INSETS = Utils.scale(10.0f);
    private static final float LOGO_SIZE_FACTOR = 0.7f;
    private static final float INSETS_FACTOR = 0.025f;
    private static final FSkinFont FONT = FSkinFont.get(22);
    private BGAnimation bgAnimation;
    private Runnable runnable;
    private boolean afterMatch;
    private boolean alternate;
    private String caption;
    private boolean textMode = false;
    private boolean match = false;
    private TextureRegion textureRegion;

    private static FSkinColor getOverlayColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE).alphaColor(0.75f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE).alphaColor(0.75f);
    }

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public static void show(String caption0, Runnable runnable) {
        LoadingOverlay.show(caption0, false, runnable);
    }

    public static void show(String caption0, boolean textMode, Runnable runnable) {
        LoadingOverlay loader = new LoadingOverlay(caption0, textMode);
        loader.show();
        ThreadUtil.invokeInGameThread(() -> FThreads.invokeInEdtLater(() -> {
            runnable.run();
            loader.hide();
            loader.finishedloading();
        }));
    }

    public static void runBackgroundTask(String caption0, Runnable task) {
        LoadingOverlay loader = new LoadingOverlay(caption0, true);
        loader.show();
        FThreads.invokeInBackgroundThread(() -> {
            task.run();
            FThreads.invokeInEdtLater(loader::hide);
        });
    }

    public LoadingOverlay(String caption0, boolean textOnly) {
        this.caption = caption0;
        this.textMode = textOnly;
    }

    public LoadingOverlay(Runnable runnable) {
        this(runnable, false, false);
    }

    public LoadingOverlay(Runnable toRun, boolean aftermatch, boolean otherTransition) {
        this.caption = "";
        this.textMode = true;
        this.textureRegion = Forge.takeScreenshot();
        this.match = true;
        this.bgAnimation = new BGAnimation();
        this.runnable = toRun;
        this.afterMatch = aftermatch;
        this.alternate = otherTransition;
    }

    public void setCaption(String caption0) {
        this.caption = caption0;
    }

    @Override
    public boolean isVisibleOnScreen(FScreen screen) {
        return true;
    }

    @Override
    protected void doLayout(float width, float height) {
    }

    @Override
    public void drawOverlay(Graphics g2) {
        if (this.match && this.bgAnimation != null) {
            this.bgAnimation.start();
            this.bgAnimation.drawBackground(g2);
            return;
        }
        if (!this.textMode) {
            float x = INSETS;
            float panelWidth = this.getWidth() - 2.0f * INSETS;
            if (Forge.isLandscapeMode()) {
                panelWidth = this.getHeight() - 2.0f * INSETS;
                x = (this.getWidth() - panelWidth) / 2.0f;
            }
            float padding = panelWidth * 0.025f;
            float logoSize = panelWidth * 0.7f;
            float fontHeight = FONT.getCapHeight();
            float panelHeight = logoSize + fontHeight + 4.0f * padding;
            float y = (this.getHeight() - panelHeight) / 2.0f;
            float oldAlpha = g2.getfloatAlphaComposite();
            g2.fillRect(FSkinColor.getStandardColor(Color.BLACK).alphaColor(0.6f), 0.0f, 0.0f, this.getWidth(), this.getHeight());
            g2.fillRect(LoadingOverlay.getOverlayColor(), x, y, panelWidth, panelHeight);
            g2.drawRect(Utils.scale(2.0f), LoadingOverlay.getForeColor(), x, y, panelWidth, panelHeight);
            y += padding;
            if (FSkin.getLogo() == null) {
                g2.drawImage(FSkinImage.LOGO, (this.getWidth() - logoSize) / 2.0f, y, logoSize, logoSize);
            } else {
                g2.drawImage(FSkin.getLogo(), (this.getWidth() - logoSize) / 2.0f, y, logoSize, logoSize);
            }
            g2.drawText(this.caption, FONT, LoadingOverlay.getForeColor(), x, y += logoSize + padding, panelWidth, this.getHeight(), false, 1, false);
        } else {
            g2.drawText(this.caption, FONT, LoadingOverlay.getForeColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), true, 1, true);
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (this.match) {
            return true;
        }
        return super.keyDown(keyCode);
    }

    private class BGAnimation
    extends ForgeAnimation {
        float DURATION;
        private float progress;

        private BGAnimation() {
            this.DURATION = LoadingOverlay.this.afterMatch ? 0.8f : 1.3f;
            this.progress = 0.0f;
        }

        public void drawBackground(Graphics g2) {
            float percentage = this.progress / this.DURATION;
            float oldAlpha = g2.getfloatAlphaComposite();
            if (percentage < 0.0f) {
                percentage = 0.0f;
            } else if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (LoadingOverlay.this.afterMatch) {
                g2.drawGrayTransitionImage(LoadingOverlay.this.textureRegion, 0.0f, 0.0f, (float)Forge.getScreenWidth(), (float)Forge.getScreenHeight(), false, percentage);
            } else if (LoadingOverlay.this.alternate) {
                g2.drawPortalFade(LoadingOverlay.this.textureRegion, 0.0f, 0.0f, Forge.getScreenWidth(), Forge.getScreenHeight(), Float.valueOf(percentage > 0.8f ? 0.8f : percentage), LoadingOverlay.this.afterMatch);
            } else {
                g2.drawNoiseFade(LoadingOverlay.this.textureRegion, 0.0f, 0.0f, Forge.getScreenWidth(), Forge.getScreenHeight(), Float.valueOf(percentage));
            }
        }

        @Override
        protected boolean advance(float dt) {
            this.progress += dt;
            return this.progress < this.DURATION;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            LoadingOverlay.this.match = false;
            LoadingOverlay.this.hide();
            if (LoadingOverlay.this.runnable != null) {
                LoadingOverlay.this.runnable.run();
            }
        }
    }
}

