/*
 * Decompiled with CFR 0.152.
 */
package forge.screens;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinImage;
import forge.menu.FPopupMenu;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FOptionPane;
import forge.util.Utils;

public abstract class LaunchScreen
extends FScreen {
    private static final float MAX_START_BUTTON_HEIGHT = 1.75f * Utils.AVG_FINGER_HEIGHT;
    private float START_BUTTON_RATIO = 0.0f;
    private static final float PADDING = FOptionPane.PADDING;
    protected final StartButton btnStart = this.add(new StartButton());

    public LaunchScreen(String headerCaption) {
        super(headerCaption);
    }

    public LaunchScreen(String headerCaption, FPopupMenu menu) {
        super(headerCaption, menu);
    }

    @Override
    protected final void doLayout(float startY, float width, float height) {
        this.START_BUTTON_RATIO = Forge.hdstart ? FSkinImage.HDBTN_START_UP.getWidth() / FSkinImage.HDBTN_START_UP.getHeight() : FSkinImage.BTN_START_UP.getWidth() / FSkinImage.BTN_START_UP.getHeight();
        float buttonWidth = width - 2.0f * PADDING;
        float buttonHeight = buttonWidth / this.START_BUTTON_RATIO;
        if (buttonHeight > MAX_START_BUTTON_HEIGHT) {
            buttonHeight = MAX_START_BUTTON_HEIGHT;
            buttonWidth = buttonHeight * this.START_BUTTON_RATIO;
        }
        this.btnStart.setBounds((width - buttonWidth) / 2.0f, height - buttonHeight - PADDING, buttonWidth, buttonHeight);
        this.doLayoutAboveBtnStart(startY, width, height - buttonHeight - 2.0f * PADDING);
    }

    protected abstract void doLayoutAboveBtnStart(float var1, float var2, float var3);

    protected abstract void startMatch();

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 62: 
            case 66: {
                this.startMatch();
                return true;
            }
        }
        return super.keyDown(keyCode);
    }

    protected class StartButton
    extends FDisplayObject {
        private boolean pressed;

        @Override
        public final boolean press(float x, float y) {
            this.pressed = true;
            return true;
        }

        @Override
        public final boolean release(float x, float y) {
            this.pressed = false;
            return true;
        }

        @Override
        public final boolean tap(float x, float y, int count) {
            if (count == 1) {
                LaunchScreen.this.btnStart.setEnabled(false);
                LaunchScreen.this.startMatch();
            }
            return true;
        }

        @Override
        public void draw(Graphics g2) {
            if (Forge.hdstart) {
                g2.drawImage(this.pressed ? FSkinImage.HDBTN_START_DOWN : (this.isHovered() ? FSkinImage.HDBTN_START_OVER : FSkinImage.HDBTN_START_UP), this.isHovered() ? -2.0f : 0.0f, 0.0f, this.getWidth(), this.getHeight());
            } else {
                g2.drawImage(this.pressed ? FSkinImage.BTN_START_DOWN : (this.isHovered() ? FSkinImage.BTN_START_OVER : FSkinImage.BTN_START_UP), 0.0f, 0.0f, this.getWidth(), this.getHeight());
            }
            if (!Forge.isLoadingaMatch() && !LaunchScreen.this.btnStart.isEnabled()) {
                LaunchScreen.this.btnStart.setEnabled(true);
            }
        }
    }
}

