/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.game.GameEntityViewMap;
import forge.game.GameObject;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardUtil;
import forge.game.card.CardView;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.StackItemView;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.input.InputSelectTargets;
import forge.player.PlayerControllerHuman;
import forge.player.PlayerZoneUpdates;
import forge.util.Aggregates;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TargetSelection {
    private final PlayerControllerHuman controller;
    private final SpellAbility ability;
    private boolean bTargetingDone = false;

    public TargetSelection(PlayerControllerHuman controller, SpellAbility currentAbility) {
        this.controller = controller;
        this.ability = currentAbility;
    }

    private TargetRestrictions getTgt() {
        return this.ability.getTargetRestrictions();
    }

    private boolean isMandatory() {
        return this.ability.isTrigger() || this.getTgt().getMandatory();
    }

    public final boolean chooseTargets(Integer numTargets, Collection<Integer> divisionValues, Predicate<GameObject> filter, boolean optional, boolean canFilterMustTarget) {
        boolean choiceResult;
        boolean hasEnoughCandidates;
        boolean mandatory;
        boolean hasAllTargets;
        if (!this.ability.usesTargeting()) {
            throw new RuntimeException("TargetSelection.chooseTargets called for ability that does not target - " + this.ability);
        }
        TargetRestrictions tgt = this.getTgt();
        int minTargets = numTargets != null ? numTargets.intValue() : this.ability.getMinTargets();
        int maxTargets = numTargets != null ? numTargets.intValue() : this.ability.getMaxTargets();
        int numTargeted = this.ability.getTargets().size();
        boolean isSingleZone = tgt.isSingleZone();
        boolean hasEnoughTargets = minTargets == 0 || numTargeted >= minTargets;
        boolean bl = hasAllTargets = numTargeted == maxTargets && maxTargets > 0;
        if (maxTargets == 0 && minTargets == 0) {
            return true;
        }
        if (this.bTargetingDone && !hasEnoughTargets) {
            return false;
        }
        if (this.bTargetingDone && hasEnoughTargets || hasAllTargets || this.ability.isDividedAsYouChoose() && divisionValues == null && this.ability.getStillToDivide() == 0) {
            return true;
        }
        List<ZoneType> zones = tgt.getZone();
        boolean bl2 = mandatory = this.isMandatory() && !optional;
        if (zones.size() == 1 && zones.get(0) == ZoneType.Stack) {
            return this.chooseCardFromStack(mandatory, numTargets);
        }
        List<GameEntity> candidates = tgt.getAllCandidates(this.ability, true);
        boolean bl3 = hasEnoughCandidates = candidates.size() >= minTargets;
        if (tgt.isDifferentControllers() || tgt.isForEachPlayer()) {
            PlayerCollection controllers = new PlayerCollection();
            Iterables.filter(candidates, Card.class).forEach(c -> controllers.add(c.getController()));
            hasEnoughCandidates &= controllers.size() >= minTargets;
        }
        mandatory &= hasEnoughCandidates;
        if (!hasEnoughCandidates && !hasEnoughTargets) {
            return false;
        }
        if (this.isMandatory() && candidates.isEmpty() && hasEnoughTargets) {
            return true;
        }
        if (tgt.isRandomTarget() && numTargets == null) {
            ArrayList<GameEntity> choices = new ArrayList<GameEntity>();
            int top = Math.min(candidates.size(), maxTargets);
            int bot = minTargets > 0 ? minTargets : 1;
            int num = tgt.isRandomNumTargets() ? Aggregates.randomInt(bot, top) : minTargets;
            for (int i = 0; i < num; ++i) {
                GameEntity choice = Aggregates.random(candidates);
                if (choice == null) continue;
                choices.add(choice);
                candidates.remove(choice);
            }
            return this.ability.getTargets().addAll(choices);
        }
        CardCollection validTargets = CardUtil.getValidCardsToTarget(this.ability);
        boolean mustTargetFiltered = false;
        if (canFilterMustTarget) {
            mustTargetFiltered = StaticAbilityMustTarget.filterMustTargetCards(this.controller.getPlayer(), validTargets, this.ability);
        }
        if (filter != null) {
            validTargets = new CardCollection((Iterable<Card>)Iterables.filter(validTargets, filter));
        }
        if (isSingleZone) {
            ArrayList<Card> removeCandidates = new ArrayList<Card>();
            Card firstTgt = this.ability.getTargetCard();
            if (firstTgt != null) {
                for (Card t2 : validTargets) {
                    if (t2.getController().equals(firstTgt.getController())) continue;
                    removeCandidates.add(t2);
                }
                validTargets.removeAll((Collection<?>)removeCandidates);
            }
        }
        if (validTargets.isEmpty()) {
            if (mustTargetFiltered) {
                return false;
            }
            if (minTargets != 0) {
                List<GameEntity> nonCardTargets = tgt.getAllCandidates(this.ability, true, true);
                if (nonCardTargets.size() == 1) {
                    return this.ability.getTargets().add(nonCardTargets.get(0));
                }
                if (nonCardTargets.isEmpty()) {
                    return false;
                }
            }
        } else if (validTargets.size() == 1 && minTargets != 0 && this.ability.isTrigger() && !tgt.canTgtPlayer()) {
            if (this.ability.isDividedAsYouChoose()) {
                this.ability.addDividedAllocation((GameObject)validTargets.get(0), this.ability.getStillToDivide());
            }
            return this.ability.getTargets().add((GameObject)validTargets.get(0));
        }
        HashMap<PlayerView, Object> playersWithValidTargets = Maps.newHashMap();
        for (Card card : validTargets) {
            playersWithValidTargets.put(PlayerView.get(card.getController()), null);
        }
        PlayerView playerView = this.controller.getLocalPlayerView();
        PlayerZoneUpdates playerZoneUpdates = this.controller.getGui().openZones(playerView, zones, playersWithValidTargets, true);
        if (!zones.contains((Object)ZoneType.Stack)) {
            InputSelectTargets inp = new InputSelectTargets(this.controller, validTargets, this.ability, mandatory, numTargets, divisionValues, filter, mustTargetFiltered);
            inp.showAndWait();
            choiceResult = !inp.hasCancelled();
            this.bTargetingDone = inp.hasPressedOk();
            this.controller.getGui().restoreOldZones(playerView, playerZoneUpdates);
        } else {
            choiceResult = this.chooseCardFromList(validTargets, true, mandatory);
        }
        return choiceResult && this.chooseTargets(numTargets, divisionValues, filter, optional, canFilterMustTarget);
    }

    private boolean chooseCardFromList(List<Card> choices, boolean targeted, boolean mandatory) {
        Game game = this.ability.getActivatingPlayer().getGame();
        GameEntityViewMap gameCacheChooseCard = GameEntityView.getMap(choices);
        ArrayList<CardView> crdsBattle = Lists.newArrayList();
        ArrayList<CardView> crdsExile = Lists.newArrayList();
        ArrayList<CardView> crdsGrave = Lists.newArrayList();
        ArrayList<CardView> crdsLibrary = Lists.newArrayList();
        ArrayList<CardView> crdsStack = Lists.newArrayList();
        ArrayList<CardView> crdsAnte = Lists.newArrayList();
        for (Card inZone : choices) {
            Card firstTgt;
            Zone zz = game.getZoneOf(inZone);
            CardView cardView = CardView.get(inZone);
            if (this.getTgt() != null && this.getTgt().isWithSameCreatureType() && (firstTgt = this.ability.getTargetCard()) != null && !firstTgt.sharesCreatureTypeWith(inZone)) continue;
            if (zz.is(ZoneType.Battlefield)) {
                crdsBattle.add(cardView);
                continue;
            }
            if (zz.is(ZoneType.Exile)) {
                crdsExile.add(cardView);
                continue;
            }
            if (zz.is(ZoneType.Graveyard)) {
                crdsGrave.add(cardView);
                continue;
            }
            if (zz.is(ZoneType.Library)) {
                crdsLibrary.add(cardView);
                continue;
            }
            if (zz.is(ZoneType.Stack)) {
                crdsStack.add(cardView);
                continue;
            }
            if (!zz.is(ZoneType.Ante)) continue;
            crdsAnte.add(cardView);
        }
        ArrayList<Object> choicesFiltered = new ArrayList<Object>();
        if (!crdsBattle.isEmpty()) {
            choicesFiltered.add("--CARDS ON BATTLEFIELD:--");
            choicesFiltered.addAll(crdsBattle);
        }
        if (!crdsExile.isEmpty()) {
            choicesFiltered.add("--CARDS IN EXILE:--");
            choicesFiltered.addAll(crdsExile);
        }
        if (!crdsGrave.isEmpty()) {
            choicesFiltered.add("--CARDS IN GRAVEYARD:--");
            choicesFiltered.addAll(crdsGrave);
        }
        if (!crdsLibrary.isEmpty()) {
            choicesFiltered.add("--CARDS IN LIBRARY:--");
            choicesFiltered.addAll(crdsLibrary);
        }
        if (!crdsStack.isEmpty()) {
            choicesFiltered.add("--CARDS IN STACK:--");
            choicesFiltered.addAll(crdsStack);
        }
        if (!crdsAnte.isEmpty()) {
            choicesFiltered.add("--CARDS IN ANTE:--");
            choicesFiltered.addAll(crdsAnte);
        }
        String msgDone = "[FINISH TARGETING]";
        if (this.ability.isMinTargetChosen()) {
            choicesFiltered.add("[FINISH TARGETING]");
        }
        Object chosen = null;
        String message = TextUtil.fastReplace(this.getTgt().getVTSelection(), "CARDNAME", this.ability.getHostCard().toString());
        chosen = !choices.isEmpty() && mandatory ? this.controller.getGui().one(message, choicesFiltered) : this.controller.getGui().oneOrNone(message, choicesFiltered);
        if (chosen == null) {
            return false;
        }
        if ("[FINISH TARGETING]".equals(chosen)) {
            this.bTargetingDone = true;
            return true;
        }
        if (chosen instanceof CardView) {
            if (!gameCacheChooseCard.containsKey(chosen)) {
                return false;
            }
            if (((CardView)chosen).getZone().equals((Object)ZoneType.Stack)) {
                for (SpellAbilityStackInstance si : game.getStack()) {
                    SpellAbility abilityOnStack = si.getSpellAbility();
                    if (!abilityOnStack.isSpell() || !abilityOnStack.getHostCard().getView().equals(chosen)) continue;
                    this.ability.getTargets().add(abilityOnStack);
                    break;
                }
            } else {
                this.ability.getTargets().add((GameObject)gameCacheChooseCard.get(chosen));
            }
        }
        return true;
    }

    private boolean chooseCardFromStack(boolean mandatory, Integer numTargets) {
        TargetRestrictions tgt = this.getTgt();
        String message = TextUtil.fastReplace(tgt.getVTSelection(), "CARDNAME", this.ability.getHostCard().toString());
        ArrayList<Object> selectOptions = new ArrayList<Object>();
        HashMap<StackItemView, SpellAbilityStackInstance> stackItemViewCache = new HashMap<StackItemView, SpellAbilityStackInstance>();
        Game game = this.ability.getActivatingPlayer().getGame();
        for (SpellAbilityStackInstance si : game.getStack()) {
            SpellAbility abilityOnStack = si.getSpellAbility();
            if (!this.ability.canTargetSpellAbility(abilityOnStack)) continue;
            stackItemViewCache.put(si.getView(), si);
            selectOptions.add(si.getView());
        }
        while (!this.bTargetingDone) {
            Object madeChoice;
            if (this.ability.isMaxTargetChosen() || numTargets != null && this.ability.getTargets().size() == numTargets.intValue()) {
                this.bTargetingDone = true;
                return true;
            }
            if (!selectOptions.contains("[FINISH TARGETING]") && this.ability.isMinTargetChosen() && (numTargets == null || this.ability.getTargets().size() == numTargets.intValue())) {
                selectOptions.add("[FINISH TARGETING]");
            }
            if (selectOptions.isEmpty()) {
                return false;
            }
            Object e = madeChoice = mandatory ? this.controller.getGui().one(message, selectOptions) : this.controller.getGui().oneOrNone(message, selectOptions);
            if (madeChoice == null) {
                return false;
            }
            if (madeChoice instanceof StackItemView) {
                this.ability.getTargets().add(((SpellAbilityStackInstance)stackItemViewCache.get(madeChoice)).getSpellAbility());
                continue;
            }
            this.bTargetingDone = true;
        }
        return true;
    }
}

