/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.collect.Lists;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.game.player.actions.FinishTargetingAction;
import forge.game.player.actions.PassPriorityAction;
import forge.game.player.actions.PayManaFromPoolAction;
import forge.game.player.actions.PlayerAction;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputPassPriority;
import forge.gamemodes.match.input.InputPayMana;
import forge.gamemodes.match.input.InputSelectTargets;
import forge.interfaces.IMacroSystem;
import forge.player.PlayerControllerHuman;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import java.util.List;

public class RecordActionsMacroSystem
implements IMacroSystem {
    private final PlayerControllerHuman playerControllerHuman;
    private final Localizer localizer = Localizer.getInstance();
    private final List<PlayerAction> actions = Lists.newArrayList();
    private final List<PlayerAction> playbackActions = Lists.newArrayList();
    private boolean recording = false;

    public RecordActionsMacroSystem(PlayerControllerHuman playerControllerHuman) {
        this.playerControllerHuman = playerControllerHuman;
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public String playbackText() {
        if (this.playbackActions.isEmpty()) {
            return null;
        }
        return this.actions.size() - this.playbackActions.size() + " / " + this.actions.size();
    }

    public boolean startRecording() {
        if (this.recording) {
            return false;
        }
        this.recording = true;
        this.actions.clear();
        this.playbackActions.clear();
        this.playerControllerHuman.getInputQueue().updateObservers();
        return true;
    }

    public boolean finishRecording() {
        if (!this.recording) {
            return false;
        }
        this.recording = false;
        this.playerControllerHuman.getInputQueue().updateObservers();
        return true;
    }

    @Override
    public void addRememberedAction(PlayerAction action) {
        if (!this.recording) {
            return;
        }
        this.actions.add(action);
        this.playbackActions.add(action);
    }

    @Override
    public void setRememberedActions() {
        if (this.recording) {
            this.finishRecording();
        } else {
            this.startRecording();
        }
    }

    public void runFullMacro() {
        if (this.actions.isEmpty() || this.recording) {
            return;
        }
        if (this.playbackActions.isEmpty()) {
            this.playbackActions.addAll(this.actions);
        } else if (this.actions.size() != this.playbackActions.size()) {
            return;
        }
        while (!this.playbackActions.isEmpty()) {
            this.runFirstAction();
        }
    }

    @Override
    public void nextRememberedAction() {
        if (this.actions.isEmpty()) {
            return;
        }
        if (this.recording) {
            System.out.println("Make sure macros are finished recording before running them...");
            return;
        }
        if (this.playbackActions.isEmpty()) {
            this.playbackActions.addAll(this.actions);
            System.out.println("Finished macro loop. Restarting at the beginning...");
        }
        this.runFirstAction();
    }

    private void runFirstAction() {
        PlayerAction action = this.playbackActions.remove(0);
        this.processAction(action);
    }

    public void processAction(PlayerAction action) {
        Input inp = this.playerControllerHuman.getInputProxy().getInput();
        if (action instanceof PassPriorityAction) {
            if (inp instanceof InputPassPriority) {
                inp.selectButtonOK();
            }
        } else if (action instanceof FinishTargetingAction) {
            if (inp instanceof InputSelectTargets) {
                inp.selectButtonOK();
            }
        } else if (action instanceof PayManaFromPoolAction) {
            if (inp instanceof InputPayMana) {
                ((InputPayMana)inp).useManaFromPool(((PayManaFromPoolAction)action).getSelectedColor());
            }
        } else {
            GameEntityView gev = action.getGameEntityView();
            if (gev instanceof CardView) {
                this.playerControllerHuman.selectCard((CardView)gev, null, new DummyTriggerEvent());
            } else if (gev instanceof PlayerView) {
                this.playerControllerHuman.selectPlayer((PlayerView)gev, null);
            }
        }
    }

    private class DummyTriggerEvent
    implements ITriggerEvent {
        private DummyTriggerEvent() {
        }

        @Override
        public int getButton() {
            return 1;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }
    }
}

