/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import forge.LobbyPlayer;
import forge.StaticData;
import forge.ai.GameState;
import forge.ai.PlayerControllerAi;
import forge.card.CardDb;
import forge.card.CardSplitType;
import forge.card.CardStateName;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckRecognizer;
import forge.deck.DeckSection;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.game.GameEntityViewMap;
import forge.game.GameLogEntryType;
import forge.game.GameObject;
import forge.game.GameType;
import forge.game.PlanarDice;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFaceView;
import forge.game.card.CardLists;
import forge.game.card.CardPlayOption;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardUtil;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.card.token.TokenInfo;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.DelayedReveal;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.player.PlayerView;
import forge.game.player.actions.SelectCardAction;
import forge.game.player.actions.SelectPlayerAction;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementEffectView;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.SpellAbilityView;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityView;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.MagicStack;
import forge.game.zone.PlayerZone;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.NextGameDecision;
import forge.gamemodes.match.input.Input;
import forge.gamemodes.match.input.InputAttack;
import forge.gamemodes.match.input.InputBlock;
import forge.gamemodes.match.input.InputChooseStartingHand;
import forge.gamemodes.match.input.InputConfirm;
import forge.gamemodes.match.input.InputConfirmMulligan;
import forge.gamemodes.match.input.InputLondonMulligan;
import forge.gamemodes.match.input.InputPassPriority;
import forge.gamemodes.match.input.InputPayMana;
import forge.gamemodes.match.input.InputPayManaOfCostPayment;
import forge.gamemodes.match.input.InputProxy;
import forge.gamemodes.match.input.InputQueue;
import forge.gamemodes.match.input.InputSelectCardsForConvokeOrImprovise;
import forge.gamemodes.match.input.InputSelectCardsFromList;
import forge.gamemodes.match.input.InputSelectEntitiesFromList;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.events.UiEventNextGameDecision;
import forge.gui.interfaces.IGuiGame;
import forge.gui.util.SOptionPane;
import forge.interfaces.IDevModeCheats;
import forge.interfaces.IGameController;
import forge.interfaces.IMacroSystem;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.player.HumanPlay;
import forge.player.RecordActionsMacroSystem;
import forge.player.TargetSelection;
import forge.trackable.TrackableCollection;
import forge.util.CardTranslation;
import forge.util.DeckAIUtils;
import forge.util.ITriggerEvent;
import forge.util.ImageUtil;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MessageUtil;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import io.sentry.Sentry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerControllerHuman
extends PlayerController
implements IGameController {
    private boolean mayLookAtAllCards = false;
    private boolean disableAutoYields = false;
    private boolean fullControl = false;
    private IGuiGame gui;
    protected final InputQueue inputQueue;
    protected final InputProxy inputProxy;
    private final Localizer localizer = Localizer.getInstance();
    protected Map<SpellAbilityView, SpellAbility> spellViewCache = null;
    private final ArrayList<Card> tempShownCards = new ArrayList();
    private final Map<String, List<Integer>> orderedSALookup = Maps.newHashMap();
    private boolean canPlayUnlimitedLands;
    private IDevModeCheats cheats;
    private IMacroSystem macros;

    public PlayerControllerHuman(Game game0, Player p, LobbyPlayer lp) {
        super(game0, p, lp);
        this.inputProxy = new InputProxy(this);
        this.inputQueue = new InputQueue(game0.getView(), this.inputProxy);
    }

    public PlayerControllerHuman(Player p, LobbyPlayer lp, PlayerControllerHuman owner) {
        super(owner.getGame(), p, lp);
        this.gui = owner.gui;
        this.inputProxy = owner.inputProxy;
        this.inputQueue = owner.getInputQueue();
    }

    public final IGuiGame getGui() {
        return this.gui;
    }

    public final void setGui(IGuiGame gui) {
        this.gui = gui;
    }

    public final InputQueue getInputQueue() {
        return this.inputQueue;
    }

    public InputProxy getInputProxy() {
        return this.inputProxy;
    }

    public PlayerView getLocalPlayerView() {
        return this.player == null ? null : this.player.getView();
    }

    public boolean getDisableAutoYields() {
        return this.disableAutoYields;
    }

    public void setDisableAutoYields(boolean disableAutoYields0) {
        this.disableAutoYields = disableAutoYields0;
    }

    @Override
    public boolean mayLookAtAllCards() {
        return this.mayLookAtAllCards;
    }

    public void setMayLookAtAllCards(boolean mayLookAtAllCards) {
        this.mayLookAtAllCards = mayLookAtAllCards;
    }

    public <T> void tempShow(Iterable<T> objects) {
        for (T t2 : objects) {
            if (t2 instanceof Card) {
                this.tempShowCard((Card)t2);
                continue;
            }
            if (!(t2 instanceof CardView)) continue;
            this.tempShowCard(this.getCard((CardView)t2));
        }
    }

    private void tempShowCard(Card c) {
        if (c == null) {
            return;
        }
        this.tempShownCards.add(c);
        c.addMayLookTemp(this.player);
    }

    @Override
    public void tempShowCards(Iterable<Card> cards) {
        for (Card c : cards) {
            this.tempShowCard(c);
        }
    }

    @Override
    public void endTempShowCards() {
        if (this.tempShownCards.isEmpty()) {
            return;
        }
        for (Card c : this.tempShownCards) {
            c.removeMayLookTemp(this.player);
        }
        this.tempShownCards.clear();
    }

    @Override
    public boolean isFullControl() {
        return this.fullControl;
    }

    @Override
    public void setFullControl(boolean full) {
        this.fullControl = full;
    }

    @Override
    public SpellAbility getAbilityToPlay(Card hostCard, List<SpellAbility> abilities, ITriggerEvent triggerEvent) {
        if (!(triggerEvent == null || hostCard.isInPlay() || hostCard.getOwner().equals(this.player) || hostCard.getController().equals(this.player) || this.player.hasKeyword("Shaman's Trance") && hostCard.isInZone(ZoneType.Graveyard))) {
            boolean noPermission = true;
            for (CardPlayOption o : hostCard.mayPlay(this.player)) {
                if (!o.grantsZonePermissions()) continue;
                noPermission = false;
                break;
            }
            for (SpellAbility sa : hostCard.getAllSpellAbilities()) {
                if (!sa.hasParam("Activator") || !this.player.isValid(sa.getParam("Activator"), hostCard.getController(), hostCard, (CardTraitBase)sa)) continue;
                noPermission = false;
                break;
            }
            if (noPermission) {
                return null;
            }
        }
        this.spellViewCache = SpellAbilityView.getMap(abilities);
        SpellAbilityView resultView = this.getGui().getAbilityToPlay(CardView.get(hostCard), Lists.newArrayList(this.spellViewCache.keySet()), triggerEvent);
        return resultView == null ? null : this.spellViewCache.get(resultView);
    }

    @Override
    public void playSpellAbilityForFree(SpellAbility copySA, boolean mayChoseNewTargets) {
        HumanPlay.playSaWithoutPayingManaCost(this, this.player.getGame(), copySA, mayChoseNewTargets);
    }

    @Override
    public void playSpellAbilityNoStack(SpellAbility effectSA, boolean canSetupTargets) {
        HumanPlay.playSpellAbilityNoStack(this, this.player, effectSA, !canSetupTargets);
    }

    @Override
    public List<PaperCard> sideboard(Deck deck, GameType gameType, String message) {
        CardPool sideboard = deck.get(DeckSection.Sideboard);
        if (sideboard == null) {
            sideboard = new CardPool();
        }
        CardPool main = deck.get(DeckSection.Main);
        int mainSize = main.countAll();
        int sbSize = sideboard.countAll();
        int combinedDeckSize = mainSize + sbSize;
        int deckMinSize = Math.min(mainSize, gameType.getDeckFormat().getMainRange().getMinimum());
        Range<Integer> sbRange = gameType.getDeckFormat().getSideRange();
        int sbMax = sbRange == null ? combinedDeckSize : sbRange.getMaximum();
        List<PaperCard> newMain = null;
        if (sbSize == 0 && mainSize == deckMinSize) {
            return null;
        }
        boolean conform = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY);
        do {
            if (newMain != null) {
                String errMsg = newMain.size() < deckMinSize ? TextUtil.concatNoSpace(this.localizer.getMessage("lblTooFewCardsMainDeck", String.valueOf(deckMinSize))) : TextUtil.concatNoSpace(this.localizer.getMessage("lblTooManyCardsSideboard", String.valueOf(sbMax)));
                this.getGui().showErrorDialog(errMsg, this.localizer.getMessage("lblInvalidDeck", new Object[0]));
            }
            List<PaperCard> resp = this.getGui().sideboard(sideboard, main, message);
            newMain = ObjectUtils.defaultIfNull(resp, main.toFlatList());
        } while (conform && (newMain.size() < deckMinSize || combinedDeckSize - newMain.size() > sbMax));
        return newMain;
    }

    @Override
    public Map<Card, Integer> assignCombatDamage(Card attacker, CardCollectionView blockers, CardCollectionView remaining, int damageDealt, GameEntity defender, boolean overrideOrder) {
        HashMap<Card, Integer> map = Maps.newHashMap();
        if (attacker.hasKeyword(Keyword.TRAMPLE) && defender != null || blockers.size() > 1 || attacker.hasKeyword("You may assign CARDNAME's combat damage divided as you choose among defending player and/or any number of creatures they control.") && overrideOrder && blockers.size() > 0 || attacker.hasKeyword("Trample:Planeswalker") && defender instanceof Card) {
            Map<CardView, Integer> result;
            GameEntityViewMap gameCacheBlockers = GameEntityView.getMap(blockers);
            CardView vAttacker = CardView.get(attacker);
            GameEntityView vDefender = GameEntityView.get(defender);
            boolean maySkip = false;
            if (remaining != null && remaining.size() > 1 && attacker.isAttacking()) {
                maySkip = true;
            }
            if ((result = this.getGui().assignCombatDamage(vAttacker, gameCacheBlockers.getTrackableKeys(), damageDealt, vDefender, overrideOrder, maySkip)) == null) {
                return null;
            }
            for (Map.Entry<CardView, Integer> e : result.entrySet()) {
                if (gameCacheBlockers.containsKey(e.getKey())) {
                    map.put((Card)gameCacheBlockers.get(e.getKey()), e.getValue());
                    continue;
                }
                if (e.getKey() != null && e.getKey().getId() != -1) continue;
                map.put(null, e.getValue());
            }
        } else {
            map.put(blockers.isEmpty() ? null : (Card)blockers.get(false), damageDealt);
        }
        return map;
    }

    @Override
    public Map<GameEntity, Integer> divideShield(Card effectSource, Map<GameEntity, Integer> affected, int shieldAmount) {
        CardView vSource = CardView.get(effectSource);
        HashMap<Object, Integer> vAffected = new HashMap<Object, Integer>(affected.size());
        for (Map.Entry<GameEntity, Integer> e : affected.entrySet()) {
            vAffected.put(GameEntityView.get(e.getKey()), e.getValue());
        }
        Map<Object, Integer> vResult = this.getGui().assignGenericAmount(vSource, vAffected, shieldAmount, false, this.localizer.getMessage("lblShield", new Object[0]));
        HashMap<GameEntity, Integer> result = new HashMap<GameEntity, Integer>();
        if (vResult != null) {
            for (Map.Entry<GameEntity, Integer> e : affected.entrySet()) {
                if (!vResult.containsKey(GameEntityView.get(e.getKey()))) continue;
                result.put(e.getKey(), vResult.get(GameEntityView.get(e.getKey())));
            }
        }
        return result;
    }

    @Override
    public Map<Byte, Integer> specifyManaCombo(SpellAbility sa, ColorSet colorSet, int manaAmount, boolean different) {
        CardView vSource = CardView.get(sa.getHostCard());
        LinkedHashMap<Object, Integer> vAffected = new LinkedHashMap<Object, Integer>(manaAmount);
        Integer maxAmount = different ? 1 : manaAmount;
        for (Byte color : colorSet) {
            vAffected.put(color, maxAmount);
        }
        Map<Object, Integer> vResult = this.getGui().assignGenericAmount(vSource, vAffected, manaAmount, false, this.localizer.getMessage("lblMana", new Object[0]).toLowerCase());
        HashMap<Byte, Integer> result = new HashMap<Byte, Integer>();
        if (vResult != null) {
            for (Byte color : colorSet) {
                if (!vResult.containsKey(color)) continue;
                result.put(color, vResult.get(color));
            }
        }
        return result;
    }

    @Override
    public Integer announceRequirements(SpellAbility ability, String announce) {
        String announceTitle;
        Card host = ability.getHostCard();
        int max = Integer.MAX_VALUE;
        int xMin = 0;
        boolean abXMin = ability.hasParam("XMin");
        Cost cost = ability.getPayCosts();
        if ("X".equals(announce)) {
            if (abXMin) {
                xMin = Integer.parseInt(ability.getParam("XMin"));
            }
            if (ability.hasParam("XMaxLimit")) {
                max = Math.min(max, AbilityUtils.calculateAmount(host, ability.getParam("XMaxLimit"), ability));
            }
            if (cost != null) {
                Integer costX = cost.getMaxForNonManaX(ability, this.player, false);
                if (costX != null) {
                    max = Math.min(max, costX);
                }
                if (cost.hasManaCost() && !abXMin) {
                    xMin = cost.getCostMana().getXMin();
                }
            }
        }
        int min2 = xMin;
        if (ability.hasParam("AnnounceMax")) {
            max = Math.min(max, AbilityUtils.calculateAmount(host, ability.getParam("AnnounceMax"), ability));
        }
        if (ability.usesTargeting() && announce.equals(ability.getTargetRestrictions().getMinTargets())) {
            max = Math.min(max, CardUtil.getValidCardsToTarget(ability).size());
        }
        if (min2 > max) {
            return null;
        }
        String string = announceTitle = "X".equals(announce) ? ability.getParamOrDefault("XAnnounceTitle", announce) : ability.getParamOrDefault("AnnounceTitle", announce);
        if (cost.isMandatory()) {
            return this.chooseNumber(ability, this.localizer.getMessage("lblChooseAnnounceForCard", announceTitle, CardTranslation.getTranslatedName(host.getName())), min2, max);
        }
        if ("NumTimes".equals(announce)) {
            return this.getGui().getInteger(this.localizer.getMessage("lblHowManyTimesToPay", ability.getPayCosts().getTotalMana(), CardTranslation.getTranslatedName(host.getName())), min2, max, min2 + 9);
        }
        return this.getGui().getInteger(this.localizer.getMessage("lblChooseAnnounceForCard", announceTitle, CardTranslation.getTranslatedName(host.getName())), min2, max, min2 + 9);
    }

    @Override
    public CardCollectionView choosePermanentsToSacrifice(SpellAbility sa, int min2, int max, CardCollectionView valid, String message) {
        return this.choosePermanentsTo(min2, max, valid, message, this.localizer.getMessage("lblSacrifice", new Object[0]).toLowerCase(), sa);
    }

    @Override
    public CardCollectionView choosePermanentsToDestroy(SpellAbility sa, int min2, int max, CardCollectionView valid, String message) {
        return this.choosePermanentsTo(min2, max, valid, message, this.localizer.getMessage("lblDestroy", new Object[0]), sa);
    }

    private CardCollectionView choosePermanentsTo(int min2, int max, CardCollectionView valid, String message, String action, SpellAbility sa) {
        if ((max = Math.min(max, valid.size())) <= 0) {
            return CardCollection.EMPTY;
        }
        String inpMessage = this.localizer.getMessage(min2 == 0 ? "lblSelectUpToNumTargetToAction" : "lblSelectNumTargetToAction", message, action);
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this, min2, max, valid, sa);
        inp.setMessage(inpMessage);
        inp.setCancelAllowed(min2 == 0);
        inp.showAndWait();
        return new CardCollection((Iterable<Card>)inp.getSelected());
    }

    private boolean useSelectCardsInput(FCollectionView<? extends GameEntity> sourceList, SpellAbility sa) {
        if (ApiType.Heist.equals((Object)sa.getApi())) {
            return false;
        }
        return this.useSelectCardsInput(sourceList);
    }

    private boolean useSelectCardsInput(FCollectionView<? extends GameEntity> sourceList) {
        if (FThreads.isGuiThread()) {
            return false;
        }
        for (GameEntity gameEntity : sourceList) {
            if (gameEntity instanceof Player) continue;
            if (!(gameEntity instanceof Card)) {
                return false;
            }
            Zone cz = ((Card)gameEntity).getZone();
            if (cz == null) {
                return false;
            }
            boolean useUiPointAtCard = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SELECT_FROM_CARD_DISPLAYS) && !GuiBase.getInterface().isLibgdxPort() ? cz.is(ZoneType.Battlefield) || cz.is(ZoneType.Hand) || cz.is(ZoneType.Library) || cz.is(ZoneType.Graveyard) || cz.is(ZoneType.Exile) || cz.is(ZoneType.Flashback) || cz.is(ZoneType.Command) || cz.is(ZoneType.Sideboard) : cz.is(ZoneType.Hand, this.player) || cz.is(ZoneType.Battlefield);
            if (useUiPointAtCard) continue;
            return false;
        }
        return true;
    }

    @Override
    public CardCollectionView chooseCardsForEffect(CardCollectionView sourceList, SpellAbility sa, String title, int min2, int max, boolean isOptional, Map<String, Object> params) {
        if (min2 == 1 && max == 1) {
            Card singleChosen = this.chooseSingleEntityForEffect(sourceList, sa, title, isOptional, params);
            return singleChosen == null ? CardCollection.EMPTY : new CardCollection(singleChosen);
        }
        CardCollection choices = new CardCollection();
        if (sourceList.isEmpty()) {
            return choices;
        }
        this.getGui().setPanelSelection(CardView.get(sa.getHostCard()));
        if (this.useSelectCardsInput(sourceList)) {
            this.tempShowCards(sourceList);
            InputSelectCardsFromList sc = new InputSelectCardsFromList(this, min2, max, sourceList, sa);
            sc.setMessage(title);
            sc.setCancelAllowed(isOptional);
            sc.showAndWait();
            this.endTempShowCards();
            return new CardCollection((Iterable<Card>)sc.getSelected());
        }
        this.tempShowCards(sourceList);
        GameEntityViewMap gameCachechoose = GameEntityView.getMap(sourceList);
        List views = this.getGui().many(title, this.localizer.getMessage("lblChosenCards", new Object[0]), min2, max, gameCachechoose.getTrackableKeys(), CardView.get(sa.getHostCard()));
        this.endTempShowCards();
        gameCachechoose.addToList(views, choices);
        return choices;
    }

    @Override
    public boolean helpPayForAssistSpell(ManaCostBeingPaid cost, SpellAbility sa, int max, int requested) {
        String title = String.format("%s trying to cast (%s) How much would you like to help pay for Assist? (Max: %s)", sa.getActivatingPlayer(), sa, max);
        int willPay = this.chooseNumber(sa, title, 0, max);
        if (willPay <= 0) {
            return true;
        }
        ManaCost manaCost = ManaCost.get(willPay);
        ManaCostBeingPaid assistCost = new ManaCostBeingPaid(manaCost);
        InputPayManaOfCostPayment inpPayment = new InputPayManaOfCostPayment(this, assistCost, sa, this.getPlayer(), null, true);
        inpPayment.setMessagePrefix("Paying for assist - ");
        inpPayment.showAndWait();
        if (inpPayment.isPaid()) {
            cost.decreaseGenericMana(willPay);
            return true;
        }
        if (sa.getHostCard().getGame().EXPERIMENTAL_RESTORE_SNAPSHOT) {
            return false;
        }
        System.out.println("Assist rollback may not work well without experimental restore snapshot enabled");
        return false;
    }

    @Override
    public Player choosePlayerToAssistPayment(FCollectionView<Player> optionList, SpellAbility sa, String title, int max) {
        return this.chooseSingleEntityForEffect(optionList, null, sa, title, true, null, null);
    }

    @Override
    public <T extends GameEntity> T chooseSingleEntityForEffect(FCollectionView<T> optionList, DelayedReveal delayedReveal, SpellAbility sa, String title, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        if (optionList.isEmpty()) {
            if (delayedReveal != null) {
                this.reveal(delayedReveal.getCards(), delayedReveal.getZone(), delayedReveal.getOwner(), delayedReveal.getMessagePrefix());
            }
            return null;
        }
        if (!isOptional && optionList.size() == 1) {
            if (delayedReveal != null) {
                this.reveal(delayedReveal.getCards(), delayedReveal.getZone(), delayedReveal.getOwner(), delayedReveal.getMessagePrefix());
            }
            return (T)((GameEntity)Iterables.getFirst(optionList, null));
        }
        this.tempShow(optionList);
        if (delayedReveal != null) {
            this.tempShow(delayedReveal.getCards());
        }
        if (this.useSelectCardsInput(optionList, sa)) {
            InputSelectEntitiesFromList<T> input = new InputSelectEntitiesFromList<T>(this, isOptional ? 0 : 1, 1, optionList, sa);
            input.setCancelAllowed(isOptional);
            input.setMessage(MessageUtil.formatMessage(title, this.player, (Object)targetedPlayer));
            input.showAndWait();
            this.endTempShowCards();
            return (T)((GameEntity)Iterables.getFirst(input.getSelected(), null));
        }
        GameEntityViewMap gameCacheChoose = GameEntityView.getMap(optionList);
        GameEntityView result = this.getGui().chooseSingleEntityForEffect(title, gameCacheChoose.getTrackableKeys(), delayedReveal, isOptional);
        this.endTempShowCards();
        if (result == null || !gameCacheChoose.containsKey(result)) {
            return null;
        }
        return (T)((GameEntity)gameCacheChoose.get(result));
    }

    @Override
    public <T extends GameEntity> List<T> chooseEntitiesForEffect(FCollectionView<T> optionList, int min2, int max, DelayedReveal delayedReveal, SpellAbility sa, String title, Player targetedPlayer, Map<String, Object> params) {
        Sentry.setExtra("Card", sa.getCardView().toString());
        Sentry.setExtra("SpellAbility", sa.toString());
        if (optionList.isEmpty()) {
            if (delayedReveal != null) {
                this.reveal(delayedReveal.getCards(), delayedReveal.getZone(), delayedReveal.getOwner(), delayedReveal.getMessagePrefix());
            }
            return Lists.newArrayList();
        }
        if (delayedReveal != null) {
            this.tempShow(delayedReveal.getCards());
        }
        this.tempShow(optionList);
        if (this.useSelectCardsInput(optionList)) {
            InputSelectEntitiesFromList<T> input = new InputSelectEntitiesFromList<T>(this, min2, max, optionList, sa);
            input.setCancelAllowed(min2 == 0);
            input.setMessage(MessageUtil.formatMessage(title, this.player, (Object)targetedPlayer));
            input.showAndWait();
            this.endTempShowCards();
            return (List)input.getSelected();
        }
        GameEntityViewMap gameCacheEntity = GameEntityView.getMap(optionList);
        List<GameEntityView> views = this.getGui().chooseEntitiesForEffect(title, gameCacheEntity.getTrackableKeys(), min2, max, delayedReveal);
        this.endTempShowCards();
        ArrayList results = Lists.newArrayList();
        if (views != null) {
            gameCacheEntity.addToList(views, results);
        }
        return results;
    }

    @Override
    public int chooseNumber(SpellAbility sa, String title, int min2, int max) {
        if (min2 >= max) {
            return min2;
        }
        if (max == Integer.MAX_VALUE) {
            Integer choice = this.getGui().getInteger(title, min2, max, 9);
            if (choice != null) {
                return choice;
            }
            return 0;
        }
        ImmutableList.Builder choices = ImmutableList.builder();
        int size = max - min2;
        for (int i = 0; i <= size; ++i) {
            choices.add((Object)(i + min2));
        }
        return (Integer)this.getGui().one(title, choices.build());
    }

    @Override
    public int chooseNumber(SpellAbility sa, String title, List<Integer> choices, Player relatedPlayer) {
        return this.getGui().one(title, choices);
    }

    @Override
    public SpellAbility chooseSingleSpellForEffect(List<SpellAbility> spells, SpellAbility sa, String title, Map<String, Object> params) {
        if (spells.size() < 2) {
            return Iterables.getFirst(spells, null);
        }
        this.getGui().setCard(CardView.get(sa.getHostCard()));
        Map<SpellAbilityView, SpellAbility> spellViewCache = SpellAbilityView.getMap(spells);
        SpellAbilityView choice = this.getGui().one(title, Lists.newArrayList(spellViewCache.keySet()));
        return spellViewCache.get(choice);
    }

    @Override
    public List<SpellAbility> chooseSpellAbilitiesForEffect(List<SpellAbility> spells, SpellAbility sa, String title, int num, Map<String, Object> params) {
        Card current;
        ArrayList<SpellAbility> result = Lists.newArrayList();
        Map<SpellAbilityView, SpellAbility> spellViewCache = SpellAbilityView.getMap(spells);
        if (sa.hasParam("ShowCurrentCard") && (current = (Card)Iterables.getFirst(AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("ShowCurrentCard"), sa), null)) != null) {
            String promptCurrent = this.localizer.getMessage("lblCurrentCard", new Object[0]) + ": " + current;
            title = title + "\n" + promptCurrent;
        }
        List<SpellAbilityView> chosen = this.getGui().getChoices(title, num, num, Lists.newArrayList(spellViewCache.keySet()));
        for (SpellAbilityView view : chosen) {
            if (!spellViewCache.containsKey(view)) continue;
            result.add(spellViewCache.get(view));
        }
        return result;
    }

    @Override
    public boolean confirmAction(SpellAbility sa, PlayerActionConfirmMode mode, String message, List<String> options, Card cardToShow, Map<String, Object> params) {
        if (cardToShow != null) {
            this.tempShowCard(cardToShow);
            boolean result = options.isEmpty() ? InputConfirm.confirm(this, cardToShow.getView(), sa, message) : InputConfirm.confirm(this, cardToShow.getView(), message, true, options);
            this.endTempShowCards();
            return result;
        }
        return options.isEmpty() ? InputConfirm.confirm(this, sa, message) : InputConfirm.confirm(this, sa.getHostCard().getView(), sa, message, true, options);
    }

    @Override
    public boolean confirmBidAction(SpellAbility sa, PlayerActionConfirmMode bidlife, String string, int bid, Player winner) {
        return InputConfirm.confirm(this, sa, string + " " + this.localizer.getMessage("lblHighestBidder", new Object[0]) + " " + winner);
    }

    @Override
    public boolean confirmStaticApplication(Card hostCard, PlayerActionConfirmMode mode, String message, String logic) {
        return InputConfirm.confirm(this, CardView.get(hostCard), message);
    }

    @Override
    public boolean confirmTrigger(WrappedAbility wrapper) {
        Card card;
        Map<AbilityKey, Object> tos;
        SpellAbility sa = wrapper.getWrappedAbility();
        Trigger regtrig = wrapper.getTrigger();
        if (this.getGui().shouldAlwaysAcceptTrigger(regtrig.getId())) {
            return true;
        }
        if (this.getGui().shouldAlwaysDeclineTrigger(regtrig.getId())) {
            return false;
        }
        if (sa.hasParam("Cost") && !sa.getParam("Cost").equals("0")) {
            return true;
        }
        StringBuilder buildQuestion = new StringBuilder(this.localizer.getMessage("lblUseTriggeredAbilityOf", new Object[0]) + " ");
        buildQuestion.append(regtrig.getHostCard().toString()).append("?");
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_COMPACT_PROMPT) && !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT)) {
            buildQuestion.append("\n(");
            buildQuestion.append(regtrig.toString());
            buildQuestion.append(")");
        }
        if ((tos = sa.getTriggeringObjects()).containsKey((Object)AbilityKey.Attacker)) {
            buildQuestion.append("\n").append(this.localizer.getMessage("lblAttacker", new Object[0])).append(": ").append(tos.get((Object)AbilityKey.Attacker));
        }
        if (tos.containsKey((Object)AbilityKey.Card) && (card = (Card)tos.get((Object)AbilityKey.Card)) != null && (card.getController() == this.player || this.getGame().getZoneOf(card) == null || this.getGame().getZoneOf(card).getZoneType().isKnown())) {
            buildQuestion.append("\n").append(this.localizer.getMessage("lblTriggeredby", new Object[0])).append(": ").append(tos.get((Object)AbilityKey.Card));
        }
        if (GuiBase.getInterface().isLibgdxPort()) {
            SpellAbilityView spellAbilityView = wrapper.getView();
            CardView cardView = spellAbilityView != null ? spellAbilityView.getHostCard() : wrapper.getCardView();
            return this.getGui().confirm(cardView, buildQuestion.toString().replaceAll("\n", " "));
        }
        InputConfirm inp = new InputConfirm(this, buildQuestion.toString(), wrapper);
        inp.showAndWait();
        return inp.getResult();
    }

    @Override
    public Player chooseStartingPlayer(boolean isFirstGame) {
        if (this.getGame().getPlayers().size() == 2) {
            String prompt = null;
            prompt = isFirstGame ? this.localizer.getMessage("lblYouHaveWonTheCoinToss", this.player.getName()) : this.localizer.getMessage("lblYouLostTheLastGame", this.player.getName());
            prompt = prompt + "\n\n" + this.localizer.getMessage("lblWouldYouLiketoPlayorDraw", new Object[0]);
            InputConfirm inp = new InputConfirm(this, prompt, this.localizer.getMessage("lblPlay", new Object[0]), this.localizer.getMessage("lblDraw", new Object[0]));
            inp.showAndWait();
            return inp.getResult() ? this.player : (Player)this.player.getOpponents().get(false);
        }
        String prompt = null;
        prompt = isFirstGame ? this.localizer.getMessage("lblYouHaveWonTheCoinToss", this.player.getName()) : this.localizer.getMessage("lblYouLostTheLastGame", this.player.getName());
        prompt = prompt + "\n\n" + this.localizer.getMessage("lblWhoWouldYouLiketoStartthisGame", new Object[0]);
        InputSelectEntitiesFromList<Player> input = new InputSelectEntitiesFromList<Player>(this, 1, 1, new FCollection<Player>(this.getGame().getPlayersInTurnOrder()));
        input.setMessage(prompt);
        input.showAndWait();
        return (Player)input.getFirstSelected();
    }

    @Override
    public CardCollection orderBlockers(Card attacker, CardCollection blockers) {
        GameEntityViewMap gameCacheBlockers = GameEntityView.getMap(blockers);
        CardView vAttacker = CardView.get(attacker);
        this.getGui().setPanelSelection(vAttacker);
        List chosen = this.getGui().order(this.localizer.getMessage("lblChooseDamageOrderFor", CardTranslation.getTranslatedName(vAttacker.getName())), this.localizer.getMessage("lblDamagedFirst", new Object[0]), gameCacheBlockers.getTrackableKeys(), vAttacker);
        CardCollection chosenCards = new CardCollection();
        gameCacheBlockers.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public List<Card> exertAttackers(List<Card> attackers) {
        GameEntityViewMap gameCacheExert = GameEntityView.getMap(attackers);
        List chosen = this.getGui().order(this.localizer.getMessage("lblExertAttackersConfirm", new Object[0]), this.localizer.getMessage("lblExerted", new Object[0]), 0, gameCacheExert.size(), gameCacheExert.getTrackableKeys(), null, null, false);
        CardCollection chosenCards = new CardCollection();
        gameCacheExert.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public List<Card> enlistAttackers(List<Card> attackers) {
        GameEntityViewMap gameCacheExert = GameEntityView.getMap(attackers);
        List chosen = this.getGui().order(this.localizer.getMessage("lblEnlistAttackersConfirm", new Object[0]), this.localizer.getMessage("lblEnlisted", new Object[0]), 0, gameCacheExert.size(), gameCacheExert.getTrackableKeys(), null, null, false);
        CardCollection chosenCards = new CardCollection();
        gameCacheExert.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public CardCollection orderBlocker(Card attacker, Card blocker, CardCollection oldBlockers) {
        GameEntityViewMap gameCacheBlockers = GameEntityView.getMap(oldBlockers);
        CardView vAttacker = CardView.get(attacker);
        this.getGui().setPanelSelection(vAttacker);
        List<CardView> chosen = this.getGui().insertInList(this.localizer.getMessage("lblChooseBlockerAfterWhichToPlaceAttackert", CardTranslation.getTranslatedName(vAttacker.getName())), CardView.get(blocker), CardView.getCollection(oldBlockers));
        CardCollection chosenCards = new CardCollection();
        gameCacheBlockers.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public CardCollection orderAttackers(Card blocker, CardCollection attackers) {
        GameEntityViewMap gameCacheAttackers = GameEntityView.getMap(attackers);
        CardView vBlocker = CardView.get(blocker);
        this.getGui().setPanelSelection(vBlocker);
        List<CardView> chosen = this.getGui().order(this.localizer.getMessage("lblChooseDamageOrderFor", CardTranslation.getTranslatedName(vBlocker.getName())), this.localizer.getMessage("lblDamagedFirst", new Object[0]), CardView.getCollection(attackers), vBlocker);
        CardCollection chosenCards = new CardCollection();
        gameCacheAttackers.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public void reveal(CardCollectionView cards, ZoneType zone, Player owner, String message, boolean addSuffix) {
        this.reveal(cards, zone, PlayerView.get(owner), message, addSuffix);
    }

    @Override
    public void reveal(List<CardView> cards, ZoneType zone, PlayerView owner, String message, boolean addSuffix) {
        this.reveal((CardCollectionView)this.getCardList(cards), zone, owner, message, addSuffix);
    }

    protected void reveal(CardCollectionView cards, ZoneType zone, PlayerView owner, String message, boolean addSuffix) {
        if (StringUtils.isBlank(message)) {
            message = this.localizer.getMessage("lblLookCardInPlayerZone", "{player's}", zone.getTranslatedName().toLowerCase());
        } else if (addSuffix) {
            message = message + " " + this.localizer.getMessage("lblPlayerZone", "{player's}", zone.getTranslatedName().toLowerCase());
        }
        String fm = MessageUtil.formatMessage(message, this.getLocalPlayerView(), (Object)owner);
        if (!cards.isEmpty()) {
            this.tempShowCards(cards);
            TrackableCollection<CardView> collection = CardView.getCollection(cards);
            this.getGui().reveal(fm, collection);
            this.getGui().updateRevealedCards(collection);
            this.endTempShowCards();
        } else {
            this.getGui().message(MessageUtil.formatMessage(this.localizer.getMessage("lblThereNoCardInPlayerZone", "{player's}", zone.getTranslatedName().toLowerCase()), this.getLocalPlayerView(), (Object)owner), fm);
        }
    }

    public List<Card> manipulateCardList(String title, Iterable<Card> cards, Iterable<Card> manipulable, boolean toTop, boolean toBottom, boolean toAnywhere) {
        GameEntityViewMap gameCacheManipulate = GameEntityView.getMap(cards);
        gameCacheManipulate.putAll(manipulable);
        List<CardView> views = this.getGui().manipulateCardList(title, CardView.getCollection(cards), CardView.getCollection(manipulable), toTop, toBottom, toAnywhere);
        return gameCacheManipulate.addToList(views, new CardCollection());
    }

    public ImmutablePair<CardCollection, CardCollection> arrangeForMove(String title, FCollectionView<Card> cards, List<Card> manipulable, boolean topOK, boolean bottomOK) {
        int i;
        List<Card> result = this.manipulateCardList(title, cards, manipulable, topOK, bottomOK, false);
        CardCollection toBottom = new CardCollection();
        CardCollection toTop = new CardCollection();
        for (i = 0; i < cards.size() && manipulable.contains(result.get(i)); ++i) {
            toTop.add(result.get(i));
        }
        if (toTop.size() < cards.size()) {
            for (i = result.size() - 1; i >= 0 && manipulable.contains(result.get(i)); --i) {
                toBottom.add(result.get(i));
            }
        }
        return ImmutablePair.of(toTop, toBottom);
    }

    @Override
    public ImmutablePair<CardCollection, CardCollection> arrangeForScry(CardCollection topN) {
        CardCollection toBottom = null;
        CardCollection toTop = null;
        this.tempShowCards(topN);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SELECT_FROM_CARD_DISPLAYS) && !GuiBase.getInterface().isLibgdxPort() && !GuiBase.isNetworkplay()) {
            CardCollectionView cardList = this.player.getCardsIn(ZoneType.Library);
            ImmutablePair<CardCollection, CardCollection> result = this.arrangeForMove(this.localizer.getMessage("lblMoveCardstoToporBbottomofLibrary", new Object[0]), cardList, topN, true, true);
            toTop = result.getLeft();
            toBottom = result.getRight();
        } else if (topN.size() == 1) {
            if (this.willPutCardOnTop((Card)topN.get(false))) {
                toTop = topN;
            } else {
                toBottom = topN;
            }
        } else {
            GameEntityViewMap cardCacheScry = GameEntityView.getMap(topN);
            toBottom = new CardCollection();
            List views = this.getGui().many(this.localizer.getMessage("lblSelectCardsToBeOutOnTheBottomOfYourLibrary", new Object[0]), this.localizer.getMessage("lblCardsToPutOnTheBottom", new Object[0]), -1, cardCacheScry.getTrackableKeys(), null);
            cardCacheScry.addToList(views, toBottom);
            topN.removeAll(toBottom);
            if (topN.isEmpty()) {
                toTop = null;
            } else if (topN.size() == 1) {
                toTop = topN;
            } else {
                GameEntityViewMap cardCacheOrder = GameEntityView.getMap(topN);
                toTop = new CardCollection();
                views = this.getGui().order(this.localizer.getMessage("lblArrangeCardsToBePutOnTopOfYourLibrary", new Object[0]), this.localizer.getMessage("lblTopOfLibrary", new Object[0]), cardCacheOrder.getTrackableKeys(), null);
                cardCacheOrder.addToList(views, toTop);
            }
        }
        this.endTempShowCards();
        return ImmutablePair.of(toTop, toBottom);
    }

    @Override
    public ImmutablePair<CardCollection, CardCollection> arrangeForSurveil(CardCollection topN) {
        CardCollection toGrave = null;
        CardCollection toTop = null;
        this.tempShowCards(topN);
        if (topN.size() == 1) {
            Card c = (Card)topN.getFirst();
            CardView view = CardView.get(c);
            this.tempShowCard(c);
            this.getGui().setCard(view);
            boolean result = false;
            result = InputConfirm.confirm(this, view, this.localizer.getMessage("lblPutCardsOnTheTopLibraryOrGraveyard", CardTranslation.getTranslatedName(view.getName())), true, ImmutableList.of(this.localizer.getMessage("lblLibrary", new Object[0]), this.localizer.getMessage("lblGraveyard", new Object[0])));
            if (result) {
                toTop = topN;
            } else {
                toGrave = topN;
            }
        } else {
            GameEntityViewMap gameCacheSurveil = GameEntityView.getMap(topN);
            toGrave = new CardCollection();
            List views = this.getGui().many(this.localizer.getMessage("lblSelectCardsToBePutIntoTheGraveyard", new Object[0]), this.localizer.getMessage("lblCardsToPutInTheGraveyard", new Object[0]), -1, gameCacheSurveil.getTrackableKeys(), null);
            gameCacheSurveil.addToList(views, toGrave);
            topN.removeAll(toGrave);
            if (topN.isEmpty()) {
                toTop = null;
            } else if (topN.size() == 1) {
                toTop = topN;
            } else {
                GameEntityViewMap cardCacheOrder = GameEntityView.getMap(topN);
                toTop = new CardCollection();
                views = this.getGui().order(this.localizer.getMessage("lblArrangeCardsToBePutOnTopOfYourLibrary", new Object[0]), this.localizer.getMessage("lblTopOfLibrary", new Object[0]), cardCacheOrder.getTrackableKeys(), null);
                cardCacheOrder.addToList(views, toTop);
            }
        }
        this.endTempShowCards();
        return ImmutablePair.of(toTop, toGrave);
    }

    @Override
    public boolean willPutCardOnTop(Card c) {
        CardView view = CardView.get(c);
        this.tempShowCard(c);
        this.getGui().setCard(c.getView());
        boolean result = false;
        result = InputConfirm.confirm(this, view, this.localizer.getMessage("lblPutCardOnTopOrBottomLibrary", CardTranslation.getTranslatedName(view.getName())), true, ImmutableList.of(this.localizer.getMessage("lblTop", new Object[0]), this.localizer.getMessage("lblBottom", new Object[0])));
        this.endTempShowCards();
        return result;
    }

    @Override
    public CardCollectionView orderMoveToZoneList(CardCollectionView cards, ZoneType destinationZone, SpellAbility source) {
        if ((source == null || source.getApi() != ApiType.ReorderZone) && destinationZone == ZoneType.Graveyard) {
            switch (FModel.getPreferences().getPref(ForgePreferences.FPref.UI_ALLOW_ORDER_GRAVEYARD_WHEN_NEEDED)) {
                case "Never": {
                    return cards;
                }
                case "With Relevant Cards": {
                    if (this.getGame().isGraveyardOrdered(this.player)) break;
                    return cards;
                }
                case "Always": {
                    break;
                }
                default: {
                    return cards;
                }
            }
        }
        this.tempShowCards(cards);
        GameEntityViewMap gameCacheMove = GameEntityView.getMap(cards);
        List choices = gameCacheMove.getTrackableKeys();
        boolean topOfDeck = destinationZone.isDeck() && (source == null || !source.hasParam("LibraryPosition") || AbilityUtils.calculateAmount(source.getHostCard(), source.getParam("LibraryPosition"), source) >= 0);
        switch (destinationZone) {
            case Library: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoLibrary", new Object[0]), this.localizer.getMessage(topOfDeck ? "lblClosestToTop" : "lblClosestToBottom", new Object[0]), choices, null);
                break;
            }
            case Battlefield: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutOntoBattlefield", new Object[0]), this.localizer.getMessage("lblPutFirst", new Object[0]), choices, null);
                break;
            }
            case Graveyard: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoGraveyard", new Object[0]), this.localizer.getMessage("lblClosestToBottom", new Object[0]), choices, null);
                break;
            }
            case Exile: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoExile", new Object[0]), this.localizer.getMessage("lblPutFirst", new Object[0]), choices, null);
                break;
            }
            case PlanarDeck: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoPlanarDeck", new Object[0]), this.localizer.getMessage(topOfDeck ? "lblClosestToTop" : "lblClosestToBottom", new Object[0]), choices, null);
                break;
            }
            case SchemeDeck: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoSchemeDeck", new Object[0]), this.localizer.getMessage(topOfDeck ? "lblClosestToTop" : "lblClosestToBottom", new Object[0]), choices, null);
                break;
            }
            case AttractionDeck: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCardsPutIntoAttractionDeck", new Object[0]), this.localizer.getMessage(topOfDeck ? "lblClosestToTop" : "lblClosestToBottom", new Object[0]), choices, null);
            }
            case Stack: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCopiesCast", new Object[0]), this.localizer.getMessage("lblPutFirst", new Object[0]), choices, null);
                break;
            }
            case None: {
                choices = this.getGui().order(this.localizer.getMessage("lblChooseOrderCards", new Object[0]), this.localizer.getMessage("lblPutFirst", new Object[0]), choices, null);
                break;
            }
            default: {
                System.out.println("ZoneType " + (Object)((Object)destinationZone) + " - Not Ordered");
                this.endTempShowCards();
                return cards;
            }
        }
        this.endTempShowCards();
        if (topOfDeck) {
            Collections.reverse(choices);
        }
        CardCollection result = new CardCollection();
        gameCacheMove.addToList(choices, result);
        return result;
    }

    @Override
    public CardCollectionView chooseCardsToDiscardFrom(Player p, SpellAbility sa, CardCollection valid, int min2, int max) {
        boolean optional;
        boolean bl = optional = min2 == 0;
        if (p != this.player) {
            this.tempShowCards(valid);
            GameEntityViewMap gameCacheDiscard = GameEntityView.getMap(valid);
            List views = this.getGui().many(String.format(this.localizer.getMessage("lblChooseMinCardToDiscard", new Object[0]), optional ? max : min2), this.localizer.getMessage("lblDiscarded", new Object[0]), min2, max, gameCacheDiscard.getTrackableKeys(), null);
            this.endTempShowCards();
            CardCollection choices = new CardCollection();
            gameCacheDiscard.addToList(views, choices);
            return choices;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this, min2, max, valid, sa);
        inp.setMessage(sa.hasParam("AnyNumber") ? this.localizer.getMessage("lblDiscardUpToNCards", new Object[0]) : this.localizer.getMessage("lblDiscardNCards", new Object[0]));
        inp.showAndWait();
        return new CardCollection((Iterable<Card>)inp.getSelected());
    }

    @Override
    public CardCollectionView chooseCardsToDelve(int genericAmount, CardCollection grave) {
        int cardsInGrave = Math.min(genericAmount, grave.size());
        if (cardsInGrave == 0) {
            return CardCollection.EMPTY;
        }
        CardCollection toExile = new CardCollection();
        ImmutableList.Builder cntChoice = ImmutableList.builder();
        for (int i = 0; i <= cardsInGrave; ++i) {
            cntChoice.add((Object)i);
        }
        int chosenAmount = (Integer)this.getGui().one(this.localizer.getMessage("lblDelveHowManyCards", new Object[0]), cntChoice.build());
        GameEntityViewMap gameCacheGrave = GameEntityView.getMap(grave);
        for (int i = 0; i < chosenAmount; ++i) {
            String title = this.localizer.getMessage("lblExileWhichCard", String.valueOf(i + 1), String.valueOf(chosenAmount));
            CardView nowChosen = (CardView)this.getGui().oneOrNone(title, gameCacheGrave.getTrackableKeys());
            if (nowChosen == null || !gameCacheGrave.containsKey(nowChosen)) {
                toExile.clear();
                break;
            }
            toExile.add((Card)gameCacheGrave.remove(nowChosen));
        }
        return toExile;
    }

    @Override
    public CardCollectionView chooseCardsToDiscardUnlessType(int num, CardCollectionView hand, String uType, SpellAbility sa) {
        final String[] splitUTypes = uType.split(",");
        InputSelectEntitiesFromList<Card> target = new InputSelectEntitiesFromList<Card>(this, num, num, (FCollectionView)hand, sa){
            private static final long serialVersionUID = -5774108410928795591L;

            @Override
            protected boolean hasEnoughTargets() {
                for (Card c : this.selected) {
                    if (!c.isValid(splitUTypes, this.sa.getActivatingPlayer(), this.sa.getHostCard(), (CardTraitBase)this.sa)) continue;
                    return true;
                }
                return super.hasEnoughTargets();
            }
        };
        int n = 1;
        StringBuilder promptType = new StringBuilder();
        for (String part : splitUTypes) {
            if (n == 1) {
                promptType.append(part.toLowerCase());
            } else {
                promptType.append(" or ").append(part.toLowerCase());
            }
            ++n;
        }
        target.setMessage(this.localizer.getMessage("lblSelectNCardsToDiscardUnlessDiscarduType", promptType));
        target.showAndWait();
        return new CardCollection((Iterable<Card>)target.getSelected());
    }

    @Override
    public Mana chooseManaFromPool(List<Mana> manaChoices) {
        ArrayList<String> options = Lists.newArrayList();
        for (int i = 0; i < manaChoices.size(); ++i) {
            Mana m4 = manaChoices.get(i);
            options.add(this.localizer.getMessage("lblNColorManaFromCard", String.valueOf(1 + i), MagicColor.toLongString(m4.getColor()), CardTranslation.getTranslatedName(m4.getSourceCard().getName())));
        }
        String chosen = (String)this.getGui().one(this.localizer.getMessage("lblPayManaFromManaPool", new Object[0]), options);
        String idx = TextUtil.split(chosen, '.')[0];
        return manaChoices.get(Integer.parseInt(idx) - 1);
    }

    @Override
    public String chooseSomeType(String kindOfType, SpellAbility sa, Collection<String> validTypes, List<String> invalidTypes, boolean isOptional) {
        ArrayList<String> types = Lists.newArrayList(validTypes);
        if (invalidTypes != null && !invalidTypes.isEmpty()) {
            Iterables.removeAll(types, invalidTypes);
        }
        if (kindOfType.equals("Creature")) {
            this.sortCreatureTypes(types);
        }
        if (isOptional) {
            return this.getGui().oneOrNone(this.localizer.getMessage("lblChooseATargetType", kindOfType.toLowerCase()), types);
        }
        return this.getGui().one(this.localizer.getMessage("lblChooseATargetType", kindOfType.toLowerCase()), types);
    }

    private void sortCreatureTypes(List<String> types) {
        HashMap<String, Integer> typesInDeck = Maps.newHashMap();
        for (Card c : this.player.getAllCards()) {
            if (c.hasKeyword(Keyword.CHANGELING) || c.getType().hasAllCreatureTypes()) continue;
            boolean bl = false;
            for (ReplacementEffect re : c.getReplacementEffects()) {
                if (re.getLayer() != ReplacementLayer.Copy) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (String type : c.getType().getCreatureTypes()) {
                String[] count = typesInDeck.getOrDefault(type, 0);
                typesInDeck.put(type, count.intValue() + 1);
            }
            for (SpellAbility sa : c.getAllSpellAbilities()) {
                if (sa.getApi() != ApiType.Token || !sa.hasParam("TokenScript")) continue;
                sa.setActivatingPlayer(this.player);
                for (String token : sa.getParam("TokenScript").split(",")) {
                    Card protoType = TokenInfo.getProtoType(token, sa, null);
                    for (String type : protoType.getType().getCreatureTypes()) {
                        Integer count = typesInDeck.getOrDefault(type, 0);
                        typesInDeck.put(type, count + 1);
                    }
                }
            }
            for (Trigger t2 : c.getTriggers()) {
                SpellAbility sa = t2.ensureAbility();
                if (sa == null || !sa.hasParam("TokenScript")) continue;
                sa.setActivatingPlayer(this.player);
                for (String token : sa.getParam("TokenScript").split(",")) {
                    Card protoType = TokenInfo.getProtoType(token, sa, null);
                    for (String type : protoType.getType().getCreatureTypes()) {
                        Integer count = typesInDeck.getOrDefault(type, 0);
                        typesInDeck.put(type, count + 1);
                    }
                }
            }
            if (!c.hasKeyword(Keyword.FABRICATE)) continue;
            Integer count = typesInDeck.getOrDefault("Servo", 0);
            typesInDeck.put("Servo", count + 1);
        }
        Collections.sort(types);
        ArrayList sortedList = Lists.newArrayList(typesInDeck.entrySet());
        sortedList.sort(Map.Entry.comparingByValue());
        for (Map.Entry entry : sortedList) {
            String type = (String)entry.getKey();
            if (!types.remove(type)) continue;
            types.add(0, type);
        }
    }

    @Override
    public String chooseSector(Card assignee, String ai, List<String> sectors) {
        String prompt;
        if (assignee != null) {
            String creature = CardTranslation.getTranslatedName(assignee.getName()) + " (" + assignee.getId() + ")";
            prompt = Localizer.getInstance().getMessage("lblAssignSectorCreature", creature);
        } else {
            prompt = Localizer.getInstance().getMessage("lblChooseSectorEffect", new Object[0]);
        }
        return this.getGui().one(prompt, sectors);
    }

    @Override
    public PlanarDice choosePDRollToIgnore(List<PlanarDice> rolls) {
        return this.getGui().one(Localizer.getInstance().getMessage("lblChooseRollIgnore", new Object[0]), rolls);
    }

    @Override
    public Integer chooseRollToIgnore(List<Integer> rolls) {
        return this.getGui().one(Localizer.getInstance().getMessage("lblChooseRollIgnore", new Object[0]), rolls);
    }

    @Override
    public Object vote(SpellAbility sa, String prompt, List<Object> options, ListMultimap<Object, Player> votes, Player forPlayer, boolean optional) {
        if (optional) {
            return this.getGui().oneOrNone(prompt, options);
        }
        return this.getGui().one(prompt, options);
    }

    @Override
    public boolean confirmReplacementEffect(ReplacementEffect replacementEffect, SpellAbility effectSA, GameEntity affected, String question) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            SpellAbilityView spellAbilityView;
            SpellAbilityView spellAbilityView2 = spellAbilityView = effectSA == null ? null : effectSA.getView();
            CardView cardView = spellAbilityView != null ? spellAbilityView.getHostCard() : (effectSA == null ? null : effectSA.getCardView());
            return this.getGui().confirm(cardView, question.replaceAll("\n", " "));
        }
        InputConfirm inp = new InputConfirm(this, question, effectSA);
        inp.showAndWait();
        return inp.getResult();
    }

    @Override
    public boolean mulliganKeepHand(Player mulliganingPlayer, int cardsToReturn) {
        InputConfirmMulligan inp = new InputConfirmMulligan(this, this.player, mulliganingPlayer);
        inp.showAndWait();
        return inp.isKeepHand();
    }

    @Override
    public CardCollectionView londonMulliganReturnCards(Player mulliganingPlayer, int cardsToReturn) {
        InputLondonMulligan inp = new InputLondonMulligan(this, this.player, cardsToReturn);
        inp.showAndWait();
        return inp.getSelectedCards();
    }

    @Override
    public void declareAttackers(Player attackingPlayer, Combat combat) {
        if (this.mayAutoPass()) {
            if (CombatUtil.validateAttackers(combat)) {
                return;
            }
            this.autoPassCancel();
        }
        InputAttack inpAttack = new InputAttack(this, attackingPlayer, combat);
        inpAttack.showAndWait();
    }

    @Override
    public void declareBlockers(Player defender, Combat combat) {
        InputBlock inpBlock = new InputBlock(this, defender, combat);
        inpBlock.showAndWait();
        this.getGui().updateAutoPassPrompt();
    }

    @Override
    public List<SpellAbility> chooseSpellAbilityToPlay() {
        MagicStack stack = this.getGame().getStack();
        if (this.mayAutoPass()) {
            int delay = 0;
            if (stack.isEmpty()) {
                if (!this.getGui().isUiSetToSkipPhase(this.getGame().getPhaseHandler().getPlayerTurn().getView(), this.getGame().getPhaseHandler().getPhase())) {
                    delay = 200;
                }
            } else {
                delay = 400;
            }
            if (delay > 0) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        if (stack.isEmpty()) {
            if (this.getGui().isUiSetToSkipPhase(this.getGame().getPhaseHandler().getPlayerTurn().getView(), this.getGame().getPhaseHandler().getPhase())) {
                return null;
            }
        } else {
            SpellAbility ability = stack.peekAbility();
            if (ability != null && ability.isAbility() && this.getGui().shouldAutoYield(ability.yieldKey())) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        InputPassPriority defaultInput = new InputPassPriority(this);
        defaultInput.showAndWait();
        return defaultInput.getChosenSa();
    }

    @Override
    public boolean playChosenSpellAbility(SpellAbility chosenSa) {
        return HumanPlay.playSpellAbility(this, this.player, chosenSa);
    }

    @Override
    public CardCollection chooseCardsToDiscardToMaximumHandSize(int nDiscard) {
        int max = this.player.getMaxHandSize();
        if (GuiBase.getInterface().isLibgdxPort()) {
            this.tempShowCards(this.player.getCardsIn(ZoneType.Hand));
            GameEntityViewMap gameCacheDiscard = GameEntityView.getMap(this.player.getCardsIn(ZoneType.Hand));
            List views = this.getGui().many(String.format(this.localizer.getMessage("lblChooseMinCardToDiscard", new Object[0]), nDiscard), this.localizer.getMessage("lblDiscarded", new Object[0]), nDiscard, nDiscard, gameCacheDiscard.getTrackableKeys(), null);
            this.endTempShowCards();
            CardCollection choices = new CardCollection();
            gameCacheDiscard.addToList(views, choices);
            return choices;
        }
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this, nDiscard, nDiscard, this.player.getZone(ZoneType.Hand).getCards()){

            @Override
            protected boolean allowAwaitNextInput() {
                return true;
            }
        };
        String message = this.localizer.getMessage("lblCleanupPhase", new Object[0]) + "\n" + this.localizer.getMessage("lblSelectCardsToDiscardHandDownMaximum", String.valueOf(nDiscard), String.valueOf(max));
        inp.setMessage(message);
        inp.setCancelAllowed(false);
        inp.showAndWait();
        return new CardCollection((Iterable<Card>)inp.getSelected());
    }

    @Override
    public CardCollectionView chooseCardsToRevealFromHand(int min2, int max, CardCollectionView valid) {
        max = Math.min(max, valid.size());
        min2 = Math.min(min2, max);
        InputSelectCardsFromList inp = new InputSelectCardsFromList(this, min2, max, valid);
        inp.setMessage(this.localizer.getMessage("lblChooseWhichCardstoReveal", new Object[0]));
        inp.showAndWait();
        return new CardCollection((Iterable<Card>)inp.getSelected());
    }

    @Override
    public boolean payManaOptional(Card c, Cost cost, SpellAbility sa, String prompt, PlayerController.ManaPaymentPurpose purpose) {
        if (sa == null && cost.isOnlyManaCost() && cost.getTotalMana().isZero() && !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.MATCHPREF_PROMPT_FREE_BLOCKS)) {
            return true;
        }
        return HumanPlay.payCostDuringAbilityResolve(this, this.player, c, cost, sa, prompt);
    }

    @Override
    public List<SpellAbility> chooseSaToActivateFromOpeningHand(List<SpellAbility> usableFromOpeningHand) {
        CardCollection srcCards = new CardCollection();
        for (SpellAbility sa : usableFromOpeningHand) {
            srcCards.add(sa.getHostCard());
        }
        ArrayList<SpellAbility> result = Lists.newArrayList();
        if (srcCards.isEmpty()) {
            return result;
        }
        GameEntityViewMap gameCacheOpenHand = GameEntityView.getMap(srcCards);
        List<CardView> chosen = this.getGui().many(this.localizer.getMessage("lblChooseCardsActivateOpeningHandandOrder", new Object[0]), this.localizer.getMessage("lblActivateFirst", new Object[0]), -1, CardView.getCollection(srcCards), null);
        block1: for (CardView view : chosen) {
            if (!gameCacheOpenHand.containsKey(view)) continue;
            Card c = (Card)gameCacheOpenHand.get(view);
            for (SpellAbility sa : usableFromOpeningHand) {
                if (sa.getHostCard() != c) continue;
                result.add(sa);
                continue block1;
            }
        }
        return result;
    }

    @Override
    public PlayerZone chooseStartingHand(List<PlayerZone> zones) {
        this.player.updateZoneForView(this.player.getZone(ZoneType.Hand));
        InputChooseStartingHand inp = new InputChooseStartingHand(this, this.player);
        inp.showAndWait();
        return inp.getSelectedHand();
    }

    @Override
    public boolean chooseBinary(SpellAbility sa, String question, PlayerController.BinaryChoiceType kindOfChoice, Boolean defaultVal) {
        ImmutableList<String> labels;
        switch (kindOfChoice) {
            case HeadsOrTails: {
                labels = ImmutableList.of(this.localizer.getMessage("lblHeads", new Object[0]), this.localizer.getMessage("lblTails", new Object[0]));
                break;
            }
            case TapOrUntap: {
                labels = ImmutableList.of(StringUtils.capitalize(this.localizer.getMessage("lblTap", new Object[0])), this.localizer.getMessage("lblUntap", new Object[0]));
                break;
            }
            case OddsOrEvens: {
                labels = ImmutableList.of(this.localizer.getMessage("lblOdds", new Object[0]), this.localizer.getMessage("lblEvens", new Object[0]));
                break;
            }
            case UntapOrLeaveTapped: {
                labels = ImmutableList.of(this.localizer.getMessage("lblUntap", new Object[0]), this.localizer.getMessage("lblLeaveTapped", new Object[0]));
                break;
            }
            case UntapTimeVault: {
                labels = ImmutableList.of(this.localizer.getMessage("lblUntapAndSkipThisTurn", new Object[0]), this.localizer.getMessage("lblLeaveTapped", new Object[0]));
                break;
            }
            case PlayOrDraw: {
                labels = ImmutableList.of(this.localizer.getMessage("lblPlay", new Object[0]), this.localizer.getMessage("lblDraw", new Object[0]));
                break;
            }
            case LeftOrRight: {
                labels = ImmutableList.of(this.localizer.getMessage("lblLeft", new Object[0]), this.localizer.getMessage("lblRight", new Object[0]));
                break;
            }
            case AddOrRemove: {
                labels = ImmutableList.of(this.localizer.getMessage("lblAddCounter", new Object[0]), this.localizer.getMessage("lblRemoveCounter", new Object[0]));
                break;
            }
            default: {
                labels = ImmutableList.copyOf(kindOfChoice.toString().split("Or"));
            }
        }
        return InputConfirm.confirm(this, sa, question, defaultVal == null || defaultVal != false, labels);
    }

    @Override
    public boolean chooseFlipResult(SpellAbility sa, Player flipper, boolean[] results, boolean call) {
        String[] stringArray;
        if (call) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.localizer.getMessage("lblHeads", new Object[0]);
            stringArray = stringArray2;
            stringArray2[1] = this.localizer.getMessage("lblTails", new Object[0]);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.localizer.getMessage("lblWinTheFlip", new Object[0]);
            stringArray = stringArray3;
            stringArray3[1] = this.localizer.getMessage("lblLoseTheFlip", new Object[0]);
        }
        String[] labelsSrc = stringArray;
        ArrayList<String> sortedResults = new ArrayList<String>();
        for (boolean result : results) {
            sortedResults.add(labelsSrc[result ? 0 : 1]);
        }
        Collections.sort(sortedResults);
        if (!call) {
            Collections.reverse(sortedResults);
        }
        return ((String)this.getGui().one(sa.getHostCard().getName() + " - " + this.localizer.getMessage("lblChooseAResult", new Object[0]), sortedResults)).equals(labelsSrc[0]);
    }

    @Override
    public Pair<SpellAbilityStackInstance, GameObject> chooseTarget(SpellAbility saSpellskite, List<Pair<SpellAbilityStackInstance, GameObject>> allTargets) {
        if (allTargets.size() < 2) {
            return Iterables.getFirst(allTargets, null);
        }
        List<Pair<SpellAbilityStackInstance, GameObject>> chosen = this.getGui().getChoices(saSpellskite.getHostCard().getName(), 1, 1, allTargets, null, new FnTargetToString());
        return Iterables.getFirst(chosen, null);
    }

    @Override
    public void notifyOfValue(SpellAbility sa, GameObject realtedTarget, String value) {
        String message = MessageUtil.formatNotificationMessage(sa, this.player, realtedTarget, value);
        if (sa != null && sa.isManaAbility()) {
            this.getGame().getGameLog().add(GameLogEntryType.LAND, message);
        } else if (sa != null && sa.getHostCard() != null && GuiBase.getInterface().isLibgdxPort()) {
            IPaperCard iPaperCard = sa.getHostCard().getPaperCard();
            CardView cardView = iPaperCard != null ? CardView.getCardForUi(iPaperCard) : sa.getHostCard().getView();
            this.getGui().confirm(cardView, message, ImmutableList.of(this.localizer.getMessage("lblOK", new Object[0])));
        } else {
            this.getGui().message(message, sa == null || sa.getHostCard() == null ? "" : CardView.get(sa.getHostCard()).toString());
        }
    }

    @Override
    public List<AbilitySub> chooseModeForAbility(SpellAbility sa, List<AbilitySub> possible, int min2, int num, boolean allowRepeat) {
        boolean trackerFrozen = this.getGame().getTracker().isFrozen();
        if (trackerFrozen) {
            this.getGame().getTracker().unfreeze();
        }
        Map<SpellAbilityView, AbilitySub> spellViewCache = SpellAbilityView.getMap(possible);
        if (trackerFrozen) {
            this.getGame().getTracker().freeze();
        }
        String modeTitle = this.localizer.getMessage("lblPlayerActivatedCardChooseMode", sa.getActivatingPlayer().toString(), CardTranslation.getTranslatedName(sa.getHostCard().getName()));
        ArrayList<AbilitySub> chosen = Lists.newArrayListWithCapacity(num);
        int chosenPawprint = 0;
        for (int i = 0; i < num; ++i) {
            if (sa.hasParam("Pawprint")) {
                int tmpPaw = chosenPawprint;
                spellViewCache.values().removeIf(ab -> Integer.parseInt(ab.getParam("Pawprint")) > num - tmpPaw);
            }
            ArrayList<SpellAbilityView> choices = Lists.newArrayList(spellViewCache.keySet());
            SpellAbilityView a = i < min2 ? this.getGui().one(modeTitle, choices) : this.getGui().oneOrNone(modeTitle, choices);
            if (a == null) break;
            AbilitySub sp = spellViewCache.get(a);
            if (!allowRepeat) {
                spellViewCache.remove(a);
            }
            if (sp.hasParam("Pawprint")) {
                chosenPawprint += AbilityUtils.calculateAmount(sp.getHostCard(), sp.getParam("Pawprint"), sp);
            }
            chosen.add(sp);
        }
        return chosen;
    }

    @Override
    public List<String> chooseColors(String message, SpellAbility sa, int min2, int max, List<String> options) {
        options = options.stream().map(DeckRecognizer::getLocalisedMagicColorName).collect(Collectors.toList());
        List<String> choices = this.getGui().getChoices(message, min2, max, options);
        return choices.stream().map(DeckRecognizer::getColorNameByLocalisedName).collect(Collectors.toList());
    }

    @Override
    public byte chooseColor(String message, SpellAbility sa, ColorSet colors) {
        int cntColors = colors.countColors();
        switch (cntColors) {
            case 0: {
                return 0;
            }
            case 1: {
                return colors.getColor();
            }
        }
        return this.chooseColorCommon(message, sa == null ? null : sa.getHostCard(), colors, false);
    }

    @Override
    public byte chooseColorAllowColorless(String message, Card c, ColorSet colors) {
        int cntColors = 1 + colors.countColors();
        switch (cntColors) {
            case 1: {
                return 0;
            }
        }
        return this.chooseColorCommon(message, c, colors, true);
    }

    private byte chooseColorCommon(String message, Card c, ColorSet colors, boolean withColorless) {
        ImmutableList.Builder colorNamesBuilder = ImmutableList.builder();
        if (withColorless) {
            colorNamesBuilder.add(MagicColor.toLongString((byte)0));
        }
        for (Byte b : colors) {
            colorNamesBuilder.add(MagicColor.toLongString(b));
        }
        ImmutableCollection colorNames = colorNamesBuilder.build();
        if (colorNames.size() > 2) {
            return MagicColor.fromName((String)this.getGui().one(message, colorNames));
        }
        boolean confirmed = false;
        confirmed = InputConfirm.confirm(this, CardView.get(c), message, true, (List<String>)((Object)colorNames));
        int idxChosen = confirmed ? 0 : 1;
        return MagicColor.fromName((String)colorNames.get(idxChosen));
    }

    @Override
    public ICardFace chooseSingleCardFace(SpellAbility sa, String message, Predicate<ICardFace> cpp, String name) {
        CardFaceView cardFaceView;
        Collection<ICardFace> cardsFromDb = FModel.getMagicDb().getCommonCards().getAllFaces();
        ArrayList<ICardFace> cards = Lists.newArrayList(Iterables.filter(cardsFromDb, cpp));
        ArrayList<CardFaceView> choices = new ArrayList<CardFaceView>();
        for (ICardFace cardFace : cards) {
            cardFaceView = new CardFaceView(CardTranslation.getTranslatedName(cardFace.getName()), cardFace.getName());
            choices.add(cardFaceView);
        }
        Collections.sort(choices);
        cardFaceView = (CardFaceView)this.getGui().one(message, choices);
        return StaticData.instance().getCommonCards().getFaceByName(cardFaceView.getOracleName());
    }

    @Override
    public ICardFace chooseSingleCardFace(SpellAbility sa, List<ICardFace> faces, String message) {
        return this.getGui().one(message, faces);
    }

    @Override
    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, String prompt, Map<String, Object> params) {
        if (options.size() <= 1) {
            return Iterables.getFirst(options, null);
        }
        return this.getGui().one(prompt, options);
    }

    @Override
    public CardState chooseSingleCardState(SpellAbility sa, List<CardState> states, String message, Map<String, Object> params) {
        if (states.size() <= 1) {
            return Iterables.getFirst(states, null);
        }
        Map<CardView.CardStateView, CardState> cache = CardView.getStateMap(states);
        CardView.CardStateView chosen = this.getGui().one(message, Lists.newArrayList(cache.keySet()));
        return cache.get(chosen);
    }

    @Override
    public String chooseKeywordForPump(List<String> options, SpellAbility sa, String prompt, Card tgtCard) {
        if (options.size() <= 1) {
            return Iterables.getFirst(options, null);
        }
        return this.getGui().one(prompt, options);
    }

    @Override
    public boolean confirmPayment(CostPart costPart, String question, SpellAbility sa) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            CardView cardView;
            try {
                cardView = CardView.getCardForUi(ImageUtil.getPaperCardFromImageKey(sa.getView().getHostCard().getCurrentState().getTrackableImageKey()));
            }
            catch (Exception e) {
                SpellAbilityView spellAbilityView = sa.getView();
                cardView = spellAbilityView != null ? spellAbilityView.getHostCard() : sa.getCardView();
            }
            return this.getGui().confirm(cardView, question.replaceAll("\n", " "));
        }
        InputConfirm inp = new InputConfirm(this, question, sa);
        inp.showAndWait();
        return inp.getResult();
    }

    @Override
    public ReplacementEffect chooseSingleReplacementEffect(List<ReplacementEffect> possibleReplacers) {
        ReplacementEffect first = possibleReplacers.get(0);
        if (possibleReplacers.size() == 1) {
            return first;
        }
        List res = possibleReplacers.stream().map(ReplacementEffect::toString).collect(Collectors.toList());
        String firstStr = (String)res.get(0);
        String prompt = this.localizer.getMessage("lblChooseFirstApplyReplacementEffect", new Object[0]);
        for (int i = 1; i < res.size(); ++i) {
            if (((String)res.get(i)).equals(firstStr)) continue;
            if (!GuiBase.isNetworkplay()) {
                return this.getGui().one(prompt, possibleReplacers);
            }
            ReplacementEffectView rev = (ReplacementEffectView)this.getGui().one(prompt, possibleReplacers.stream().map(ReplacementEffect::getView).collect(Collectors.toList()));
            return possibleReplacers.stream().filter(re -> re.getId() == rev.getId()).findAny().orElse(first);
        }
        return first;
    }

    @Override
    public StaticAbility chooseSingleStaticAbility(String prompt, List<StaticAbility> possibleStatics) {
        StaticAbility first = possibleStatics.get(0);
        if (possibleStatics.size() == 1 || !this.fullControl) {
            return first;
        }
        List sts = possibleStatics.stream().map(StaticAbility::toString).collect(Collectors.toList());
        String firstStr = (String)sts.get(0);
        for (int i = 1; i < sts.size(); ++i) {
            if (((String)sts.get(i)).equals(firstStr)) continue;
            if (!GuiBase.isNetworkplay()) {
                return this.getGui().one(prompt, possibleStatics);
            }
            StaticAbilityView stv = (StaticAbilityView)this.getGui().one(prompt, possibleStatics.stream().map(StaticAbility::getView).collect(Collectors.toList()));
            return possibleStatics.stream().filter(st -> st.getId() == stv.getId()).findAny().orElse(first);
        }
        return first;
    }

    @Override
    public String chooseProtectionType(String string, SpellAbility sa, List<String> choices) {
        return this.getGui().one(string, choices);
    }

    @Override
    public boolean payCostToPreventEffect(Cost cost, SpellAbility sa, boolean alreadyPaid, FCollectionView<Player> allPayers) {
        return HumanPlay.payCostDuringAbilityResolve(this, this.player, sa.getHostCard(), cost, sa, null);
    }

    @Override
    public void orderAndPlaySimultaneousSa(List<SpellAbility> activePlayerSAs) {
        List<SpellAbility> orderedSAs = activePlayerSAs;
        if (activePlayerSAs.size() > 1) {
            String firstStr = activePlayerSAs.get(0).toString();
            boolean needPrompt = !activePlayerSAs.get(0).isTrigger();
            int idxAdditionalInfo = firstStr.indexOf(" [");
            StringBuilder saLookupKey = new StringBuilder(idxAdditionalInfo > 0 ? firstStr.substring(0, idxAdditionalInfo - 1) : firstStr);
            char delim = '\u0005';
            for (int i = 1; i < activePlayerSAs.size(); ++i) {
                SpellAbility currentSa = activePlayerSAs.get(i);
                String saStr = currentSa.toString();
                if (currentSa.isTrigger()) {
                    needPrompt |= currentSa.getTrigger().hasParam("OrderDuplicates");
                } else if (currentSa.usesTargeting()) {
                    needPrompt = true;
                }
                if (!needPrompt && !saStr.equals(firstStr)) {
                    needPrompt = true;
                }
                saLookupKey.append(delim).append(saStr);
                idxAdditionalInfo = saLookupKey.indexOf(" [");
                if (idxAdditionalInfo <= 0) continue;
                saLookupKey = new StringBuilder(saLookupKey.substring(0, idxAdditionalInfo - 1));
            }
            if (needPrompt) {
                List<Integer> savedOrder = this.orderedSALookup.get(saLookupKey.toString());
                List orderedSAVs = Lists.newArrayList();
                Map<SpellAbilityView, SpellAbility> spellViewCache = SpellAbilityView.getMap(orderedSAs);
                if (savedOrder != null) {
                    orderedSAVs = Lists.newArrayList();
                    for (Integer index : savedOrder) {
                        orderedSAVs.add(activePlayerSAs.get(index).getView());
                    }
                } else {
                    for (SpellAbility spellAbility : orderedSAs) {
                        orderedSAVs.add(spellAbility.getView());
                    }
                }
                if (savedOrder != null) {
                    boolean preselect = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_PRESELECT_PREVIOUS_ABILITY_ORDER);
                    orderedSAVs = this.getGui().order(this.localizer.getMessage("lblReorderSimultaneousAbilities", new Object[0]), this.localizer.getMessage("lblResolveFirst", new Object[0]), 0, 0, preselect ? Lists.newArrayList() : orderedSAVs, preselect ? orderedSAVs : Lists.newArrayList(), null, false);
                } else {
                    orderedSAVs = this.getGui().order(this.localizer.getMessage("lblSelectOrderForSimultaneousAbilities", new Object[0]), this.localizer.getMessage("lblResolveFirst", new Object[0]), orderedSAVs, null);
                }
                orderedSAs = Lists.newArrayList();
                for (SpellAbilityView spellAbilityView : orderedSAVs) {
                    orderedSAs.add(spellViewCache.get(spellAbilityView));
                }
                savedOrder = Lists.newArrayListWithCapacity(activePlayerSAs.size());
                for (SpellAbility sa : orderedSAs) {
                    savedOrder.add(activePlayerSAs.indexOf(sa));
                }
                this.orderedSALookup.put(saLookupKey.toString(), savedOrder);
            }
        }
        for (int i = orderedSAs.size() - 1; i >= 0; --i) {
            SpellAbility next = orderedSAs.get(i);
            if (next.isTrigger() && !next.isCopied()) {
                HumanPlay.playSpellAbility(this, this.player, next);
                continue;
            }
            if (next.isCopied()) {
                if (next.isSpell()) {
                    if (!next.getHostCard().isInZone(ZoneType.Stack)) {
                        next.setHostCard(this.player.getGame().getAction().moveToStack(next.getHostCard(), next));
                    } else {
                        this.player.getGame().getStackZone().add(next.getHostCard());
                    }
                }
                if (next.isMayChooseNewTargets()) {
                    next.setupNewTargets(this.player);
                }
            }
            this.player.getGame().getStack().add(next);
        }
    }

    @Override
    public boolean playTrigger(Card host, WrappedAbility wrapperAbility, boolean isMandatory) {
        return HumanPlay.playSpellAbilityNoStack(this, this.player, wrapperAbility);
    }

    @Override
    public boolean playSaFromPlayEffect(SpellAbility tgtSA) {
        return HumanPlay.playSpellAbility(this, this.player, tgtSA);
    }

    @Override
    public boolean chooseTargetsFor(SpellAbility currentAbility) {
        SpellAbility checkSA;
        TargetSelection select = new TargetSelection(this, currentAbility);
        boolean canFilterMustTarget = true;
        for (checkSA = currentAbility.getParent(); checkSA != null; checkSA = checkSA.getParent()) {
            if (!checkSA.usesTargeting()) continue;
            canFilterMustTarget = false;
            break;
        }
        for (checkSA = currentAbility.getSubAbility(); checkSA != null; checkSA = checkSA.getSubAbility()) {
            if (!checkSA.usesTargeting()) continue;
            canFilterMustTarget = false;
            break;
        }
        boolean result = select.chooseTargets(null, null, null, false, canFilterMustTarget);
        Iterable<GameEntity> targets = currentAbility.getTargets().getTargetEntities();
        int size = Iterables.size(targets);
        int amount = currentAbility.getStillToDivide();
        if (result && size > 0 && amount > 0) {
            if (currentAbility.hasParam("DividedUpTo")) {
                amount = this.chooseNumber(currentAbility, this.localizer.getMessage("lblHowMany", new Object[0]), size, amount);
            }
            if (size == 1) {
                currentAbility.addDividedAllocation(Iterables.get(targets, 0), amount);
            } else if (size == amount) {
                for (GameEntity e : targets) {
                    currentAbility.addDividedAllocation(e, 1);
                }
            } else if (amount == 0) {
                for (GameEntity e : targets) {
                    currentAbility.addDividedAllocation(e, 0);
                }
            } else {
                if (size > amount) {
                    return false;
                }
                String label = "lblDamage";
                if (currentAbility.getApi() == ApiType.PreventDamage) {
                    label = "lblShield";
                } else if (currentAbility.getApi() == ApiType.PutCounter) {
                    label = "lblCounters";
                }
                label = this.localizer.getMessage(label, new Object[0]).toLowerCase();
                CardView vSource = CardView.get(currentAbility.getHostCard());
                HashMap<Object, Integer> vTargets = new HashMap<Object, Integer>(size);
                for (GameEntity e : targets) {
                    vTargets.put(GameEntityView.get(e), amount);
                }
                Map<Object, Integer> vResult = this.getGui().assignGenericAmount(vSource, vTargets, amount, true, label);
                for (GameEntity e : targets) {
                    currentAbility.addDividedAllocation(e, vResult.get(GameEntityView.get(e)));
                }
                if (currentAbility.getStillToDivide() > 0) {
                    return false;
                }
            }
        }
        return result;
    }

    @Override
    public TargetChoices chooseNewTargetsFor(SpellAbility ability, Predicate<GameObject> filter, boolean optional) {
        SpellAbility sa;
        SpellAbility spellAbility = sa = ability.isWrapper() ? ((WrappedAbility)ability).getWrappedAbility() : ability;
        if (!sa.usesTargeting()) {
            return null;
        }
        TargetChoices oldTarget = sa.getTargets();
        TargetSelection select = new TargetSelection(this, sa);
        sa.clearTargets();
        if (select.chooseTargets(oldTarget.size(), sa.isDividedAsYouChoose() ? Lists.newArrayList(oldTarget.getDividedValues()) : null, filter, optional, false)) {
            return sa.getTargets();
        }
        sa.setTargets(oldTarget);
        return null;
    }

    @Override
    public boolean chooseCardsPile(SpellAbility sa, CardCollectionView pile1, CardCollectionView pile2, String faceUp) {
        boolean result;
        block3: {
            CardView chosen;
            String p1Str = TextUtil.concatNoSpace("-- Pile 1 (", String.valueOf(pile1.size()), " cards) --");
            String p2Str = TextUtil.concatNoSpace("-- Pile 2 (", String.valueOf(pile2.size()), " cards) --");
            ArrayList<CardView> cards = Lists.newArrayListWithCapacity(pile1.size() + pile2.size() + 2);
            CardView pileView1 = new CardView(Integer.MIN_VALUE, null, p1Str);
            cards.add(pileView1);
            if (faceUp.equals("False")) {
                this.tempShowCards(pile1);
                cards.addAll(CardView.getCollection(pile1));
            }
            CardView pileView2 = new CardView(-2147483647, null, p2Str);
            cards.add(pileView2);
            if (!faceUp.equals("True")) {
                this.tempShowCards(pile2);
                cards.addAll(CardView.getCollection(pile2));
            }
            do {
                if (!(chosen = (CardView)this.getGui().one(this.localizer.getMessage("lblChooseaPile", new Object[0]), cards)).equals(pileView1)) continue;
                result = true;
                break block3;
            } while (!chosen.equals(pileView2));
            result = false;
        }
        this.endTempShowCards();
        return result;
    }

    @Override
    public void revealAnte(String message, Multimap<Player, PaperCard> removedAnteCards) {
        for (Player p : removedAnteCards.keySet()) {
            this.getGui().reveal(this.localizer.getMessage("lblActionFromPlayerDeck", message, Lang.getInstance().getPossessedObject(MessageUtil.mayBeYou(this.player, (Object)p), "")), ImmutableList.copyOf(removedAnteCards.get(p)));
        }
    }

    @Override
    public void revealAISkipCards(String message, Map<Player, Map<DeckSection, List<? extends PaperCard>>> unplayable) {
        if (GuiBase.getInterface().isLibgdxPort()) {
            for (Player p : unplayable.keySet()) {
                Map<DeckSection, List<? extends PaperCard>> removedUnplayableCards = unplayable.get(p);
                ArrayList labels = new ArrayList();
                for (DeckSection s2 : new TreeSet<DeckSection>(removedUnplayableCards.keySet())) {
                    if (DeckSection.Sideboard.equals((Object)s2)) continue;
                    labels.addAll(removedUnplayableCards.get((Object)s2));
                }
                if (labels.isEmpty()) continue;
                this.getGui().reveal(this.localizer.getMessage("lblActionFromPlayerDeck", message, Lang.getInstance().getPossessedObject(MessageUtil.mayBeYou(this.player, (Object)p), "")), ImmutableList.copyOf(labels));
            }
            return;
        }
        for (Player p : unplayable.keySet()) {
            Map<DeckSection, List<? extends PaperCard>> removedUnplayableCards = unplayable.get(p);
            ArrayList<String> labels = new ArrayList<String>();
            for (DeckSection s3 : new TreeSet<DeckSection>(removedUnplayableCards.keySet())) {
                labels.add("=== " + DeckAIUtils.getLocalizedDeckSection(this.localizer, s3) + " ===");
                labels.addAll((Collection)removedUnplayableCards.get((Object)s3));
            }
            this.getGui().reveal(this.localizer.getMessage("lblActionFromPlayerDeck", message, Lang.getInstance().getPossessedObject(MessageUtil.mayBeYou(this.player, (Object)p), "")), ImmutableList.copyOf(labels));
        }
    }

    @Override
    public List<PaperCard> chooseCardsYouWonToAddToDeck(List<PaperCard> losses) {
        return this.getGui().many(this.localizer.getMessage("lblSelectCardstoAddtoYourDeck", new Object[0]), this.localizer.getMessage("lblAddTheseToMyDeck", new Object[0]), 0, losses.size(), losses, null);
    }

    @Override
    public boolean payManaCost(ManaCost toPay, CostPartMana costPartMana, SpellAbility sa, String prompt, ManaConversionMatrix matrix, boolean effect) {
        return HumanPlay.payManaCost(this, toPay, costPartMana, sa, this.player, prompt, matrix, effect);
    }

    @Override
    public Map<Card, ManaCostShard> chooseCardsForConvokeOrImprovise(SpellAbility sa, ManaCost manaCost, CardCollectionView untappedCards, boolean improvise) {
        InputSelectCardsForConvokeOrImprovise inp = new InputSelectCardsForConvokeOrImprovise(this, this.player, manaCost, untappedCards, improvise, sa);
        inp.showAndWait();
        return inp.getConvokeMap();
    }

    @Override
    public String chooseCardName(SpellAbility sa, Predicate<ICardFace> cpp, String valid, String message) {
        ICardFace cardFace;
        PaperCard cp;
        Card instanceForPlayer;
        do {
            cardFace = this.chooseSingleCardFace(sa, message, cpp, sa.getHostCard().getName());
        } while (!(instanceForPlayer = Card.fromPaperCard(cp = FModel.getMagicDb().getCommonCards().getCard(cardFace.getName()), this.player)).isValid(valid, sa.getHostCard().getController(), sa.getHostCard(), (CardTraitBase)sa));
        return cardFace.getName();
    }

    @Override
    public Card chooseSingleCardForZoneChange(ZoneType destination, List<ZoneType> origin, SpellAbility sa, CardCollection fetchList, DelayedReveal delayedReveal, String selectPrompt, boolean isOptional, Player decider) {
        return this.chooseSingleEntityForEffect(fetchList, delayedReveal, sa, selectPrompt, isOptional, decider, null);
    }

    @Override
    public List<Card> chooseCardsForZoneChange(ZoneType destination, List<ZoneType> origin, SpellAbility sa, CardCollection fetchList, int min2, int max, DelayedReveal delayedReveal, String selectPrompt, Player decider) {
        return this.chooseEntitiesForEffect(fetchList, min2, max, delayedReveal, sa, selectPrompt, decider, null);
    }

    @Override
    public boolean isGuiPlayer() {
        return this.lobbyPlayer == GamePlayerUtil.getGuiPlayer();
    }

    public void updateAchievements() {
        AchievementCollection.updateAll(this);
    }

    public boolean canUndoLastAction() {
        if (!this.getGame().stack.canUndo(this.player)) {
            return false;
        }
        Player priorityPlayer = this.getGame().getPhaseHandler().getPriorityPlayer();
        return priorityPlayer != null && priorityPlayer == this.player;
    }

    @Override
    public void undoLastAction() {
        this.tryUndoLastAction();
    }

    public boolean tryUndoLastAction() {
        if (!this.canUndoLastAction()) {
            return false;
        }
        if (this.getGame().getStack().undo()) {
            Input currentInput = this.inputQueue.getInput();
            if (currentInput instanceof InputPassPriority) {
                currentInput.showMessageInitial();
            }
            return true;
        }
        return false;
    }

    @Override
    public void selectButtonOk() {
        this.inputProxy.selectButtonOK();
    }

    @Override
    public void selectButtonCancel() {
        this.inputProxy.selectButtonCancel();
    }

    public void confirm() {
        if (this.inputQueue.getInput() instanceof InputConfirm) {
            this.selectButtonOk();
        }
    }

    @Override
    public void passPriority() {
        this.passPriority(false);
    }

    @Override
    public void passPriorityUntilEndOfTurn() {
        this.passPriority(true);
    }

    private void passPriority(boolean passUntilEndOfTurn) {
        Input inp = this.inputProxy.getInput();
        if (inp instanceof InputPassPriority) {
            if (passUntilEndOfTurn) {
                this.autoPassUntilEndOfTurn();
            }
            inp.selectButtonOK();
        } else {
            FThreads.invokeInEdtNowOrLater(() -> {});
        }
    }

    @Override
    public void useMana(byte mana) {
        Input input = this.inputQueue.getInput();
        if (input instanceof InputPayMana) {
            ((InputPayMana)input).useManaFromPool(mana);
        }
    }

    @Override
    public void selectPlayer(PlayerView playerView, ITriggerEvent triggerEvent) {
        this.macros().addRememberedAction(new SelectPlayerAction(playerView));
        this.inputProxy.selectPlayer(playerView, triggerEvent);
    }

    @Override
    public boolean selectCard(CardView cardView, List<CardView> otherCardViewsToSelect, ITriggerEvent triggerEvent) {
        this.macros().addRememberedAction(new SelectCardAction(cardView));
        return this.inputProxy.selectCard(cardView, otherCardViewsToSelect, triggerEvent);
    }

    @Override
    public void selectAbility(SpellAbilityView sa) {
        if (this.spellViewCache == null || this.spellViewCache.isEmpty()) {
            return;
        }
        this.inputProxy.selectAbility(this.spellViewCache.get(sa));
    }

    @Override
    public void alphaStrike() {
        this.inputProxy.alphaStrike();
    }

    @Override
    public void resetAtEndOfTurn() {
    }

    @Override
    public boolean canPlayUnlimitedLands() {
        return this.canPlayUnlimitedLands;
    }

    @Override
    public IDevModeCheats cheat() {
        if (this.cheats == null) {
            this.cheats = new DevModeCheats();
        }
        return this.cheats;
    }

    public boolean hasCheated() {
        return this.cheats != null;
    }

    @Override
    public IMacroSystem macros() {
        if (this.macros == null) {
            this.macros = new RecordActionsMacroSystem(this);
        }
        return this.macros;
    }

    @Override
    public void concede() {
        if (this.player != null) {
            this.player.concede();
            this.getGame().getAction().checkGameOverCondition();
        }
    }

    public boolean mayAutoPass() {
        return this.getGui().mayAutoPass(this.getLocalPlayerView());
    }

    public void autoPassUntilEndOfTurn() {
        this.getGui().autoPassUntilEndOfTurn(this.getLocalPlayerView());
    }

    @Override
    public void autoPassCancel() {
        if (this.getGui() == null) {
            return;
        }
        this.getGui().autoPassCancel(this.getLocalPlayerView());
    }

    @Override
    public void awaitNextInput() {
        this.getGui().awaitNextInput();
    }

    @Override
    public void cancelAwaitNextInput() {
        this.getGui().cancelAwaitNextInput();
    }

    @Override
    public void resetInputs() {
        Input inp = this.inputProxy.getInput();
        if (inp != null) {
            inp.selectButtonCancel();
        }
    }

    @Override
    public void nextGameDecision(NextGameDecision decision) {
        this.gameView.getMatch().fireEvent(new UiEventNextGameDecision(this, decision));
    }

    @Override
    public String getActivateDescription(CardView card) {
        return this.getInputProxy().getActivateAction(card);
    }

    @Override
    public void reorderHand(CardView card, int index) {
        PlayerZone hand = this.player.getZone(ZoneType.Hand);
        hand.reorder(this.getCard(card), index);
        this.player.updateZoneForView(hand);
    }

    @Override
    public String chooseCardName(SpellAbility sa, List<ICardFace> faces, String message) {
        ICardFace face = this.chooseSingleCardFace(sa, faces, message);
        return face == null ? "" : face.getName();
    }

    @Override
    public Card chooseDungeon(Player player, List<PaperCard> dungeonCards, String message) {
        PaperCard dungeon = this.getGui().one(message, dungeonCards);
        return Card.fromPaperCard(dungeon, player);
    }

    @Override
    public List<Card> chooseCardsForSplice(SpellAbility sa, List<Card> cards) {
        GameEntityViewMap gameCacheSplice = GameEntityView.getMap(cards);
        List chosen = this.getGui().many(this.localizer.getMessage("lblChooseCardstoSpliceonto", new Object[0]), this.localizer.getMessage("lblChosenCards", new Object[0]), 0, gameCacheSplice.size(), gameCacheSplice.getTrackableKeys(), sa.getHostCard().getView());
        CardCollection chosenCards = new CardCollection();
        gameCacheSplice.addToList(chosen, chosenCards);
        return chosenCards;
    }

    @Override
    public List<OptionalCostValue> chooseOptionalCosts(SpellAbility choosen, List<OptionalCostValue> optionalCost) {
        return this.getGui().many(this.localizer.getMessage("lblChooseOptionalCosts", new Object[0]), this.localizer.getMessage("lblOptionalCosts", new Object[0]), 0, optionalCost.size(), optionalCost, choosen.getHostCard().getView());
    }

    @Override
    public boolean confirmMulliganScry(Player p) {
        return InputConfirm.confirm(this, (SpellAbility)null, this.localizer.getMessage("lblDoYouWanttoScry", new Object[0]));
    }

    @Override
    public int chooseNumberForKeywordCost(SpellAbility sa, Cost cost, KeywordInterface keyword, String prompt, int max) {
        if (max <= 0) {
            return 0;
        }
        if (max == 1) {
            return InputConfirm.confirm(this, sa, prompt) ? 1 : 0;
        }
        Integer v = this.getGui().getInteger(prompt, 0, max, 9);
        return v == null ? 0 : v;
    }

    @Override
    public int chooseNumberForCostReduction(SpellAbility sa, int min2, int max) {
        if (this.fullControl) {
            return this.chooseNumber(sa, this.localizer.getMessage("lblChooseAmountCostReduction", new Object[0]), min2, max);
        }
        return max;
    }

    @Override
    public CardCollection chooseCardsForEffectMultiple(Map<String, CardCollection> validMap, SpellAbility sa, String title, boolean isOptional) {
        CardCollection result = new CardCollection();
        for (Map.Entry<String, CardCollection> e : validMap.entrySet()) {
            result.addAll(this.chooseCardsForEffect(e.getValue(), sa, title + " (" + e.getKey() + ")", 0, 1, isOptional, null));
        }
        return result;
    }

    public Card getCard(CardView cardView) {
        return this.getGame().findByView(cardView);
    }

    public CardCollection getCardList(Iterable<CardView> cardViews) {
        CardCollection result = new CardCollection();
        for (CardView cardView : cardViews) {
            Card c = this.getCard(cardView);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    public class DevModeCheats
    implements IDevModeCheats {
        private CardFaceView lastAdded;
        private ZoneType lastAddedZone;
        private Player lastAddedPlayer;
        private SpellAbility lastAddedSA;
        private boolean lastTrigs;
        private boolean lastSummoningSickness;
        private boolean lastTopOfTheLibrary;

        private DevModeCheats() {
        }

        @Override
        public void setCanPlayUnlimitedLands(boolean canPlayUnlimitedLands0) {
            PlayerControllerHuman.this.canPlayUnlimitedLands = canPlayUnlimitedLands0;
            PlayerControllerHuman.this.getGame().fireEvent(new GameEventPlayerStatsChanged(PlayerControllerHuman.this.player, false));
        }

        @Override
        public void setViewAllCards(boolean canViewAll) {
            PlayerControllerHuman.this.mayLookAtAllCards = canViewAll;
            for (Player p : PlayerControllerHuman.this.getGame().getPlayers()) {
                PlayerControllerHuman.this.getGui().updateCards(CardView.getCollection(p.getAllCards()));
            }
        }

        @Override
        public void generateMana() {
            Player pPriority = PlayerControllerHuman.this.getGame().getPhaseHandler().getPriorityPlayer();
            if (pPriority == null) {
                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblNoPlayerHasPriorityCannotAddedManaToPool", new Object[0]));
                return;
            }
            Card dummy = new Card(-777777, PlayerControllerHuman.this.getGame());
            dummy.setOwner(pPriority);
            HashMap<String, String> produced = Maps.newHashMap();
            produced.put("Produced", "W W W W W W W U U U U U U U B B B B B B B G G G G G G G R R R R R R R 7");
            AbilityManaPart abMana = new AbilityManaPart(dummy, produced);
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> abMana.produceMana(null));
        }

        @Override
        public void rollbackPhase() {
            Player pPriority = PlayerControllerHuman.this.getGame().getPhaseHandler().getPriorityPlayer();
            if (pPriority == null) {
                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblNoPlayerPriorityGameStateCannotBeSetup", new Object[0]));
                return;
            }
            if (PlayerControllerHuman.this.getGui().getGamestate() != null) {
                PlayerControllerHuman.this.getGui().getGamestate().applyToGame(PlayerControllerHuman.this.getGame());
            }
        }

        private GameState createGameStateObject() {
            return new GameState(){

                @Override
                public IPaperCard getPaperCard(String cardName, String setCode, int artID) {
                    return FModel.getMagicDb().getCommonCards().getCard(cardName, setCode, artID);
                }
            };
        }

        @Override
        public void dumpGameState() {
            block8: {
                GameState state = this.createGameStateObject();
                try {
                    state.initFromGame(PlayerControllerHuman.this.getGame());
                    File f = GuiBase.getInterface().getSaveFile(new File(ForgeConstants.USER_GAMES_DIR, "state.txt"));
                    if (f == null || f.exists() && !PlayerControllerHuman.this.getGui().showConfirmDialog(PlayerControllerHuman.this.localizer.getMessage("lblOverwriteExistFileConfirm", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblFileExists", new Object[0]))) break block8;
                    try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
                        bw.write(state.toString());
                    }
                }
                catch (Exception e) {
                    String err = e.getClass().getName();
                    if (e.getMessage() != null) {
                        err = err + ": " + e.getMessage();
                    }
                    PlayerControllerHuman.this.getGui().showErrorDialog(err);
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void setupGameState() {
            String filename;
            File gamesDir = new File(ForgeConstants.USER_GAMES_DIR);
            if (!gamesDir.exists()) {
                gamesDir.mkdir();
            }
            if ((filename = GuiBase.getInterface().showFileDialog(PlayerControllerHuman.this.localizer.getMessage("lblSelectGameStateFile", new Object[0]), ForgeConstants.USER_GAMES_DIR)) == null) {
                return;
            }
            GameState state = this.createGameStateObject();
            try {
                FileInputStream fstream = new FileInputStream(filename);
                state.parse(fstream);
                fstream.close();
            }
            catch (FileNotFoundException fnfe) {
                SOptionPane.showErrorDialog(PlayerControllerHuman.this.localizer.getMessage("lblFileNotFound", new Object[0]) + ": " + filename);
                return;
            }
            catch (Exception e) {
                SOptionPane.showErrorDialog(PlayerControllerHuman.this.localizer.getMessage("lblErrorLoadingBattleSetupFile", new Object[0]));
                return;
            }
            Player pPriority = PlayerControllerHuman.this.getGame().getPhaseHandler().getPriorityPlayer();
            if (pPriority == null) {
                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblNoPlayerPriorityGameStateCannotBeSetup", new Object[0]));
                return;
            }
            state.applyToGame(PlayerControllerHuman.this.getGame());
        }

        @Override
        public void tutorForCard() {
            Player pPriority = PlayerControllerHuman.this.getGame().getPhaseHandler().getPriorityPlayer();
            if (pPriority == null) {
                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblNoPlayerPriorityDeckCantBeTutoredFrom", new Object[0]));
                return;
            }
            CardCollection lib = (CardCollection)pPriority.getCardsIn(ZoneType.Library);
            ArrayList<ZoneType> origin = Lists.newArrayList();
            origin.add(ZoneType.Library);
            SpellAbility.EmptySa sa = new SpellAbility.EmptySa(new Card(-1, PlayerControllerHuman.this.getGame()));
            Card card = PlayerControllerHuman.this.chooseSingleCardForZoneChange(ZoneType.Hand, origin, sa, lib, null, PlayerControllerHuman.this.localizer.getMessage("lblChooseaCard", new Object[0]), true, pPriority);
            if (card == null) {
                return;
            }
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> PlayerControllerHuman.this.getGame().getAction().moveToHand(card, null));
        }

        @Override
        public void addCountersToPermanent() {
            this.modifyCountersOnPermanent(false);
        }

        @Override
        public void removeCountersFromPermanent() {
            this.modifyCountersOnPermanent(true);
        }

        public void modifyCountersOnPermanent(boolean subtract) {
            String titleMsg = subtract ? PlayerControllerHuman.this.localizer.getMessage("lblRemoveCountersFromWhichCard", new Object[0]) : PlayerControllerHuman.this.localizer.getMessage("lblAddCountersToWhichCard", new Object[0]);
            GameEntityViewMap gameCacheCounters = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getCardsIn(ZoneType.Battlefield));
            CardView cv = (CardView)PlayerControllerHuman.this.getGui().oneOrNone(titleMsg, gameCacheCounters.getTrackableKeys());
            if (cv == null || !gameCacheCounters.containsKey(cv)) {
                return;
            }
            Card card = (Card)gameCacheCounters.get(cv);
            ImmutableList<CounterType> counters = subtract ? ImmutableList.copyOf(card.getCounters().keySet()) : ImmutableList.copyOf(Collections2.transform(CounterEnumType.values, CounterType::get));
            CounterType counter = PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblWhichTypeofCounter", new Object[0]), counters);
            if (counter == null) {
                return;
            }
            Integer count = PlayerControllerHuman.this.getGui().getInteger(PlayerControllerHuman.this.localizer.getMessage("lblHowManyCounters", new Object[0]), 1, Integer.MAX_VALUE, 10);
            if (count == null) {
                return;
            }
            if (subtract) {
                card.subtractCounter(counter, (int)count, null);
            } else {
                card.addCounterInternal(counter, (int)count, card.getController(), false, null, null);
            }
        }

        @Override
        public void tapPermanents() {
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> {
                CardCollection untapped = CardLists.filter((Iterable<Card>)PlayerControllerHuman.this.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.UNTAPPED);
                InputSelectCardsFromList inp = new InputSelectCardsFromList(PlayerControllerHuman.this, 0, Integer.MAX_VALUE, untapped);
                inp.setCancelAllowed(true);
                inp.setMessage(PlayerControllerHuman.this.localizer.getMessage("lblChoosePermanentstoTap", new Object[0]));
                inp.showAndWait();
                if (!inp.hasCancelled()) {
                    CardCollection tapped = new CardCollection();
                    for (Card c : inp.getSelected()) {
                        if (!c.tap(true, null, null)) continue;
                        tapped.add(c);
                    }
                    if (!tapped.isEmpty()) {
                        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                        runParams.put(AbilityKey.Cards, tapped);
                        PlayerControllerHuman.this.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
                    }
                }
            });
        }

        @Override
        public void untapPermanents() {
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> {
                CardCollection tapped = CardLists.filter((Iterable<Card>)PlayerControllerHuman.this.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.TAPPED);
                InputSelectCardsFromList inp = new InputSelectCardsFromList(PlayerControllerHuman.this, 0, Integer.MAX_VALUE, tapped);
                inp.setCancelAllowed(true);
                inp.setMessage(PlayerControllerHuman.this.localizer.getMessage("lblChoosePermanentstoUntap", new Object[0]));
                inp.showAndWait();
                if (!inp.hasCancelled()) {
                    CardCollection untapped = new CardCollection();
                    for (Card c : inp.getSelected()) {
                        if (!c.untap(true)) continue;
                        untapped.add(c);
                    }
                    if (!untapped.isEmpty()) {
                        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                        HashMap<Player, CardCollection> map = Maps.newHashMap();
                        map.put(PlayerControllerHuman.this.getPlayer(), untapped);
                        runParams.put(AbilityKey.Map, map);
                        PlayerControllerHuman.this.getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
                    }
                }
            });
        }

        @Override
        public void setPlayerLife() {
            GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
            PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblSetLifeforWhichPlayer", new Object[0]), gameCachePlayer.getTrackableKeys());
            if (pv == null || !gameCachePlayer.containsKey(pv)) {
                return;
            }
            Player player = (Player)gameCachePlayer.get(pv);
            Integer life = PlayerControllerHuman.this.getGui().getInteger(PlayerControllerHuman.this.localizer.getMessage("lblSetLifetoWhat", new Object[0]), 0);
            if (life == null) {
                return;
            }
            player.setLife(life, null);
        }

        @Override
        public void winGame() {
            Input input = PlayerControllerHuman.this.inputQueue.getInput();
            if (!(input instanceof InputPassPriority)) {
                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblYouMustHavePrioritytoUseThisFeature", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblWinGame", new Object[0]));
                return;
            }
            LobbyPlayer guiPlayer = PlayerControllerHuman.this.getLobbyPlayer();
            PlayerCollection players = PlayerControllerHuman.this.getGame().getPlayers();
            for (Player player : players) {
                if (player.getLobbyPlayer() == guiPlayer) continue;
                player.setLife(0, null);
            }
            input.selectButtonOK();
        }

        @Override
        public void addCardToHand() {
            this.addCardToZone(ZoneType.Hand, false, false);
        }

        @Override
        public void addCardToBattlefield() {
            this.addCardToZone(ZoneType.Battlefield, false, true);
        }

        @Override
        public void addCardToLibrary() {
            this.addCardToZone(ZoneType.Library, false, false);
        }

        @Override
        public void addCardToGraveyard() {
            this.addCardToZone(ZoneType.Graveyard, false, false);
        }

        @Override
        public void addCardToExile() {
            this.addCardToZone(ZoneType.Exile, false, false);
        }

        @Override
        public void castASpell() {
            this.addCardToZone(ZoneType.Battlefield, false, false);
        }

        @Override
        public void repeatLastAddition() {
            if (this.lastAdded == null) {
                return;
            }
            this.addCardToZone(null, true, this.lastTrigs);
        }

        private void addCardToZone(ZoneType zone, boolean repeatLast, boolean noTriggers) {
            CardFaceView f;
            ZoneType targetZone = repeatLast ? this.lastAddedZone : zone;
            String message = null;
            message = targetZone != ZoneType.Battlefield ? PlayerControllerHuman.this.localizer.getMessage("lblPutCardInWhichPlayerZone", targetZone.getTranslatedName().toLowerCase()) : (noTriggers ? PlayerControllerHuman.this.localizer.getMessage("lblPutCardInWhichPlayerBattlefield", new Object[0]) : PlayerControllerHuman.this.localizer.getMessage("lblPutCardInWhichPlayerPlayOrStack", new Object[0]));
            Player pOld = this.lastAddedPlayer;
            if (repeatLast) {
                if (pOld == null) {
                    return;
                }
            } else {
                GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
                PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(message, gameCachePlayer.getTrackableKeys());
                if (pv == null || !gameCachePlayer.containsKey(pv)) {
                    return;
                }
                pOld = (Player)gameCachePlayer.get(pv);
            }
            Player p = pOld;
            CardDb carddb = FModel.getMagicDb().getCommonCards();
            ArrayList<ICardFace> faces = Lists.newArrayList(carddb.getAllFaces());
            ArrayList<CardFaceView> choices = new ArrayList<CardFaceView>();
            for (ICardFace cardFace : faces) {
                CardFaceView cardFaceView = new CardFaceView(CardTranslation.getTranslatedName(cardFace.getName()), cardFace.getName());
                choices.add(cardFaceView);
            }
            Collections.sort(choices);
            CardFaceView cardFaceView = f = repeatLast ? this.lastAdded : (CardFaceView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblNameTheCard", new Object[0]), choices);
            if (f == null) {
                return;
            }
            PaperCard c = carddb.getUniqueByName(f.getOracleName());
            Card forgeCard = Card.fromPaperCard(c, p);
            forgeCard.setGameTimestamp(PlayerControllerHuman.this.getGame().getNextTimestamp());
            PaperCard finalC = c;
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> {
                block21: {
                    block22: {
                        block23: {
                            if (targetZone != ZoneType.Battlefield) break block22;
                            if (!forgeCard.getName().equals(f.getName())) {
                                if (forgeCard.getRules().getSplitType().equals((Object)CardSplitType.Specialize)) {
                                    for (Map.Entry<CardStateName, ICardFace> e : forgeCard.getRules().getSpecializeParts().entrySet()) {
                                        if (!f.getName().equals(e.getValue().getName())) continue;
                                        forgeCard.changeToState(e.getKey());
                                        break;
                                    }
                                } else {
                                    forgeCard.changeToState(forgeCard.getRules().getSplitType().getChangedStateName());
                                    if (forgeCard.getCurrentStateName().equals((Object)CardStateName.Transformed) || forgeCard.getCurrentStateName().equals((Object)CardStateName.Modal)) {
                                        forgeCard.setBackSide(true);
                                    }
                                }
                            }
                            if (!noTriggers) break block23;
                            if (forgeCard.isPermanent() && !forgeCard.isAura()) {
                                if (forgeCard.isCreature() && !repeatLast) {
                                    this.lastSummoningSickness = forgeCard.hasKeyword(Keyword.HASTE) ? true : PlayerControllerHuman.this.getGui().confirm(forgeCard.getView(), PlayerControllerHuman.this.localizer.getMessage("lblCardShouldBeSummoningSicknessConfirm", CardTranslation.getTranslatedName(forgeCard.getName())));
                                }
                                PlayerControllerHuman.this.getGame().getAction().moveTo(targetZone, forgeCard, null, AbilityKey.newMap());
                                if (forgeCard.isCreature()) {
                                    forgeCard.setSickness(this.lastSummoningSickness);
                                }
                                break block21;
                            } else {
                                PlayerControllerHuman.this.getGui().message(PlayerControllerHuman.this.localizer.getMessage("lblChosenCardNotPermanentorCantExistIndependentlyontheBattleground", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblError", new Object[0]));
                                return;
                            }
                        }
                        if (finalC.getRules().getType().isLand()) {
                            PlayerControllerHuman.this.getGame().getAction().moveToHand(forgeCard, null);
                            PlayerControllerHuman.this.getGame().getAction().moveToPlay(forgeCard, null, null);
                            PlayerControllerHuman.this.getGame().getTriggerHandler().runWaitingTriggers();
                        } else {
                            SpellAbility sa;
                            FCollectionView<SpellAbility> choices1 = forgeCard.getBasicSpells();
                            if (choices1.isEmpty()) {
                                return;
                            }
                            if (choices1.size() == 1) {
                                sa = (SpellAbility)choices1.iterator().next();
                            } else {
                                SpellAbility spellAbility = sa = repeatLast ? this.lastAddedSA : (SpellAbility)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblChoose", new Object[0]), (FCollection)choices1);
                            }
                            if (sa == null) {
                                return;
                            }
                            this.lastAddedSA = sa;
                            PlayerControllerHuman.this.getGame().getAction().moveToHand(forgeCard, null);
                            sa.setActivatingPlayer(p);
                            sa.setCastFromPlayEffect(true);
                            HumanPlay.playSaWithoutPayingManaCost(PlayerControllerHuman.this, PlayerControllerHuman.this.getGame(), sa, true);
                        }
                        PlayerControllerHuman.this.getGame().getStack().addAllTriggeredAbilitiesToStack();
                        break block21;
                    }
                    if (targetZone == ZoneType.Library) {
                        if (!repeatLast) {
                            this.lastTopOfTheLibrary = PlayerControllerHuman.this.getGui().confirm(forgeCard.getView(), PlayerControllerHuman.this.localizer.getMessage("lblCardShouldBeAddedToLibraryTopOrBottom", CardTranslation.getTranslatedName(forgeCard.getName())), true, Arrays.asList(PlayerControllerHuman.this.localizer.getMessage("lblTop", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblBottom", new Object[0])));
                        }
                        if (this.lastTopOfTheLibrary) {
                            PlayerControllerHuman.this.getGame().getAction().moveToLibrary(forgeCard, null);
                        } else {
                            PlayerControllerHuman.this.getGame().getAction().moveToBottomOfLibrary(forgeCard, null);
                        }
                    } else {
                        PlayerControllerHuman.this.getGame().getAction().moveTo(targetZone, forgeCard, null, AbilityKey.newMap());
                    }
                }
                this.lastAdded = f;
                this.lastAddedZone = targetZone;
                this.lastAddedPlayer = p;
                this.lastTrigs = noTriggers;
            });
        }

        @Override
        public void exileCardsFromHand() {
            GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
            PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblExileCardsFromPlayerHandConfirm", new Object[0]), gameCachePlayer.getTrackableKeys());
            if (pv == null || !gameCachePlayer.containsKey(pv)) {
                return;
            }
            Player p = (Player)gameCachePlayer.get(pv);
            CardCollectionView inHand = p.getCardsIn(ZoneType.Hand);
            GameEntityViewMap gameCacheExile = GameEntityView.getMap(inHand);
            List views = PlayerControllerHuman.this.getGui().many(PlayerControllerHuman.this.localizer.getMessage("lblChooseCardsExile", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblDiscarded", new Object[0]), 0, inHand.size(), gameCacheExile.getTrackableKeys(), null);
            CardCollection selection = new CardCollection();
            gameCacheExile.addToList(views, selection);
            for (Card c : selection) {
                if (c == null) continue;
                if (PlayerControllerHuman.this.getGame().getAction().moveTo(ZoneType.Exile, c, null, AbilityKey.newMap()) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(p).append(" exiles ").append(c).append(" due to Dev Cheats.");
                    PlayerControllerHuman.this.getGame().getGameLog().add(GameLogEntryType.DISCARD, sb.toString());
                    continue;
                }
                PlayerControllerHuman.this.getGame().getGameLog().add(GameLogEntryType.INFORMATION, "DISCARD CHEAT ERROR");
            }
        }

        @Override
        public void exileCardsFromBattlefield() {
            GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
            PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblExileCardsFromPlayerBattlefieldConfirm", new Object[0]), gameCachePlayer.getTrackableKeys());
            if (pv == null || !gameCachePlayer.containsKey(pv)) {
                return;
            }
            Player p = (Player)gameCachePlayer.get(pv);
            CardCollectionView otb = p.getCardsIn(ZoneType.Battlefield);
            GameEntityViewMap gameCacheExile = GameEntityView.getMap(otb);
            List views = PlayerControllerHuman.this.getGui().many(PlayerControllerHuman.this.localizer.getMessage("lblChooseCardsExile", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblDiscarded", new Object[0]), 0, otb.size(), gameCacheExile.getTrackableKeys(), null);
            CardCollection selection = new CardCollection();
            gameCacheExile.addToList(views, selection);
            for (Card c : selection) {
                if (c == null) continue;
                if (PlayerControllerHuman.this.getGame().getAction().moveTo(ZoneType.Exile, c, null, AbilityKey.newMap()) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(p).append(" exiles ").append(c).append(" due to Dev Cheats.");
                    PlayerControllerHuman.this.getGame().getGameLog().add(GameLogEntryType.ZONE_CHANGE, sb.toString());
                    continue;
                }
                PlayerControllerHuman.this.getGame().getGameLog().add(GameLogEntryType.INFORMATION, "EXILE FROM PLAY CHEAT ERROR");
            }
        }

        @Override
        public void removeCardsFromGame() {
            GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
            PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblRemoveCardBelongingWitchPlayer", new Object[0]), gameCachePlayer.getTrackableKeys());
            if (pv == null || !gameCachePlayer.containsKey(pv)) {
                return;
            }
            Player p = (Player)gameCachePlayer.get(pv);
            String zone = PlayerControllerHuman.this.getGui().one(PlayerControllerHuman.this.localizer.getMessage("lblRemoveCardFromWhichZone", new Object[0]), Arrays.asList("Hand", "Battlefield", "Library", "Graveyard", "Exile"));
            CardCollectionView cards = p.getCardsIn(ZoneType.smartValueOf(zone));
            GameEntityViewMap gameCacheExile = GameEntityView.getMap(cards);
            List views = PlayerControllerHuman.this.getGui().many(PlayerControllerHuman.this.localizer.getMessage("lblChooseCardsRemoveFromGame", new Object[0]), PlayerControllerHuman.this.localizer.getMessage("lblRemoved", new Object[0]), 0, cards.size(), gameCacheExile.getTrackableKeys(), null);
            CardCollection selection = new CardCollection();
            gameCacheExile.addToList(views, selection);
            for (Card c : selection) {
                if (c == null) continue;
                c.getGame().getAction().ceaseToExist(c, true);
                StringBuilder sb = new StringBuilder();
                sb.append(p).append(" removes ").append(c).append(" from game due to Dev Cheats.");
                PlayerControllerHuman.this.getGame().getGameLog().add(GameLogEntryType.ZONE_CHANGE, sb.toString());
            }
        }

        @Override
        public void riggedPlanarRoll() {
            GameEntityViewMap gameCachePlayer = GameEntityView.getMap(PlayerControllerHuman.this.getGame().getPlayers());
            PlayerView pv = (PlayerView)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblWhichPlayerShouldRoll", new Object[0]), gameCachePlayer.getTrackableKeys());
            if (pv == null || !gameCachePlayer.containsKey(pv)) {
                return;
            }
            Player player = (Player)gameCachePlayer.get(pv);
            PlanarDice res = PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblChooseResult", new Object[0]), PlanarDice.values);
            if (res == null) {
                return;
            }
            System.out.println("Rigging planar dice roll: " + res.toString());
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> PlanarDice.roll(player, res));
        }

        @Override
        public void planeswalkTo() {
            if (!PlayerControllerHuman.this.getGame().getRules().hasAppliedVariant(GameType.Planechase)) {
                return;
            }
            Player p = PlayerControllerHuman.this.getGame().getPhaseHandler().getPlayerTurn();
            ArrayList<PaperCard> allPlanars = Lists.newArrayList();
            for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
                if (!c.getRules().getType().isPlane() && !c.getRules().getType().isPhenomenon()) continue;
                allPlanars.add(c);
            }
            Collections.sort(allPlanars);
            IPaperCard c = (IPaperCard)PlayerControllerHuman.this.getGui().oneOrNone(PlayerControllerHuman.this.localizer.getMessage("lblNameTheCard", new Object[0]), allPlanars);
            if (c == null) {
                return;
            }
            Card forgeCard = Card.fromPaperCard(c, p);
            PlayerControllerHuman.this.getGame().getAction().invoke(() -> {
                PlayerControllerHuman.this.getGame().getAction().changeZone(null, p.getZone(ZoneType.PlanarDeck), forgeCard, 0, null);
                PlanarDice.roll(p, PlanarDice.Planeswalk);
            });
        }

        @Override
        public void askAI(boolean useSimulation) {
            PlayerControllerAi ai = new PlayerControllerAi(PlayerControllerHuman.this.player.getGame(), PlayerControllerHuman.this.player, PlayerControllerHuman.this.player.getOriginalLobbyPlayer());
            ai.setUseSimulation(useSimulation);
            PlayerControllerHuman.this.player.runWithController(() -> {
                List<SpellAbility> sas = ai.chooseSpellAbilityToPlay();
                SpellAbility chosen = sas == null ? null : sas.get(0);
                PlayerControllerHuman.this.getGui().message(chosen == null ? "AI doesn't want to play anything right now" : chosen.getHostCard().toString(), "AI Play Suggestion");
            }, ai);
        }
    }

    private static final class FnTargetToString
    implements Function<Pair<SpellAbilityStackInstance, GameObject>, String>,
    Serializable {
        private static final long serialVersionUID = -4779137632302777802L;

        private FnTargetToString() {
        }

        @Override
        public String apply(Pair<SpellAbilityStackInstance, GameObject> targ) {
            return targ.getRight().toString() + " - " + targ.getLeft().getStackDescription();
        }
    }
}

