/*
 * Decompiled with CFR 0.152.
 */
package forge.player;

import forge.LobbyPlayer;
import forge.ai.AIOption;
import forge.ai.AiProfileUtil;
import forge.ai.LobbyPlayerAi;
import forge.gui.GuiBase;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.LobbyPlayerHuman;
import forge.util.GuiDisplayUtil;
import forge.util.MyRandom;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class GamePlayerUtil {
    private static final LobbyPlayer guiPlayer = new LobbyPlayerHuman("Human");

    private GamePlayerUtil() {
    }

    public static LobbyPlayer getGuiPlayer() {
        return guiPlayer;
    }

    public static LobbyPlayer getGuiPlayer(String name, int avatarIndex, int sleeveIndex, boolean writePref) {
        if (writePref) {
            if (!name.equals(guiPlayer.getName())) {
                guiPlayer.setName(name);
                FModel.getPreferences().setPref(ForgePreferences.FPref.PLAYER_NAME, name);
                FModel.getPreferences().save();
            }
            guiPlayer.setAvatarIndex(avatarIndex);
            guiPlayer.setSleeveIndex(sleeveIndex);
            return guiPlayer;
        }
        return new LobbyPlayerHuman(name, avatarIndex, sleeveIndex);
    }

    public static LobbyPlayer getQuestPlayer() {
        return guiPlayer;
    }

    public static LobbyPlayer createAiPlayer() {
        return GamePlayerUtil.createAiPlayer(GuiDisplayUtil.getRandomAiName());
    }

    public static LobbyPlayer createAiPlayer(String name) {
        int avatarCount = GuiBase.getInterface().getAvatarCount();
        int sleeveCount = GuiBase.getInterface().getSleevesCount();
        return GamePlayerUtil.createAiPlayer(name, avatarCount == 0 ? 0 : MyRandom.getRandom().nextInt(avatarCount), sleeveCount == 0 ? 0 : MyRandom.getRandom().nextInt(sleeveCount));
    }

    public static LobbyPlayer createAiPlayer(String name, String profileOverride) {
        int avatarCount = GuiBase.getInterface().getAvatarCount();
        int sleeveCount = GuiBase.getInterface().getSleevesCount();
        return GamePlayerUtil.createAiPlayer(name, avatarCount == 0 ? 0 : MyRandom.getRandom().nextInt(avatarCount), sleeveCount == 0 ? 0 : MyRandom.getRandom().nextInt(sleeveCount), null, profileOverride);
    }

    public static LobbyPlayer createAiPlayer(String name, int avatarIndex) {
        int sleeveCount = GuiBase.getInterface().getSleevesCount();
        return GamePlayerUtil.createAiPlayer(name, avatarIndex, sleeveCount == 0 ? 0 : MyRandom.getRandom().nextInt(sleeveCount), null, "");
    }

    public static LobbyPlayer createAiPlayer(String name, int avatarIndex, int sleeveIndex) {
        return GamePlayerUtil.createAiPlayer(name, avatarIndex, sleeveIndex, null, "");
    }

    public static LobbyPlayer createAiPlayer(String name, int avatarIndex, int sleeveIndex, Set<AIOption> options) {
        return GamePlayerUtil.createAiPlayer(name, avatarIndex, sleeveIndex, options, "");
    }

    public static LobbyPlayer createAiPlayer(String name, int avatarIndex, int sleeveIndex, Set<AIOption> options, String profileOverride) {
        LobbyPlayerAi player = new LobbyPlayerAi(name, options);
        String profile = "";
        if (profileOverride.isEmpty()) {
            String lastProfileChosen = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CURRENT_AI_PROFILE);
            if (!AiProfileUtil.getProfilesDisplayList().contains(lastProfileChosen)) {
                System.out.println("[AI Preferences] Unknown profile " + lastProfileChosen + " was requested, resetting to default.");
                lastProfileChosen = "Default";
                FModel.getPreferences().setPref(ForgePreferences.FPref.UI_CURRENT_AI_PROFILE, "Default");
                FModel.getPreferences().save();
            }
            player.setRotateProfileEachGame(lastProfileChosen.equals("Random (Every Game)"));
            if (lastProfileChosen.equals("Random (Every Match)")) {
                lastProfileChosen = AiProfileUtil.getRandomProfile();
            }
            profile = lastProfileChosen;
        } else {
            profile = profileOverride;
        }
        assert (!profile.isEmpty());
        player.setAiProfile(profile);
        player.setAvatarIndex(avatarIndex);
        player.setSleeveIndex(sleeveIndex);
        return player;
    }

    public static void setPlayerName() {
        String newPlayerName;
        String oldPlayerName = FModel.getPreferences().getPref(ForgePreferences.FPref.PLAYER_NAME);
        try {
            newPlayerName = StringUtils.isBlank(oldPlayerName) ? GamePlayerUtil.getVerifiedPlayerName(GamePlayerUtil.getPlayerNameUsingFirstTimePrompt(), oldPlayerName) : GamePlayerUtil.getVerifiedPlayerName(GamePlayerUtil.getPlayerNameUsingStandardPrompt(oldPlayerName), oldPlayerName);
        }
        catch (IllegalStateException ise) {
            newPlayerName = StringUtils.isBlank(oldPlayerName) ? "Human" : oldPlayerName;
        }
        FModel.getPreferences().setPref(ForgePreferences.FPref.PLAYER_NAME, newPlayerName);
        FModel.getPreferences().save();
        if (StringUtils.isBlank(oldPlayerName) && !newPlayerName.equals("Human")) {
            GamePlayerUtil.showThankYouPrompt(newPlayerName);
        }
    }

    private static void showThankYouPrompt(String playerName) {
        SOptionPane.showMessageDialog("Thank you, " + playerName + ". You will not be prompted again but you can change\nyour name at any time using the \"Player Name\" setting in Preferences\nor via the constructed match setup screen\n");
    }

    private static String getPlayerNameUsingFirstTimePrompt() {
        return SOptionPane.showInputDialog("By default, Forge will refer to you as the \"Human\" during gameplay.\nIf you would prefer a different name please enter it now.", "Personalize Forge Gameplay", SOptionPane.QUESTION_ICON);
    }

    private static String getPlayerNameUsingStandardPrompt(String playerName) {
        return SOptionPane.showInputDialog("Please enter a new name. (alpha-numeric only)", "Personalize Forge Gameplay", null, playerName);
    }

    private static String getVerifiedPlayerName(String newName, String oldName) {
        newName = newName == null || !StringUtils.isAlphanumericSpace(newName) ? (StringUtils.isBlank(oldName) ? "Human" : oldName) : (StringUtils.isWhitespace(newName) ? "Human" : newName.trim());
        return newName;
    }
}

