/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Graphics;
import forge.assets.FImage;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;

public class FSubMenu
extends FMenuItem {
    FPopupMenu popupMenu;

    public FSubMenu(String text0, FPopupMenu popupMenu0) {
        this(text0, null, popupMenu0, true);
    }

    public FSubMenu(String text0, FPopupMenu popupMenu0, boolean enabled0) {
        this(text0, null, popupMenu0, enabled0);
    }

    public FSubMenu(String text0, FImage icon0, FPopupMenu popupMenu0) {
        this(text0, icon0, popupMenu0, true);
    }

    public FSubMenu(String text0, FImage icon0, FPopupMenu popupMenu0, boolean enabled0) {
        super(text0, icon0, null, enabled0);
        this.popupMenu = popupMenu0;
    }

    @Override
    protected boolean showPressedColor() {
        return super.showPressedColor() || this.popupMenu.isVisible();
    }

    @Override
    public boolean tap(float x, float y, int count) {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.hide();
        } else {
            this.popupMenu.show(this, this.getWidth(), 0.0f);
        }
        return true;
    }

    @Override
    public void draw(Graphics g2) {
        float x1;
        super.draw(g2);
        float divotWidth = DIVOT_WIDTH;
        float divotHeight = divotWidth * 2.0f;
        float x2 = this.getWidth() - GAP_X - 1.0f;
        float x3 = x1 = x2 - divotWidth;
        float y2 = this.getHeight() / 2.0f;
        float y1 = y2 - divotHeight / 2.0f;
        float y3 = y2 + divotHeight / 2.0f;
        g2.fillTriangle(FSubMenu.getForeColor(), x1, y1, x2, y2, x3, y3);
    }
}

