/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.screens.FScreen;
import forge.toolbox.FButton;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;

public abstract class FPopupMenu
extends FDropDownMenu {
    private FDisplayObject owner;
    private float x;
    private float y;
    private Vector2 pressPoint;
    private Vector2 fixedSize;

    public void show(FDisplayObject owner0, float x0, float y0) {
        this.owner = owner0;
        this.x = this.owner.localToScreenX(x0);
        this.y = this.owner.localToScreenY(y0);
        if (this.owner instanceof FLabel || this.owner instanceof FButton) {
            this.owner.press(x0, y0);
            this.pressPoint = new Vector2(x0, y0);
        }
        this.show();
    }

    public void show(float screenX, float screenY, float fixedWidth, float fixedHeight) {
        this.x = screenX;
        this.y = screenY;
        this.fixedSize = new Vector2(fixedWidth, fixedHeight);
        this.setDropDownContainer(Forge.getCurrentScreen());
        this.show();
    }

    @Override
    protected FDisplayObject getDropDownOwner() {
        return this.owner;
    }

    @Override
    protected void onHidden() {
        if (this.pressPoint != null) {
            this.owner.release(this.pressPoint.x, this.pressPoint.y);
            this.pressPoint = null;
        }
        this.owner = null;
        this.fixedSize = null;
    }

    @Override
    protected void updateSizeAndPosition() {
        if (this.fixedSize != null) {
            this.paneSize = this.updateAndGetPaneSize(this.fixedSize.x, this.fixedSize.y);
            this.setBounds(this.x, this.y, this.fixedSize.x, this.fixedSize.y);
            for (FMenuItem item : this.items) {
                item.setTabMode(true);
            }
            return;
        }
        FScreen screen = Forge.getCurrentScreen();
        float screenWidth = screen.getWidth();
        float screenHeight = screen.getHeight();
        this.paneSize = this.updateAndGetPaneSize(screenWidth, screenHeight);
        this.paneSize = new FScrollPane.ScrollBounds(Math.round(this.paneSize.getWidth()), Math.round(this.paneSize.getHeight()));
        if (this.x + this.paneSize.getWidth() > screenWidth) {
            this.x = screenWidth - this.paneSize.getWidth();
        }
        if (this.y + this.paneSize.getHeight() > screenHeight) {
            this.y = screenHeight - this.paneSize.getHeight();
        }
        this.setBounds(Math.round(this.x), Math.round(this.y), this.paneSize.getWidth(), this.paneSize.getHeight());
    }

    @Override
    protected float determineMenuWidth() {
        if (this.fixedSize != null) {
            return this.fixedSize.x;
        }
        return super.determineMenuWidth();
    }

    @Override
    protected boolean autoHide() {
        return this.fixedSize == null;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        if (this.fixedSize == null) {
            super.drawBackground(g2);
        }
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        if (this.fixedSize == null) {
            super.drawOverlay(g2);
        }
    }
}

