/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.menu.FDropDown;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuBar;
import forge.toolbox.FDisplayObject;
import forge.util.Utils;

public class FMenuTab
extends FDisplayObject {
    public static final FSkinFont FONT = FSkinFont.get(12);
    boolean iconOnly = false;
    boolean active = false;
    public static final float PADDING = Utils.scale(2.0f);
    private static final float SEPARATOR_WIDTH = Utils.scale(1.0f);
    private final FMenuBar menuBar;
    private final FDropDown dropDown;
    private String text;
    private float minWidth;
    private int index;

    private static FSkinColor getSelBackColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    }

    private static FSkinColor getSelBorderColor() {
        return FDropDown.getBorderColor();
    }

    private static FSkinColor getSelForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getForeColor() {
        return FMenuTab.getSelForeColor().alphaColor(0.5f);
    }

    private static FSkinColor getSeparatorColor() {
        return FMenuTab.getSelForeColor().alphaColor(0.3f);
    }

    public FMenuTab(String text0, FMenuBar menuBar0, FDropDown dropDown0, int index0, boolean iconOnly0) {
        this.menuBar = menuBar0;
        this.dropDown = dropDown0;
        this.index = index0;
        this.iconOnly = iconOnly0;
        this.setText(text0);
    }

    @Override
    public boolean tap(float x, float y, int count) {
        if (this.dropDown.isVisible()) {
            this.dropDown.hide();
        } else {
            this.dropDown.show();
        }
        return true;
    }

    public void hideDropDown() {
        if (this.dropDown.isVisible()) {
            this.dropDown.hide();
        }
    }

    public void showDropDown() {
        if (!this.dropDown.isVisible()) {
            this.dropDown.show();
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (Forge.hasGamepad() && this.dropDown.isVisible()) {
            if (keyCode == 19) {
                this.dropDown.setPreviousSelected();
            }
            if (keyCode == 20) {
                this.dropDown.setNextSelected();
            }
            if (keyCode == 96) {
                this.dropDown.tapChild();
            }
            if (keyCode == 97) {
                this.dropDown.cancel();
            }
        }
        return super.keyDown(keyCode);
    }

    public void setText(String text0) {
        this.text = text0;
        this.minWidth = FMenuTab.FONT.getBounds((CharSequence)this.text).width;
        this.menuBar.revalidate();
    }

    public void setActiveIcon(boolean value) {
        this.active = value;
    }

    @Override
    public void setVisible(boolean visible0) {
        if (this.isVisible() == visible0) {
            return;
        }
        super.setVisible(visible0);
        if (!visible0) {
            this.dropDown.hide();
        }
        if (this.menuBar != null) {
            this.menuBar.revalidate();
        }
    }

    public float getMinWidth() {
        if (this.iconOnly) {
            float multiplier = Forge.isLandscapeMode() ? 2.5f : 1.8f;
            return FONT.getLineHeight() * multiplier;
        }
        return this.minWidth;
    }

    @Override
    public void draw(Graphics g2) {
        FSkinColor foreColor;
        float h2;
        float w;
        float y;
        float x;
        if (this.dropDown.isVisible()) {
            x = PADDING;
            y = PADDING;
            w = this.getWidth() - 2.0f * x + 1.0f;
            h2 = this.getHeight() - y + 1.0f;
            g2.startClip(x, y, w, h2);
            g2.fillRect(FMenuTab.getSelBackColor(), x, y, w, h2);
            g2.drawRect(2.0f, FMenuTab.getSelBorderColor(), x, y, w, h2);
            g2.endClip();
            foreColor = FMenuTab.getSelForeColor();
        } else {
            foreColor = FMenuTab.getForeColor();
        }
        if (this.index < this.menuBar.getTabCount() - 1) {
            x = this.getWidth();
            y = this.getHeight() / 4.0f;
            g2.drawLine(SEPARATOR_WIDTH, FMenuTab.getSeparatorColor(), x, y, x, this.getHeight() - y);
        }
        x = PADDING;
        y = PADDING;
        w = this.getWidth() - 2.0f * PADDING;
        h2 = this.getHeight() - 2.0f * PADDING;
        if (this.isHovered()) {
            g2.fillRect(FMenuTab.getSelBackColor().brighter(), x, y, w, h2);
        }
        if (this.iconOnly) {
            float mod = w * 0.75f;
            FSkinImage icon = this.active ? FSkinImage.SEE : FSkinImage.UNSEE;
            float scaleW = w * 0.8f;
            float scaleH = scaleW * 0.6f;
            g2.drawImage(icon, x + w / 2.0f - scaleW / 2.0f, y + h2 / 2.0f - scaleH / 2.0f, scaleW, scaleH);
        } else {
            g2.drawText(this.text, FONT, foreColor, x, y, w, h2, false, 1, true);
        }
    }

    public boolean isShowingDropdownMenu(boolean any) {
        if (this.dropDown == null) {
            return false;
        }
        if (any) {
            return this.dropDown.isVisible();
        }
        return this.dropDown.isVisible() && this.dropDown instanceof FDropDownMenu;
    }

    public void clearSelected() {
        if (this.menuBar != null) {
            this.menuBar.clearSelected();
        }
    }
}

