/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import com.badlogic.gdx.utils.Timer;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.gui.UiCommand;
import forge.gui.interfaces.IButton;
import forge.localinstance.skin.FSkinProp;
import forge.screens.FScreen;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.util.Utils;

public class FMenuItem
extends FDisplayObject
implements IButton {
    public static final float HEIGHT = Utils.AVG_FINGER_HEIGHT * 0.8f;
    protected static final float DIVOT_WIDTH = HEIGHT / 6.0f;
    protected static final float GAP_X = HEIGHT * 0.1f;
    private static final float ICON_SIZE = (int)((HEIGHT - 2.0f * GAP_X) / 20.0f) * 20;
    private static final FSkinFont FONT = FSkinFont.get(12);
    private final String text;
    private final FImage icon;
    private final FEvent.FEventHandler handler;
    private boolean pressed;
    private boolean allowForIcon;
    private boolean selected;
    private boolean tabMode;
    private float textWidth;
    private TextRenderer textRenderer;
    private final Timer.Task handleTapTask = new Timer.Task(){

        @Override
        public void run() {
            FMenuItem.this.handler.handleEvent(new FEvent(FMenuItem.this, FEvent.FEventType.TAP));
        }
    };

    protected static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    private static FSkinColor getPressedColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE).alphaColor(0.9f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE).alphaColor(0.9f);
    }

    private static FSkinColor getSeparatorColor() {
        return FMenuItem.getForeColor().alphaColor(0.5f);
    }

    private static FSkinColor getTabSeparatorColor() {
        return FScreen.Header.getBackColor().stepColor(-40);
    }

    public FMenuItem(String text0, FEvent.FEventHandler handler0) {
        this(text0, null, handler0, true);
    }

    public FMenuItem(String text0, FEvent.FEventHandler handler0, boolean enabled0) {
        this(text0, null, handler0, enabled0);
    }

    public FMenuItem(String text0, FImage icon0, FEvent.FEventHandler handler0) {
        this(text0, icon0, handler0, true);
    }

    public FMenuItem(String text0, FImage icon0, FEvent.FEventHandler handler0, boolean enabled0) {
        this.text = text0;
        this.icon = icon0;
        this.handler = handler0;
        this.setEnabled(enabled0);
        this.textWidth = FMenuItem.FONT.getBounds((CharSequence)this.text).width;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public void setAllowForIcon(boolean allowForIcon0) {
        this.allowForIcon = allowForIcon0;
    }

    public void setTabMode(boolean tabMode0) {
        this.tabMode = tabMode0;
    }

    public void setTextRenderer(TextRenderer textRenderer0) {
        this.textRenderer = textRenderer0;
    }

    public float getMinWidth() {
        float width = this.textWidth + DIVOT_WIDTH + 4.0f * GAP_X;
        if (this.allowForIcon) {
            width += ICON_SIZE + GAP_X;
        }
        return width;
    }

    @Override
    public boolean press(float x, float y) {
        this.pressed = true;
        return true;
    }

    @Override
    public boolean release(float x, float y) {
        this.pressed = false;
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        Timer.schedule(this.handleTapTask, 0.1f);
        return false;
    }

    protected boolean showPressedColor() {
        return this.pressed && !this.tabMode || this.selected;
    }

    @Override
    public void draw(Graphics g2) {
        float w = this.getWidth();
        float h2 = HEIGHT;
        if (this.isHovered() && !this.pressed) {
            g2.fillRect(FMenuItem.getPressedColor().brighter().alphaColor(0.4f), 0.0f, 0.0f, w, h2);
        }
        if (this.showPressedColor()) {
            g2.fillRect(FMenuItem.getPressedColor(), 0.0f, 0.0f, w, h2);
        }
        float x = GAP_X;
        if (this.allowForIcon) {
            if (this.icon != null) {
                g2.drawImage(this.icon, x, (h2 - ICON_SIZE) / 2.0f, ICON_SIZE, ICON_SIZE);
            }
            x += ICON_SIZE + GAP_X;
        }
        if (this.textRenderer == null) {
            g2.drawText(this.text, FONT, FMenuItem.getForeColor(), x, 0.0f, w - x - GAP_X, h2, false, 8, true);
        } else {
            this.textRenderer.drawText(g2, this.text, FONT, FMenuItem.getForeColor(), x, 0.0f, w - x - GAP_X, h2, 0.0f, h2, false, 8, true);
        }
        if (this.tabMode) {
            g2.drawLine(1.0f, FMenuItem.getTabSeparatorColor(), 0.0f, h2, w, h2);
        } else {
            g2.drawLine(1.0f, FMenuItem.getSeparatorColor(), 0.0f, h2, w, h2);
        }
    }

    @Override
    public void setText(String text0) {
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean b0) {
        this.selected = b0;
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }

    @Override
    public void setCommand(UiCommand command0) {
    }

    @Override
    public void setImage(FSkinProp color) {
    }

    @Override
    public void setTextColor(int r, int g2, int b) {
    }
}

