/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Forge;
import forge.Graphics;
import forge.menu.FDropDown;
import forge.menu.FMenuTab;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import java.util.ArrayList;
import java.util.List;

public class FMenuBar
extends FScreen.Header {
    private final List<FMenuTab> tabs = new ArrayList<FMenuTab>();
    private int selected = -1;

    public void addTab(String text0, FDropDown dropDown0) {
        this.addTab(text0, dropDown0, false);
    }

    public void addTab(String text0, FDropDown dropDown0, boolean iconOnly) {
        FMenuTab tab = new FMenuTab(text0, this, dropDown0, this.tabs.size(), iconOnly);
        dropDown0.setMenuTab(tab);
        this.tabs.add(this.add(tab));
    }

    @Override
    public float getPreferredHeight() {
        return Math.round(FMenuTab.FONT.getLineHeight() * 2.0f + 2.0f * FMenuTab.PADDING);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    @Override
    protected void doLayout(float width, float height) {
        int visibleTabCount = 0;
        float minWidth = 0.0f;
        int iconOnlyTabCount = 0;
        float iconMinWidth = 0.0f;
        for (FMenuTab tab : this.tabs) {
            if (!tab.isVisible()) continue;
            if (Forge.isLandscapeMode()) {
                if (!tab.iconOnly) {
                    minWidth += tab.getMinWidth();
                    ++visibleTabCount;
                    continue;
                }
                iconMinWidth += tab.getMinWidth();
                ++iconOnlyTabCount;
                continue;
            }
            minWidth += tab.getMinWidth();
            ++visibleTabCount;
        }
        int x = 0;
        float dx = (width - minWidth) / (float)visibleTabCount;
        for (FMenuTab tab : this.tabs) {
            int tabWidth;
            if (!tab.isVisible()) continue;
            if (tab.iconOnly) {
                tab.setActiveIcon(MatchController.instance.getGameView().getRevealedCollection() != null);
            }
            if ((float)(x + (tabWidth = Math.round(tab.getMinWidth() + dx))) > width) {
                tabWidth = Math.round(width - (float)x);
            }
            tab.setBounds(tab.iconOnly ? 0.0f : (float)x, 0.0f, tab.iconOnly ? tab.getMinWidth() + FMenuTab.PADDING * 2.0f : (float)tabWidth, height);
            x = (int)((float)x + (tab.iconOnly ? tab.getMinWidth() + FMenuTab.PADDING * 2.0f : (float)tabWidth));
        }
    }

    @Override
    protected void drawBackground(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.fillRect(FMenuBar.getBackColor(), 0.0f, 0.0f, w, h2);
    }

    @Override
    public float doLandscapeLayout(float screenWidth, float screenHeight) {
        return 0.0f;
    }

    public void setNextSelected() {
        ++this.selected;
        this.closeAll();
        if (this.selected > this.tabs.size()) {
            this.selected = 0;
        }
        try {
            this.tabs.get(this.selected).showDropDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected > this.tabs.size()) {
            this.closeAll();
            this.selected = this.tabs.size();
            return;
        }
    }

    public void setPreviousSelected() {
        --this.selected;
        this.closeAll();
        if (this.selected < 0) {
            this.selected = this.tabs.size();
        }
        try {
            this.tabs.get(this.selected).showDropDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected < 0) {
            this.closeAll();
            this.selected = -1;
            return;
        }
    }

    public void closeAll() {
        for (FMenuTab fMenuTab : this.tabs) {
            fMenuTab.hideDropDown();
        }
    }

    public boolean isShowingMenu(boolean anyDropdown) {
        return this.tabs.stream().anyMatch(tab -> tab.isShowingDropdownMenu(anyDropdown));
    }

    public void clearSelected() {
        --this.selected;
        if (this.selected < -1) {
            this.selected = this.tabs.size();
        }
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (keyCode == 109) {
            this.setNextSelected();
            return true;
        }
        return super.keyDown(keyCode);
    }
}

