/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.menu.FDropDown;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FScrollPane;
import forge.util.TextBounds;
import forge.util.Utils;

public class FMagnifyView
extends FDropDown {
    private static final float PADDING = Utils.scale(5.0f);
    private FDisplayObject owner;
    private String text;
    private FSkinColor foreColor;
    private FSkinColor backColor;
    private FSkinFont font;
    private TextRenderer renderer;

    public static void show(FDisplayObject owner0, String text0, FSkinColor foreColor0, FSkinColor backColor0, FSkinFont font0, boolean parseReminderText0) {
        FMagnifyView view = new FMagnifyView();
        view.owner = owner0;
        view.text = text0;
        view.foreColor = foreColor0;
        view.backColor = backColor0;
        view.font = font0;
        view.renderer = new TextRenderer(parseReminderText0);
        view.show();
    }

    private FMagnifyView() {
    }

    @Override
    protected void updateSizeAndPosition() {
        float x = this.owner.screenPos.x;
        float y = this.owner.screenPos.y + this.owner.getHeight();
        this.paneSize = this.updateAndGetPaneSize(this.owner.getWidth(), y);
        float height = this.paneSize.getHeight();
        if (height > y) {
            height = y;
        }
        this.setBounds(Math.round(x), Math.round(y -= height), Math.round(this.owner.getWidth()), Math.round(height));
    }

    @Override
    protected boolean autoHide() {
        return true;
    }

    @Override
    protected FDisplayObject getDropDownOwner() {
        return this.owner;
    }

    @Override
    protected FScrollPane.ScrollBounds updateAndGetPaneSize(float maxWidth, float maxVisibleHeight) {
        TextBounds bounds = this.renderer.getWrappedBounds(this.text, this.font, maxWidth - 2.0f * PADDING);
        return new FScrollPane.ScrollBounds(maxWidth, bounds.height + 2.0f * PADDING);
    }

    @Override
    public void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        g2.fillRect(this.backColor, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.renderer.drawText(g2, this.text, this.font, this.foreColor, PADDING - this.getScrollLeft(), PADDING - this.getScrollTop(), this.getScrollWidth() - 2.0f * PADDING, this.getScrollHeight() - 2.0f * PADDING, 0.0f, this.getHeight(), true, 8, false);
    }
}

