/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinTexture;
import forge.menu.FMenuTab;
import forge.menu.FSubMenu;
import forge.screens.FScreen;
import forge.screens.match.views.VDevMenu;
import forge.screens.match.views.VGameMenu;
import forge.screens.match.views.VLog;
import forge.screens.match.views.VPlayers;
import forge.screens.match.views.VReveal;
import forge.screens.match.views.VStack;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FOverlay;
import forge.toolbox.FScrollPane;

public abstract class FDropDown
extends FScrollPane {
    private Backdrop backdrop;
    private FMenuTab menuTab;
    private FContainer dropDownContainer;
    private FDisplayObject selectedChild;
    protected FScrollPane.ScrollBounds paneSize;

    public static FSkinColor getBorderColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_BORDERS);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_BORDERS);
    }

    public FDropDown() {
        super.setVisible(false);
    }

    public FMenuTab getMenuTab() {
        return this.menuTab;
    }

    public void setMenuTab(FMenuTab menuTab0) {
        this.menuTab = menuTab0;
    }

    public FContainer getDropDownContainer() {
        return this.dropDownContainer;
    }

    public void setDropDownContainer(FContainer dropDownContainer0) {
        this.dropDownContainer = dropDownContainer0;
    }

    protected FContainer getContainer() {
        FContainer container = this.dropDownContainer;
        if (container == null && (container = FOverlay.getTopOverlay()) == null) {
            container = Forge.getCurrentScreen();
        }
        return container;
    }

    public void update() {
        if (this.isVisible()) {
            this.updateSizeAndPosition();
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setNextSelected() {
        this.scrollToHoveredChild(true);
    }

    public void setPreviousSelected() {
        this.scrollToHoveredChild(false);
    }

    @Override
    public boolean press(float x, float y) {
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        if (this.autoHide()) {
            this.hide();
        }
        return true;
    }

    @Override
    public boolean longPress(float x, float y) {
        return true;
    }

    @Override
    public boolean flick(float x, float y) {
        return true;
    }

    @Override
    public void setVisible(boolean visible0) {
        if (this.isVisible() == visible0) {
            return;
        }
        FContainer container = this.getContainer();
        if (visible0) {
            this.updateSizeAndPosition();
            if (this.autoHide()) {
                this.backdrop = new Backdrop();
                this.backdrop.setSize(container.getWidth(), container.getHeight());
                container.add(this.backdrop);
            }
            container.add(this);
        } else {
            container.remove(this);
            if (this.backdrop != null) {
                this.backdrop.setVisible(false);
                container.remove(this.backdrop);
                this.backdrop = null;
            }
            this.onHidden();
        }
        super.setVisible(visible0);
    }

    protected void onHidden() {
    }

    protected abstract boolean autoHide();

    protected abstract FScrollPane.ScrollBounds updateAndGetPaneSize(float var1, float var2);

    protected void updateSizeAndPosition() {
        float maxVisibleHeight;
        boolean showAbove;
        if (this.menuTab == null) {
            return;
        }
        Rectangle boundary = Forge.getCurrentScreen().getDropDownBoundary();
        float x = this.menuTab.screenPos.x;
        float y = this.menuTab.screenPos.y + this.menuTab.getHeight();
        if (y < boundary.y + boundary.height / 2.0f) {
            showAbove = false;
            maxVisibleHeight = boundary.y + boundary.height - y;
        } else {
            showAbove = true;
            y = this.menuTab.screenPos.y;
            maxVisibleHeight = y - boundary.y;
        }
        this.paneSize = this.updateAndGetPaneSize(boundary.width, maxVisibleHeight);
        this.paneSize = new FScrollPane.ScrollBounds(Math.round(this.paneSize.getWidth()), Math.round(this.paneSize.getHeight()));
        if (x + this.paneSize.getWidth() > boundary.x + boundary.width) {
            x = boundary.x + boundary.width - this.paneSize.getWidth();
        }
        float height = Math.min(this.paneSize.getHeight(), maxVisibleHeight);
        if (showAbove) {
            y -= height;
        }
        this.setBounds(Math.round(x), Math.round(y), this.paneSize.getWidth(), height);
    }

    @Override
    protected final FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
        return this.paneSize;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, w, h2);
        g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, w, h2);
    }

    @Override
    protected boolean drawAboveOverlay() {
        return true;
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        super.drawOverlay(g2);
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.drawRect(2.0f, FDropDown.getBorderColor(), 0.0f, 0.0f, w, h2);
        if (this.getDropDownOwner() instanceof FMenuTab) {
            try {
                float y;
                float x;
                if (this.getScrollLeft() > 0.0f) {
                    x = this.getIndicatorMargin();
                    y = this.getHeight() / 2.0f;
                    g2.fillTriangle(FDropDown.getIndicatorColor(), x, y, x + this.getIndicatorSize(), y - this.getIndicatorSize(), x + this.getIndicatorSize(), y + this.getIndicatorSize());
                }
                if (this.getScrollLeft() < this.getMaxScrollLeft()) {
                    x = this.getWidth() - this.getIndicatorMargin();
                    y = this.getHeight() / 2.0f;
                    g2.fillTriangle(FDropDown.getIndicatorColor(), x, y, x - this.getIndicatorSize(), y - this.getIndicatorSize(), x - this.getIndicatorSize(), y + this.getIndicatorSize());
                }
                if (this.getScrollTop() > 0.0f) {
                    x = this.getWidth() / 2.0f;
                    y = this.getIndicatorMargin();
                    g2.fillTriangle(FDropDown.getIndicatorColor(), x, y, x - this.getIndicatorSize(), y + this.getIndicatorSize(), x + this.getIndicatorSize(), y + this.getIndicatorSize());
                }
                if (this.getScrollTop() < this.getMaxScrollTop()) {
                    x = this.getWidth() / 2.0f;
                    y = this.getHeight() - this.getIndicatorSize();
                    g2.fillTriangle(FDropDown.getIndicatorColor(), x, y, x - this.getIndicatorSize(), y - this.getIndicatorSize(), x + this.getIndicatorSize(), y - this.getIndicatorSize());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected FDisplayObject getDropDownOwner() {
        return this.menuTab;
    }

    protected boolean hideBackdropOnPress(float x, float y) {
        FDisplayObject owner = this.getDropDownOwner();
        return owner == null || !owner.screenPos.contains(x, y);
    }

    public void tapChild() {
        if (this.selectedChild != null) {
            this.selectedChild.tap(0.0f, 0.0f, 1);
            if (this.getMenuTab() != null) {
                this.getMenuTab().clearSelected();
            }
            if (this.autoHide()) {
                this.hide();
            }
        }
    }

    public void cancel() {
        if (this.getMenuTab() != null) {
            this.getMenuTab().clearSelected();
        }
        this.hide();
    }

    public void scrollToHoveredChild(boolean down) {
        this.selectedChild = null;
        for (FDisplayObject fDisplayObject : this.getChildren()) {
            if (!fDisplayObject.isHovered()) continue;
            float mod = down ? 0.0f : -fDisplayObject.screenPos.height;
            float y = fDisplayObject.screenPos.y + mod;
            this.scrollIntoView(fDisplayObject.screenPos.x, y, fDisplayObject.screenPos.width, fDisplayObject.screenPos.height, 0.0f);
            this.selectedChild = fDisplayObject;
            break;
        }
    }

    protected boolean preventOwnerHandlingBackupTap(float x, float y, int count) {
        FDisplayObject owner = this.getDropDownOwner();
        if (owner instanceof FSubMenu) {
            return owner.contains(owner.getLeft() + owner.screenToLocalX(x), owner.getTop() + owner.screenToLocalY(y));
        }
        return true;
    }

    private boolean isMatchHeader() {
        if (this instanceof VGameMenu) {
            return true;
        }
        if (this instanceof VPlayers) {
            return true;
        }
        if (this instanceof VReveal) {
            return true;
        }
        if (this instanceof VLog) {
            return true;
        }
        if (this instanceof VDevMenu) {
            return true;
        }
        return this instanceof VStack;
    }

    private class Backdrop
    extends FDisplayObject {
        private Backdrop() {
        }

        @Override
        public boolean press(float x, float y) {
            if (FDropDown.this.hideBackdropOnPress(this.localToScreenX(x), y)) {
                FDropDown.this.hide();
            }
            return false;
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (!this.isVisible()) {
                return false;
            }
            FDropDown.this.hide();
            return FDropDown.this.preventOwnerHandlingBackupTap(x, y, count);
        }

        @Override
        public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
            if (!FDropDown.this.isMatchHeader()) {
                FDropDown.this.hide();
            }
            return false;
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            if (!FDropDown.this.isMatchHeader()) {
                FDropDown.this.hide();
            }
            return false;
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            if (!FDropDown.this.isMatchHeader()) {
                FDropDown.this.hide();
            }
            return false;
        }

        @Override
        public void draw(Graphics g2) {
        }
    }
}

