/*
 * Decompiled with CFR 0.152.
 */
package forge.menu;

import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.menu.FMenuItem;
import forge.toolbox.FCheckBox;
import forge.toolbox.FEvent;

public class FCheckBoxMenuItem
extends FMenuItem {
    public static final float CHECKBOX_SIZE = HEIGHT * 0.45f;
    public static final float PADDING = (HEIGHT - CHECKBOX_SIZE) / 3.0f;
    private final boolean checked;

    public static FSkinColor foreColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public static FSkinColor getCheckboxColor() {
        return FCheckBoxMenuItem.foreColor().alphaColor(0.5f);
    }

    public FCheckBoxMenuItem(String text0, boolean checked0, FEvent.FEventHandler handler0) {
        this(text0, checked0, null, handler0, true);
    }

    public FCheckBoxMenuItem(String text0, boolean checked0, FEvent.FEventHandler handler0, boolean enabled0) {
        this(text0, checked0, null, handler0, enabled0);
    }

    public FCheckBoxMenuItem(String text0, boolean checked0, FImage icon0, FEvent.FEventHandler handler0) {
        this(text0, checked0, icon0, handler0, true);
    }

    public FCheckBoxMenuItem(String text0, boolean checked0, FImage icon0, FEvent.FEventHandler handler0, boolean enabled0) {
        super(text0, icon0, handler0, enabled0);
        this.checked = checked0;
    }

    @Override
    public float getMinWidth() {
        return super.getMinWidth() + CHECKBOX_SIZE + 2.0f * PADDING - GAP_X;
    }

    @Override
    public void draw(Graphics g2) {
        super.draw(g2);
        float w = CHECKBOX_SIZE;
        float h2 = CHECKBOX_SIZE;
        float x = this.getWidth() - PADDING - w;
        float y = (this.getHeight() - h2) / 2.0f;
        FCheckBox.drawCheckBox(g2, FCheckBoxMenuItem.getCheckboxColor(), FCheckBoxMenuItem.foreColor(), this.checked, x, y, w, h2);
    }
}

