/*
 * Decompiled with CFR 0.152.
 */
package forge.localinstance.achievements;

import com.google.common.collect.Maps;
import forge.game.GameType;
import forge.game.Match;
import forge.game.player.Player;
import forge.gui.GuiBase;
import forge.gui.interfaces.IComboBox;
import forge.localinstance.achievements.Achievement;
import forge.localinstance.achievements.AltWinAchievements;
import forge.localinstance.achievements.ArcaneMaster;
import forge.localinstance.achievements.CardActivationAchievements;
import forge.localinstance.achievements.ChallengeAchievements;
import forge.localinstance.achievements.GameWinStreak;
import forge.localinstance.achievements.Hellbent;
import forge.localinstance.achievements.LifeToSpare;
import forge.localinstance.achievements.ManaFlooded;
import forge.localinstance.achievements.ManaScrewed;
import forge.localinstance.achievements.MatchWinStreak;
import forge.localinstance.achievements.NeedForSpeed;
import forge.localinstance.achievements.Overkill;
import forge.localinstance.achievements.PlaneswalkerAchievements;
import forge.localinstance.achievements.RagsToRiches;
import forge.localinstance.achievements.StormChaser;
import forge.localinstance.achievements.TotalGameWins;
import forge.localinstance.achievements.TotalMatchWins;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.player.PlayerControllerHuman;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import forge.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AchievementCollection
implements Iterable<Achievement> {
    protected final Map<String, Achievement> achievements = Maps.newLinkedHashMap();
    protected final String name;
    protected final String filename;
    protected final String path;
    protected final boolean isLimitedFormat;

    public static void updateAll(PlayerControllerHuman controller) {
        if (controller.hasCheated()) {
            return;
        }
        Match match = controller.getMatch();
        Player player = controller.getPlayer();
        if (GuiBase.getInterface().isLibgdxPort()) {
            ThreadUtil.invokeInGameThread(() -> AchievementCollection.doUpdateAllAchievements(match, player));
        } else {
            AchievementCollection.doUpdateAllAchievements(match, player);
        }
    }

    private static void doUpdateAllAchievements(Match match, Player player) {
        FModel.getAchievements(match.getRules().getGameType()).updateAll(player);
        AltWinAchievements.instance.updateAll(player);
        PlaneswalkerAchievements.instance.updateAll(player);
        ChallengeAchievements.instance.updateAll(player);
        CardActivationAchievements.instance.updateAll(player);
    }

    public static void buildComboBox(IComboBox<AchievementCollection> cb) {
        cb.addItem(FModel.getAchievements(GameType.Constructed));
        cb.addItem(FModel.getAchievements(GameType.Draft));
        cb.addItem(FModel.getAchievements(GameType.Sealed));
        cb.addItem(FModel.getAchievements(GameType.Quest));
        cb.addItem(FModel.getAchievements(GameType.PlanarConquest));
        cb.addItem(FModel.getAchievements(GameType.Puzzle));
        cb.addItem(FModel.getAchievements(GameType.Adventure));
        cb.addItem(AltWinAchievements.instance);
        cb.addItem(PlaneswalkerAchievements.instance);
        cb.addItem(CardActivationAchievements.instance);
        cb.addItem(ChallengeAchievements.instance);
    }

    protected AchievementCollection(String name0, String filename0, boolean isLimitedFormat0) {
        this(name0, filename0, isLimitedFormat0, null);
    }

    protected AchievementCollection(String name0, String filename0, boolean isLimitedFormat0, String path0) {
        this.name = Localizer.getInstance().getMessage(name0, new Object[0]);
        this.filename = filename0;
        this.isLimitedFormat = isLimitedFormat0;
        this.path = path0;
        this.addSharedAchievements();
        this.addAchievements();
        this.load();
    }

    protected void addSharedAchievements() {
        this.add(new GameWinStreak(10, 25, 50, 100));
        this.add(new MatchWinStreak(10, 25, 50, 100));
        this.add(new TotalGameWins(250, 500, 1000, 2000));
        this.add(new TotalMatchWins(100, 250, 500, 1000));
        if (this.isLimitedFormat) {
            this.add(new NeedForSpeed(8, 6, 4, 2));
        } else {
            this.add(new NeedForSpeed(5, 3, 1, 0));
        }
        this.add(new Overkill(-25, -50, -100, -200));
        this.add(new LifeToSpare(20, 40, 80, 160));
        this.add(new Hellbent());
        this.add(new ArcaneMaster());
        this.add(new StormChaser(5, 10, 20, 50));
        this.add(new ManaScrewed());
        if (this.isLimitedFormat) {
            this.add(new ManaFlooded(8, 11, 14, 17));
        } else {
            this.add(new ManaFlooded(8, 12, 18, 24));
        }
        this.add(new RagsToRiches());
    }

    protected void addAchievements() {
        if (this.path != null) {
            List<String> achievementListFile = FileUtil.readFile(this.path);
            for (String s2 : achievementListFile) {
                if (s2.isEmpty()) continue;
                String[] k = StringUtils.split(s2, "|");
                this.add(k[0], k[1], k[2]);
            }
        }
    }

    protected void add(Achievement achievement) {
        this.achievements.put(achievement.getKey(), achievement);
    }

    protected void add(String name, String title, String desc) {
    }

    public void updateAll(Player player) {
        for (Achievement achievement : this.achievements.values()) {
            achievement.update(player);
        }
        this.save();
    }

    public void load() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(this.filename));
            NodeList nodes = document.getElementsByTagName("a");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element el = (Element)nodes.item(i);
                Achievement achievement = this.achievements.get(el.getAttribute("name"));
                if (achievement == null) continue;
                achievement.loadFromXml(el);
            }
        }
        catch (FileNotFoundException builder) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void save() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("achievements");
            document.appendChild(root);
            for (Map.Entry<String, Achievement> entry : this.achievements.entrySet()) {
                Achievement achievement = entry.getValue();
                if (!achievement.needSave()) continue;
                Element el = document.createElement("a");
                el.setAttribute("name", entry.getKey());
                achievement.saveToXml(el);
                root.appendChild(el);
            }
            XmlUtil.saveDocument(document, this.filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.achievements.size();
    }

    @Override
    public Iterator<Achievement> iterator() {
        return this.achievements.values().iterator();
    }

    public String toString() {
        return this.name;
    }

    static {
        FileUtil.ensureDirectoryExists(ForgeConstants.ACHIEVEMENTS_DIR);
    }
}

